/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.dict;

public interface VRMap {
    public static final VRMap DEFAULT = new VRMap(){

        public int lookup(int tag) {
            if ((tag & 0xFFFF) == 0) {
                return 21836;
            }
            switch (tag & 0xFFFF0000) {
                case 0: {
                    return this.vrOfCommand(tag);
                }
                case 131072: {
                    return this.vrOfFileMetaInfo(tag);
                }
                case 262144: {
                    return this.vrOfDicomDir(tag);
                }
            }
            if ((tag & 0x10000) != 0) {
                return (tag & 0xFF00) == 0 ? 19535 : 21838;
            }
            return this.vrOfData(tag);
        }

        int vrOfCommand(int tag) {
            switch (tag) {
                case 1536: 
                case 4144: {
                    return 16709;
                }
                case 2305: 
                case 4101: {
                    return 16724;
                }
                case 2306: {
                    return 19535;
                }
                case 2: 
                case 3: 
                case 4096: 
                case 4097: {
                    return 21833;
                }
                case 1: 
                case 16: 
                case 512: 
                case 768: 
                case 1024: 
                case 2128: 
                case 2144: 
                case 16384: 
                case 16400: 
                case 20496: 
                case 20512: 
                case 20752: 
                case 20768: 
                case 20784: 
                case 20800: 
                case 20816: 
                case 20832: 
                case 20848: 
                case 20864: 
                case 20880: 
                case 20896: {
                    return 21838;
                }
                case 256: 
                case 272: 
                case 288: 
                case 1792: 
                case 2048: 
                case 2304: 
                case 2307: 
                case 4098: 
                case 4104: 
                case 4128: 
                case 4129: 
                case 4130: 
                case 4131: 
                case 4145: {
                    return 21843;
                }
            }
            throw new IllegalArgumentException("Unrecognized Tag 0x" + Integer.toHexString(tag));
        }

        int vrOfFileMetaInfo(int tag) {
            switch (tag) {
                case 131094: {
                    return 16709;
                }
                case 131073: 
                case 131330: {
                    return 20290;
                }
                case 131091: {
                    return 21320;
                }
                case 131074: 
                case 131075: 
                case 131088: 
                case 131090: 
                case 131328: {
                    return 21833;
                }
            }
            throw new IllegalArgumentException("Unrecognized Tag 0x" + Integer.toHexString(tag));
        }

        int vrOfDicomDir(int tag) {
            switch (tag) {
                case 266544: 
                case 266561: 
                case 266562: 
                case 267312: 
                case 267520: {
                    return 17235;
                }
                case 266784: {
                    return 21329;
                }
                case 267314: 
                case 267536: 
                case 267537: 
                case 267538: 
                case 267546: {
                    return 21833;
                }
                case 266752: 
                case 266754: 
                case 267264: 
                case 267296: 
                case 267524: 
                case 267776: {
                    return 21836;
                }
                case 266770: 
                case 267280: {
                    return 21843;
                }
            }
            throw new IllegalArgumentException("Unrecognized Tag 0x" + Integer.toHexString(tag));
        }

        int vrOfData(int tag) {
            switch (tag) {
                case 524372: 
                case 3280929: 
                case 0x400001: 
                case 4194881: 
                case 7606836: 
                case 7606838: 
                case 553648240: 
                case 553648448: {
                    return 16709;
                }
                case 0x101010: {
                    return 16723;
                }
                case 2134373: 
                case 2134375: 
                case 2621449: 
                case 7471142: 
                case 7471186: 
                case 7471200: 
                case 7606354: 
                case 0x4000020: 
                case 0x2200000E: 
                case 805830754: {
                    return 16724;
                }
                case 524293: 
                case 524296: 
                case 524354: 
                case 524370: 
                case 524374: 
                case 524384: 
                case 524385: 
                case 524388: 
                case 524392: 
                case 524549: 
                case 524555: 
                case 524559: 
                case 532752: 
                case 532992: 
                case 532996: 
                case 533000: 
                case 561159: 
                case 561669: 
                case 561670: 
                case 561671: 
                case 561672: 
                case 561673: 
                case 562272: 
                case 0x100022: 
                case 0x100040: 
                case 1057184: 
                case 1057283: 
                case 1057432: 
                case 1179746: 
                case 1179780: 
                case 1179781: 
                case 1572885: 
                case 1572896: 
                case 1572897: 
                case 1572898: 
                case 1572899: 
                case 1572901: 
                case 1572919: 
                case 1572920: 
                case 1572921: 
                case 1572977: 
                case 1572979: 
                case 1577032: 
                case 1577066: 
                case 0x181080: 
                case 1577268: 
                case 1577274: 
                case 1577280: 
                case 1577287: 
                case 0x181155: 
                case 1577302: 
                case 1577306: 
                case 0x181166: 
                case 0x181181: 
                case 0x181191: 
                case 1577729: 
                case 1577746: 
                case 1577749: 
                case 1577986: 
                case 1577987: 
                case 1578064: 
                case 1578128: 
                case 1578129: 
                case 1578240: 
                case 1578248: 
                case 1578496: 
                case 1578752: 
                case 0x181800: 
                case 1579010: 
                case 1585408: 
                case 1593600: 
                case 1593601: 
                case 1597489: 
                case 1601536: 
                case 1601540: 
                case 1601541: 
                case 1601572: 
                case 1601588: 
                case 1601616: 
                case 1601632: 
                case 1601636: 
                case 1609732: 
                case 1609736: 
                case 1609737: 
                case 1609744: 
                case 1609745: 
                case 1609746: 
                case 1609748: 
                case 1609749: 
                case 1609750: 
                case 1609751: 
                case 1609752: 
                case 1609760: 
                case 1609761: 
                case 1609762: 
                case 1609764: 
                case 1609765: 
                case 1609766: 
                case 1609767: 
                case 1609768: 
                case 1609769: 
                case 1609778: 
                case 1609779: 
                case 1609780: 
                case 1609782: 
                case 1609783: 
                case 1609795: 
                case 1609796: 
                case 1609800: 
                case 1609809: 
                case 1609812: 
                case 1609817: 
                case 1609824: 
                case 1609826: 
                case 1609828: 
                case 1609829: 
                case 1609831: 
                case 1609845: 
                case 1609847: 
                case 1609848: 
                case 1609857: 
                case 1609861: 
                case 1609876: 
                case 1609984: 
                case 1609985: 
                case 1610055: 
                case 1610086: 
                case 1610089: 
                case 1610096: 
                case 1610097: 
                case 1610098: 
                case 1610099: 
                case 1610100: 
                case 1610103: 
                case 1610104: 
                case 1610105: 
                case 1610112: 
                case 1610115: 
                case 0x189198: 
                case 0x189199: 
                case 1610240: 
                case 1610260: 
                case 1610294: 
                case 1610498: 
                case 1610517: 
                case 1610518: 
                case 1610531: 
                case 1610547: 
                case 1610548: 
                case 1610562: 
                case 1610563: 
                case 1610564: 
                case 1610784: 
                case 1610789: 
                case 1610791: 
                case 1610805: 
                case 1610839: 
                case 1610868: 
                case 1611557: 
                case 1611576: 
                case 1611605: 
                case 1611606: 
                case 1611608: 
                case 1611609: 
                case 1611616: 
                case 1611617: 
                case 1611618: 
                case 1611619: 
                case 1611620: 
                case 1611621: 
                case 1611622: 
                case 1611623: 
                case 1611624: 
                case 1611625: 
                case 1611632: 
                case 1611784: 
                case 1611787: 
                case 1611788: 
                case 0x200020: 
                case 0x200060: 
                case 0x200062: 
                case 0x200070: 
                case 0x200080: 
                case 2134130: 
                case 2134791: 
                case 2134796: 
                case 2134801: 
                case 0x220005: 
                case 0x22000D: 
                case 2228281: 
                case 2621444: 
                case 2621521: 
                case 2621536: 
                case 2622208: 
                case 2622209: 
                case 2625600: 
                case 2625680: 
                case 2626304: 
                case 2626384: 
                case 2626562: 
                case 2626565: 
                case 2626573: 
                case 2626574: 
                case 2626575: 
                case 2626576: 
                case 2629904: 
                case 2629908: 
                case 2646273: 
                case 2658307: 
                case 2658568: 
                case 2658869: 
                case 2659396: 
                case 2659398: 
                case 2659412: 
                case 2659444: 
                case 3276810: 
                case 3276812: 
                case 3280981: 
                case 0x380008: 
                case 3801092: 
                case 3801605: 
                case 3801858: 
                case 0x400020: 
                case 0x400033: 
                case 4194357: 
                case 4194898: 
                case 4194913: 
                case 4195096: 
                case 0x404001: 
                case 0x404002: 
                case 0x404003: 
                case 0x404006: 
                case 0x404020: 
                case 4235280: 
                case 0x40A040: 
                case 4235344: 
                case 4235392: 
                case 4235396: 
                case 4235568: 
                case 4236433: 
                case 4236435: 
                case 4250368: 
                case 4250379: 
                case 0x500004: 
                case 5242903: 
                case 5242906: 
                case 5505081: 
                case 5505538: 
                case 0x540500: 
                case 5509120: 
                case 5509121: 
                case 5509122: 
                case 5509124: 
                case 5509376: 
                case 5509378: 
                case 5509664: 
                case 5510144: 
                case 5510145: 
                case 6422529: 
                case 6422536: 
                case 6422544: 
                case 0x660009: 
                case 0x66000D: 
                case 0x66000E: 
                case 0x660010: 
                case 0x700002: 
                case 0x700003: 
                case 0x700004: 
                case 0x700005: 
                case 7340050: 
                case 7340053: 
                case 7340067: 
                case 7340068: 
                case 7340097: 
                case 0x700080: 
                case 0x700100: 
                case 7340806: 
                case 7340812: 
                case 7341061: 
                case 7471110: 
                case 7471140: 
                case 7471156: 
                case 7471162: 
                case 7471184: 
                case 7471202: 
                case 7471624: 
                case 7471876: 
                case 7471888: 
                case 7471890: 
                case 7471894: 
                case 7472130: 
                case 7472132: 
                case 7472134: 
                case 7472384: 
                case 7472400: 
                case 7472406: 
                case 7472416: 
                case 7472642: 
                case 7472644: 
                case 0x720700: 
                case 0x720702: 
                case 7472900: 
                case 7472902: 
                case 7472912: 
                case 7472914: 
                case 7472916: 
                case 7472918: 
                case 7606272: 
                case 7606306: 
                case 7606322: 
                case 7606324: 
                case 7606326: 
                case 7606784: 
                case 7606850: 
                case 7606852: 
                case 7606854: 
                case 0x1000410: 
                case 67108885: 
                case 0x4000110: 
                case 67109637: 
                case 67110245: 
                case 0x20000020: 
                case 0x20000030: 
                case 0x20000040: 
                case 0x20000062: 
                case 536871011: 
                case 536871013: 
                case 536871015: 
                case 536871017: 
                case 536871018: 
                case 537919536: 
                case 537919552: 
                case 537919568: 
                case 537919570: 
                case 537919572: 
                case 537919584: 
                case 537919616: 
                case 537919654: 
                case 537919655: 
                case 537919656: 
                case 537919657: 
                case 0x20100100: 
                case 0x20100110: 
                case 537919808: 
                case 0x20200020: 
                case 0x20200040: 
                case 0x20200050: 
                case 0x202000A0: 
                case 0x202000A2: 
                case 541065312: 
                case 541065328: 
                case 541065330: 
                case 541065344: 
                case 541065346: 
                case 541065360: 
                case 541065472: 
                case 0x20500020: 
                case 0x21000020: 
                case 553648176: 
                case 0x21100010: 
                case 0x21100020: 
                case 0x21200010: 
                case 0x22000001: 
                case 0x22000003: 
                case 0x22000006: 
                case 0x22000007: 
                case 0x22000008: 
                case 0x22000009: 
                case 0x2200000A: 
                case 0x2200000F: 
                case 0x22000020: 
                case 805437450: 
                case 805437452: 
                case 805437505: 
                case 805568513: 
                case 805568514: 
                case 0x30040004: 
                case 805568522: 
                case 805568596: 
                case 805568610: 
                case 0x30060033: 
                case 0x30060036: 
                case 805699650: 
                case 805699748: 
                case 805699762: 
                case 805699780: 
                case 805830676: 
                case 805830698: 
                case 805830700: 
                case 805830934: 
                case 805831168: 
                case 805831204: 
                case 805831216: 
                case 0x300A000A: 
                case 805961740: 
                case 805961748: 
                case 805961749: 
                case 805961760: 
                case 805961813: 
                case 805961907: 
                case 805961912: 
                case 805961924: 
                case 805961926: 
                case 805961934: 
                case 805961939: 
                case 805961966: 
                case 805961976: 
                case 805961978: 
                case 805961993: 
                case 805962008: 
                case 805962015: 
                case 805962017: 
                case 805962019: 
                case 805962022: 
                case 805962050: 
                case 805962054: 
                case 805962060: 
                case 805962130: 
                case 805962146: 
                case 805962160: 
                case 805962166: 
                case 805962240: 
                case 805962242: 
                case 805962260: 
                case 805962290: 
                case 805962340: 
                case 805962376: 
                case 805962386: 
                case 806223874: 
                case 1074266640: 
                case 1074266642: 
                case 1409290246: {
                    return 17235;
                }
                case 524306: 
                case 524320: 
                case 524321: 
                case 524322: 
                case 524323: 
                case 524324: 
                case 524325: 
                case 0x100030: 
                case 1057232: 
                case 1576978: 
                case 1577472: 
                case 1601548: 
                case 2110467: 
                case 0x320032: 
                case 3276852: 
                case 3280896: 
                case 3280912: 
                case 3280960: 
                case 3280976: 
                case 3670042: 
                case 3670044: 
                case 3670048: 
                case 0x380030: 
                case 0x400002: 
                case 0x400004: 
                case 0x400244: 
                case 4194896: 
                case 0x402004: 
                case 4235553: 
                case 7340162: 
                case 553648192: 
                case 805699592: 
                case 805830692: 
                case 805830740: 
                case 805830742: 
                case 805831010: 
                case 805831014: 
                case 805831248: 
                case 805961734: 
                case 805962284: 
                case 806223876: 
                case 1074266368: 
                case 1074266376: 
                case 1074266386: {
                    return 17473;
                }
                case 532784: 
                case 0x101020: 
                case 0x101030: 
                case 1572904: 
                case 1572914: 
                case 1572915: 
                case 1572944: 
                case 1572960: 
                case 1572978: 
                case 0x180080: 
                case 0x180081: 
                case 1572994: 
                case 1572995: 
                case 1572996: 
                case 1572999: 
                case 0x180088: 
                case 1573008: 
                case 1573011: 
                case 1573012: 
                case 1573013: 
                case 1577025: 
                case 1577028: 
                case 1577030: 
                case 1577031: 
                case 1577033: 
                case 1577040: 
                case 1577056: 
                case 1577059: 
                case 1577061: 
                case 1577062: 
                case 1577063: 
                case 1577064: 
                case 1577065: 
                case 1577073: 
                case 1577076: 
                case 1577077: 
                case 1577078: 
                case 1577079: 
                case 0x181100: 
                case 0x181110: 
                case 0x181111: 
                case 0x181114: 
                case 1577248: 
                case 0x181121: 
                case 1577264: 
                case 0x181131: 
                case 1577269: 
                case 1577270: 
                case 1577271: 
                case 0x181138: 
                case 0x181141: 
                case 1577282: 
                case 1577283: 
                case 0x181144: 
                case 1577285: 
                case 1577286: 
                case 1577300: 
                case 1577310: 
                case 1577314: 
                case 1577316: 
                case 0x181183: 
                case 0x181184: 
                case 1577360: 
                case 1577376: 
                case 1577378: 
                case 1577728: 
                case 1577748: 
                case 1577750: 
                case 0x181318: 
                case 0x181411: 
                case 1578002: 
                case 1578003: 
                case 1578080: 
                case 1578096: 
                case 1578112: 
                case 1578256: 
                case 0x181511: 
                case 1578272: 
                case 1578273: 
                case 1578288: 
                case 1578289: 
                case 1585409: 
                case 1585410: 
                case 1593362: 
                case 1593378: 
                case 1593380: 
                case 1593382: 
                case 1593383: 
                case 1593384: 
                case 1593385: 
                case 1593872: 
                case 1593874: 
                case 1597440: 
                case 1601537: 
                case 1601554: 
                case 1601556: 
                case 1601558: 
                case 1601562: 
                case 1601568: 
                case 1601570: 
                case 1601574: 
                case 1601576: 
                case 1601584: 
                case 1601586: 
                case 1601602: 
                case 1601604: 
                case 1601608: 
                case 1601612: 
                case 1601618: 
                case 1601620: 
                case 1601637: 
                case 1605968: 
                case 0x188151: 
                case 0x200030: 
                case 0x200032: 
                case 2097205: 
                case 2097207: 
                case 0x200110: 
                case 2101313: 
                case 2228302: 
                case 2621488: 
                case 2621489: 
                case 2621490: 
                case 2625616: 
                case 2625617: 
                case 2625618: 
                case 2625619: 
                case 0x282112: 
                case 3801114: 
                case 3801616: 
                case 3801618: 
                case 3801619: 
                case 3801620: 
                case 3801621: 
                case 3801624: 
                case 3801632: 
                case 3801633: 
                case 3801634: 
                case 3801635: 
                case 4194964: 
                case 4195078: 
                case 4195079: 
                case 4195090: 
                case 4195092: 
                case 4195094: 
                case 4196138: 
                case 4196154: 
                case 4196170: 
                case 4227842: 
                case 4235576: 
                case 4236042: 
                case 5242900: 
                case 5242902: 
                case 5242904: 
                case 5242905: 
                case 5505044: 
                case 5505045: 
                case 5505139: 
                case 5505536: 
                case 5509632: 
                case 5509635: 
                case 5509648: 
                case 5509888: 
                case 5509920: 
                case 5509921: 
                case 5509922: 
                case 5509923: 
                case 5509924: 
                case 0x700101: 
                case 0x720072: 
                case 7606276: 
                case 7606328: 
                case 7606330: 
                case 537920374: 
                case 0x20200030: 
                case 805437453: 
                case 805437454: 
                case 805437456: 
                case 805437457: 
                case 805437458: 
                case 0x30020022: 
                case 805437476: 
                case 805437478: 
                case 805437480: 
                case 0x30020032: 
                case 805437506: 
                case 805568520: 
                case 805568524: 
                case 805568526: 
                case 805568530: 
                case 0x30040040: 
                case 805568578: 
                case 805568594: 
                case 805568600: 
                case 805568624: 
                case 805568626: 
                case 805568628: 
                case 805699628: 
                case 805699652: 
                case 805699653: 
                case 805699664: 
                case 805699764: 
                case 805699782: 
                case 805830678: 
                case 805830706: 
                case 0x30080033: 
                case 805830710: 
                case 805830711: 
                case 805830714: 
                case 805830715: 
                case 805830722: 
                case 805830724: 
                case 805830728: 
                case 805830738: 
                case 805830774: 
                case 805830776: 
                case 805830778: 
                case 805830962: 
                case 805830964: 
                case 805830970: 
                case 805830972: 
                case 805961752: 
                case 805961754: 
                case 805961761: 
                case 805961762: 
                case 805961763: 
                case 805961765: 
                case 805961766: 
                case 805961767: 
                case 805961768: 
                case 805961770: 
                case 805961771: 
                case 805961772: 
                case 805961773: 
                case 805961796: 
                case 805961798: 
                case 805961802: 
                case 805961804: 
                case 805961806: 
                case 805961809: 
                case 805961810: 
                case 805961811: 
                case 805961858: 
                case 805961860: 
                case 805961862: 
                case 805961890: 
                case 805961892: 
                case 805961908: 
                case 805961914: 
                case 805961918: 
                case 805961942: 
                case 805961944: 
                case 805961946: 
                case 805961954: 
                case 805961958: 
                case 805961961: 
                case 805961962: 
                case 805961963: 
                case 805961964: 
                case 805961970: 
                case 805961974: 
                case 805961984: 
                case 805961986: 
                case 805961990: 
                case 805961996: 
                case 805961998: 
                case 805962004: 
                case 805962005: 
                case 805962012: 
                case 805962014: 
                case 805962016: 
                case 805962018: 
                case 805962020: 
                case 805962021: 
                case 805962024: 
                case 805962025: 
                case 805962026: 
                case 805962028: 
                case 805962030: 
                case 805962032: 
                case 805962036: 
                case 805962172: 
                case 805962194: 
                case 805962196: 
                case 805962198: 
                case 805962264: 
                case 805962266: 
                case 805962274: 
                case 805962276: 
                case 805962280: 
                case 805962282: 
                case 805962320: 
                case 805962346: 
                case 805962348: 
                case 805962372: 
                case 805962374: 
                case 805962380: 
                case 805962390: 
                case 805962396: 
                case 805962398: 
                case 805962400: 
                case 805962404: 
                case 805962424: 
                case 805962426: 
                case 805962440: 
                case 805962450: 
                case 805962452: 
                case 805962454: 
                case 806092808: 
                case 806092809: {
                    return 17491;
                }
                case 524330: 
                case 524550: 
                case 524551: 
                case 1609844: 
                case 1610065: 
                case 1611521: 
                case 1611780: 
                case 1613826: 
                case 0x404005: 
                case 0x404010: 
                case 0x404011: 
                case 4235312: 
                case 4235314: 
                case 4235394: 
                case 4235552: 
                case 4235578: 
                case 4250374: 
                case 4250375: 
                case 0x40E004: 
                case 7471114: 
                case 16778272: 
                case 67109125: 
                case 67110242: {
                    return 17492;
                }
                case 528739: 
                case 532788: 
                case 1597480: 
                case 1597482: 
                case 1597484: 
                case 1597486: 
                case 1597492: 
                case 1597494: 
                case 1597524: 
                case 1609753: 
                case 1609776: 
                case 1609781: 
                case 1609810: 
                case 1609811: 
                case 1609825: 
                case 1609827: 
                case 1609833: 
                case 1609840: 
                case 1609843: 
                case 1609849: 
                case 1609858: 
                case 1609863: 
                case 1609865: 
                case 1609872: 
                case 1609873: 
                case 1609880: 
                case 1609988: 
                case 1609989: 
                case 1609990: 
                case 1610069: 
                case 1610088: 
                case 0x189181: 
                case 1610114: 
                case 1610116: 
                case 1610133: 
                case 1610134: 
                case 1610263: 
                case 1610264: 
                case 1610272: 
                case 1610499: 
                case 1610501: 
                case 1610502: 
                case 1610503: 
                case 1610505: 
                case 1610512: 
                case 1610513: 
                case 1610515: 
                case 1610519: 
                case 1610520: 
                case 1610521: 
                case 1610530: 
                case 1610532: 
                case 1610535: 
                case 1610536: 
                case 1610544: 
                case 1610546: 
                case 1610549: 
                case 1610565: 
                case 1611541: 
                case 1611542: 
                case 1611543: 
                case 1611544: 
                case 1611545: 
                case 1611552: 
                case 1611553: 
                case 1611554: 
                case 1611555: 
                case 1611556: 
                case 1611558: 
                case 1611559: 
                case 1611777: 
                case 1611781: 
                case 2134355: 
                case 2134785: 
                case 2134786: 
                case 2134792: 
                case 2134793: 
                case 2134794: 
                case 2134797: 
                case 2626566: 
                case 4231698: 
                case 4231716: 
                case 4231717: 
                case 5242899: 
                case 0x500015: 
                case 5242908: 
                case 5242909: 
                case 6553608: 
                case 7340818: 
                case 7471220: 
                case 7471368: 
                case 7471920: 
                case 7472402: 
                case 7472404: {
                    return 17988;
                }
                case 562265: 
                case 1086513: 
                case 1597530: 
                case 1597536: 
                case 1610754: 
                case 1610755: 
                case 1610756: 
                case 1610790: 
                case 1610792: 
                case 1610793: 
                case 1610823: 
                case 1610825: 
                case 1610834: 
                case 1610849: 
                case 1610851: 
                case 1610852: 
                case 1610853: 
                case 1610854: 
                case 1610855: 
                case 1610856: 
                case 1610857: 
                case 1610864: 
                case 1610865: 
                case 1610867: 
                case 0x220007: 
                case 0x220008: 
                case 0x220009: 
                case 0x22000A: 
                case 0x22000B: 
                case 0x22000C: 
                case 0x22000E: 
                case 0x220010: 
                case 0x220011: 
                case 0x220012: 
                case 2228243: 
                case 2228244: 
                case 0x220030: 
                case 0x220032: 
                case 2228277: 
                case 2228278: 
                case 2228279: 
                case 2228280: 
                case 2228289: 
                case 2228296: 
                case 2228297: 
                case 0x220055: 
                case 2228310: 
                case 2228311: 
                case 2646292: 
                case 2659345: 
                case 2659397: 
                case 0x66000A: 
                case 0x66000C: 
                case 6684695: 
                case 6684696: 
                case 6684697: 
                case 6684698: 
                case 6684699: 
                case 6684700: 
                case 0x660020: 
                case 0x700010: 
                case 0x700011: 
                case 7340052: 
                case 0x700022: 
                case 7340291: 
                case 7341059: 
                case 7471222: 
                case 805962048: 
                case 805962052: 
                case 805962056: 
                case 805962058: {
                    return 17996;
                }
                case 528736: 
                case 532770: 
                case 532772: 
                case 532776: 
                case 532777: 
                case 532778: 
                case 532802: 
                case 532803: 
                case 532804: 
                case 1572928: 
                case 1572976: 
                case 1572980: 
                case 1572981: 
                case 1572998: 
                case 1573001: 
                case 1573009: 
                case 1577029: 
                case 1577058: 
                case 0x181081: 
                case 1577090: 
                case 1577091: 
                case 1577092: 
                case 1577094: 
                case 0x181088: 
                case 1577104: 
                case 1577108: 
                case 1577289: 
                case 1577296: 
                case 0x181151: 
                case 1577298: 
                case 1577299: 
                case 1577328: 
                case 0x181182: 
                case 1577538: 
                case 1577539: 
                case 1577730: 
                case 1577989: 
                case 1578133: 
                case 1578498: 
                case 1578500: 
                case 1578502: 
                case 1578504: 
                case 1578512: 
                case 1578514: 
                case 1578528: 
                case 1578754: 
                case 1578756: 
                case 1578758: 
                case 1578760: 
                case 1578768: 
                case 1578770: 
                case 1578784: 
                case 1585411: 
                case 1585412: 
                case 1585413: 
                case 1593424: 
                case 1601552: 
                case 1601553: 
                case 1601606: 
                case 0x200011: 
                case 0x200012: 
                case 2097171: 
                case 2097172: 
                case 2097173: 
                case 2097174: 
                case 2097175: 
                case 2097176: 
                case 2097177: 
                case 0x200022: 
                case 0x200024: 
                case 0x200026: 
                case 0x200100: 
                case 2097413: 
                case 0x201000: 
                case 0x201001: 
                case 0x201002: 
                case 2101252: 
                case 2101360: 
                case 0x201200: 
                case 0x201202: 
                case 2101764: 
                case 2101766: 
                case 2101768: 
                case 2101769: 
                case 0x280008: 
                case 2621492: 
                case 3801602: 
                case 3801857: 
                case 5505047: 
                case 5505078: 
                case 5505080: 
                case 5505552: 
                case 5509633: 
                case 5509634: 
                case 5509904: 
                case 5509905: 
                case 7340130: 
                case 7340290: 
                case 7471204: 
                case 7606308: 
                case 0x20000010: 
                case 0x20000060: 
                case 536871009: 
                case 537919828: 
                case 553648496: 
                case 805437481: 
                case 805568598: 
                case 805699618: 
                case 805699626: 
                case 805699654: 
                case 805699656: 
                case 805699657: 
                case 805699714: 
                case 805699716: 
                case 805830690: 
                case 805830746: 
                case 805830756: 
                case 805830770: 
                case 805830786: 
                case 805830802: 
                case 805830946: 
                case 805830966: 
                case 805830968: 
                case 805830978: 
                case 805830994: 
                case 805831203: 
                case 805961746: 
                case 805961794: 
                case 805961841: 
                case 805961848: 
                case 805961849: 
                case 805961850: 
                case 805961856: 
                case 0x300A00A0: 
                case 805961916: 
                case 805961920: 
                case 805961928: 
                case 805961936: 
                case 805961938: 
                case 805961941: 
                case 805961952: 
                case 805961956: 
                case 805961959: 
                case 805961960: 
                case 805961965: 
                case 805961968: 
                case 805961980: 
                case 805961988: 
                case 805962000: 
                case 805962002: 
                case 805962114: 
                case 805962258: 
                case 805962292: 
                case 805962304: 
                case 805962338: 
                case 805962370: 
                case 805962378: 
                case 805962384: 
                case 805962402: 
                case 805962418: 
                case 806092806: 
                case 806092807: 
                case 0x300C000C: 
                case 806092814: 
                case 806092834: 
                case 806092881: 
                case 806092906: 
                case 806092960: 
                case 0x300C00C0: 
                case 806093008: 
                case 806093024: 
                case 806093040: {
                    return 18771;
                }
                case 524400: 
                case 524416: 
                case 524548: 
                case 524562: 
                case 528432: 
                case 528446: 
                case 528448: 
                case 528512: 
                case 528528: 
                case 532786: 
                case 0x100020: 
                case 0x100021: 
                case 0x101000: 
                case 0x101040: 
                case 0x101050: 
                case 0x101080: 
                case 0x101081: 
                case 0x101090: 
                case 0x102000: 
                case 0x102110: 
                case 1057104: 
                case 1057106: 
                case 1057264: 
                case 0x102201: 
                case 1057426: 
                case 1057429: 
                case 1057433: 
                case 0x120010: 
                case 0x120020: 
                case 0x120021: 
                case 1179696: 
                case 1179697: 
                case 1179712: 
                case 1179714: 
                case 1179728: 
                case 1179744: 
                case 1179747: 
                case 1179761: 
                case 1179762: 
                case 1179777: 
                case 1179778: 
                case 0x180010: 
                case 1572912: 
                case 1572913: 
                case 1572916: 
                case 0x181000: 
                case 1576964: 
                case 1576965: 
                case 1576966: 
                case 1576967: 
                case 0x181008: 
                case 0x181010: 
                case 0x181011: 
                case 1576982: 
                case 1576983: 
                case 0x181018: 
                case 1576985: 
                case 1576986: 
                case 1576987: 
                case 1576992: 
                case 1576995: 
                case 1577008: 
                case 1577024: 
                case 1577057: 
                case 1577060: 
                case 1577072: 
                case 1577093: 
                case 0x181161: 
                case 1577569: 
                case 1577984: 
                case 1577985: 
                case 1593360: 
                case 1593376: 
                case 1593377: 
                case 1609793: 
                case 1609798: 
                case 1609808: 
                case 1610101: 
                case 1610787: 
                case 1610803: 
                case 2101312: 
                case 2110468: 
                case 2110470: 
                case 0x205000: 
                case 0x205002: 
                case 2134547: 
                case 2134584: 
                case 2135073: 
                case 2135123: 
                case 2625620: 
                case 2625621: 
                case 2633731: 
                case 2633732: 
                case 2646050: 
                case 3276818: 
                case 3280928: 
                case 3280944: 
                case 3280947: 
                case 3280992: 
                case 3281008: 
                case 3670032: 
                case 3670033: 
                case 3670038: 
                case 3670046: 
                case 3670080: 
                case 3670096: 
                case 3670112: 
                case 3670113: 
                case 3670114: 
                case 0x380300: 
                case 3671040: 
                case 3671296: 
                case 3801612: 
                case 0x400007: 
                case 4194322: 
                case 4194900: 
                case 4194901: 
                case 4195594: 
                case 4195602: 
                case 4195610: 
                case 4195665: 
                case 0x400600: 
                case 4196090: 
                case 4198402: 
                case 0x401004: 
                case 4198405: 
                case 4198408: 
                case 4198659: 
                case 4202497: 
                case 4202518: 
                case 4202519: 
                case 4206593: 
                case 4210742: 
                case 4235303: 
                case 4236434: 
                case 4325394: 
                case 4325396: 
                case 5242907: 
                case 5242910: 
                case 0x500020: 
                case 5509377: 
                case 5509379: 
                case 5509380: 
                case 5509381: 
                case 6303760: 
                case 6422533: 
                case 6422537: 
                case 0x66000B: 
                case 6684721: 
                case 0x660036: 
                case 7340136: 
                case 7340161: 
                case 7471108: 
                case 7471112: 
                case 7471120: 
                case 7471168: 
                case 7471188: 
                case 7471190: 
                case 7471206: 
                case 7471622: 
                case 7606284: 
                case 7606358: 
                case 7606786: 
                case 7606788: 
                case 7606818: 
                case 7606832: 
                case 8915204: 
                case 8915216: 
                case 8915218: 
                case 16778278: 
                case 67110243: 
                case 67110244: 
                case 0x20000050: 
                case 0x20300020: 
                case 554696752: 
                case 0x2200000C: 
                case 0x30020003: 
                case 805568518: 
                case 805699588: 
                case 805699622: 
                case 805699640: 
                case 805699784: 
                case 805830917: 
                case 0x300A0003: 
                case 805961737: 
                case 805961739: 
                case 805961750: 
                case 805961922: 
                case 805961932: 
                case 805961982: 
                case 805961994: 
                case 805962116: 
                case 805962262: 
                case 805962278: 
                case 805962294: 
                case 805962296: 
                case 805962308: 
                case 805962342: 
                case 805962388: 
                case 805962392: 
                case 805962420: 
                case 1074266178: 
                case 1074266371: 
                case 1074266394: 
                case 1074266626: {
                    return 19535;
                }
                case 540672: 
                case 1057200: 
                case 0x104000: 
                case 1589248: 
                case 1601542: 
                case 1601544: 
                case 1601600: 
                case 1601601: 
                case 1601634: 
                case 1610788: 
                case 0x204000: 
                case 2134360: 
                case 2637824: 
                case 3293184: 
                case 3686400: 
                case 0x400400: 
                case 0x401400: 
                case 0x402400: 
                case 0x660004: 
                case 6684722: 
                case 7471208: 
                case 7606840: 
                case 16778276: 
                case 537919826: 
                case 0x22000004: 
                case 0x22000005: 
                case 805961851: 
                case 0x40000010: 
                case 0x40004000: 
                case 1074266389: {
                    return 19540;
                }
                case -196612: 
                case 0x282000: 
                case 4325393: 
                case 67109141: 
                case 67109152: 
                case 67109648: 
                case 0x4000404: 
                case 67110176: {
                    return 20290;
                }
                case 6553609: 
                case 0x660016: 
                case 6684705: 
                case 1442840592: 
                case 1442840608: {
                    return 20294;
                }
                case 2626049: 
                case 2626050: 
                case 2626051: 
                case 2626052: 
                case 0x281221: 
                case 0x281222: 
                case 2626083: 
                case 2626568: 
                case 2633734: 
                case 6684707: 
                case 6684708: 
                case 6684709: 
                case 6684713: 
                case 1409286416: 
                case 1409286418: 
                case 1409290250: 
                case 1409290256: 
                case 2145386512: {
                    return 20311;
                }
                case 524432: 
                case 528456: 
                case 528464: 
                case 528480: 
                case 528496: 
                case 0x100010: 
                case 0x101001: 
                case 0x101005: 
                case 0x101060: 
                case 1057431: 
                case 3280946: 
                case 0x400006: 
                case 0x401010: 
                case 4202504: 
                case 4210743: 
                case 4235381: 
                case 4235555: 
                case 7340164: 
                case 7471210: 
                case 805699750: 
                case 806223880: 
                case 1074266370: 
                case 1074266378: 
                case 1074266380: 
                case 1074266388: 
                case 1074266393: {
                    return 20558;
                }
                case 524368: 
                case 524436: 
                case 524544: 
                case 524546: 
                case 524547: 
                case 524801: 
                case 528400: 
                case 532768: 
                case 1057108: 
                case 1057120: 
                case 1057152: 
                case 1572900: 
                case 1572997: 
                case 1576994: 
                case 1577312: 
                case 0x181180: 
                case 1577488: 
                case 1577552: 
                case 1577553: 
                case 1577568: 
                case 0x181801: 
                case 1593344: 
                case 1601546: 
                case 1609733: 
                case 1609799: 
                case 1610528: 
                case 0x200010: 
                case 2110465: 
                case 2110466: 
                case 2134102: 
                case 3801120: 
                case 3801603: 
                case 0x400009: 
                case 0x400010: 
                case 0x400011: 
                case 0x400242: 
                case 4194883: 
                case 4194899: 
                case 0x401001: 
                case 4198403: 
                case 4198406: 
                case 4198407: 
                case 4198409: 
                case 4202502: 
                case 4202503: 
                case 4202505: 
                case 4202512: 
                case 4231696: 
                case 5505048: 
                case 0x540400: 
                case 7340816: 
                case 0x720002: 
                case 7471212: 
                case 8913200: 
                case 0x21000010: 
                case 553648480: 
                case 554696857: 
                case 0x30020002: 
                case 0x30020020: 
                case 805699586: 
                case 805699717: 
                case 805830699: 
                case 805961730: 
                case 805961795: 
                case 805961906: 
                case 805961940: 
                case 805961953: 
                case 805961957: 
                case 805961973: 
                case 805961992: 
                case 805962132: 
                case 805962136: 
                case 805962148: 
                case 805962152: 
                case 805962168: 
                case 805962306: 
                case 805962339: 
                case 805962385: 
                case 805962419: 
                case 0x40080040: 
                case 1074266624: {
                    return 21320;
                }
                case 1597472: 
                case 1597474: 
                case 7340114: 
                case 7340115: 
                case 7471228: {
                    return 21324;
                }
                case 524369: 
                case 524418: 
                case 524438: 
                case 524560: 
                case 528434: 
                case 528457: 
                case 528466: 
                case 528482: 
                case 528498: 
                case 528516: 
                case 528640: 
                case 528656: 
                case 528657: 
                case 528661: 
                case 528672: 
                case 528677: 
                case 528688: 
                case 528698: 
                case 528704: 
                case 528709: 
                case 528714: 
                case 528715: 
                case 528740: 
                case 528792: 
                case 528793: 
                case 528896: 
                case 528976: 
                case 532754: 
                case 532787: 
                case 532789: 
                case 533016: 
                case 533024: 
                case 533032: 
                case 533033: 
                case 533040: 
                case 533056: 
                case 533058: 
                case 533060: 
                case 533062: 
                case 536577: 
                case 561298: 
                case 561441: 
                case 561444: 
                case 561492: 
                case 561685: 
                case 561719: 
                case 562192: 
                case 562264: 
                case 1048612: 
                case 0x100050: 
                case 0x100101: 
                case 0x100102: 
                case 0x101002: 
                case 0x102202: 
                case 1057427: 
                case 1057428: 
                case 1057430: 
                case 1179748: 
                case 1179779: 
                case 1572882: 
                case 1572884: 
                case 1572902: 
                case 1572905: 
                case 1572906: 
                case 1572918: 
                case 1593604: 
                case 1597457: 
                case 1609734: 
                case 1609794: 
                case 1609797: 
                case 1609801: 
                case 1609846: 
                case 1609860: 
                case 1609987: 
                case 1609991: 
                case 1610002: 
                case 1610004: 
                case 1610005: 
                case 1610007: 
                case 0x189118: 
                case 0x189119: 
                case 1610021: 
                case 1610022: 
                case 1610066: 
                case 1610102: 
                case 1610135: 
                case 1610278: 
                case 1610279: 
                case 1610297: 
                case 1610497: 
                case 1610500: 
                case 1610504: 
                case 1610514: 
                case 1610516: 
                case 1610529: 
                case 1610533: 
                case 1610534: 
                case 1610537: 
                case 1610552: 
                case 1610560: 
                case 1610561: 
                case 1610566: 
                case 1610753: 
                case 1610757: 
                case 1610758: 
                case 1610759: 
                case 1610770: 
                case 1610775: 
                case 1610802: 
                case 1610804: 
                case 1610833: 
                case 1610837: 
                case 1610838: 
                case 1610850: 
                case 1610866: 
                case 1610870: 
                case 1610871: 
                case 1611570: 
                case 1611571: 
                case 1611572: 
                case 1611573: 
                case 1611574: 
                case 1611575: 
                case 1611593: 
                case 1611601: 
                case 1611633: 
                case 1611634: 
                case 1611779: 
                case 1611782: 
                case 1611783: 
                case 1611785: 
                case 1611789: 
                case 1611790: 
                case 1611791: 
                case 1613825: 
                case 2134129: 
                case 2134289: 
                case 2134291: 
                case 2134294: 
                case 2134561: 
                case 0x209222: 
                case 2134798: 
                case 2134799: 
                case 2134800: 
                case 2135120: 
                case 0x220006: 
                case 2228245: 
                case 2228246: 
                case 2228247: 
                case 2228248: 
                case 2228249: 
                case 2228250: 
                case 2228251: 
                case 2228252: 
                case 2228253: 
                case 0x220020: 
                case 0x220021: 
                case 0x220022: 
                case 2228273: 
                case 0x220042: 
                case 2228312: 
                case 2626561: 
                case 2626564: 
                case 2626571: 
                case 2626572: 
                case 2633728: 
                case 2633744: 
                case 2634000: 
                case 2641920: 
                case 2646272: 
                case 2658576: 
                case 2658610: 
                case 2658629: 
                case 2659349: 
                case 2659362: 
                case 2659395: 
                case 2659585: 
                case 2659586: 
                case 2659589: 
                case 3280945: 
                case 3280996: 
                case 3670020: 
                case 3670036: 
                case 3670084: 
                case 3670116: 
                case 3670272: 
                case 3801600: 
                case 3801608: 
                case 3801609: 
                case 3801610: 
                case 3801617: 
                case 0x3A0300: 
                case 0x400008: 
                case 0x40000B: 
                case 4194342: 
                case 4194343: 
                case 4194358: 
                case 4194361: 
                case 4194362: 
                case 0x400100: 
                case 0x400220: 
                case 4194912: 
                case 4194928: 
                case 4194933: 
                case 4194945: 
                case 4194963: 
                case 4194965: 
                case 4194966: 
                case 4195086: 
                case 4195104: 
                case 4195105: 
                case 4195108: 
                case 0x400330: 
                case 0x400340: 
                case 0x400440: 
                case 0x400441: 
                case 0x400500: 
                case 4195603: 
                case 4195605: 
                case 4195608: 
                case 4195616: 
                case 0x400550: 
                case 0x400555: 
                case 4195680: 
                case 4195682: 
                case 4195738: 
                case 4195856: 
                case 4195858: 
                case 4195872: 
                case 4196122: 
                case 4196568: 
                case 4196570: 
                case 4196586: 
                case 4198410: 
                case 0x401011: 
                case 4198418: 
                case 0x401101: 
                case 0x404004: 
                case 0x404007: 
                case 0x404009: 
                case 4210709: 
                case 4210710: 
                case 4210712: 
                case 4210713: 
                case 4210721: 
                case 0x404022: 
                case 4210725: 
                case 4210726: 
                case 4210727: 
                case 4210728: 
                case 4210729: 
                case 0x404030: 
                case 4210737: 
                case 4210738: 
                case 0x404033: 
                case 0x404034: 
                case 4210741: 
                case 0x409094: 
                case 4231318: 
                case 4235331: 
                case 4235379: 
                case 4235384: 
                case 4235386: 
                case 4235388: 
                case 4235400: 
                case 4235408: 
                case 4235624: 
                case 4235632: 
                case 4235669: 
                case 4236032: 
                case 4236033: 
                case 4236128: 
                case 4236144: 
                case 4236146: 
                case 4236149: 
                case 4236165: 
                case 4236176: 
                case 4236548: 
                case 4236581: 
                case 4237104: 
                case 4239392: 
                case 4251654: 
                case 4325395: 
                case 0x500010: 
                case 5242898: 
                case 5505042: 
                case 5505043: 
                case 5505046: 
                case 5505058: 
                case 5505074: 
                case 5505106: 
                case 5505122: 
                case 5505123: 
                case 5505138: 
                case 5505568: 
                case 5505570: 
                case 5505792: 
                case 5505794: 
                case 5505796: 
                case 5505798: 
                case 5506064: 
                case 5506066: 
                case 5506068: 
                case 0x603000: 
                case 0x620002: 
                case 6422531: 
                case 6422538: 
                case 6422543: 
                case 6553602: 
                case 6553605: 
                case 6553615: 
                case 6553616: 
                case 0x660002: 
                case 0x660011: 
                case 6684690: 
                case 6684691: 
                case 0x660026: 
                case 6684711: 
                case 6684712: 
                case 6684715: 
                case 6684717: 
                case 6684718: 
                case 6684719: 
                case 0x660030: 
                case 6684724: 
                case 6684725: 
                case 0x700001: 
                case 0x700008: 
                case 0x700009: 
                case 7340122: 
                case 0x700060: 
                case 7340166: 
                case 7340808: 
                case 7340809: 
                case 7340810: 
                case 7340813: 
                case 7340817: 
                case 7340820: 
                case 7340824: 
                case 7340828: 
                case 7340830: 
                case 7341058: 
                case 0x700404: 
                case 7471116: 
                case 7471118: 
                case 7471122: 
                case 0x720020: 
                case 0x720022: 
                case 7471152: 
                case 7471166: 
                case 7471232: 
                case 7471362: 
                case 0x720200: 
                case 7471632: 
                case 7471636: 
                case 7471872: 
                case 7472128: 
                case 7472640: 
                case 7606274: 
                case 7606280: 
                case 7606286: 
                case 7606304: 
                case 7606320: 
                case 7606336: 
                case 7606338: 
                case 7606340: 
                case 7606342: 
                case 7606344: 
                case 7606346: 
                case 7606348: 
                case 7606350: 
                case 7606352: 
                case 7606800: 
                case 7606802: 
                case 7606806: 
                case 7606816: 
                case 0x880200: 
                case 0x4000401: 
                case 0x4000402: 
                case 0x4000403: 
                case 0x4000500: 
                case 0x4000550: 
                case 67110241: 
                case 536870942: 
                case 0x200000A2: 
                case 536871076: 
                case 536871080: 
                case 0x20000500: 
                case 536872208: 
                case 537920768: 
                case 537920784: 
                case 537920800: 
                case 0x20200110: 
                case 0x20200111: 
                case 538968368: 
                case 538968384: 
                case 541065232: 
                case 0x20400020: 
                case 541066496: 
                case 542113808: 
                case 0x20500500: 
                case 553649408: 
                case 555745360: 
                case 555745392: 
                case 556793872: 
                case 556793877: 
                case 556793904: 
                case 556793920: 
                case 556793936: 
                case 556793952: 
                case 556793984: 
                case 556794016: 
                case 556794048: 
                case 0x2200000D: 
                case 0x30020030: 
                case 805437504: 
                case 805568528: 
                case 805568592: 
                case 805568608: 
                case 805699600: 
                case 805699602: 
                case 805699604: 
                case 805699606: 
                case 805699616: 
                case 0x30060030: 
                case 805699641: 
                case 805699648: 
                case 805699712: 
                case 805699718: 
                case 805699744: 
                case 805699760: 
                case 805699776: 
                case 805830672: 
                case 805830688: 
                case 0x30080030: 
                case 805830720: 
                case 805830736: 
                case 805830752: 
                case 805830768: 
                case 0x30080080: 
                case 805830800: 
                case 805830816: 
                case 805830832: 
                case 805830848: 
                case 805830864: 
                case 805830880: 
                case 805830912: 
                case 805830928: 
                case 805830944: 
                case 805830960: 
                case 805830976: 
                case 805830992: 
                case 805831008: 
                case 805831200: 
                case 805831232: 
                case 805961744: 
                case 805961792: 
                case 805961800: 
                case 805961840: 
                case 805961904: 
                case 805961910: 
                case 805961930: 
                case 805961937: 
                case 805961955: 
                case 805961972: 
                case 805961991: 
                case 805962001: 
                case 805962006: 
                case 805962010: 
                case 805962112: 
                case 805962128: 
                case 805962144: 
                case 805962164: 
                case 805962246: 
                case 805962256: 
                case 805962288: 
                case 805962336: 
                case 805962368: 
                case 805962416: 
                case 805962448: 
                case 805962768: 
                case 806092802: 
                case 806092804: 
                case 806092810: 
                case 806092832: 
                case 806092864: 
                case 806092866: 
                case 806092880: 
                case 806092885: 
                case 806092896: 
                case 806092928: 
                case 806092976: 
                case 1074266192: 
                case 1074266385: 
                case 1074266391: 
                case 1074266392: 
                case 1375769129: 
                case 1375769136: 
                case 1409286400: {
                    return 21329;
                }
                case 1610265: 
                case 1610806: 
                case 1610807: 
                case 1610808: 
                case 1610809: 
                case 1610816: 
                case 1610818: 
                case 2625601: 
                case 2625792: 
                case 2625793: 
                case 2625794: 
                case 2625795: 
                case 2633730: 
                case 2646304: 
                case 2659587: 
                case 7471164: 
                case 7471230: {
                    return 21331;
                }
                case 524417: 
                case 524434: 
                case 524564: 
                case 524565: 
                case 524566: 
                case 532753: 
                case 1179729: 
                case 1609856: 
                case 1610117: 
                case 1610118: 
                case 1613827: 
                case 2626385: 
                case 2646416: 
                case 4194944: 
                case 4195088: 
                case 4195670: 
                case 4198658: 
                case 4251649: 
                case 4325392: 
                case 0x620006: 
                case 0x700006: 
                case 7340815: 
                case 7471214: 
                case 7606278: 
                case 7606282: 
                case 8915206: 
                case 0x20100010: 
                case 537919824: 
                case 805437444: 
                case 0x30060006: 
                case 805699624: 
                case 805699720: 
                case 805830674: 
                case 805830758: 
                case 805830772: 
                case 805831170: 
                case 805961732: 
                case 805961742: 
                case 805961923: 
                case 805962134: 
                case 805962150: 
                case 805962162: 
                case 805962170: 
                case 805962192: 
                case 1074266379: 
                case 1074266880: 
                case 0x40084000: {
                    return 21332;
                }
                case 524307: 
                case 524336: 
                case 524337: 
                case 524338: 
                case 524339: 
                case 524340: 
                case 524341: 
                case 1048626: 
                case 1572903: 
                case 1572917: 
                case 1576980: 
                case 1577026: 
                case 1577027: 
                case 1577074: 
                case 1577075: 
                case 1577473: 
                case 1601550: 
                case 2110469: 
                case 0x320033: 
                case 3276853: 
                case 3280897: 
                case 3280913: 
                case 3280961: 
                case 3280977: 
                case 3670043: 
                case 3670045: 
                case 3670049: 
                case 3670066: 
                case 0x400003: 
                case 0x400005: 
                case 4194885: 
                case 4194897: 
                case 4202501: 
                case 4235554: 
                case 7340163: 
                case 553648208: 
                case 805699593: 
                case 805830693: 
                case 805831012: 
                case 805831016: 
                case 805831249: 
                case 805961735: 
                case 805962286: 
                case 806223877: 
                case 1074266369: 
                case 1074266377: 
                case 1074266387: {
                    return 21581;
                }
                case 524308: 
                case 524310: 
                case 524312: 
                case 524376: 
                case 524386: 
                case 524556: 
                case 524557: 
                case 528720: 
                case 528725: 
                case 528730: 
                case 528743: 
                case 528789: 
                case 536592: 
                case 561443: 
                case 1576962: 
                case 0x20000D: 
                case 0x20000E: 
                case 0x200052: 
                case 0x200200: 
                case 2134369: 
                case 2134372: 
                case 2134802: 
                case 2134803: 
                case 2625945: 
                case 0x400554: 
                case 4210723: 
                case 4235556: 
                case 4250380: 
                case 4250381: 
                case 4251665: 
                case 6553603: 
                case 7340826: 
                case 8913216: 
                case 0x4000010: 
                case 0x4000100: 
                case 67110160: 
                case 805699620: 
                case 805699778: {
                    return 21833;
                }
                case 528737: 
                case 528738: 
                case 1577070: 
                case 1597462: 
                case 1597464: 
                case 1597466: 
                case 1597468: 
                case 1597470: 
                case 1597488: 
                case 1597490: 
                case 1597496: 
                case 1597498: 
                case 1597500: 
                case 1597502: 
                case 1597504: 
                case 1597506: 
                case 1597510: 
                case 1597512: 
                case 1597514: 
                case 1597520: 
                case 1597522: 
                case 1597526: 
                case 1597528: 
                case 1609877: 
                case 1610023: 
                case 1610073: 
                case 1610292: 
                case 2134103: 
                case 2134312: 
                case 2134359: 
                case 2134568: 
                case 2658305: 
                case 2658306: 
                case 3801104: 
                case 4235570: 
                case 4250483: 
                case 6303776: 
                case 6553607: 
                case 0x660001: 
                case 0x660003: 
                case 6684693: 
                case 6684702: 
                case 6684714: 
                case 6684716: 
                case 7471224: 
                case 7606356: {
                    return 21836;
                }
                case 524289: 
                case 524304: 
                case 524352: 
                case 524353: 
                case 528384: 
                case 1577536: 
                case 1593392: 
                case 1593408: 
                case 0x200050: 
                case 0x201020: 
                case 2621445: 
                case 2621504: 
                case 2621520: 
                case 0x280200: 
                case 2625664: {
                    return 21838;
                }
                case 528791: 
                case 1057216: 
                case 1577068: 
                case 1577540: 
                case 1577744: 
                case 1577988: 
                case 1578530: 
                case 1578531: 
                case 1578532: 
                case 1597458: 
                case 1597460: 
                case 1597476: 
                case 1597478: 
                case 1597508: 
                case 1597516: 
                case 1597518: 
                case 1609816: 
                case 1609830: 
                case 1609875: 
                case 1610289: 
                case 1610290: 
                case 1610304: 
                case 1610305: 
                case 1610551: 
                case 1610800: 
                case 1610817: 
                case 1611561: 
                case 1611577: 
                case 1611584: 
                case 2134358: 
                case 2134370: 
                case 2134371: 
                case 0x220001: 
                case 0x220002: 
                case 0x220003: 
                case 0x220004: 
                case 0x280002: 
                case 2621443: 
                case 2621446: 
                case 2621456: 
                case 2621457: 
                case 2621458: 
                case 2621460: 
                case 2621696: 
                case 2621697: 
                case 2621698: 
                case 2621699: 
                case 2621700: 
                case 2621701: 
                case 2621702: 
                case 2621703: 
                case 2621704: 
                case 2621705: 
                case 2621712: 
                case 2621713: 
                case 2621728: 
                case 2621729: 
                case 2625796: 
                case 2626563: 
                case 2626567: 
                case 2646032: 
                case 2646048: 
                case 2646064: 
                case 2646080: 
                case 2646274: 
                case 2646288: 
                case 2646290: 
                case 2658457: 
                case 2659350: 
                case 2659590: 
                case 2659591: 
                case 3801093: 
                case 3801626: 
                case 0x400300: 
                case 4195073: 
                case 4195074: 
                case 0x400303: 
                case 4231697: 
                case 4231702: 
                case 4235440: 
                case 4235574: 
                case 4235648: 
                case 5505040: 
                case 5505041: 
                case 5505056: 
                case 5505057: 
                case 5505072: 
                case 5505073: 
                case 5505075: 
                case 0x540050: 
                case 5505105: 
                case 5505107: 
                case 5505120: 
                case 5505121: 
                case 5505136: 
                case 5505137: 
                case 5505152: 
                case 5505153: 
                case 5505168: 
                case 5505280: 
                case 5505281: 
                case 5505553: 
                case 5505800: 
                case 5509936: 
                case 6303746: 
                case 6303748: 
                case 0x603006: 
                case 6303752: 
                case 6422532: 
                case 6422539: 
                case 6422540: 
                case 6422541: 
                case 6422542: 
                case 6684703: 
                case 0x700020: 
                case 7340065: 
                case 7340098: 
                case 0x700066: 
                case 0x700067: 
                case 7341057: 
                case 7471124: 
                case 7471144: 
                case 7471154: 
                case 7471160: 
                case 7471226: 
                case 7471360: 
                case 7471364: 
                case 7471366: 
                case 7471370: 
                case 7471372: 
                case 7471374: 
                case 0x720202: 
                case 7471620: 
                case 7471634: 
                case 7471638: 
                case 7471640: 
                case 7471874: 
                case 7471878: 
                case 7471880: 
                case 7471892: 
                case 7471896: 
                case 7471904: 
                case 0x4000005: 
                case 0x200000A0: 
                case 536871073: 
                case 0x20100120: 
                case 537919792: 
                case 537919838: 
                case 537919840: 
                case 0x20200010: 
                case 540016656: 
                case 541065233: 
                case 541065332: 
                case 0x2200000B: 
                case 1409290244: {
                    return 21843;
                }
                case 2654176: 
                case 4194353: 
                case 4194354: 
                case 4195842: 
                case 4235616: 
                case 4251664: 
                case 0x720070: 
                case 0x22000002: {
                    return 21844;
                }
                case -73728: 
                case -73715: 
                case -73507: {
                    return 0;
                }
            }
            switch (tag & 0xFF00FFFF) {
                case 0x50000020: 
                case 0x50001001: 
                case 0x60000040: 
                case 0x60000060: 
                case 0x60000110: 
                case 0x60001001: {
                    return 17235;
                }
                case 1610617602: 
                case 1610617603: {
                    return 17491;
                }
                case 1610612757: 
                case 1610617601: {
                    return 18771;
                }
                case 0x50000022: 
                case 0x50002500: 
                case 0x60000022: 
                case 1610612805: 
                case 1610618112: {
                    return 19535;
                }
                case 1342185486: 
                case 0x60004000: {
                    return 19540;
                }
                case 0x50003000: {
                    return 20290;
                }
                case 1342185484: 
                case 0x60003000: {
                    return 20311;
                }
                case 0x50000030: 
                case 0x50000040: 
                case 1342177542: {
                    return 21320;
                }
                case 1342187008: {
                    return 21329;
                }
                case 0x60000050: {
                    return 21331;
                }
                case 1342185478: 
                case 1342185480: 
                case 1342185482: {
                    return 21836;
                }
                case 0x60000200: {
                    return 21838;
                }
                case 0x50000005: 
                case 0x50000010: 
                case 1342177539: 
                case 1342177540: 
                case 0x50000105: 
                case 0x50000110: 
                case 1342177554: 
                case 1342177556: 
                case 0x50002000: 
                case 0x50002002: 
                case 1342185476: 
                case 1342187024: 
                case 0x60000010: 
                case 0x60000011: 
                case 1610612754: 
                case 1610612817: 
                case 1610612818: 
                case 0x60000100: 
                case 1610612994: 
                case 0x60001100: 
                case 0x60001101: 
                case 1610617090: 
                case 1610617091: 
                case 1610617344: 
                case 1610617345: 
                case 1610617346: 
                case 1610617347: {
                    return 21843;
                }
            }
            switch (tag & 0xFFFFFF00) {
                case 2109696: {
                    return 21320;
                }
            }
            return 21838;
        }
    };

    public int lookup(int var1);
}

