/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.data;

import java.nio.ByteOrder;
import org.dcm4che.data.DcmEncodeParam;

public class DcmDecodeParam {
    public final ByteOrder byteOrder;
    public final boolean explicitVR;
    public final boolean deflated;
    public final boolean encapsulated;
    public static final DcmEncodeParam IVR_LE = new DcmEncodeParam(ByteOrder.LITTLE_ENDIAN, false, false, false, false, false, false);
    public static final DcmEncodeParam IVR_BE = new DcmEncodeParam(ByteOrder.BIG_ENDIAN, false, false, false, true, true, true);
    public static final DcmEncodeParam EVR_LE = new DcmEncodeParam(ByteOrder.LITTLE_ENDIAN, true, false, false, true, true, true);
    public static final DcmEncodeParam EVR_BE = new DcmEncodeParam(ByteOrder.BIG_ENDIAN, true, false, false, true, true, true);
    public static final DcmEncodeParam DEFL_EVR_LE = new DcmEncodeParam(ByteOrder.LITTLE_ENDIAN, true, true, false, true, true, true);
    public static final DcmEncodeParam ENCAPS_EVR_LE = new DcmEncodeParam(ByteOrder.LITTLE_ENDIAN, true, false, true, true, true, true);

    public DcmDecodeParam(ByteOrder byteOrder, boolean explicitVR, boolean deflated, boolean encapsulated) {
        if (byteOrder == null) {
            throw new NullPointerException();
        }
        this.byteOrder = byteOrder;
        this.explicitVR = explicitVR;
        this.deflated = deflated;
        this.encapsulated = encapsulated;
    }

    public String toString() {
        return (this.explicitVR ? "explVR-" : "implVR-") + this.byteOrder.toString() + (this.deflated ? " deflated" : "") + (this.encapsulated ? " encapsulated" : "");
    }

    public static final DcmEncodeParam valueOf(String tsuid) {
        if ("1.2.840.10008.1.2".equals(tsuid)) {
            return IVR_LE;
        }
        if ("1.2.840.10008.1.2.1".equals(tsuid) || "1.2.840.10008.1.2.4.94".equals(tsuid) || "1.2.840.10008.1.2.4.96".equals(tsuid)) {
            return EVR_LE;
        }
        if ("1.2.840.10008.1.2.1.99".equals(tsuid) || "1.2.840.10008.1.2.4.95".equals(tsuid) || "1.2.840.10008.1.2.4.97".equals(tsuid)) {
            return DEFL_EVR_LE;
        }
        if ("1.2.840.10008.1.2.2".equals(tsuid)) {
            return EVR_BE;
        }
        return ENCAPS_EVR_LE;
    }
}

