/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.FileFormat;
import org.dcm4che.data.FileMetaInfo;

public final class DatasetSerializer
implements Serializable {
    static final long serialVersionUID = -4404056689087154718L;
    private static final int ITEM_DELIMITATION_ITEM_TAG = -73715;
    private static final byte[] ITEM_DELIMITATION_ITEM_ELEM_LE = new byte[]{-2, -1, 13, -32, 0, 0, 0, 0};
    private static final byte[] ITEM_DELIMITATION_ITEM_ELEM_BE = new byte[]{-1, -2, -32, 13, 0, 0, 0, 0};
    private transient Dataset ds;

    public DatasetSerializer() {
    }

    public DatasetSerializer(Dataset ds) {
        this.ds = ds;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        FileMetaInfo fmi = this.ds.getFileMetaInfo();
        if (fmi == null) {
            out.writeBoolean(false);
            this.ds.writeFile(out, DcmEncodeParam.EVR_LE);
            out.write(ITEM_DELIMITATION_ITEM_ELEM_LE);
        } else {
            out.writeBoolean(true);
            this.ds.writeFile(out, null);
            out.write(fmi.getTransferSyntaxUID() == "1.2.840.10008.1.2.2" ? ITEM_DELIMITATION_ITEM_ELEM_BE : ITEM_DELIMITATION_ITEM_ELEM_LE);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.ds = DcmObjectFactory.getInstance().newDataset();
        this.ds.readFile(in, in.readBoolean() ? FileFormat.DICOM_FILE : FileFormat.EVR_LE_STREAM, -73715);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.ds;
    }
}

