/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.client;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.dcm4che.client.DataSourceImageOutputStream;
import org.dcm4che.client.LutBuffer;
import org.dcm4che.client.PrintSCU;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.image.PixelDataDescription;
import org.dcm4che.image.PixelDataFactory;
import org.dcm4che.image.PixelDataReader;
import org.dcm4che.image.PixelDataWriter;
import org.dcm4che.net.DataSource;

class PrintSCUDataSource
implements DataSource {
    private static final Logger log = Logger.getLogger(PrintSCUDataSource.class);
    private static final DcmParserFactory parserFact = DcmParserFactory.getInstance();
    private final PrintSCU printSCU;
    private final Dataset imageBox;
    private final File file;
    private final File psFile;
    private final boolean burnInOverlays;
    private final boolean autoScale;
    private static final PixelDataFactory pdFact = PixelDataFactory.getInstance();
    private static final Dataset IMAGE_MODULE = PrintSCU.dcmFact.newDataset();

    public PrintSCUDataSource(PrintSCU printSCU, Dataset imageBox, File file, File psFile, boolean burnInOverlays, boolean autoScale) {
        this.printSCU = printSCU;
        this.imageBox = imageBox;
        this.file = file;
        this.psFile = psFile;
        this.burnInOverlays = burnInOverlays;
        this.autoScale = autoScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, String tsUID) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
        Dataset ds = PrintSCU.dcmFact.newDataset();
        Dataset ps = this.psFile != null ? PrintSCU.dcmFact.newDataset() : ds;
        try {
            boolean windowPresent;
            int toBitsAllocated;
            int toBitsStored;
            DcmParser parser = parserFact.newDcmParser(in);
            parser.setDcmHandler(ds.getDcmHandler());
            parser.parseDcmFile(null, 2145386512);
            if (this.psFile != null) {
                DcmParser psParser = parserFact.newDcmParser(new BufferedInputStream(new FileInputStream(this.psFile)));
                psParser.setDcmHandler(ps.getDcmHandler());
                psParser.parseDcmFile(null, -1);
            }
            if (parser.getReadTag() != 2145386512) {
                throw new IOException("No Pixel Data in file - " + this.file);
            }
            DcmDecodeParam decodeParam = parser.getDcmDecodeParam();
            DcmEncodeParam encodeParam = DcmDecodeParam.valueOf(tsUID);
            PixelDataDescription toDesc = null;
            PixelDataDescription fromDesc = new PixelDataDescription(ds, decodeParam.byteOrder, parser.getReadVR());
            if (fromDesc.getNumberOfFrames() > 1) {
                throw new IOException("multi-frame images are not currently supported");
            }
            int bitsAlloc = ds.getInt(2621696, 8);
            int bitsStored = ds.getInt(2621697, 8);
            int highBit = ds.getInt(2621698, bitsStored - 1);
            int cols = ds.getInt(2621457, 0);
            int rows = ds.getInt(2621456, 0);
            int spp = ds.getInt(0x280002, 1);
            boolean signed = ds.getInt(2621699, 0) == 1;
            String pmi = ds.getString(2621444, "MONOCHROME2");
            if (bitsStored == 32 && !signed) {
                throw new IOException("conversion from " + bitsStored + " bits stored, unsigned is not currently supported");
            }
            if (this.printSCU.isColorPrint()) {
                if (!"RGB".equals(pmi)) {
                    throw new IOException("Conversion from " + pmi + " to RGB not currently supported");
                }
            } else if (!"MONOCHROME2".equals(pmi) && !"MONOCHROME1".equals(pmi)) {
                throw new IOException("Conversion from " + pmi + " to MONOCHROME not currently supported");
            }
            if (bitsStored > 8) {
                toBitsStored = 12;
                toBitsAllocated = 16;
            } else {
                toBitsStored = 8;
                toBitsAllocated = 8;
            }
            if (bitsStored != toBitsStored || bitsAlloc != toBitsAllocated || highBit != bitsStored - 1 || signed || !fromDesc.isByPlane() && spp > 1) {
                if (!this.autoScale) {
                    throw new IllegalArgumentException("The image's pixel formatis incompatable for an Image Box and auto-scale is disabled");
                }
                toDesc = new PixelDataDescription(fromDesc, encodeParam, toBitsAllocated, toBitsStored, false, true);
                ds.putUS(2621697, toBitsStored);
                ds.putUS(2621696, toBitsAllocated);
                ds.putUS(2621698, toBitsStored - 1);
                ds.putUS(2621699, 0);
                ds.putUS(2621446, 1);
            } else {
                toDesc = fromDesc;
            }
            log.debug("readlen=" + parser.getReadLength() + "calclen=" + toDesc.calcPixelDataLength());
            this.imageBox.writeDataset(out, encodeParam);
            ds.writeHeader(out, encodeParam, this.printSCU.isColorPrint() ? 0x20200111 : 0x20200110, 21329, -1);
            ds.writeHeader(out, encodeParam, -73728, 0, -1);
            int[][] buff = null;
            PixelDataReader pd = null;
            if (this.burnInOverlays) {
                int burnValue;
                int group = 0x60000000;
                int cntr = 16;
                Vector<Overlay> list = new Vector<Overlay>(16);
                while (cntr > 0) {
                    DcmElement el = ds.get(group | 0x3000);
                    if (el != null) {
                        list.add(new Overlay(group, ds));
                    }
                    if (ps != ds && (el = ps.get(group | 0x3000)) != null) {
                        list.add(new Overlay(group, ps));
                    }
                    --cntr;
                    group += 131072;
                }
                Overlay[] overlays = list.toArray(new Overlay[0]);
                list = null;
                int n = burnValue = signed ? (1 << highBit) - 1 : -1;
                if (overlays.length > 0) {
                    if (buff == null) {
                        pd = this.readPixelData(fromDesc, in);
                        buff = pd.getPixelDataArray(0);
                    }
                    for (int i = 0; i < overlays.length; ++i) {
                        try {
                            Overlay ovl = overlays[i];
                            int colstart = Math.max(0, ovl.x);
                            int colend = Math.min(ovl.x + ovl.cols, cols);
                            int rowstart = Math.max(0, ovl.y);
                            int rowend = Math.min(ovl.y + ovl.rows, rows);
                            int x = ovl.x >= 0 ? 0 : -ovl.x;
                            int y = ovl.y >= 0 ? 0 : -ovl.y;
                            int mask = 1;
                            int ind = x + y * ovl.cols;
                            for (int j = rowstart; j < rowend; ++j) {
                                for (int k = colstart; k < colend; ++k) {
                                    if ((ovl.data[ind >> 3] & mask) > 0) {
                                        for (int s = 0; s < spp; ++s) {
                                            buff[s][j * cols + k] = burnValue;
                                        }
                                    }
                                    ++ind;
                                    if (mask == 128) {
                                        mask = 1;
                                        continue;
                                    }
                                    mask <<= 1;
                                }
                                ind = x + (y + j + 1) * ovl.cols;
                            }
                            continue;
                        }
                        catch (IndexOutOfBoundsException e) {
                            log.error("Bad overlay plane data (" + i + "), not enough data");
                        }
                    }
                }
                if (bitsAlloc > bitsStored) {
                    if (buff == null) {
                        pd = this.readPixelData(fromDesc, in);
                        buff = pd.getPixelDataArray(0);
                    }
                    int mask = ~((1 << bitsStored) - 1 << highBit - bitsStored + 1);
                    for (int s = 0; s < spp; ++s) {
                        for (int i = 0; i < buff[s].length; ++i) {
                            if ((buff[s][i] & mask) == 0) continue;
                            buff[s][i] = burnValue;
                        }
                    }
                }
            }
            float rs = ps.getFloat(2625619, 1.0f);
            float ri = ps.getFloat(2625618, 0.0f);
            int winTop = 0;
            int winBot = 0;
            Dataset voi = this.getVoiDataset(ds, ps);
            boolean bl = windowPresent = voi.contains(2625616) && voi.contains(2625617);
            if (windowPresent) {
                winTop = (int)Math.ceil((voi.getFloat(2625616, 0.0f) + voi.getFloat(2625617, 0.0f) / 2.0f - ri) / rs);
                winBot = (int)Math.floor((voi.getFloat(2625616, 0.0f) - voi.getFloat(2625617, 0.0f) / 2.0f - ri) / rs);
            }
            LutBuffer mlut = null;
            LutBuffer vlut = null;
            LutBuffer plut = null;
            LutBuffer lut = null;
            if ("MONOCHROME1".equals(pmi) || "MONOCHROME2".equals(pmi)) {
                float mpv = rs >= 0.0f ? (float)fromDesc.minPossibleStoredValue() * rs + ri : (float)fromDesc.maxPossibleStoredValue() * rs + ri;
                Dataset item = ps.getItem(2633728);
                if (item != null) {
                    mlut = new LutBuffer(item.getByteBuffer(2633734), item.getInts(2633730), signed ? 21331 : 21843);
                }
                if ((item = voi.getItem(2633744)) != null) {
                    vlut = new LutBuffer(item.getByteBuffer(2633734), item.getInts(2633730), mlut != null ? 21843 : (mpv < 0.0f ? 21331 : 21843));
                }
                if (mlut != null && vlut != null) {
                    lut = this.combineLuts(mlut, vlut);
                } else if (mlut != null) {
                    lut = mlut;
                } else if (vlut != null) {
                    lut = vlut;
                }
                item = ps.getItem(542113808);
                if (item != null) {
                    plut = new LutBuffer(item.getByteBuffer(2633734), item.getInts(2633730), 21843);
                    ds.putCS(2621444, "MONOCHROME2");
                } else if ("INVERSE".equals(ps.getString(0x20500020))) {
                    ds.putCS(2621444, "MONOCHROME2".equals(pmi) ? "MONOCHROME1" : "MONOCHROME2");
                }
            }
            ds.subSet(IMAGE_MODULE).writeDataset(out, encodeParam);
            ds.writeHeader(out, encodeParam, parser.getReadTag(), toDesc.getPixelDataVr(), (int)toDesc.calcPixelDataLength());
            if (lut != null) {
                if (buff == null) {
                    pd = this.readPixelData(fromDesc, in);
                    buff = pd.getPixelDataArray(0);
                }
                if (plut != null) {
                    this.scaleToRangeWithLUTAndPLut(buff, fromDesc, toBitsStored, false, rs, ri, lut, plut, winBot, winTop);
                } else {
                    this.scaleToRangeWithLUT(buff, fromDesc, toBitsStored, false, rs, ri, lut, winBot, winTop);
                }
            } else if (plut != null) {
                if (buff == null) {
                    pd = this.readPixelData(fromDesc, in);
                    buff = pd.getPixelDataArray(0);
                }
                this.scaleToRangeWithPLut(buff, fromDesc, toBitsStored, false, plut, winBot, winTop);
            } else if (toDesc != fromDesc || windowPresent) {
                if (buff == null) {
                    pd = this.readPixelData(fromDesc, in);
                    buff = pd.getPixelDataArray(0);
                }
                this.scaleToRange(buff, fromDesc, toBitsStored, false, winBot, winTop);
            }
            if (pd != null) {
                int[][][] tmp = new int[1][0][0];
                tmp[0] = buff;
                PixelDataWriter pdWriter = pdFact.newWriter(tmp, false, toDesc, new DataSourceImageOutputStream(out));
                pdWriter.writePixelData();
            } else {
                this.copy(in, out, parser.getReadLength());
            }
            ds.writeHeader(out, encodeParam, -73715, 0, 0);
            ds.writeHeader(out, encodeParam, -73507, 0, 0);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException ignore) {}
        }
    }

    private Dataset getVoiDataset(Dataset ds, Dataset ps) {
        DcmElement scVoiLutSeq = ps.get(2634000);
        if (ds == ps || scVoiLutSeq == null) {
            return ds;
        }
        String iuid = ds.getString(524312);
        int n = scVoiLutSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = scVoiLutSeq.getItem(i);
            DcmElement ris = item.get(528704);
            if (ris != null) {
                for (int j = 0; j < ris.countItems(); ++j) {
                    if (!ris.getItem(j).getString(528725, "").equals(iuid)) continue;
                    return item;
                }
                continue;
            }
            return item;
        }
        return ds;
    }

    private PixelDataReader readPixelData(PixelDataDescription desc, InputStream in) throws IOException {
        PixelDataReader reader = pdFact.newReader(desc, ImageIO.createImageInputStream(in));
        reader.readPixelData(true);
        return reader;
    }

    private LutBuffer combineLuts(LutBuffer lut0, LutBuffer lut1) {
        return this.combineLuts(new LutBuffer[]{lut0, lut1});
    }

    private LutBuffer combineLuts(LutBuffer[] luts) {
        int n = luts[0].getLutSize();
        byte[] olut = new byte[n * 2];
        int olutInd = 0;
        for (int i = 0; i < n; ++i) {
            int curVal = luts[0].getEntry(i);
            for (int j = 1; j < luts.length; ++j) {
                curVal = luts[j].getEntryFromInput(curVal);
            }
            olut[olutInd++] = (byte)curVal;
            olut[olutInd++] = (byte)(curVal >> 8);
        }
        ByteBuffer wrapped = ByteBuffer.wrap(olut);
        wrapped.order(ByteOrder.LITTLE_ENDIAN);
        return new LutBuffer(wrapped, n, luts[0].getFirstValueMapped(), luts[luts.length - 1].getDepth(), 1);
    }

    private void scaleToRangeWithPLut(int[][] pixelData, PixelDataDescription from, int toBitDepth, boolean toSigned, LutBuffer plut, int start, int end) {
        int max;
        int fromBitDepth = from.getBitsStored();
        int min = from.isSigned() ? -(1 << fromBitDepth - 1) : 0;
        int n = max = from.isSigned() ? (1 << fromBitDepth - 1) - 1 : (1 << fromBitDepth) - 1;
        if (start == end) {
            start = min;
            end = max;
        }
        int rngOrig = end - start;
        int newMin = toSigned ? -(1 << toBitDepth - 1) : 0;
        int newMax = toSigned ? (1 << toBitDepth - 1) - 1 : (1 << toBitDepth) - 1;
        int rngNew = newMax - newMin;
        int plutRng = (1 << plut.getDepth()) - 1;
        int plutInputUB = plut.getLutSize() - 1;
        float f1 = (float)(plut.getLutSize() - 1) / (float)rngOrig;
        float f2 = (float)rngNew / (float)plutRng;
        int leftShift = 32 - from.getHighBit() - 1;
        int rightShift = 32 - from.getBitsStored();
        int plutMinMappedValue = (int)((float)plut.getEntry(0) * f2 + 0.5f) - newMin;
        int plutMaxMappedValue = (int)((float)plut.getEntry(plutInputUB) * f2 + 0.5f) - newMin;
        if (from.isSigned()) {
            for (int s = 0; s < pixelData.length; ++s) {
                for (int i = 0; i < pixelData[s].length; ++i) {
                    double tmp = (float)((pixelData[s][i] << leftShift >> rightShift) - start) * f1;
                    pixelData[s][i] = tmp < 0.0 ? plutMinMappedValue : (tmp > (double)plutInputUB ? plutMaxMappedValue : (int)((float)plut.getEntry((int)(tmp + 0.5)) * f2 + 0.5f) - newMin);
                }
            }
        } else {
            for (int s = 0; s < pixelData.length; ++s) {
                for (int i = 0; i < pixelData[s].length; ++i) {
                    double tmp = (float)((pixelData[s][i] << leftShift >>> rightShift) - start) * f1;
                    pixelData[s][i] = tmp < 0.0 ? plutMinMappedValue : (tmp > (double)plutInputUB ? plutMaxMappedValue : (int)((float)plut.getEntry((int)(tmp + 0.5)) * f2 + 0.5f) - newMin);
                }
            }
        }
    }

    private void scaleToRangeWithLUTAndPLut(int[][] pixelData, PixelDataDescription from, int toBitDepth, boolean toSigned, float rescaleSlope, float rescaleInt, LutBuffer lut, LutBuffer plut, int start, int end) {
        int fromBitDepth = lut.getDepth();
        int min = 0;
        int max = (1 << fromBitDepth) - 1;
        if (start == end) {
            start = min;
            end = max;
        }
        int rngOrig = end - start;
        int newMin = toSigned ? -(1 << toBitDepth - 1) : 0;
        int newMax = toSigned ? (1 << toBitDepth - 1) - 1 : (1 << toBitDepth) - 1;
        int rngNew = newMax - newMin;
        int plutRng = (1 << plut.getDepth()) - 1;
        int plutInputUB = plut.getLutSize() - 1;
        float f1 = (float)(plut.getLutSize() - 1) / (float)rngOrig;
        float f2 = (float)rngNew / (float)plutRng;
        int leftShift = 32 - from.getHighBit() - 1;
        int rightShift = 32 - from.getBitsStored();
        int plutMinMappedValue = (int)((float)plut.getEntry(0) * f2 + 0.5f) - newMin;
        int plutMaxMappedValue = (int)((float)plut.getEntry(plutInputUB) * f2 + 0.5f) - newMin;
        if (from.isSigned()) {
            for (int s = 0; s < pixelData.length; ++s) {
                for (int i = 0; i < pixelData[s].length; ++i) {
                    double tmp = (float)(pixelData[s][i] << leftShift >> rightShift) * rescaleSlope + rescaleInt;
                    tmp = lut.getEntryFromInput((int)(tmp + 0.5));
                    pixelData[s][i] = (tmp = (tmp - (double)start) * (double)f1) < 0.0 ? plutMinMappedValue : (tmp > (double)plutInputUB ? plutMaxMappedValue : (int)((float)plut.getEntry((int)(tmp + 0.5)) * f2 + 0.5f) - newMin);
                }
            }
        } else {
            for (int s = 0; s < pixelData.length; ++s) {
                for (int i = 0; i < pixelData[s].length; ++i) {
                    double tmp = (float)(pixelData[s][i] << leftShift >>> rightShift) * rescaleSlope + rescaleInt;
                    tmp = lut.getEntryFromInput((int)(tmp + 0.5));
                    pixelData[s][i] = (tmp = (tmp - (double)start) * (double)f1) < 0.0 ? plutMinMappedValue : (tmp > (double)plutInputUB ? plutMaxMappedValue : (int)((float)plut.getEntry((int)(tmp + 0.5)) * f2 + 0.5f) - newMin);
                }
            }
        }
    }

    private void scaleToRangeWithLUT(int[][] pixelData, PixelDataDescription from, int toBitDepth, boolean toSigned, float rescaleSlope, float rescaleInt, LutBuffer lut, int start, int end) {
        int fromBitDepth = lut.getDepth();
        int min = 0;
        int max = (1 << fromBitDepth) - 1;
        if (start == end) {
            start = min;
            end = max;
        }
        int rngOrig = end - start;
        int newMin = toSigned ? -(1 << toBitDepth - 1) : 0;
        int newMax = toSigned ? (1 << toBitDepth - 1) - 1 : (1 << toBitDepth) - 1;
        int rngNew = newMax - newMin;
        float f = (float)rngNew / (float)rngOrig;
        int leftShift = 32 - from.getHighBit() - 1;
        int rightShift = 32 - from.getBitsStored();
        if (from.isSigned()) {
            for (int s = 0; s < pixelData.length; ++s) {
                for (int i = 0; i < pixelData[s].length; ++i) {
                    double tmp = (float)(pixelData[s][i] << leftShift >> rightShift) * rescaleSlope + rescaleInt;
                    tmp = lut.getEntryFromInput((int)(tmp + 0.5));
                    pixelData[s][i] = (tmp = (tmp - (double)start) * (double)f) < 0.0 ? newMin : (tmp > (double)rngNew ? newMax : (int)(tmp + 0.5) - newMin);
                }
            }
        } else {
            for (int s = 0; s < pixelData.length; ++s) {
                for (int i = 0; i < pixelData[s].length; ++i) {
                    double tmp = (float)(pixelData[s][i] << leftShift >>> rightShift) * rescaleSlope + rescaleInt;
                    tmp = lut.getEntryFromInput((int)(tmp + 0.5));
                    pixelData[s][i] = (tmp = (tmp - (double)start) * (double)f) < 0.0 ? newMin : (tmp > (double)rngNew ? newMax : (int)(tmp + 0.5) - newMin);
                }
            }
        }
    }

    private void scaleToRange(int[][] pixelData, PixelDataDescription from, int toBitDepth, boolean toSigned, int start, int end) {
        int max;
        int fromBitDepth = from.getBitsStored();
        int min = from.isSigned() ? -(1 << fromBitDepth - 1) : 0;
        int n = max = from.isSigned() ? (1 << fromBitDepth - 1) - 1 : (1 << fromBitDepth) - 1;
        if (start == end) {
            start = min;
            end = max;
        }
        int rngOrig = end - start;
        int newMin = toSigned ? -(1 << toBitDepth - 1) : 0;
        int newMax = toSigned ? (1 << toBitDepth - 1) - 1 : (1 << toBitDepth) - 1;
        int rngNew = newMax - newMin;
        float f = (float)rngNew / (float)rngOrig;
        int leftShift = 32 - from.getHighBit() - 1;
        int rightShift = 32 - fromBitDepth;
        if (from.isSigned()) {
            for (int s = 0; s < pixelData.length; ++s) {
                for (int i = 0; i < pixelData[s].length; ++i) {
                    float tmp = (float)((pixelData[s][i] << leftShift >> rightShift) - start) * f;
                    pixelData[s][i] = tmp < 0.0f ? newMin : (tmp > (float)rngNew ? newMax : (int)(tmp + 0.5f) - newMin);
                }
            }
        } else {
            for (int s = 0; s < pixelData.length; ++s) {
                for (int i = 0; i < pixelData[s].length; ++i) {
                    float tmp = (float)((pixelData[s][i] << leftShift >>> rightShift) - start) * f;
                    pixelData[s][i] = tmp < 0.0f ? newMin : (tmp > (float)rngNew ? newMax : (int)(tmp + 0.5f) - newMin);
                }
            }
        }
    }

    private void copy(InputStream in, OutputStream out, int len) throws IOException {
        int c;
        byte[] buffer = this.printSCU.getBuffer();
        for (int remain = len; remain > 0; remain -= c) {
            c = in.read(buffer, 0, Math.min(buffer.length, remain));
            if (c == -1) {
                throw new EOFException("EOF during read of pixel data");
            }
            out.write(buffer, 0, c);
        }
    }

    static {
        IMAGE_MODULE.putUS(0x280002);
        IMAGE_MODULE.putCS(2621444);
        IMAGE_MODULE.putUS(2621446);
        IMAGE_MODULE.putUS(2621456);
        IMAGE_MODULE.putUS(2621457);
        IMAGE_MODULE.putIS(2621492);
        IMAGE_MODULE.putUS(2621696);
        IMAGE_MODULE.putUS(2621697);
        IMAGE_MODULE.putUS(2621698);
        IMAGE_MODULE.putUS(2621699);
    }

    private static final class Overlay {
        public int cols;
        public int rows;
        public int x;
        public int y;
        public byte[] data;

        public Overlay(int group, Dataset ds) {
            int OvRows = 16;
            int OvCols = 17;
            int OvOrigin = 80;
            int OvData = 12288;
            this.data = ds.getByteBuffer(group | 0x3000).array();
            if (this.data == null) {
                throw new IllegalArgumentException("no overlay data");
            }
            int[] origin = ds.getInts(group | 0x50);
            this.x = origin[0] - 1;
            this.y = origin[1] - 1;
            this.cols = ds.getInt(group | 0x11, 0);
            this.rows = ds.getInt(group | 0x10, 0);
            if (this.cols == 0 || this.rows == 0) {
                throw new IllegalArgumentException("bad/no cols/rows in overlay");
            }
        }
    }
}

