/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che;

import java.util.ResourceBundle;

public class Implementation {
    private static final ResourceBundle rb = ResourceBundle.getBundle(Implementation.class.getName());

    public static String getClassUID() {
        return rb.getString("dcm4che.ImplementationClassUID");
    }

    public static String getVersionName() {
        return rb.getString("dcm4che.ImplementationVersionName");
    }

    public static Object findFactory(String key) {
        String name = rb.getString(key);
        try {
            return Implementation.getProviderClass(name).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationError("class not found: " + name, ex);
        }
        catch (InstantiationException ex) {
            throw new ConfigurationError("could not instantiate: " + name, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationError("could not instantiate: " + name, ex);
        }
    }

    private static Class getProviderClass(String className) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(className, true, Implementation.class.getClassLoader());
    }

    private Implementation() {
    }

    static class ConfigurationError
    extends Error {
        ConfigurationError(String msg, Exception x) {
            super(msg, x);
        }
    }
}

