/*
 * Decompiled with CFR 0.152.
 */
package org.regenstrief.xhl7;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.regenstrief.xhl7.MLLPDriver;

public class MLLPClient {
    MLLPDriver _driver;
    OutputStream _outputStream;
    public static String SAMPLE_MESSAGE = "MSH|^~\\&|EPIC|EPICADT|SMS|SMSADT|199912271408|CHARRIS|ADT^A04|1817457|D|2.3|\nEVN|A04|199912271408|||CHARRIS\nPID||0493575^^^2^ID 1|454721||DOE^JOHN^^^^|DOE^JOHN^^^^|19480203|M||B|254 E238ST^^EUCLID^OH^44123^USA||(216)731-4359|||M|NON|400003403~1129086|999-|\nNK1||CONROY^MARI^^^^|SPO||(216)731-4359||EC|||||||||||||||||||||||||||\nPV1||O|168   ~219~C~PMA^^^^^^^^^||||277^ALLEN FADZL^BONNIE^^^^|||||||||| ||2688684|||||||||||||||||||||||||199912271408||||||002376853";

    public MLLPClient(String theServer, String thePort) throws IOException {
        Socket socket = new Socket(theServer, Integer.parseInt(thePort));
        this._driver = new MLLPDriver(socket.getInputStream(), socket.getOutputStream(), true);
    }

    public MLLPClient(Socket socket) throws IOException {
        this._driver = new MLLPDriver(socket.getInputStream(), socket.getOutputStream(), true);
    }

    public MLLPClient(SocketFactory socketFactory, String theServer, String thePort) throws IOException {
        Socket socket = socketFactory.createSocket(theServer, Integer.parseInt(thePort));
        this._driver = new MLLPDriver(socket.getInputStream(), socket.getOutputStream(), true);
    }

    public static MLLPClient makeSSLClient(String theServer, String thePort) throws IOException {
        return new MLLPClient(SSLSocketFactory.getDefault(), theServer, thePort);
    }

    protected void close() throws IOException {
        this._driver.close();
    }

    private String sendMessage(String theMessage) throws IOException {
        StringBuffer theResponse = new StringBuffer();
        InputStream in = this._driver.getInputStream();
        PrintStream out = new PrintStream(this._driver.getOutputStream());
        System.err.println("sending: " + theMessage);
        out.println(theMessage);
        this._driver.turn();
        if (this._driver.hasMoreInput()) {
            int c = in.read();
            while (c != -1) {
                theResponse.append((char)c);
                c = in.read();
            }
        }
        return theResponse.toString();
    }

    private String sendFile(String theFileName) throws IOException {
        String thisLine;
        String theResponse = new String();
        System.out.print("Loading " + theFileName + ".. ");
        String theHl7Text = "";
        BufferedReader br = new BufferedReader(new FileReader(theFileName));
        while ((thisLine = br.readLine()) != null) {
            theHl7Text = theHl7Text.concat(thisLine);
            if (!br.ready()) continue;
            theHl7Text = theHl7Text.concat("\n");
        }
        theResponse = this.sendMessage(theHl7Text);
        System.out.println("... sending comleted.");
        return theResponse.toString();
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("\tjava org.regenstrief.xhl7.MLLPClient [-s] server port [file]");
    }

    public static void main(String[] args) throws IOException {
        boolean useSSL = false;
        System.out.println("Simple HL7 v2.x LLP Client");
        int argi = 0;
        String theServer = "";
        String thePort = "";
        if (args.length > 2 && args[argi].equals("-s")) {
            useSSL = true;
            ++argi;
        }
        if (args.length - argi <= 1) {
            MLLPClient.usage();
            return;
        }
        theServer = args[argi++];
        thePort = args[argi++];
        MLLPClient client = useSSL ? MLLPClient.makeSSLClient(theServer, thePort) : new MLLPClient(theServer, thePort);
        String rs = "<no response>";
        rs = args.length - argi > 0 ? client.sendFile(args[argi]) : client.sendMessage(SAMPLE_MESSAGE);
        System.out.println("Response: " + rs);
        client.close();
    }
}

