/*
 * Decompiled with CFR 0.152.
 */
package org.regenstrief.xhl7;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.regenstrief.xhl7.HL7XMLLiterate;
import org.regenstrief.xhl7.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HL7XMLWriter
implements ContentHandler,
HL7XMLLiterate,
XMLWriter {
    private Writer _output = new OutputStreamWriter(System.out);
    private char[] _delimiters = "|^~\\&".toCharArray();

    public HL7XMLWriter() {
    }

    public HL7XMLWriter(OutputStream outputStream) {
        this.setOutputStream(outputStream);
    }

    public HL7XMLWriter(Writer output) {
        this.setOutput(output);
    }

    public void setOutput(Writer output) {
        if (output == null) {
            throw new NullPointerException("output");
        }
        this._output = output;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._output = new OutputStreamWriter(outputStream);
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            int nextWritePosition = start;
            int endPosition = start + length;
            block2: while (nextWritePosition < endPosition) {
                int unescapeableRegionPosition = nextWritePosition;
                while (unescapeableRegionPosition < endPosition) {
                    char c = ch[unescapeableRegionPosition++];
                    for (int i = 0; i < 5; ++i) {
                        if (c != this._delimiters[i]) continue;
                        int writeLength = unescapeableRegionPosition - 1 - nextWritePosition;
                        if (writeLength > 0) {
                            this._output.write(ch, nextWritePosition, writeLength);
                        }
                        this._output.write(this._delimiters[3]);
                        this._output.write("FSRET".charAt(i));
                        this._output.write(this._delimiters[3]);
                        nextWritePosition = unescapeableRegionPosition;
                        continue block2;
                    }
                    if (c != '\r' && c != '\n') continue;
                    int writeLength = unescapeableRegionPosition - 1 - nextWritePosition;
                    if (unescapeableRegionPosition < endPosition) {
                        char nextc = ch[unescapeableRegionPosition];
                        if (c == '\r' && nextc == '\n') {
                            ++unescapeableRegionPosition;
                        }
                    }
                    if (writeLength > 0) {
                        this._output.write(ch, nextWritePosition, writeLength);
                    }
                    this._output.write(this._delimiters[3]);
                    this._output.write(".br");
                    this._output.write(this._delimiters[3]);
                    nextWritePosition = unescapeableRegionPosition;
                    continue block2;
                }
                int writeLength = unescapeableRegionPosition - nextWritePosition;
                if (writeLength > 0) {
                    this._output.write(ch, nextWritePosition, writeLength);
                }
                nextWritePosition = unescapeableRegionPosition;
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            localName = localName.intern();
            if (localName == "field") {
                this._output.write(this._delimiters[0]);
            } else if (localName == "repeat") {
                this._output.write(this._delimiters[2]);
            } else if (localName == "component") {
                this._output.write(this._delimiters[1]);
            } else if (localName == "subcomponent") {
                this._output.write(this._delimiters[4]);
            } else if (localName == "escape") {
                this._output.write(this._delimiters[3]);
            } else if (localName == "FHS" || localName == "BHS" || localName == "MSH") {
                String escapeDelimiter;
                String subcomponentDelimiter;
                String componentDelimiter;
                String repeatDelimiter;
                String fieldDelimiter = atts.getValue("fieldDelimiter");
                if (fieldDelimiter != null) {
                    this._delimiters[0] = fieldDelimiter.charAt(0);
                }
                if ((repeatDelimiter = atts.getValue("repeatDelimiter")) != null) {
                    this._delimiters[2] = repeatDelimiter.charAt(0);
                }
                if ((componentDelimiter = atts.getValue("componentDelimiter")) != null) {
                    this._delimiters[1] = componentDelimiter.charAt(0);
                }
                if ((subcomponentDelimiter = atts.getValue("subcomponentDelimiter")) != null) {
                    this._delimiters[4] = subcomponentDelimiter.charAt(0);
                }
                if ((escapeDelimiter = atts.getValue("escapeDelimiter")) != null) {
                    this._delimiters[3] = escapeDelimiter.charAt(0);
                }
                this._output.write(localName);
                this._output.write(this._delimiters);
            } else if (localName != "hl7") {
                this._output.write(localName);
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            localName = localName.intern();
            if (localName != "field" && localName != "repeat" && localName != "component" && localName != "subcomponent") {
                if (localName == "escape") {
                    this._output.write(this._delimiters[3]);
                } else if (localName != "hl7") {
                    this._output.write(13);
                    this._output.flush();
                }
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }
}

