/*
 * Decompiled with CFR 0.152.
 */
package org.regenstrief.xhl7;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.regenstrief.xhl7.HL7XMLLiterate;
import org.regenstrief.xhl7.HL7XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class HL7XMLReader
implements XMLReader,
HL7XMLLiterate {
    ContentHandler _contentHandler;
    AttributesImpl _atts = new AttributesImpl();
    private int _status = 0;
    private static int N_ESCAPE = 0;
    private static int N_SUBCOMPONENT = 1;
    private static int N_COMPONENT = 2;
    private static int N_REPEAT = 3;
    private static int N_FIELD = 4;
    private static int S_ESCAPE = 1 << N_ESCAPE;
    private static int S_SUBCOMPONENT = 1 << N_SUBCOMPONENT;
    private static int S_COMPONENT = 1 << N_COMPONENT;
    private static int S_REPEAT = 1 << N_REPEAT;
    private static int S_FIELD = 1 << N_FIELD;
    private static String[] tagName = new String[]{"escape", "subcomponent", "component", "repeat", "field"};
    private ErrorHandler _ErrorHandler;

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this._contentHandler = contentHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        LineNumberReader reader = null;
        if (input.getCharacterStream() == null) {
            if (input.getByteStream() == null) {
                if (input.getSystemId() == null) {
                    throw new SAXException("no usable input");
                }
                this.parse(input.getSystemId());
                return;
            }
            reader = new LineNumberReader(new InputStreamReader(input.getByteStream()));
        } else {
            reader = new LineNumberReader(input.getCharacterStream());
        }
        String delimiters = "|^~\\&";
        this._contentHandler.startDocument();
        this._contentHandler.startElement("", "hl7", "hl7", this._atts);
        String segmentTag = null;
        Tokenizer tokens = null;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            try {
                segmentTag = line.substring(0, 3).intern();
                if (segmentTag == "FHS" || segmentTag == "BHS" || segmentTag == "MSH") {
                    delimiters = line.substring(3, 8);
                    tokens = new Tokenizer(line.substring(8), delimiters);
                    this._atts.addAttribute("", "fieldDelimiter", "fieldDelimiter", "CDATA", delimiters.substring(0, 1));
                    this._atts.addAttribute("", "componentDelimiter", "componentDelimiter", "CDATA", delimiters.substring(1, 2));
                    this._atts.addAttribute("", "repeatDelimiter", "repeatDelimiter", "CDATA", delimiters.substring(2, 3));
                    this._atts.addAttribute("", "escapeDelimiter", "escapeDelimiter", "CDATA", delimiters.substring(3, 4));
                    this._atts.addAttribute("", "subcomponentDelimiter", "subcomponentDelimiter", "CDATA", delimiters.substring(4, 5));
                } else {
                    tokens = new Tokenizer(line, delimiters);
                    segmentTag = tokens.nextToken();
                }
                this._contentHandler.startElement("", segmentTag, segmentTag, this._atts);
                this._atts.clear();
                this._status = 0;
                block10: while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if (token.length() == 1) {
                        switch (delimiters.indexOf(token.charAt(0))) {
                            case 0: {
                                this.newElement(N_FIELD);
                                continue block10;
                            }
                            case 2: {
                                this.newElement(N_REPEAT);
                                continue block10;
                            }
                            case 1: {
                                this.newElement(N_COMPONENT);
                                continue block10;
                            }
                            case 4: {
                                this.newElement(N_SUBCOMPONENT);
                                continue block10;
                            }
                            case 3: {
                                String closingEscape = tokens.lookAhead(2);
                                if (closingEscape == null || closingEscape.length() != 1 || closingEscape.charAt(0) != delimiters.charAt(3) || this.likeEscapeContent(tokens.lookAhead(1)) < this.likeEscapeContent(tokens.lookAhead(3))) break;
                                this.toggleEscape();
                                token = tokens.nextToken();
                                this._contentHandler.characters(token.toCharArray(), 0, token.length());
                                token = tokens.nextToken();
                                this.toggleEscape();
                                continue block10;
                            }
                        }
                    }
                    this._contentHandler.characters(token.toCharArray(), 0, token.length());
                }
                this.closeElement(N_FIELD);
                this._contentHandler.endElement("", segmentTag, segmentTag);
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
                throw new SAXException("premature end of input");
            }
        }
        this._contentHandler.endElement("", "hl7", "hl7");
        this._contentHandler.endDocument();
    }

    int likeEscapeContent(String content) {
        if (content == null) {
            return -500;
        }
        int length = content.length();
        char c0 = content.charAt(0);
        if (length == 1) {
            switch (c0) {
                case 'N': {
                    return 100;
                }
                case 'H': {
                    return 100;
                }
                case 'F': {
                    return 100;
                }
                case 'S': {
                    return 100;
                }
                case 'T': {
                    return 100;
                }
                case 'R': {
                    return 100;
                }
                case 'E': {
                    return 100;
                }
            }
            return 'A' < c0 && c0 < 'Z' ? 10 : -10;
        }
        if (length < 10) {
            switch (c0) {
                case '.': {
                    char c1 = content.charAt(1);
                    switch (c1) {
                        case 's': {
                            return 50;
                        }
                        case 'b': {
                            return 30;
                        }
                        case 'i': {
                            return 30;
                        }
                        case 't': {
                            return 30;
                        }
                        case 'S': {
                            return 30;
                        }
                        case 'B': {
                            return 20;
                        }
                        case 'I': {
                            return 20;
                        }
                        case 'T': {
                            return 20;
                        }
                    }
                    if ('a' < c1 && c1 < 'z') {
                        return 10;
                    }
                    if ('A' < c1 && c1 < 'Z') {
                        return 5;
                    }
                    return -10;
                }
                case 'X': {
                    return 3;
                }
                case 'Z': {
                    return 3;
                }
                case 'C': {
                    return 2;
                }
                case 'M': {
                    return 2;
                }
                case 'U': {
                    return 2;
                }
            }
            return -10;
        }
        switch (c0) {
            case '.': {
                return -10;
            }
            case 'X': {
                return 3;
            }
            case 'Z': {
                return 2;
            }
            case 'C': {
                return -10;
            }
            case 'M': {
                return -10;
            }
            case 'U': {
                return -10;
            }
        }
        return -100;
    }

    private void closeElement(int level) throws SAXException {
        for (int i = 0; i <= level; ++i) {
            int mask = 1 << i;
            if ((this._status & mask) == 0) continue;
            this._contentHandler.endElement("", tagName[i], tagName[i]);
            this._status &= ~mask;
        }
    }

    private void newElement(int level) throws SAXException {
        this.closeElement(level);
        this._contentHandler.startElement("", tagName[level], tagName[level], this._atts);
        this._status |= 1 << level;
    }

    private void toggleEscape() throws SAXException {
        if ((this._status & S_ESCAPE) != 0) {
            this.closeElement(N_ESCAPE);
        } else {
            this.newElement(N_ESCAPE);
        }
    }

    public void parse(String url) throws IOException, SAXException {
        try {
            this.parse(new InputSource(new URL(url).openStream()));
        }
        catch (MalformedURLException ex) {
            throw new SAXException(ex);
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((name = name.intern()) != "http://xml.org/sax/features/namespaces" && name != "http://xml.org/sax/features/namespace-prefixes") {
            throw new SAXNotRecognizedException(name);
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public ErrorHandler getErrorHandler() {
        return this._ErrorHandler;
    }

    public void setErrorHandler(ErrorHandler ErrorHandler2) {
        this._ErrorHandler = ErrorHandler2;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler x) {
    }

    public void setEntityResolver(EntityResolver x) {
    }

    public static void main(String[] args) throws Exception {
        if (args[0].equals("-t")) {
            Tokenizer tok = new Tokenizer(args[1], args[2]);
            while (tok.hasMoreTokens()) {
                System.out.println(tok.nextToken());
            }
        } else {
            boolean doTransform = true;
            boolean outputTraditionally = false;
            HL7XMLReader reader = new HL7XMLReader();
            if (!doTransform && outputTraditionally) {
                reader.setContentHandler(new HL7XMLWriter(System.out));
                reader.parse(args[0]);
            } else if (!doTransform && !outputTraditionally) {
                reader.setContentHandler(new ContentHandler(){

                    public void characters(char[] ch, int start, int length) {
                        System.out.print(new String(ch, start, length));
                    }

                    public void endElement(String namespaceURI, String localName, String qName) {
                        System.out.print("</" + qName + ">");
                    }

                    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
                        System.out.print("<" + qName + ">");
                    }

                    public void endDocument() {
                    }

                    public void startPrefixMapping(String prefix, String uri) {
                    }

                    public void endPrefixMapping(String prefix) {
                    }

                    public void ignorableWhitespace(char[] ch, int start, int length) {
                    }

                    public void processingInstruction(String target, String data) {
                    }

                    public void setDocumentLocator(Locator locator) {
                    }

                    public void skippedEntity(String name) {
                    }

                    public void startDocument() {
                    }
                });
                reader.parse(args[0]);
            } else if (doTransform) {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(new SAXSource(reader, new InputSource(args[0])), new StreamResult(System.out));
            }
        }
    }

    public static class Tokenizer {
        private StringTokenizer _tokens;
        public static int BUFFER_SIZE = 8;
        private String[] _ringBuffer = new String[BUFFER_SIZE];
        private int _bufferPointer = BUFFER_SIZE - 1;

        public Tokenizer(String data, String delimiters) {
            this._tokens = new StringTokenizer(data, delimiters, true);
            for (int i = 0; i < BUFFER_SIZE - 1; ++i) {
                String token;
                this._ringBuffer[i] = token = this._tokens.hasMoreTokens() ? this._tokens.nextToken() : null;
            }
        }

        boolean hasMoreTokens() {
            return this.lookAhead(1) != null;
        }

        String nextToken() {
            this._ringBuffer[this._bufferPointer] = this._tokens.hasMoreTokens() ? this._tokens.nextToken() : null;
            this._bufferPointer = (this._bufferPointer + 1) % BUFFER_SIZE;
            return this._ringBuffer[this._bufferPointer];
        }

        String lookAhead(int i) {
            if (i < BUFFER_SIZE) {
                return this._ringBuffer[(this._bufferPointer + i) % BUFFER_SIZE];
            }
            throw new IllegalArgumentException("lookahead by more than " + BUFFER_SIZE);
        }
    }
}

