/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.dcm4chex.archive.common.SecurityUtils;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionDTO;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionLocalHome;

public abstract class StudyPermissionManagerBean
implements SessionBean {
    private StudyPermissionLocalHome studyPermissionHome;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.studyPermissionHome = (StudyPermissionLocalHome)jndiCtx.lookup("java:comp/env/ejb/StudyPermission");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.studyPermissionHome = null;
    }

    public Collection findByPatientPk(Long pk) {
        try {
            return this.toDTOs(this.studyPermissionHome.findByPatientPk(pk));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Collection findByStudyIuid(String suid) {
        try {
            return this.toDTOs(this.studyPermissionHome.findByStudyIuid(suid));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Collection findByStudyIuidAndAction(String suid, String action) {
        try {
            return this.toDTOs(this.studyPermissionHome.findByStudyIuidAndAction(suid, action));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean hasPermission(String suid, String action, String role) {
        try {
            this.studyPermissionHome.find(suid, action, role);
            return true;
        }
        catch (ObjectNotFoundException onfe) {
            return false;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean hasPermission(String suid, String action, Subject subject) {
        String[] roles = SecurityUtils.rolesOf((Subject)subject);
        for (int i = 0; i < roles.length; ++i) {
            if (!this.hasPermission(suid, action, roles[i])) continue;
            return true;
        }
        return false;
    }

    private Collection toDTOs(Collection c) {
        ArrayList<StudyPermissionDTO> dtos = new ArrayList<StudyPermissionDTO>(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            dtos.add(((StudyPermissionLocal)iter.next()).toDTO());
        }
        return dtos;
    }

    public boolean grant(String suid, String action, String role) {
        if (this.hasPermission(suid, action, role)) {
            return false;
        }
        try {
            this.studyPermissionHome.create(suid, action, role);
            return true;
        }
        catch (CreateException e) {
            if (this.hasPermission(suid, action, role)) {
                return false;
            }
            throw new EJBException((Exception)((Object)e));
        }
    }

    public int grant(String suid, String[] actions, String role) {
        int count = 0;
        for (int i = 0; i < actions.length; ++i) {
            if (!this.grant(suid, actions[i], role)) continue;
            ++count;
        }
        return count;
    }

    public boolean revoke(StudyPermissionDTO dto) {
        try {
            if (dto.getPk() != -1L) {
                this.studyPermissionHome.remove((Object)new Long(dto.getPk()));
                return true;
            }
            return this.revoke(dto.getStudyIuid(), dto.getAction(), dto.getRole());
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean revoke(String suid, String action, String role) {
        try {
            StudyPermissionLocal studyPermission;
            try {
                studyPermission = this.studyPermissionHome.find(suid, action, role);
            }
            catch (ObjectNotFoundException onfe) {
                return false;
            }
            studyPermission.remove();
            return true;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public int revoke(String suid, String[] actions, String role) {
        int count = 0;
        for (int i = 0; i < actions.length; ++i) {
            if (!this.revoke(suid, actions[i], role)) continue;
            ++count;
        }
        return count;
    }

    public Collection grantForPatient(long patPk, String[] actions, String role) {
        Collection c;
        try {
            c = this.studyPermissionHome.selectStudyIuidsByPatientPk(new Long(patPk));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        this.grant(c, actions, role);
        return c;
    }

    public Collection revokeForPatient(long patPk, String[] actions, String role) {
        Collection c;
        try {
            c = this.studyPermissionHome.selectStudyIuidsByPatientPk(new Long(patPk));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        this.revoke(c, actions, role);
        return c;
    }

    public Collection grantForPatient(String pid, String issuer, String[] actions, String role) {
        Collection c;
        try {
            c = this.studyPermissionHome.selectStudyIuidsByPatientId(pid, issuer);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        this.grant(c, actions, role);
        return c;
    }

    private int grant(Collection suids, String[] actions, String role) {
        int count = 0;
        Iterator iter = suids.iterator();
        while (iter.hasNext()) {
            count += this.grant((String)iter.next(), actions, role);
        }
        return count;
    }

    public Collection revokeForPatient(String pid, String issuer, String[] actions, String role) {
        Collection c;
        try {
            c = this.studyPermissionHome.selectStudyIuidsByPatientId(pid, issuer);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        this.revoke(c, actions, role);
        return c;
    }

    private int revoke(Collection suids, String[] actions, String role) {
        int count = 0;
        Iterator iter = suids.iterator();
        while (iter.hasNext()) {
            count += this.revoke((String)iter.next(), actions, role);
        }
        return count;
    }

    public int countStudiesOfPatient(Long patPk) {
        try {
            return this.studyPermissionHome.selectStudyIuidsByPatientPk(patPk).size();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }
}

