/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.AttrUtils;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;
import org.dcm4chex.archive.ejb.session.UpdateDerivedFieldsUtils;

public abstract class StudyMgtBean
implements SessionBean {
    private static final Logger log = Logger.getLogger(StudyMgtBean.class);
    private PatientLocalHome patHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;
    private InstanceLocalHome instHome;

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.patHome = null;
        this.studyHome = null;
        this.seriesHome = null;
        this.instHome = null;
    }

    public void createStudy(Dataset ds, PatientMatching matching) throws DcmServiceException, CreateException, FinderException {
        this.checkDuplicateStudy(ds.getString(0x20000D));
        this.studyHome.create(ds, this.findOrCreatePatient(ds, matching));
    }

    private PatientLocal findOrCreatePatient(Dataset ds, PatientMatching matching) throws FinderException, CreateException {
        try {
            return this.patHome.selectPatient(ds, matching, true);
        }
        catch (ObjectNotFoundException onfe) {
            return this.patHome.create(ds);
        }
    }

    private void checkDuplicateStudy(String suid) throws FinderException, DcmServiceException {
        try {
            this.studyHome.findByStudyIuid(suid);
            throw new DcmServiceException(273, suid);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return;
        }
    }

    private StudyLocal getStudy(String suid) throws FinderException, DcmServiceException {
        try {
            return this.studyHome.findByStudyIuid(suid);
        }
        catch (ObjectNotFoundException e) {
            throw new DcmServiceException(274, suid);
        }
    }

    public void updateStudy(String iuid, Dataset ds, PatientMatching matching) throws DcmServiceException {
        try {
            PatientLocal pat;
            StudyLocal study = this.getStudy(iuid);
            if (study == null) {
                log.warn((Object)("Unable to update the study that does not exist. StudyIuid: " + iuid));
                return;
            }
            Dataset attrs = study.getAttributes(false);
            attrs.putAll((DcmObject)ds);
            study.setAttributes(attrs);
            DcmElement seriesSq = ds.get(528661);
            if (seriesSq != null) {
                HashSet dirtyStudies = new HashSet();
                HashSet dirtySeries = new HashSet();
                int n = seriesSq.countItems();
                for (int i = 0; i < n; ++i) {
                    this.updateSeries(seriesSq.getItem(i), study, dirtyStudies, dirtySeries);
                }
                this.updateDerivedSeriesFields(dirtySeries);
                this.updateDerivedStudyFields(dirtyStudies);
            }
            if ((ds.contains(0x100020) || ds.contains(0x100010)) && (pat = this.findOrCreatePatient(ds, matching)).getPk() != study.getPatient().getPk()) {
                study.setPatient(pat);
            }
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updatePatientOnly(String iuid, Dataset ds, Dataset modAttrs) throws DcmServiceException {
        try {
            Dataset origModAttrs;
            PatientLocal patient = this.getStudy(iuid).getPatient();
            Dataset dataset = origModAttrs = modAttrs == null ? null : DcmObjectFactory.getInstance().newDataset();
            if (patient.updateAttributes(ds, origModAttrs)) {
                AttrUtils.fetchModifiedAttributes(ds, origModAttrs, modAttrs, AttributeFilter.getPatientAttributeFilter());
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void updateStudyOnly(String iuid, Dataset ds, Dataset modAttrs) throws DcmServiceException {
        try {
            Dataset origModAttrs;
            StudyLocal study = this.getStudy(iuid);
            Dataset dataset = origModAttrs = modAttrs == null ? null : DcmObjectFactory.getInstance().newDataset();
            if (study.updateAttributes(ds, origModAttrs)) {
                AttrUtils.fetchModifiedAttributes(ds, origModAttrs, modAttrs, AttributeFilter.getStudyAttributeFilter());
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    private void updateDerivedStudyFields(Set dirtyStudies) throws FinderException {
        for (String iuid : dirtyStudies) {
            StudyLocal study = this.studyHome.findByStudyIuid(iuid);
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
        }
    }

    private void updateDerivedSeriesFields(Set dirtySeries) throws FinderException {
        for (String iuid : dirtySeries) {
            SeriesLocal series = this.seriesHome.findBySeriesIuid(iuid);
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series);
        }
    }

    private void updateSeries(Dataset ds, StudyLocal study, Set dirtyStudies, Set dirtySeries) throws FinderException, CreateException {
        try {
            SeriesLocal series = this.seriesHome.findBySeriesIuid(ds.getString(0x20000E));
            StudyLocal prevStudy = series.getStudy();
            if (!study.isIdentical((EJBLocalObject)prevStudy)) {
                log.info((Object)("Move " + series.asString() + " from " + prevStudy.asString() + " to " + study.asString()));
                series.setStudy(study);
                dirtyStudies.add(study.getStudyIuid());
                dirtyStudies.add(prevStudy.getStudyIuid());
            }
            Dataset attrs = series.getAttributes(false);
            String newModality = ds.getString(524384);
            if (newModality != null && !newModality.equals(attrs.getString(524384))) {
                dirtyStudies.add(study.getStudyIuid());
            }
            attrs.putAll((DcmObject)ds);
            series.setAttributes(attrs);
            DcmElement sopSq = ds.get(528793);
            if (sopSq != null) {
                int n = sopSq.countItems();
                for (int i = 0; i < n; ++i) {
                    this.updateInstance(sopSq.getItem(i), series, dirtyStudies, dirtySeries);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            this.seriesHome.create(ds, study);
            dirtyStudies.add(study.getStudyIuid());
        }
    }

    private void updateInstance(Dataset ds, SeriesLocal series, Set dirtyStudies, Set dirtySeries) throws FinderException, CreateException {
        try {
            InstanceLocal inst = this.instHome.findBySopIuid(ds.getString(528725));
            SeriesLocal prevSeries = inst.getSeries();
            if (!series.isIdentical((EJBLocalObject)prevSeries)) {
                log.info((Object)("Move " + inst.asString() + " from " + prevSeries.asString() + " to " + series.asString()));
                inst.setSeries(series);
                dirtySeries.add(series.getSeriesIuid());
                dirtyStudies.add(series.getStudy().getStudyIuid());
                dirtySeries.add(prevSeries.getSeriesIuid());
                dirtyStudies.add(prevSeries.getStudy().getStudyIuid());
            }
            Dataset attrs = inst.getAttributes(false);
            attrs.putAll((DcmObject)ds);
            inst.setAttributes(attrs);
        }
        catch (ObjectNotFoundException e) {
            this.instHome.create(ds, series);
            dirtySeries.add(series.getSeriesIuid());
            dirtyStudies.add(series.getStudy().getStudyIuid());
        }
    }

    public void updateStudyStatusId(String iuid, String statusId) throws FinderException, DcmServiceException {
        StudyLocal study = this.getStudy(iuid);
        Dataset attrs = study.getAttributes(false);
        if (!statusId.equals(attrs.getString(3276810))) {
            attrs.putCS(3276810, statusId);
            study.setAttributes(attrs);
        }
    }

    public String getStudyStatusId(String iuid, String statusId) throws FinderException, DcmServiceException {
        return this.getStudy(iuid).getStudyStatusId();
    }
}

