/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.Collection;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.PersonName;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.GPSPSPerformerLocal;
import org.dcm4chex.archive.ejb.interfaces.GPSPSPerformerLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocal;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesRequestLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesRequestLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SoundexUpdateLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;
import org.dcm4chex.archive.ejb.interfaces.VerifyingObserverLocal;
import org.dcm4chex.archive.ejb.interfaces.VerifyingObserverLocalHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoundexUpdateBean
implements SessionBean {
    private static final Logger LOG = LoggerFactory.getLogger(SoundexUpdateBean.class);
    private SessionContext ctx;
    private PatientLocalHome patHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;
    private SeriesRequestLocalHome seriesRequestHome;
    private VerifyingObserverLocalHome observerHome;
    private MWLItemLocalHome mwlItemHome;
    private GPSPSPerformerLocalHome gpspsPerformerHome;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ctx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.seriesRequestHome = (SeriesRequestLocalHome)jndiCtx.lookup("java:comp/env/ejb/SeriesRequest");
            this.observerHome = (VerifyingObserverLocalHome)jndiCtx.lookup("java:comp/env/ejb/VerifyingObserver");
            this.mwlItemHome = (MWLItemLocalHome)jndiCtx.lookup("java:comp/env/ejb/MWLItem");
            this.gpspsPerformerHome = (GPSPSPerformerLocalHome)jndiCtx.lookup("java:comp/env/ejb/GPSPSPerformer");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.ctx = null;
        this.patHome = null;
        this.studyHome = null;
        this.seriesHome = null;
        this.seriesRequestHome = null;
        this.observerHome = null;
        this.mwlItemHome = null;
        this.gpspsPerformerHome = null;
    }

    public int updatePatientNameSoundex() {
        if (!AttributeFilter.isSoundexEnabled()) {
            return 0;
        }
        try {
            Collection c = this.patHome.findAll();
            LOG.info("Start updating Patient Name Soundex codes");
            SoundexUpdateLocal ejb = (SoundexUpdateLocal)this.ctx.getEJBLocalObject();
            for (PatientLocal pat : c) {
                ejb.updatePatientNameSoundex(pat);
            }
            LOG.info("Finished updating Patient Name Soundex codes");
            return c.size();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updatePatientNameSoundex(PatientLocal pat) {
        PersonName pn = this.newPersonName(pat.getPatientName());
        pat.setPatientFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
        pat.setPatientGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
    }

    public int updateReferringPhysicianNameSoundex() {
        if (!AttributeFilter.isSoundexEnabled()) {
            return 0;
        }
        try {
            Collection c = this.studyHome.findAll();
            LOG.info("Start updating Referring Physician Name Soundex codes");
            SoundexUpdateLocal ejb = (SoundexUpdateLocal)this.ctx.getEJBLocalObject();
            for (StudyLocal study : c) {
                ejb.updateReferringPhysicianNameSoundex(study);
            }
            LOG.info("Finished updating Referring Physician Name Soundex codes");
            return c.size();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updateReferringPhysicianNameSoundex(StudyLocal study) {
        PersonName pn = this.newPersonName(study.getReferringPhysicianName());
        study.setReferringPhysicianFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
        study.setReferringPhysicianGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
    }

    public int updatePerformingPhysicianNameSoundex() {
        if (!AttributeFilter.isSoundexEnabled()) {
            return 0;
        }
        try {
            Collection c = this.seriesHome.findAll();
            LOG.info("Start updating Performing Physician Name Soundex codes");
            SoundexUpdateLocal ejb = (SoundexUpdateLocal)this.ctx.getEJBLocalObject();
            for (SeriesLocal series : c) {
                ejb.updatePerformingPhysicianNameSoundex(series);
            }
            LOG.info("Finished updating Performing Physician Name Soundex codes");
            return c.size();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updatePerformingPhysicianNameSoundex(SeriesLocal series) {
        PersonName pn = this.newPersonName(series.getPerformingPhysicianName());
        series.setPerformingPhysicianFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
        series.setPerformingPhysicianGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
    }

    public int updateRequestingPhysicianNameSoundex() {
        if (!AttributeFilter.isSoundexEnabled()) {
            return 0;
        }
        try {
            Collection c = this.seriesRequestHome.findAll();
            LOG.info("Start updating Requesting Physician Name Soundex codes");
            SoundexUpdateLocal ejb = (SoundexUpdateLocal)this.ctx.getEJBLocalObject();
            for (SeriesRequestLocal seriesRequest : c) {
                ejb.updateRequestingPhysicianNameSoundex(seriesRequest);
            }
            LOG.info("Finished updating Requesting Physician Name Soundex codes");
            return c.size();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updateRequestingPhysicianNameSoundex(SeriesRequestLocal seriesRequest) {
        PersonName pn = this.newPersonName(seriesRequest.getRequestingPhysician());
        seriesRequest.setRequestingPhysicianFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
        seriesRequest.setRequestingPhysicianGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
    }

    public int updateVerifyingObserverNameSoundex() {
        if (!AttributeFilter.isSoundexEnabled()) {
            return 0;
        }
        try {
            Collection c = this.observerHome.findAll();
            LOG.info("Start updating Verifying Observer Name Soundex codes");
            SoundexUpdateLocal ejb = (SoundexUpdateLocal)this.ctx.getEJBLocalObject();
            for (VerifyingObserverLocal observer : c) {
                ejb.updateVerifyingObserverNameSoundex(observer);
            }
            LOG.info("Finished updating Verifying Observer Name Soundex codes");
            return c.size();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updateVerifyingObserverNameSoundex(VerifyingObserverLocal observer) {
        PersonName pn = this.newPersonName(observer.getVerifyingObserverName());
        observer.setVerifyingObserverFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
        observer.setVerifyingObserverGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
    }

    public int updateMWLPerformingPhysicianNameSoundex() {
        if (!AttributeFilter.isSoundexEnabled()) {
            return 0;
        }
        try {
            Collection c = this.mwlItemHome.findAll();
            LOG.info("Start updating MWL Performing Physician Name Soundex codes");
            SoundexUpdateLocal ejb = (SoundexUpdateLocal)this.ctx.getEJBLocalObject();
            for (MWLItemLocal mwlitem : c) {
                ejb.updateMWLPerformingPhysicianNameSoundex(mwlitem);
            }
            LOG.info("Finished updating MWL Performing Physician Name Soundex codes");
            return c.size();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updateMWLPerformingPhysicianNameSoundex(MWLItemLocal mwlitem) {
        PersonName pn = this.newPersonName(mwlitem.getPerformingPhysicianName());
        mwlitem.setPerformingPhysicianFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
        mwlitem.setPerformingPhysicianGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
    }

    public int updateGPSPSHumanPerformerNameSoundex() {
        if (!AttributeFilter.isSoundexEnabled()) {
            return 0;
        }
        try {
            Collection c = this.gpspsPerformerHome.findAll();
            LOG.info("Start updating GPSPS Human Performer Name Soundex codes");
            SoundexUpdateLocal ejb = (SoundexUpdateLocal)this.ctx.getEJBLocalObject();
            for (GPSPSPerformerLocal performer : c) {
                ejb.updateGPSPSPerformerNameSoundex(performer);
            }
            LOG.info("Finished updating GPSPS Human Performer Name Soundex codes");
            return c.size();
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updateGPSPSPerformerNameSoundex(GPSPSPerformerLocal performer) {
        PersonName pn = this.newPersonName(performer.getHumanPerformerName());
        performer.setHumanPerformerFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
        performer.setHumanPerformerGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
    }

    private PersonName newPersonName(String pname) {
        try {
            return DcmObjectFactory.getInstance().newPersonName(pname);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Cannot generate Soundex code for Illegal Person Name: " + pname + " - treat as unknown.");
            return null;
        }
    }
}

