/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.entity.AttrUtils;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.exceptions.NonUniquePatientException;
import org.dcm4chex.archive.exceptions.PatientAlreadyExistsException;

public abstract class PatientUpdateBean
implements SessionBean {
    private static final Logger LOG = Logger.getLogger(PatientUpdateBean.class);
    private PatientLocalHome patHome;

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.patHome = null;
    }

    public void changePatientIdentifierList(Dataset correct, Dataset prior, PatientMatching matching, boolean keepPrior) throws CreateException, FinderException, PatientAlreadyExistsException, EJBException, RemoveException {
        LOG.info((Object)("Change PID for " + correct.getString(0x100010) + " from " + this.toPidAndIssuer(prior) + " to " + this.toPidAndIssuer(correct)));
        try {
            this.patHome.selectPatient(correct, matching, false);
            String prompt = "Patient with PID " + this.toPidAndIssuer(correct) + " already exists";
            LOG.warn((Object)prompt);
            throw new PatientAlreadyExistsException(prompt);
        }
        catch (ObjectNotFoundException e) {
            try {
                PatientLocal priorPat = this.patHome.selectPatient(prior, matching, true);
                Dataset newAttrs = priorPat.getAttributes(true);
                newAttrs.putLO(0x100020, correct.getString(0x100020));
                newAttrs.putLO(0x100021, correct.getString(0x100021));
                if (keepPrior) {
                    PatientLocal correctPat = this.patHome.create(newAttrs);
                    this.merge(correctPat, priorPat, keepPrior);
                } else {
                    priorPat.setAttributes(newAttrs);
                }
            }
            catch (ObjectNotFoundException x) {
                LOG.warn((Object)"Prior patient of ChangePatientIdentifierList request not found! Ignored!");
            }
            return;
        }
    }

    public void mergePatient(Dataset dominant, Dataset prior, PatientMatching matching, boolean keepPrior) throws CreateException, FinderException, EJBException, RemoveException {
        LOG.info((Object)("Merge " + prior.getString(0x100010) + " with PID " + this.toPidAndIssuer(prior) + " to " + dominant.getString(0x100010) + " with PID " + this.toPidAndIssuer(dominant)));
        PatientLocal dominantPat = this.updateOrCreate(dominant, matching);
        PatientLocal priorPat = this.updateOrCreate(prior, matching);
        LOG.debug((Object)("Merge patient.pk " + priorPat.getPk() + " to patient.pk " + dominantPat.getPk()));
        this.merge(dominantPat, priorPat, keepPrior);
    }

    private void merge(PatientLocal dominantPat, PatientLocal priorPat, boolean keepPrior) throws EJBException, RemoveException {
        if (dominantPat.equals(priorPat)) {
            throw new IllegalArgumentException("Prior and dominant patients are the same! Can't merge patient to itself!");
        }
        dominantPat.getStudies().addAll(priorPat.getStudies());
        dominantPat.getMpps().addAll(priorPat.getMpps());
        dominantPat.getMwlItems().addAll(priorPat.getMwlItems());
        dominantPat.getGsps().addAll(priorPat.getGsps());
        dominantPat.getGppps().addAll(priorPat.getGppps());
        dominantPat.getUPS().addAll(priorPat.getUPS());
        dominantPat.getMerged().addAll(priorPat.getMerged());
        if (keepPrior) {
            priorPat.setMergedWith(dominantPat);
        } else {
            priorPat.remove();
        }
    }

    public void updatePatient(StudyLocal study, Dataset attrs, PatientMatching matching) throws FinderException, CreateException {
        this.updatePatient(study, attrs, null, matching);
    }

    public void updatePatient(StudyLocal study, Dataset attrs, Dataset modified, PatientMatching matching) throws FinderException, CreateException {
        String pid = attrs.getString(0x100020);
        if (pid == null || pid.length() == 0) {
            return;
        }
        PatientLocal newPatient = this.updateOrCreate(attrs, modified, matching);
        PatientLocal oldPat = study.getPatient();
        if (oldPat.getPk() == newPatient.getPk()) {
            return;
        }
        if (modified != null) {
            modified.putAll((DcmObject)attrs);
        }
        study.setPatient(newPatient);
        for (SeriesLocal series : study.getSeries()) {
            if (series.getMpps() == null) continue;
            series.getMpps().setPatient(newPatient);
        }
    }

    public void updatePatient(Dataset attrs, PatientMatching matching) throws CreateException, FinderException {
        this.updatePatient(attrs, null, matching);
    }

    public void updatePatient(Dataset attrs, Dataset modified, PatientMatching matching) throws CreateException, FinderException {
        LOG.info((Object)("Update " + attrs.getString(0x100010) + " with PID " + this.toPidAndIssuer(attrs)));
        this.updateOrCreate(attrs, modified, matching);
    }

    public PatientLocal updateOrCreate(Dataset ds, PatientMatching matching) throws CreateException, FinderException {
        return this.updateOrCreate(ds, null, matching);
    }

    private PatientLocal updateOrCreate(Dataset ds, Dataset modified, PatientMatching matching) throws CreateException, FinderException {
        try {
            return this.findAndUpdatePatient(ds, modified, matching);
        }
        catch (ObjectNotFoundException e) {
            PatientLocal pat;
            try {
                pat = this.patHome.create(ds);
            }
            catch (CreateException ce) {
                try {
                    return this.findAndUpdatePatient(ds, modified, matching);
                }
                catch (FinderException fe) {
                    throw ce;
                }
            }
            try {
                this.patHome.selectPatient(ds, matching, false);
                if (modified != null) {
                    modified.putAll((DcmObject)ds);
                }
                return pat;
            }
            catch (NonUniquePatientException nupe) {
                try {
                    pat.remove();
                }
                catch (RemoveException e1) {
                    throw new EJBException((Exception)((Object)e));
                }
                return this.findAndUpdatePatient(ds, modified, matching);
            }
        }
    }

    private PatientLocal findAndUpdatePatient(Dataset ds, Dataset modified, PatientMatching matching) throws FinderException {
        PatientLocal pat;
        Dataset origModAttrs = null;
        if (modified != null) {
            origModAttrs = DcmObjectFactory.getInstance().newDataset();
        }
        if ((pat = this.patHome.selectPatient(ds, matching, false)).updateAttributes(ds, origModAttrs)) {
            AttrUtils.fetchModifiedAttributes(ds, origModAttrs, modified);
        }
        return pat;
    }

    public boolean deletePatient(Dataset ds, PatientMatching matching) throws RemoveException, FinderException {
        LOG.info((Object)("Delete " + ds.getString(0x100010) + " with PID " + this.toPidAndIssuer(ds)));
        try {
            this.patHome.selectPatient(ds, matching, false).remove();
            return true;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
    }

    public void patientArrived(Dataset ds, PatientMatching matching) throws FinderException {
        LOG.info((Object)("Change status of SPS for " + ds.getString(0x100010) + " with PID " + this.toPidAndIssuer(ds) + " to ARRIVED"));
        try {
            PatientLocal pat = this.patHome.selectPatient(ds, matching, false);
            Collection c = pat.getMwlItems();
            for (MWLItemLocal mwlitem : c) {
                if (mwlitem.getSpsStatusAsInt() != 0) continue;
                mwlitem.updateSpsStatus(1);
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void updateOtherPatientIDsOrCreate(Dataset ds, PatientMatching matching) throws FinderException, CreateException {
        try {
            this.patHome.selectPatient(ds, matching, false).updateOtherPatientIDs(ds);
        }
        catch (ObjectNotFoundException e) {
            this.patHome.create(ds);
        }
    }

    private String toPidAndIssuer(Dataset ds) {
        return ds.getString(0x100020) + "^^^" + ds.getString(0x100021, "");
    }
}

