/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObject;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocal;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientUpdateLocalHome;
import org.dcm4chex.archive.exceptions.DuplicateMWLItemException;
import org.dcm4chex.archive.exceptions.PatientMismatchException;

public abstract class MWLManagerBean
implements SessionBean {
    private static Logger log = Logger.getLogger(MWLManagerBean.class);
    private PatientUpdateLocalHome patUpdateHome;
    private PatientLocalHome patHome;
    private MWLItemLocalHome mwlItemHome;

    public void setSessionContext(SessionContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patUpdateHome = (PatientUpdateLocalHome)jndiCtx.lookup("java:comp/env/ejb/PatientUpdate");
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.mwlItemHome = (MWLItemLocalHome)jndiCtx.lookup("java:comp/env/ejb/MWLItem");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.mwlItemHome = null;
        this.patHome = null;
        this.patUpdateHome = null;
    }

    public Dataset removeWorklistItem(String rpid, String spsid) {
        try {
            MWLItemLocal mwlItem = this.mwlItemHome.findByRpIdAndSpsId(rpid, spsid);
            Dataset attrs = this.toAttributes(mwlItem);
            mwlItem.remove();
            return attrs;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public Dataset removeWorklistItem(Dataset ds, PatientMatching matching) throws PatientMismatchException, FinderException, RemoveException {
        try {
            MWLItemLocal mwlItem = this.getWorklistItem(ds, matching, false);
            Dataset attrs = this.toAttributes(mwlItem);
            mwlItem.remove();
            return attrs;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    private MWLItemLocal getWorklistItem(Dataset ds, PatientMatching matching, boolean updatePatient) throws FinderException, PatientMismatchException {
        Dataset sps = ds.getItem(0x400100);
        MWLItemLocal mwlItem = this.mwlItemHome.findByRpIdAndSpsId(ds.getString(0x401001), sps.getString(0x400009));
        PatientLocal pat = mwlItem.getPatient();
        try {
            if (this.patHome.selectPatient(ds, matching, false).isIdentical((EJBLocalObject)pat)) {
                if (updatePatient) {
                    pat.updateAttributes(ds);
                }
                return mwlItem;
            }
        }
        catch (ObjectNotFoundException onfe) {
            // empty catch block
        }
        String prompt = "Patient[pid=" + ds.getString(0x100020) + ", issuer=" + ds.getString(0x100021) + "] does not match Patient associated with " + mwlItem.asString();
        log.warn((Object)prompt);
        throw new PatientMismatchException(prompt);
    }

    public boolean updateSPSStatus(String rpid, String spsid, String status) {
        try {
            MWLItemLocal mwlItem = this.mwlItemHome.findByRpIdAndSpsId(rpid, spsid);
            Dataset attrs = mwlItem.getAttributes();
            attrs.getItem(0x400100).putCS(0x400020, status);
            mwlItem.setAttributes(attrs);
            return true;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean updateSPSStatus(Dataset ds, PatientMatching matching) throws PatientMismatchException {
        MWLItemLocal mwlItem;
        try {
            mwlItem = this.getWorklistItem(ds, matching, true);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        String status = ds.getItem(0x400100).getString(0x400020);
        Dataset attrs = mwlItem.getAttributes();
        attrs.getItem(0x400100).putCS(0x400020, status);
        mwlItem.setAttributes(attrs);
        return true;
    }

    private PatientLocal updateOrCreatePatient(Dataset ds, PatientMatching matching) throws FinderException, CreateException {
        return this.patUpdateHome.create().updateOrCreate(ds, matching);
    }

    public Dataset addWorklistItem(Dataset ds, PatientMatching matching) throws CreateException, FinderException {
        this.checkDuplicate(ds);
        MWLItemLocal mwlItem = this.mwlItemHome.create(ds, this.updateOrCreatePatient(ds, matching));
        return this.toAttributes(mwlItem);
    }

    private void checkDuplicate(Dataset ds) throws DuplicateMWLItemException, FinderException {
        try {
            Dataset sps = ds.getItem(0x400100);
            MWLItemLocal mwlItem = this.mwlItemHome.findByRpIdAndSpsId(ds.getString(0x401001), sps.getString(0x400009));
            throw new DuplicateMWLItemException("Duplicate " + mwlItem.asString());
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return;
        }
    }

    private Dataset toAttributes(MWLItemLocal mwlItem) {
        Dataset attrs = mwlItem.getAttributes();
        attrs.putAll((DcmObject)mwlItem.getPatient().getAttributes(false));
        return attrs;
    }

    public boolean updateWorklistItem(Dataset ds, PatientMatching matching) throws PatientMismatchException {
        MWLItemLocal mwlItem;
        try {
            mwlItem = this.getWorklistItem(ds, matching, true);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        Dataset attrs = mwlItem.getAttributes();
        attrs.putAll((DcmObject)ds, 2);
        mwlItem.setAttributes(attrs);
        return true;
    }
}

