/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocal;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocal;
import org.dcm4chex.archive.ejb.interfaces.MWLItemLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.exceptions.NonUniquePatientException;
import org.dcm4chex.archive.exceptions.PatientMismatchException;

public abstract class MPPSManagerBean
implements SessionBean {
    public static final int SERIES_STORED = 0;
    private static Logger log = Logger.getLogger(MPPSManagerBean.class);
    private static final String NO_LONGER_BE_UPDATED_ERR_MSG = "Performed Procedure Step Object may no longer be updated";
    private static final int NO_LONGER_BE_UPDATED_ERR_ID = 42768;
    private static final int DELETED = 1;
    private PatientLocalHome patHome;
    private SeriesLocalHome seriesHome;
    private MPPSLocalHome mppsHome;
    private MWLItemLocalHome mwlItemHome;
    private SessionContext sessionCtx;

    public void setSessionContext(SessionContext ctx) {
        this.sessionCtx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.mppsHome = (MPPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/MPPS");
            this.mwlItemHome = (MWLItemLocalHome)jndiCtx.lookup("java:comp/env/ejb/MWLItem");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.sessionCtx = null;
        this.mppsHome = null;
        this.patHome = null;
        this.seriesHome = null;
    }

    public void createMPPS(Dataset ds, PatientMatching matching) throws DcmServiceException {
        this.checkDuplicate(ds.getString(524312));
        try {
            this.mppsHome.create(ds, this.findOrCreatePatient(ds, matching));
        }
        catch (CreateException e) {
            log.error((Object)("Creation of MPPS(iuid=" + ds.getString(524312) + ") failed: "), (Throwable)e);
            throw new DcmServiceException(272);
        }
    }

    private void checkDuplicate(String ppsiuid) throws DcmServiceException {
        try {
            this.mppsHome.findBySopIuid(ppsiuid);
            throw new DcmServiceException(273);
        }
        catch (ObjectNotFoundException e) {
        }
        catch (FinderException e) {
            log.error((Object)("Query for GMPS(iuid=" + ppsiuid + ") failed: "), (Throwable)e);
            throw new DcmServiceException(272);
        }
    }

    private PatientLocal findOrCreatePatient(Dataset ds, PatientMatching matching) throws DcmServiceException {
        try {
            try {
                return this.patHome.selectPatient(ds, matching, true);
            }
            catch (ObjectNotFoundException enfe) {
                return this.patHome.create(ds);
            }
            catch (NonUniquePatientException onfe) {
                return this.patHome.create(ds);
            }
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public Dataset getMPPS(String iuid) throws FinderException {
        MPPSLocal mpps = this.mppsHome.findBySopIuid(iuid);
        PatientLocal pat = mpps.getPatient();
        Dataset attrs = mpps.getAttributes();
        attrs.putAll((DcmObject)pat.getAttributes(false));
        return attrs;
    }

    public void updateMPPS(Dataset ds) throws DcmServiceException {
        MPPSLocal mpps;
        try {
            mpps = this.mppsHome.findBySopIuid(ds.getString(524312));
        }
        catch (ObjectNotFoundException e) {
            throw new DcmServiceException(274);
        }
        catch (FinderException e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
        if (!"IN PROGRESS".equals(mpps.getPpsStatus())) {
            DcmServiceException e = new DcmServiceException(272, NO_LONGER_BE_UPDATED_ERR_MSG);
            e.setErrorID(42768);
            throw e;
        }
        Dataset attrs = mpps.getAttributes();
        attrs.putAll((DcmObject)ds);
        mpps.setAttributes(attrs);
        if ("COMPLETED".equals(ds.getString(4194898))) {
            try {
                Collection seriess = this.seriesHome.listBySeriesIUIDsWithoutPPS(this.getPerfSeriesIUIDs(ds));
                for (SeriesLocal s : seriess) {
                    Dataset ds1 = s.getAttributes(true);
                    DcmElement sq = ds1.putSQ(528657);
                    Dataset item = sq.addNewItem();
                    item.putUI(524312, mpps.getSopIuid());
                    ds1.putDA(0x400244, (Date)mpps.getPpsStartDateTime());
                    ds1.putTM(4194885, (Date)mpps.getPpsStartDateTime());
                    s.setAttributes(ds1);
                }
                mpps.getSeries().addAll(seriess);
            }
            catch (FinderException e) {
                log.warn((Object)"Update referenced series failed!", (Throwable)e);
            }
        }
    }

    public Dataset[] deleteMPPSEntries(String[] iuids) {
        Dataset[] mppsAttrs = new Dataset[iuids.length];
        for (int i = 0; i < iuids.length; ++i) {
            try {
                MPPSLocal mpps = this.mppsHome.findBySopIuid(iuids[i]);
                mppsAttrs[i] = mpps.getAttributes();
                mppsAttrs[i].putAll((DcmObject)mpps.getPatient().getAttributes(false));
                mpps.remove();
                this.removePpsAttrsFromSeries(iuids[i]);
                continue;
            }
            catch (Exception x) {
                log.error((Object)("Cant delete mpps:" + iuids[i]), (Throwable)x);
            }
        }
        return mppsAttrs;
    }

    private void removePpsAttrsFromSeries(String pps_iuid) throws FinderException {
        Collection c = this.seriesHome.findByPpsIuid(pps_iuid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Series with PPS IUID:" + pps_iuid + " found:" + c));
        }
        for (SeriesLocal series : c) {
            Dataset attrs = series.getAttributes(true);
            attrs.remove(0x400244);
            attrs.remove(4194885);
            attrs.remove(528657);
            series.setAttributes(attrs);
        }
    }

    public Dataset createIANwithPatSummaryAndStudyID(String mppsiuid, String seriesStoredIuid) {
        MPPSLocal mpps;
        try {
            mpps = this.mppsHome.findBySopIuid(mppsiuid);
        }
        catch (ObjectNotFoundException onf) {
            return null;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (mpps.getPpsStatus().equals("IN PROGRESS")) {
            log.debug((Object)("Sending IAN is postponed! MPPS is still 'In Progress'. mppsIUID:" + mpps.getSopIuid()));
            log.debug((Object)"MPPS dataset:");
            log.debug((Object)mpps.getAttributes());
            return null;
        }
        if (mpps.getPpsStatus().equals("DISCONTINUED")) {
            Dataset item = mpps.getAttributes().getItem(4194945);
            if ("110514".equals(item.getString(524544)) && "DCM".equals(item.getString(524546))) {
                log.warn((Object)("IAN is not sent for discontinued MPPS with reason 'Incorrect worklist entry selected' mppsIUID:" + mpps.getSopIuid()));
                return null;
            }
            if (!this.containsInstances(mpps.getAttributes())) {
                log.debug((Object)("IAN not sent for discontinued and empty MPPS. mppsIUID:" + mpps.getSopIuid()));
                return null;
            }
        }
        Dataset attrs = mpps.getAttributes();
        Dataset ian = DcmObjectFactory.getInstance().newDataset();
        DcmElement perfSeriesSq = attrs.get(0x400340);
        DcmElement refSeriesSq = ian.putSQ(528661);
        int n = perfSeriesSq.countItems();
        for (int i = 0; i < n; ++i) {
            SeriesLocal series;
            int countNonImage;
            Dataset perfSeries = perfSeriesSq.getItem(i);
            String seriesIUID = perfSeries.getString(0x20000E);
            DcmElement refImageSeq = perfSeries.get(528704);
            DcmElement refNonImageSeq = perfSeries.get(0x400220);
            int countImage = refImageSeq != null ? refImageSeq.countItems() : 0;
            int n2 = countNonImage = refNonImageSeq != null ? refNonImageSeq.countItems() : 0;
            if (countImage == 0 && countNonImage == 0) {
                log.warn((Object)("Performed Series item " + i + " of mpps (iuid:" + mpps.getSopIuid() + ") neither has image nor nonimage references! Leave this series out. iuid:" + seriesIUID));
                continue;
            }
            try {
                series = this.seriesHome.findBySeriesIuid(seriesIUID);
            }
            catch (ObjectNotFoundException e) {
                log.debug((Object)("Sending IAN is postponed! Series[iuid=" + seriesIUID + "] not yet received"));
                return null;
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
            if (series.getSeriesStatus() != 0 && !seriesIUID.equals(seriesStoredIuid)) {
                log.debug((Object)("Sending IAN is postponed! Series Stored notification for Series[iuid=" + seriesIUID + "] not yet emitted"));
                return null;
            }
            Collection insts = series.getInstances();
            if (insts.size() < countImage + countNonImage) {
                log.debug((Object)("Sending IAN is postponed! Series[iuid=" + seriesIUID + "] not yet received completely"));
                return null;
            }
            Dataset refSeries = refSeriesSq.addNewItem();
            refSeries.putUI(0x20000E, seriesIUID);
            DcmElement refSOPSeq = refSeries.putSQ(528793);
            if (refImageSeq != null && !MPPSManagerBean.containsAll(insts, refImageSeq, refSOPSeq)) {
                log.debug((Object)("Sending IAN is postponed! Series[iuid=" + seriesIUID + "] not yet received completely"));
                return null;
            }
            if (refNonImageSeq == null || MPPSManagerBean.containsAll(insts, refNonImageSeq, refSOPSeq)) continue;
            log.debug((Object)("Sending IAN is postponed! Series[iuid=" + seriesIUID + "] not yet received completely"));
            return null;
        }
        Dataset ssa = attrs.getItem(4194928);
        String studyIUID = ssa != null ? ssa.getString(0x20000D) : null;
        DcmElement refPPSSeq = ian.putSQ(528657);
        Dataset refPPS = refPPSSeq.addNewItem();
        refPPS.putUI(528720, "1.2.840.10008.3.1.2.3.3");
        refPPS.putUI(528725, mppsiuid);
        refPPS.putSQ(4210713);
        ian.putUI(0x20000D, studyIUID);
        ian.putSH(0x200010, attrs.getString(0x200010));
        Dataset patAttrs = mpps.getPatient().getAttributes(false);
        ian.putPN(0x100010, patAttrs.getString(0x100010));
        ian.putLO(0x100020, patAttrs.getString(0x100020));
        return ian;
    }

    private boolean containsInstances(Dataset attrs) {
        DcmElement perfSeriesSq = attrs.get(0x400340);
        int n = perfSeriesSq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset perfSeries = perfSeriesSq.getItem(i);
            DcmElement refImageSeq = perfSeries.get(528704);
            if (refImageSeq != null && refImageSeq.countItems() > 0) {
                return true;
            }
            DcmElement refNonImageSeq = perfSeries.get(0x400220);
            if (refNonImageSeq == null || refNonImageSeq.countItems() <= 0) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAll(Collection insts, DcmElement srcRefSOPSeq, DcmElement dstRefSOPSeq) {
        int n = srcRefSOPSeq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset srcRefSOP = srcRefSOPSeq.getItem(i);
            String iuid = srcRefSOP.getString(528725);
            InstanceLocal inst = MPPSManagerBean.selectByIuid(insts, iuid);
            if (inst == null) {
                return false;
            }
            Dataset dstRefSOP = dstRefSOPSeq.addNewItem();
            dstRefSOP.putUI(528720, inst.getSopCuid());
            dstRefSOP.putUI(528725, iuid);
            dstRefSOP.putCS(524374, Availability.toString((int)inst.getAvailabilitySafe()));
            String aet = inst.getRetrieveAETs();
            dstRefSOP.putAE(524372, aet == null ? inst.getExternalRetrieveAET() : aet);
        }
        return true;
    }

    private static InstanceLocal selectByIuid(Collection insts, String iuid) {
        for (InstanceLocal inst : insts) {
            if (!inst.getSopIuid().equals(iuid)) continue;
            return inst;
        }
        return null;
    }

    public Map linkMppsToMwl(String rpid, String spsid, String mppsIUID) throws DcmServiceException {
        log.info((Object)("linkMppsToMwl spsId:" + spsid + " mpps:" + mppsIUID));
        try {
            MWLItemLocal mwlItem = this.mwlItemHome.findByRpIdAndSpsId(rpid, spsid);
            MPPSLocal mpps = this.mppsHome.findBySopIuid(mppsIUID);
            PatientLocal mwlPat = mwlItem.getPatient();
            PatientLocal mppsPat = mpps.getPatient();
            Dataset mwlAttrs = mwlItem.getAttributes();
            Map map = this.updateLinkedMpps(mpps, mwlItem, mwlAttrs, mwlPat.getAttributes(true));
            Map studyPats = this.getMismatchStudyPatients(mpps, mwlPat.getPk(), mppsPat.getPk());
            if (!mwlPat.equals(mppsPat)) {
                map.put("mwlPat", mwlPat.getAttributes(true));
                map.put("mppsPat", mppsPat.getAttributes(true));
            }
            if (studyPats.size() > 0) {
                map.put("mwlPat", mwlPat.getAttributes(true));
                map.put("studyPats", studyPats.values());
            }
            return map;
        }
        catch (ObjectNotFoundException e) {
            throw new DcmServiceException(274);
        }
        catch (FinderException e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private Map getMismatchStudyPatients(MPPSLocal mpps, Long mwlPatPk, Long mppsPatPk) {
        HashMap<Long, Dataset> studyPats = new HashMap<Long, Dataset>();
        Iterator it = mpps.getSeries().iterator();
        while (it.hasNext()) {
            PatientLocal studyPat = ((SeriesLocal)it.next()).getStudy().getPatient();
            Long studyPatPk = studyPat.getPk();
            if (studyPatPk == mwlPatPk || studyPatPk == mppsPatPk) continue;
            studyPats.put(studyPatPk, studyPat.getAttributes(true));
        }
        return studyPats;
    }

    private Map updateLinkedMpps(MPPSLocal mpps, MWLItemLocal mwlItem, Dataset mwlAttrs, Dataset mwlPat) {
        Dataset ssa;
        HashMap<String, Dataset> map = new HashMap<String, Dataset>();
        Dataset mppsAttrs = mpps.getAttributes();
        log.debug((Object)"MPPS attrs:");
        log.debug((Object)mppsAttrs);
        log.debug((Object)"MWL attrs:");
        log.debug((Object)mwlAttrs);
        String rpid = mwlAttrs.getString(0x401001);
        String spsid = mwlAttrs.getItem(0x400100).getString(0x400009);
        String accNo = mwlAttrs.getString(524368);
        DcmElement ssaSQ = mppsAttrs.get(4194928);
        String studyIUID = null;
        boolean spsNotInList = true;
        int len = ssaSQ.countItems();
        for (int i = 0; i < len; ++i) {
            String ssaSpsID;
            ssa = ssaSQ.getItem(i);
            if (ssa == null) continue;
            if (studyIUID == null) {
                studyIUID = ssa.getString(0x20000D);
            }
            if ((ssaSpsID = ssa.getString(0x400009)) != null && !spsid.equals(ssaSpsID)) continue;
            ssa.putSH(524368, accNo);
            ssa.putSH(0x400009, spsid);
            ssa.putSH(0x401001, rpid);
            ssa.putUI(0x20000D, studyIUID);
            spsNotInList = false;
        }
        if (spsNotInList) {
            ssa = ssaSQ.addNewItem();
            Dataset spsDS = mwlAttrs.getItem(0x400100);
            ssa.putUI(0x20000D, studyIUID);
            ssa.putSH(0x400009, spsid);
            ssa.putSH(0x401001, rpid);
            ssa.putSH(524368, accNo);
            ssa.putSQ(528656);
            ssa.putSH(0x401001, mwlAttrs.getString(0x401001));
            ssa.putLO(0x400007, spsDS.getString(0x400007));
            DcmElement mppsSPCSQ = ssa.putSQ(0x400008);
            DcmElement mwlSPCSQ = spsDS.get(0x400008);
            if (mwlSPCSQ != null && mwlSPCSQ.countItems() > 0) {
                int len2 = mwlSPCSQ.countItems();
                for (int i = 0; i < len2; ++i) {
                    mppsSPCSQ.addNewItem().putAll((DcmObject)mwlSPCSQ.getItem(i));
                }
            }
            log.debug((Object)"add new scheduledStepAttribute item:");
            log.debug((Object)ssa);
            log.debug((Object)"new mppsAttrs:");
            log.debug((Object)mppsAttrs);
        }
        mpps.setAttributes(mppsAttrs);
        mppsAttrs.putAll((DcmObject)mwlPat);
        log.info((Object)"mwlPat:");
        log.info((Object)mwlPat);
        log.info((Object)"mppsAttrs:");
        log.info((Object)mppsAttrs);
        map.put("mppsAttrs", mppsAttrs);
        map.put("mwlAttrs", mwlAttrs);
        return map;
    }

    public Map linkMppsToMwl(Dataset mwlAttrs, String mppsIUID) throws DcmServiceException, FinderException, CreateException {
        String spsID = mwlAttrs.get(0x400100).getItem().getString(0x400009);
        log.info((Object)("linkMppsToMwl sps:" + spsID + " mpps:" + mppsIUID));
        MPPSLocal mpps = this.mppsHome.findBySopIuid(mppsIUID);
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        Dataset mwlPatDs = filter.filter(mwlAttrs);
        PatientLocal mppsPat = mpps.getPatient();
        Map map = this.updateLinkedMpps(mpps, null, mwlAttrs, mwlPatDs);
        if (!this.isSamePatient(mwlPatDs, mppsPat)) {
            PatientLocal mwlPat;
            try {
                mwlPat = this.patHome.selectPatient(mwlPatDs.getString(0x100020), mwlPatDs.getString(0x100021));
            }
            catch (ObjectNotFoundException onfe) {
                mwlPat = this.patHome.create(mwlPatDs);
            }
            map.put("mwlPat", mwlPat.getAttributes(true));
            map.put("mppsPat", mppsPat.getAttributes(true));
        }
        return map;
    }

    private boolean isSamePatient(Dataset mwlPatDs, PatientLocal mppsPat) {
        String mppsPatId = mppsPat.getPatientId();
        if (mppsPatId == null) {
            log.warn((Object)"Link MPPS to MWL: MPPS patient without PatientID! try to check via Patient Name");
            String name = mppsPat.getPatientName();
            if (name == null) {
                log.error((Object)"Link MPPS to MWL: MPPS patient without Patient Name! Ignore differences to avoid merge!");
                return true;
            }
            return name.equals(mwlPatDs.getString(0x100010));
        }
        if (!mppsPat.getPatientId().equals(mwlPatDs.getString(0x100020))) {
            return false;
        }
        String issuer = mppsPat.getIssuerOfPatientId();
        return issuer != null ? issuer.equals(mwlPatDs.getString(0x100021)) : true;
    }

    public Dataset unlinkMpps(String mppsIUID) throws FinderException, CreateException {
        String spsID;
        String rpID;
        MPPSLocal mpps = this.mppsHome.findBySopIuid(mppsIUID);
        Dataset mppsAttrs = mpps.getAttributes();
        Dataset mppsAttrsSav = mpps.getAttributes();
        DcmElement ssaSQ = mppsAttrs.get(4194928);
        Dataset ds = null;
        ArrayList<String> spsIDs = new ArrayList<String>(ssaSQ.countItems());
        for (int i = ssaSQ.countItems() - 1; i >= 0; --i) {
            ds = ssaSQ.getItem(i);
            rpID = ds.getString(0x401001);
            spsID = ds.getString(0x400009);
            spsIDs.add(rpID + "_" + spsID);
            if (spsID == null) continue;
            try {
                MWLItemLocal mwlItem = this.mwlItemHome.findByRpIdAndSpsId(rpID, spsID);
                Dataset mwlDS = mwlItem.getAttributes();
                mwlDS.getItem(0x400100).putCS(0x400020, "SCHEDULED");
                mwlItem.setAttributes(mwlDS);
                continue;
            }
            catch (FinderException ignore) {
                // empty catch block
            }
        }
        String studyIUID = ds.getString(0x20000D);
        ds.clear();
        ds.putUI(0x20000D, studyIUID);
        ds.putSH(0x400009, (String)null);
        ds.putSH(524368, (String)null);
        ds.putSQ(528656);
        ds.putSH(0x401001, (String)null);
        ds.putLO(0x400007, (String)null);
        ds.putSQ(0x400008);
        mppsAttrs.putSQ(4194928).addItem(ds);
        mpps.setAttributes(mppsAttrs);
        mppsAttrsSav.putAll((DcmObject)mpps.getPatient().getAttributes(true));
        Collection seriesDS = this.getSeriesAndStudyDS(mpps.getSopIuid());
        boolean noOtherMpps = this.mppsHome.findByStudyIuid(studyIUID).size() < 2;
        Dataset series2 = null;
        ArrayList<Dataset> seriesChgd = new ArrayList<Dataset>();
        boolean remainingReqAttrs = false;
        for (Dataset series2 : seriesDS) {
            DcmElement reqAttrSQ = series2.get(4194933);
            if (reqAttrSQ == null || reqAttrSQ.countItems() <= 0) continue;
            seriesChgd.add(series2);
            DcmElement newReqAttrSQ = series2.putSQ(4194933);
            for (int i = 0; i < reqAttrSQ.countItems(); ++i) {
                Dataset item = reqAttrSQ.getItem(i);
                rpID = item.getString(0x401001);
                spsID = item.getString(0x400009);
                if (spsIDs.contains(rpID + "_" + spsID)) continue;
                newReqAttrSQ.addItem(item);
            }
            if (newReqAttrSQ.countItems() <= 0) continue;
            remainingReqAttrs = true;
        }
        if (series2 != null && !remainingReqAttrs && noOtherMpps) {
            if (seriesChgd.size() == 0) {
                seriesChgd.add(series2);
            } else {
                series2 = (Dataset)seriesChgd.iterator().next();
            }
            series2.putSH(524368);
        }
        this.updateSeriesAndStudy(seriesChgd);
        return mppsAttrsSav;
    }

    public void removeRequestAttributesInSeries(Dataset mwlAttrs, Collection seriesIuids) throws CreateException, FinderException {
        String mwlID = mwlAttrs.getString(0x401001) + "_" + mwlAttrs.getItem(0x400100).getString(0x400009);
        Dataset seriesAttrs = null;
        for (String suid : seriesIuids) {
            SeriesLocal series;
            try {
                series = this.seriesHome.findBySeriesIuid(suid);
            }
            catch (FinderException x) {
                log.info((Object)("Series " + suid + " not found! Remove of Request Attributes Ignored!"));
                continue;
            }
            seriesAttrs = series.getAttributes(true);
            DcmElement reqAttrSQ = seriesAttrs.get(4194933);
            if (reqAttrSQ == null || reqAttrSQ.countItems() <= 0) continue;
            DcmElement newReqAttrSQ = seriesAttrs.putSQ(4194933);
            int len = reqAttrSQ.countItems();
            for (int i = 0; i < len; ++i) {
                Dataset item = reqAttrSQ.getItem(i);
                if (mwlID.equals(item.getString(0x401001) + "_" + item.getString(0x400009))) continue;
                newReqAttrSQ.addItem(item);
            }
            if (newReqAttrSQ.countItems() == reqAttrSQ.countItems()) continue;
            if (newReqAttrSQ.countItems() == 0) {
                seriesAttrs.putSH(524368);
            }
            series.updateAttributes(seriesAttrs, true, null);
        }
    }

    public Collection getSeriesIUIDs(String mppsIUID) throws FinderException {
        ArrayList<String> col = new ArrayList<String>();
        Collection series = this.seriesHome.findByPpsIuid(mppsIUID);
        Iterator iter = series.iterator();
        while (iter.hasNext()) {
            col.add(((SeriesLocal)iter.next()).getSeriesIuid());
        }
        return col;
    }

    public Collection getSeriesAndStudyDS(String mppsIUID) throws FinderException {
        ArrayList<Dataset> col = new ArrayList<Dataset>();
        Collection seriess = this.seriesHome.findByPpsIuid(mppsIUID);
        for (SeriesLocal series : seriess) {
            Dataset ds = series.getAttributes(true);
            ds.putAll((DcmObject)series.getStudy().getAttributes(true));
            col.add(ds);
        }
        return col;
    }

    public Dataset updateSeriesAndStudy(Collection seriesDS) throws FinderException, CreateException {
        Dataset ds2 = null;
        SeriesLocal series = null;
        Dataset dsN = DcmObjectFactory.getInstance().newDataset();
        DcmElement refSeriesSeq = dsN.putSQ(528661);
        for (Dataset ds2 : seriesDS) {
            String iuid = ds2.getString(0x20000E);
            series = this.seriesHome.findBySeriesIuid(iuid);
            series.updateAttributes(ds2, true, null);
            Dataset dsSer = refSeriesSeq.addNewItem();
            dsSer.putAll((DcmObject)series.getAttributes(true));
            Iterator iter2 = series.getInstances().iterator();
            if (!iter2.hasNext()) continue;
            DcmElement refSopSeq = dsSer.putSQ(528793);
            while (iter2.hasNext()) {
                InstanceLocal il = (InstanceLocal)iter2.next();
                Dataset dsInst = refSopSeq.addNewItem();
                dsInst.putUI(528720, il.getSopCuid());
                dsInst.putUI(528725, il.getSopIuid());
                dsInst.putAE(524372, il.getRetrieveAETs());
            }
        }
        if (series != null) {
            StudyLocal study = series.getStudy();
            study.setAttributes(ds2);
            dsN.putAll((DcmObject)study.getAttributes(true));
            dsN.putAll((DcmObject)study.getPatient().getAttributes(true));
        }
        return dsN;
    }

    public void updateSeriesAttributes(String uid, Dataset newAttrs, boolean updateStudyAttributes) {
        try {
            SeriesLocal series = this.seriesHome.findBySeriesIuid(uid);
            series.updateAttributes(newAttrs, true, null);
            if (updateStudyAttributes) {
                series.getStudy().updateAttributes(newAttrs, null);
            }
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public List updateScheduledStepAttributes(Dataset mwlitem, PatientMatching matching, boolean updateDifferentPatientOfExistingStudy) throws PatientMismatchException {
        PatientLocal pat;
        Collection c;
        String suid = mwlitem.getString(0x20000D);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Query for MPPS for Study " + suid));
        }
        try {
            c = this.mppsHome.mppsByStudyIuid(suid);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + c.size() + " MPPS for Study " + suid));
        }
        if (c.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        boolean discontinued = "DISCONTINUED".equals(mwlitem.getItem(0x400100).getString(0x400020));
        try {
            pat = this.patHome.selectPatient(mwlitem, matching, false);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        ArrayList<Dataset> updated = new ArrayList<Dataset>(c.size());
        for (MPPSLocal mpps : c) {
            DcmElement ssasq;
            PatientLocal priorPat = mpps.getPatient();
            if (!pat.isIdentical((EJBLocalObject)priorPat)) {
                String prompt = pat.asString() + " does not match " + priorPat.asString() + " associated with " + mpps.asString();
                if (!updateDifferentPatientOfExistingStudy) {
                    log.warn((Object)prompt);
                    throw new PatientMismatchException(prompt);
                }
                log.info((Object)prompt);
                this.updatePatientOfMppsAndStudy(suid, mpps, pat);
            }
            Dataset attrs = mpps.getAttributes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check " + mpps.asString() + " for update of Scheduled Step Attributes:"));
                log.debug((Object)attrs);
            }
            if (!this.updateScheduledStepAttributes(mwlitem, ssasq = attrs.get(4194928), discontinued)) continue;
            mpps.setAttributes(attrs);
            updated.add(attrs);
            log.info((Object)("Updated Scheduled Step Attributes of " + mpps.asString()));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)attrs);
        }
        return updated;
    }

    private void updatePatientOfMppsAndStudy(String suid, MPPSLocal mpps, PatientLocal pat) {
        PatientLocal priorPat = mpps.getPatient();
        String patPrompt = pat.asString();
        String priorPatPrompt = priorPat.asString();
        log.info((Object)("Move " + mpps.asString() + " from " + priorPatPrompt + " to " + patPrompt));
        mpps.setPatient(pat);
        Collection studies = priorPat.getStudies();
        Iterator it = studies.iterator();
        while (it.hasNext()) {
            StudyLocal study = (StudyLocal)it.next();
            String studyPrompt = study.asString();
            if (study.getStudyIuid().equals(suid)) {
                log.info((Object)("Move " + studyPrompt + " from " + priorPatPrompt + " to " + patPrompt));
                it.remove();
                study.setPatient(pat);
                continue;
            }
            log.warn((Object)(studyPrompt + " still associated with " + priorPatPrompt));
        }
    }

    private boolean contains(DcmElement refRequestSeq, String suid) {
        if (refRequestSeq != null) {
            int n = refRequestSeq.countItems();
            for (int i = 0; i < n; ++i) {
                Dataset refRequest = refRequestSeq.getItem(i);
                if (!suid.equals(refRequest.getString(0x20000D))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean updateScheduledStepAttributes(Dataset mwlitem, DcmElement ssasq, boolean discontinued) {
        String suid = mwlitem.getString(0x20000D);
        String rpid = mwlitem.getString(0x401001);
        Dataset sps = mwlitem.getItem(0x400100);
        String spsid = sps.getString(0x400009);
        int n = ssasq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset ssa = ssasq.getItem(i);
            if (!suid.equals(ssa.getString(0x20000D)) || !this.isNullOrEquals(ssa.getString(0x401001), rpid) || !this.isNullOrEquals(ssa.getString(0x400009), spsid)) continue;
            if (discontinued) {
                ssa.clear();
                ssa.putUI(0x20000D, suid);
                ssa.putSH(0x400009, (String)null);
                ssa.putSH(524368, (String)null);
                ssa.putSQ(528656);
                ssa.putSH(0x401001, (String)null);
                ssa.putLO(0x400007, (String)null);
                ssa.putSQ(0x400008);
                return true;
            }
            boolean updated = this.updateRefStudySeq(ssa, suid);
            if (this.updateSH(ssa, 524368, mwlitem.getString(524368))) {
                updated = true;
            }
            if (this.updateLO(ssa, 4202518, mwlitem.getString(4202518))) {
                updated = true;
            }
            if (this.updateLO(ssa, 4202519, mwlitem.getString(4202519))) {
                updated = true;
            }
            if (this.updateSH(ssa, 0x401001, rpid)) {
                updated = true;
            }
            if (this.updateLO(ssa, 3280992, mwlitem.getString(3280992))) {
                updated = true;
            }
            if (this.updateItem(ssa, 3280996, mwlitem.getItem(3280996))) {
                updated = true;
            }
            if (this.updateSH(ssa, 0x400009, spsid)) {
                updated = true;
            }
            if (this.updateLO(ssa, 0x400007, sps.getString(0x400007))) {
                updated = true;
            }
            if (this.updateItems(ssa, 0x400008, sps.get(0x400008))) {
                updated = true;
            }
            return updated;
        }
        return false;
    }

    private boolean isNullOrEquals(String val, String ref) {
        return val == null || val.equals(ref);
    }

    private boolean updateRefStudySeq(Dataset ssa, String suid) {
        if (ssa.getItem(528656) != null) {
            return false;
        }
        Dataset refStudy = ssa.putSQ(528656).addNewItem();
        refStudy.putUI(528720, "1.2.840.10008.3.1.2.3.1");
        refStudy.putUI(528725, suid);
        return true;
    }

    private boolean updateSH(Dataset ssa, int tag, String val) {
        if (val == null || val.equals(ssa.getString(tag))) {
            return false;
        }
        ssa.putSH(tag, val);
        return true;
    }

    private boolean updateLO(Dataset ssa, int tag, String val) {
        if (val == null || val.equals(ssa.getString(tag))) {
            return false;
        }
        ssa.putLO(tag, val);
        return true;
    }

    private boolean updateItem(Dataset ssa, int tag, Dataset item) {
        if (item == null || item.equals(ssa.getItem(tag))) {
            return false;
        }
        ssa.putSQ(tag).addItem(item);
        return true;
    }

    private boolean updateItems(Dataset ssa, int tag, DcmElement sq) {
        if (sq == null || sq.isEmpty() || sq.equals(ssa.get(tag))) {
            return false;
        }
        DcmElement dstsq = ssa.putSQ(tag);
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            dstsq.addItem(sq.getItem(i));
        }
        return true;
    }

    private String[] getPerfSeriesIUIDs(Dataset ds) {
        DcmElement sq = ds.get(0x400340);
        ArrayList<String> l = new ArrayList<String>();
        int len = sq.countItems();
        for (int i = 0; i < len; ++i) {
            l.add(sq.getItem(i).getString(0x20000E));
        }
        return l.toArray(new String[l.size()]);
    }
}

