/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.interfaces.GPPPSLocal;
import org.dcm4chex.archive.ejb.interfaces.GPPPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.GPSPSLocal;
import org.dcm4chex.archive.ejb.interfaces.GPSPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.exceptions.NonUniquePatientException;

public abstract class GPPPSManagerBean
implements SessionBean {
    private static Logger log = Logger.getLogger(GPPPSManagerBean.class);
    private static final int GPSPS_NOT_IN_PROGRESS = 42244;
    private static final int GPSPS_DIFF_TRANS_UID = 42245;
    private static final int GPPPS_NOT_IN_PROGRESS = 42246;
    private PatientLocalHome patHome;
    private GPSPSLocalHome spsHome;
    private GPPPSLocalHome ppsHome;

    public void setSessionContext(SessionContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
            this.spsHome = (GPSPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/GPSPS");
            this.ppsHome = (GPPPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/GPPPS");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.spsHome = null;
        this.ppsHome = null;
        this.patHome = null;
    }

    public void createGPPPS(Dataset ds, PatientMatching matching) throws DcmServiceException {
        this.checkDuplicate(ds.getString(524312));
        PatientLocal pat = this.findOrCreatePatient(ds, matching);
        Collection gpsps = this.findRefGpsps(ds, pat);
        GPPPSLocal pps = this.doCreate(ds, pat);
        if (gpsps != null) {
            pps.setGpsps(gpsps);
        }
    }

    private PatientLocal findOrCreatePatient(Dataset ds, PatientMatching matching) throws DcmServiceException {
        try {
            try {
                return this.patHome.selectPatient(ds, matching, true);
            }
            catch (ObjectNotFoundException enfe) {
                return this.patHome.create(ds);
            }
            catch (NonUniquePatientException onfe) {
                return this.patHome.create(ds);
            }
        }
        catch (Exception e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    private GPPPSLocal doCreate(Dataset ds, PatientLocal pat) throws DcmServiceException {
        try {
            return this.ppsHome.create(ds, pat);
        }
        catch (CreateException e) {
            log.error((Object)("Creation of GP-PPS(iuid=" + ds.getString(524312) + ") failed: "), (Throwable)e);
            throw new DcmServiceException(272);
        }
    }

    private void checkDuplicate(String ppsiuid) throws DcmServiceException {
        try {
            this.ppsHome.findBySopIuid(ppsiuid);
            throw new DcmServiceException(273);
        }
        catch (ObjectNotFoundException e) {
        }
        catch (FinderException e) {
            log.error((Object)("Query for GP-PPS(iuid=" + ppsiuid + ") failed: "), (Throwable)e);
            throw new DcmServiceException(272);
        }
    }

    private Collection findRefGpsps(Dataset pps, PatientLocal pat) throws DcmServiceException {
        DcmElement spssq = pps.get(4210710);
        if (spssq == null) {
            return null;
        }
        int n = spssq.countItems();
        ArrayList<GPSPSLocal> c = new ArrayList<GPSPSLocal>(n);
        for (int i = 0; i < n; ++i) {
            Dataset refSOP = spssq.getItem(i);
            String spsiuid = refSOP.getString(528725);
            String spstuid = refSOP.getString(4210723);
            try {
                GPSPSLocal sps = this.spsHome.findBySopIuid(spsiuid);
                PatientLocal spspat = sps.getPatient();
                if (!pat.isIdentical((EJBLocalObject)spspat)) {
                    log.info((Object)("Patient of referenced GP-SPS(iuid=" + spsiuid + "): " + spspat.asString() + " differes from Patient of GP-PPS: " + pat.asString()));
                    throw new DcmServiceException(262, "GP-SPS PID: " + spspat.getPatientId() + ", GP-PPS PID: " + pat.getPatientId());
                }
                if (!sps.isInProgress()) {
                    String spsstatus = sps.getGpspsStatus();
                    log.info((Object)("Status of referenced GP-SPS(iuid=" + spsiuid + ") is not IN PROGRESS, but " + spsstatus));
                    throw new DcmServiceException(42244, "ref GP-SPS status: " + spsstatus);
                }
                String tuid = sps.getTransactionUid();
                if (!spstuid.equals(tuid)) {
                    log.info((Object)("Referenced GP-SPS Transaction UID: " + spstuid + " does not match the Transaction UID: " + tuid + " of the N-ACTION request"));
                    throw new DcmServiceException(42245);
                }
                Dataset spsAttrs = sps.getAttributes();
                DcmElement ppss = spsAttrs.get(4210709);
                if (ppss == null) {
                    ppss = spsAttrs.putSQ(4210709);
                }
                Dataset refpps = ppss.addNewItem();
                refpps.putUI(528720, pps.getString(524310));
                refpps.putUI(528725, pps.getString(524312));
                sps.setAttributes(spsAttrs);
                c.add(sps);
                continue;
            }
            catch (ObjectNotFoundException e) {
                log.info((Object)("Referenced GP-SPS(iuid=" + spsiuid + ") not in provided GP-WL"));
                continue;
            }
            catch (FinderException e) {
                log.error((Object)("Query for GP-SPS(iuid=" + spsiuid + ") failed: "), (Throwable)e);
                throw new DcmServiceException(272);
            }
        }
        return c;
    }

    public Dataset getGPPPS(String iuid) throws DcmServiceException {
        GPPPSLocal pps = this.findBySopIuid(iuid);
        PatientLocal pat = pps.getPatient();
        Dataset attrs = pps.getAttributes();
        attrs.putAll((DcmObject)pat.getAttributes(false));
        return attrs;
    }

    public void updateGPPPS(Dataset ds) throws DcmServiceException {
        String iuid = ds.getString(524312);
        GPPPSLocal pps = this.findBySopIuid(iuid);
        if (!pps.isInProgress()) {
            String ppsstatus = pps.getPpsStatus();
            log.info((Object)("Status of GP-PPS(iuid=" + iuid + ") is not IN PROGRESS, but " + ppsstatus));
            throw new DcmServiceException(42246, "GP-PPS status: " + ppsstatus);
        }
        Dataset attrs = pps.getAttributes();
        attrs.putAll((DcmObject)ds);
        pps.setAttributes(attrs);
    }

    private GPPPSLocal findBySopIuid(String iuid) throws DcmServiceException {
        try {
            return this.ppsHome.findBySopIuid(iuid);
        }
        catch (ObjectNotFoundException e) {
            throw new DcmServiceException(274);
        }
        catch (FinderException e) {
            throw new DcmServiceException(272, (Throwable)e);
        }
    }

    public void removeGPPPS(String iuid) throws EJBException, RemoveException, FinderException {
        this.ppsHome.findBySopIuid(iuid).remove();
        log.info((Object)("GPPPS removed:" + iuid));
    }
}

