/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.util.Collection;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;

public abstract class FixPatientAttributesBean
implements SessionBean {
    private static Logger log = Logger.getLogger(FixPatientAttributesBean.class);
    private PatientLocalHome patHome;

    public void setSessionContext(SessionContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.patHome = (PatientLocalHome)jndiCtx.lookup("java:comp/env/ejb/Patient");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.patHome = null;
    }

    public int[] checkPatientAttributes(int offset, int limit, boolean doUpdate) throws FinderException {
        Collection col = this.patHome.findAll(offset, limit);
        if (col.isEmpty()) {
            return null;
        }
        int[] result = new int[]{0, 0};
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        for (PatientLocal patient : col) {
            Dataset patAttrs = patient.getAttributes(false);
            Dataset filtered = filter.filter(patAttrs);
            if (patAttrs.size() > filtered.size()) {
                log.warn((Object)("Detect Patient Record [pk= " + patient.getPk() + "] with non-patient attributes:"));
                log.warn((Object)patAttrs);
                if (doUpdate) {
                    patient.setAttributes(filtered);
                    log.warn((Object)("Remove non-patient attributes from Patient Record [pk= " + patient.getPk() + "]"));
                }
                result[0] = result[0] + 1;
            }
            result[1] = result[1] + 1;
        }
        return result;
    }
}

