/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.DeleteStudyOrder;
import org.dcm4chex.archive.common.DeleteStudyOrdersAndMaxAccessTime;
import org.dcm4chex.archive.common.IANAndPatientID;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.FileLocal;
import org.dcm4chex.archive.ejb.interfaces.FileLocalHome;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemLocal;
import org.dcm4chex.archive.ejb.interfaces.FileSystemLocalHome;
import org.dcm4chex.archive.ejb.interfaces.FileSystemMgt2Local;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateFileLocal;
import org.dcm4chex.archive.ejb.interfaces.PrivateFileLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyOnFileSystemLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyOnFileSystemLocalHome;
import org.dcm4chex.archive.ejb.session.UpdateDerivedFieldsUtils;
import org.dcm4chex.archive.exceptions.ConcurrentStudyStorageException;
import org.dcm4chex.archive.exceptions.NoSuchSeriesException;
import org.dcm4chex.archive.exceptions.NoSuchStudyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystemMgt2Bean
implements SessionBean {
    private static Logger log = Logger.getLogger(FileSystemMgt2Bean.class);
    private static final int[] IAN_PAT_TAGS = new int[]{524293, 0x100010, 0x100020};
    private SessionContext ctx;
    private FileSystemLocalHome fileSystemHome;
    private FileLocalHome fileHome;
    private PrivateFileLocalHome privFileHome;
    private StudyLocalHome studyHome;
    private SeriesLocalHome seriesHome;
    private InstanceLocalHome instHome;
    private StudyOnFileSystemLocalHome sofHome;
    private static final Comparator DESC_FILE_PK = new Comparator(){

        public int compare(Object o1, Object o2) {
            FileDTO dto1 = (FileDTO)o1;
            FileDTO dto2 = (FileDTO)o2;
            int diffAvail = dto1.getAvailability() - dto2.getAvailability();
            long diffPk = dto2.getPk() - dto1.getPk();
            return diffAvail != 0 ? diffAvail : (diffPk == 0L ? 0 : (diffPk < 0L ? -1 : 1));
        }
    };

    public void setSessionContext(SessionContext ctx) {
        this.ctx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.fileSystemHome = (FileSystemLocalHome)jndiCtx.lookup("java:comp/env/ejb/FileSystem");
            this.fileHome = (FileLocalHome)jndiCtx.lookup("java:comp/env/ejb/File");
            this.privFileHome = (PrivateFileLocalHome)jndiCtx.lookup("java:comp/env/ejb/PrivateFile");
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
            this.sofHome = (StudyOnFileSystemLocalHome)jndiCtx.lookup("java:comp/env/ejb/StudyOnFileSystem");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.ctx = null;
        this.fileSystemHome = null;
        this.fileHome = null;
        this.privFileHome = null;
        this.studyHome = null;
        this.seriesHome = null;
        this.instHome = null;
        this.sofHome = null;
    }

    public FileSystemDTO addFileSystem(FileSystemDTO dto) throws CreateException {
        return this.fileSystemHome.create(dto).toDTO();
    }

    public FileSystemDTO removeFileSystem(String groupID, String dirPath) throws FinderException, RemoveException {
        FileSystemLocal fs = this.fileSystemHome.findByGroupIdAndDirectoryPath(groupID, dirPath);
        FileSystemDTO dto = fs.toDTO();
        this.removeFileSystem(fs);
        return dto;
    }

    private void removeFileSystem(FileSystemLocal fs) throws RemoveException, FinderException {
        FileSystemLocal next = fs.getNextFileSystem();
        if (next != null && fs.isIdentical((EJBLocalObject)next)) {
            next = null;
        }
        Collection c = fs.getPreviousFileSystems();
        FileSystemLocal[] prevs = c.toArray(new FileSystemLocal[c.size()]);
        for (int i = 0; i < prevs.length; ++i) {
            prevs[i].setNextFileSystem(next);
        }
        if (fs.getStatus() == 0 && next != null && next.getStatus() == 1) {
            next.setStatus(0);
        }
        fs.remove();
    }

    public FileSystemDTO getFileSystem(long pk) throws FinderException {
        return this.fileSystemHome.findByPrimaryKey(new Long(pk)).toDTO();
    }

    public FileSystemDTO getFileSystemOfGroup(String groupID, String path) throws FinderException {
        return FileSystemMgt2Bean.toDTO(this.fileSystemHome.findByGroupIdAndDirectoryPath(groupID, path));
    }

    public FileSystemDTO[] getAllFileSystems() throws FinderException {
        return FileSystemMgt2Bean.toDTO(this.fileSystemHome.findAll());
    }

    public FileSystemDTO[] getFileSystemsOfGroup(String groupId) throws FinderException {
        return FileSystemMgt2Bean.toDTO(this.fileSystemHome.findByGroupId(groupId));
    }

    public FileSystemDTO[] getRWFileSystemsOfGroup(String groupId) throws FinderException {
        return FileSystemMgt2Bean.toDTO(this.fileSystemHome.findRWByGroupId(groupId));
    }

    public FileSystemDTO getDefRWFileSystemsOfGroup(String groupId) throws FinderException {
        return FileSystemMgt2Bean.toDTO(this.selectDefRWFileSystemsOfGroup(groupId));
    }

    private FileSystemLocal selectDefRWFileSystemsOfGroup(String groupId) throws FinderException {
        Collection c = this.fileSystemHome.findByGroupIdAndStatus(groupId, 0);
        if (!c.isEmpty()) {
            return (FileSystemLocal)c.iterator().next();
        }
        c = this.fileSystemHome.findByGroupIdAndStatus(groupId, 1);
        for (FileSystemLocal fs : c) {
            if (fs.getAvailability() == 2 || fs.getAvailability() == 3) continue;
            log.info((Object)("Update status of " + fs.asString() + " to RW+"));
            fs.setStatus(0);
            return fs;
        }
        return null;
    }

    public FileSystemDTO updateFileSystemStatus(long pk, int status) throws FinderException {
        return this.updateFileSystemStatus(this.fileSystemHome.findByPrimaryKey(new Long(pk)), status);
    }

    public FileSystemDTO updateFileSystemStatus(String groupID, String dirPath, int status) throws FinderException {
        return this.updateFileSystemStatus(this.fileSystemHome.findByGroupIdAndDirectoryPath(groupID, dirPath), status);
    }

    private FileSystemDTO updateFileSystemStatus(FileSystemLocal fs, int status) throws FinderException {
        if (status != fs.getStatus()) {
            if (status == 0) {
                int availability = fs.getAvailability();
                if (availability == 3 || availability == 2) {
                    throw new IllegalStateException("The file system is " + Availability.toString((int)availability) + ", and cannot be selected as the active volume");
                }
                Collection c = this.fileSystemHome.findByGroupIdAndStatus(fs.getGroupID(), 0);
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    ((FileSystemLocal)iterator.next()).setStatus(1);
                }
            }
            fs.setStatus(status);
        }
        return fs.toDTO();
    }

    public FileSystemDTO updateFileSystemRetrieveAET(String groupID, String dirPath, String retrieveAET, int limit) throws FinderException {
        FileSystemLocal fs = this.fileSystemHome.findByGroupIdAndDirectoryPath(groupID, dirPath);
        String oldAET = fs.getRetrieveAET();
        if (!retrieveAET.equals(oldAET)) {
            fs.setRetrieveAET(retrieveAET);
            this.updateRetrieveAETForStudyOnFileSystem(fs, oldAET, retrieveAET, limit);
        }
        return fs.toDTO();
    }

    public int updateFileSystemRetrieveAET(String oldAET, String newAET, int limit) throws FinderException {
        if (oldAET.equals(newAET)) {
            return 0;
        }
        Collection fss = this.fileSystemHome.findByRetrieveAET(oldAET);
        for (FileSystemLocal fs : fss) {
            fs.setRetrieveAET(newAET);
            this.updateRetrieveAETForStudyOnFileSystem(fs, oldAET, newAET, limit);
        }
        return fss.size();
    }

    private void updateRetrieveAETForStudyOnFileSystem(FileSystemLocal fs, String oldAET, String newAET, int batchsize) throws FinderException {
        int offset = 0;
        while (true) {
            Collection studies = this.studyHome.findStudiesWithFilesOnFileSystem(fs, offset, batchsize);
            for (StudyLocal study : studies) {
                FileSystemMgt2Local ejb = (FileSystemMgt2Local)this.ctx.getEJBLocalObject();
                study.updateRetrieveAETs(oldAET, newAET);
            }
            if (studies.size() < batchsize) break;
            offset += batchsize;
        }
    }

    public FileSystemDTO updateAvailabilityForStudyOnFileSystem(String groupID, String dirPath, int availabilityOfExtRetr, int batchsize) throws FinderException {
        FileSystemLocal fs = this.fileSystemHome.findByGroupIdAndDirectoryPath(groupID, dirPath);
        int offset = 0;
        while (true) {
            Collection studies = this.studyHome.findStudiesWithFilesOnFileSystem(fs, offset, batchsize);
            for (StudyLocal study : studies) {
                FileSystemMgt2Local ejb = (FileSystemMgt2Local)this.ctx.getEJBLocalObject();
                ejb.updateAvailabilityForStudy(study, availabilityOfExtRetr);
            }
            if (studies.size() < batchsize) break;
            offset += batchsize;
        }
        return fs.toDTO();
    }

    public boolean updateFileSystemAvailability(String groupID, String dirPath, int availability) throws FinderException {
        FileSystemLocal fs = this.fileSystemHome.findByGroupIdAndDirectoryPath(groupID, dirPath);
        if (fs.getAvailability() == availability) {
            return false;
        }
        fs.setAvailability(availability);
        return true;
    }

    public boolean updateAvailabilityForStudy(StudyLocal study, int availabilityOfExtRetr) throws FinderException {
        Collection series = study.getSeries();
        boolean updated = false;
        boolean updateStudy = false;
        for (SeriesLocal ser : series) {
            Collection insts = ser.getInstances();
            boolean updateSeries = false;
            for (InstanceLocal inst : insts) {
                if (!inst.updateAvailability(availabilityOfExtRetr)) continue;
                updated = true;
                updateSeries = true;
            }
            if (!updateSeries || !ser.updateAvailability()) continue;
            updateStudy = true;
        }
        if (updateStudy) {
            study.updateAvailability();
        }
        return updated;
    }

    public FileSystemDTO linkFileSystems(String groupID, String dirPath, String next) throws FinderException {
        FileSystemLocal prevfs = this.fileSystemHome.findByGroupIdAndDirectoryPath(groupID, dirPath);
        FileSystemLocal nextfs = next != null && next.length() != 0 ? this.fileSystemHome.findByGroupIdAndDirectoryPath(groupID, next) : null;
        prevfs.setNextFileSystem(nextfs);
        return prevfs.toDTO();
    }

    public FileSystemDTO addAndLinkFileSystem(FileSystemDTO dto) throws FinderException, CreateException {
        FileSystemLocal prev = this.selectDefRWFileSystemsOfGroup(dto.getGroupID());
        if (prev == null) {
            dto.setStatus(0);
            Collection c = this.fileSystemHome.findByGroupId(dto.getGroupID());
            if (!c.isEmpty()) {
                prev = (FileSystemLocal)c.iterator().next();
            }
        }
        FileSystemLocal fs = this.fileSystemHome.create(dto);
        if (prev != null) {
            FileSystemLocal next;
            FileSystemLocal prev0 = prev;
            while ((next = prev.getNextFileSystem()) != null && !next.isIdentical((EJBLocalObject)prev0)) {
                prev = next;
            }
            prev.setNextFileSystem(fs);
            fs.setNextFileSystem(next);
        }
        return fs.toDTO();
    }

    public long sizeOfFilesCreatedAfter(long pk, long after) throws FinderException {
        return this.fileSystemHome.sizeOfFilesCreatedAfter(new Long(pk), new Timestamp(after));
    }

    public Timestamp minCreatedTimeOnFsWithFileStatus(String dirPath, int status) throws FinderException {
        return this.fileSystemHome.minCreatedTimeOnFsWithFileStatus(dirPath, status);
    }

    private static FileSystemDTO toDTO(FileSystemLocal fs) {
        return fs != null ? fs.toDTO() : null;
    }

    private static FileSystemDTO[] toDTO(Collection c) {
        FileSystemDTO[] dto = new FileSystemDTO[c.size()];
        Iterator it = c.iterator();
        for (int i = 0; i < dto.length; ++i) {
            dto[i] = ((FileSystemLocal)it.next()).toDTO();
        }
        return dto;
    }

    public long getStudySize(DeleteStudyOrder order) throws FinderException {
        return this.studyHome.selectStudySize(Long.valueOf(order.getStudyPk()), Long.valueOf(order.getFsPk()));
    }

    public boolean markStudyOnFSRecordForDeletion(DeleteStudyOrder order, boolean b) throws RemoveException, FinderException {
        StudyOnFileSystemLocal sof = this.sofHome.findByPrimaryKey(Long.valueOf(order.getSoFsPk()));
        boolean marked = sof.getMarkedForDeletion();
        if (b) {
            if (marked) {
                this.logOrderInfoMsg(order, "is already marked for deletion!");
                return false;
            }
            if (sof.getAccessTime().getTime() > order.getAccessTime()) {
                this.logOrderInfoMsg(order, "may have updated after check of deletion constraints -> do not mark study for deletion.");
                return false;
            }
        } else if (!marked) {
            this.logOrderInfoMsg(order, "Remove of deletion mark ignored! (not marked for deletion)");
            return false;
        }
        sof.setMarkedForDeletion(b);
        return true;
    }

    public boolean removeStudyOnFSRecord(DeleteStudyOrder order) throws RemoveException, FinderException {
        StudyOnFileSystemLocal sof = this.sofHome.findByPrimaryKey(Long.valueOf(order.getSoFsPk()));
        if (!sof.getMarkedForDeletion()) {
            this.logOrderInfoMsg(order, "is not marked for deletion -> do not remove StudyOnFSRecord!");
            return false;
        }
        sof.remove();
        return true;
    }

    public void createStudyOnFSRecord(DeleteStudyOrder order) throws CreateException, FinderException {
        this.sofHome.create(this.studyHome.findByPrimaryKey(Long.valueOf(order.getStudyPk())), this.fileSystemHome.findByPrimaryKey(Long.valueOf(order.getFsPk())));
    }

    public DeleteStudyOrdersAndMaxAccessTime createDeleteOrdersForStudiesOnFSGroup(String fsGroup, long minAccessTime, long maxAccessTime, int limit, boolean externalRetrieveable, boolean storageNotCommited, boolean copyOnMedia, String copyOnFSGroup, boolean copyArchived, boolean copyOnReadOnlyFS) throws FinderException {
        return this.createDeleteOrders(this.sofHome.findByFSGroupAndAccessedBetween(fsGroup, new Timestamp(minAccessTime), new Timestamp(maxAccessTime), limit), externalRetrieveable, storageNotCommited, copyOnMedia, copyOnFSGroup, copyArchived, copyOnReadOnlyFS);
    }

    public Collection<DeleteStudyOrder> createDeleteOrdersForStudyOnFSGroup(String suid, String fsGroup) throws FinderException {
        Collection sofs = this.sofHome.findByStudyIUIDAndFSGroup(suid, fsGroup);
        ArrayList<DeleteStudyOrder> orders = new ArrayList<DeleteStudyOrder>(sofs.size());
        for (StudyOnFileSystemLocal sof : sofs) {
            StudyLocal study = sof.getStudy();
            DeleteStudyOrder deleteStudyOrder = new DeleteStudyOrder(sof.getPk().longValue(), study.getPk().longValue(), sof.getFileSystem().getPk().longValue(), sof.getAccessTime().getTime(), study.getExternalRetrieveAET(), study.getStudyIuid());
            deleteStudyOrder.processOrderProperties(new Object[]{suid});
            orders.add(deleteStudyOrder);
        }
        return orders;
    }

    private DeleteStudyOrdersAndMaxAccessTime createDeleteOrders(Collection sofs, boolean externalRetrieveable, boolean storageNotCommited, boolean copyOnMedia, String copyOnFSGroup, boolean copyArchived, boolean copyOnReadOnlyFS) throws FinderException {
        if (sofs.isEmpty()) {
            return null;
        }
        ArrayList<DeleteStudyOrder> orders = new ArrayList<DeleteStudyOrder>(sofs.size());
        long maxAccessTime = 0L;
        for (StudyOnFileSystemLocal sof : sofs) {
            maxAccessTime = sof.getAccessTime().getTime();
            if (!sof.matchDeleteConstrains(externalRetrieveable, storageNotCommited, copyOnMedia, copyOnFSGroup, copyArchived, copyOnReadOnlyFS)) continue;
            StudyLocal study = sof.getStudy();
            DeleteStudyOrder deleteStudyOrder = new DeleteStudyOrder(sof.getPk().longValue(), study.getPk().longValue(), sof.getFileSystem().getPk().longValue(), maxAccessTime, study.getExternalRetrieveAET(), study.getStudyIuid());
            deleteStudyOrder.processOrderProperties(new Object[]{study.getStudyIuid()});
            orders.add(deleteStudyOrder);
        }
        return new DeleteStudyOrdersAndMaxAccessTime(orders, maxAccessTime);
    }

    public Collection<Dataset> createIANforStudy(Long studyPk) throws FinderException, NoSuchStudyException {
        try {
            return this.createIANs(this.studyHome.findByPrimaryKey(studyPk));
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchStudyException((Throwable)e);
        }
    }

    public IANAndPatientID createIANforStudy(String uid) throws FinderException, NoSuchStudyException {
        try {
            StudyLocal study = this.studyHome.findByStudyIuid(uid);
            Dataset styAttrs = study.getAttributes(false);
            Dataset patAttrs = study.getPatient().getAttributes(false);
            Collection<Dataset> ians = this.createIANs(study);
            return new IANAndPatientID(patAttrs.getString(0x100020), patAttrs.getString(0x100010), styAttrs.getString(0x200010), ians);
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchStudyException((Throwable)e);
        }
    }

    private Collection<Dataset> createIANs(StudyLocal study) {
        PatientLocal pat = study.getPatient();
        HashMap<String, Dataset> ianMap = new HashMap<String, Dataset>();
        for (SeriesLocal series : study.getSeries()) {
            DcmElement refSerSeq;
            Dataset serAttrs = series.getAttributes(false);
            Dataset refPPS = serAttrs.getItem(528657);
            String refPPSIuid = refPPS == null ? null : refPPS.getString(528725);
            Dataset ian = (Dataset)ianMap.get(refPPSIuid);
            if (ian == null) {
                ian = DcmObjectFactory.getInstance().newDataset();
                ian.putAll((DcmObject)pat.getAttributes(false).subSet(IAN_PAT_TAGS));
                ian.putSH(0x200010, study.getStudyId());
                ian.putUI(0x20000D, study.getStudyIuid());
                DcmElement refPPSSeq = ian.putSQ(528657);
                refSerSeq = ian.putSQ(528661);
                if (refPPSIuid != null) {
                    refPPSSeq.addItem(refPPS);
                }
                ianMap.put(refPPSIuid, ian);
            } else {
                refSerSeq = ian.get(528661);
            }
            Dataset refSer = refSerSeq.addNewItem();
            refSer.putUI(0x20000E, series.getSeriesIuid());
            DcmElement refSopSeq = refSer.putSQ(528793);
            Collection insts = series.getInstances();
            for (InstanceLocal inst : insts) {
                Dataset refSOP = refSopSeq.addNewItem();
                refSOP.putUI(528720, inst.getSopCuid());
                refSOP.putUI(528725, inst.getSopIuid());
                DatasetUtils.putRetrieveAET((Dataset)refSOP, (String)inst.getRetrieveAETs(), (String)inst.getExternalRetrieveAET());
                refSOP.putCS(524374, Availability.toString((int)inst.getAvailabilitySafe()));
            }
        }
        return ianMap.values();
    }

    public Dataset createIANforSeries(Long seriesPk) throws FinderException, NoSuchSeriesException {
        try {
            return this.createIAN(this.seriesHome.findByPrimaryKey(seriesPk));
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchSeriesException((Throwable)e);
        }
    }

    public IANAndPatientID createIANforSeries(String uid) throws FinderException, NoSuchSeriesException {
        try {
            SeriesLocal series = this.seriesHome.findBySeriesIuid(uid);
            StudyLocal study = series.getStudy();
            Dataset styAttrs = study.getAttributes(false);
            Dataset patAttrs = study.getPatient().getAttributes(false);
            ArrayList<Dataset> ians = new ArrayList<Dataset>(1);
            ians.add(this.createIAN(series));
            return new IANAndPatientID(patAttrs.getString(0x100020), patAttrs.getString(0x100010), styAttrs.getString(0x200010), ians);
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchSeriesException((Throwable)e);
        }
    }

    private Dataset createIAN(SeriesLocal series) {
        StudyLocal study = series.getStudy();
        PatientLocal pat = study.getPatient();
        Dataset ian = DcmObjectFactory.getInstance().newDataset();
        ian.putAll((DcmObject)pat.getAttributes(false).subSet(IAN_PAT_TAGS));
        ian.putSH(0x200010, study.getStudyId());
        ian.putUI(0x20000D, study.getStudyIuid());
        DcmElement refPPSSeq = ian.putSQ(528657);
        HashSet ppsuids = new HashSet();
        DcmElement refSerSeq = ian.putSQ(528661);
        Dataset serAttrs = series.getAttributes(false);
        Dataset refPPS = serAttrs.getItem(528657);
        if (refPPS != null) {
            refPPSSeq.addItem(refPPS);
        }
        Dataset refSer = refSerSeq.addNewItem();
        refSer.putUI(0x20000E, series.getSeriesIuid());
        DcmElement refSopSeq = refSer.putSQ(528793);
        Collection insts = series.getInstances();
        for (InstanceLocal inst : insts) {
            Dataset refSOP = refSopSeq.addNewItem();
            refSOP.putUI(528720, inst.getSopCuid());
            refSOP.putUI(528725, inst.getSopIuid());
            DatasetUtils.putRetrieveAET((Dataset)refSOP, (String)inst.getRetrieveAETs(), (String)inst.getExternalRetrieveAET());
            refSOP.putCS(524374, Availability.toString((int)inst.getAvailabilitySafe()));
        }
        return ian;
    }

    public String[] deleteStudy(DeleteStudyOrder order, boolean delStudyFromDB, boolean delPatientWithoutObjects) throws ConcurrentStudyStorageException {
        try {
            long fsPk = order.getFsPk();
            StudyLocal study = this.studyHome.findByPrimaryKey(Long.valueOf(order.getStudyPk()));
            FileSystemLocal fs = this.fileSystemHome.findByPrimaryKey(Long.valueOf(fsPk));
            Collection files = study.getFiles(Long.valueOf(fsPk));
            this.checkConcurrentStudyStorage(study, fs);
            String fsPath = fs.getDirectoryPath();
            String[] fpaths = new String[files.size()];
            int i = 0;
            for (FileLocal f : files) {
                fpaths[i] = fsPath + '/' + f.getFilePath();
                f.remove();
                ++i;
            }
            if (delStudyFromDB && study.getAllFiles().isEmpty()) {
                PatientLocal pat = study.getPatient();
                study.remove();
                if (delPatientWithoutObjects) {
                    this.deletePatientWithoutObjects(pat);
                }
            } else {
                int availabilityOfExtRetr = order.getExternalRetrieveAvailability();
                this.updateStudyAvailability(study, availabilityOfExtRetr);
            }
            return fpaths;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private void checkConcurrentStudyStorage(StudyLocal study, FileSystemLocal fs) throws FinderException, ConcurrentStudyStorageException {
        try {
            if (!this.sofHome.findByStudyAndFileSystem(study, fs).getMarkedForDeletion()) {
                throw new ConcurrentStudyStorageException("Concurrent storage of study[uid=" + study.getStudyIuid() + "] on file system[dir=" + fs.getDirectoryPath() + "] - do not delete study");
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public FileDTO[] getFilesOfStudy(DeleteStudyOrder order) throws ConcurrentStudyStorageException {
        try {
            long fsPk = order.getFsPk();
            StudyLocal study = this.studyHome.findByPrimaryKey(Long.valueOf(order.getStudyPk()));
            FileSystemLocal fs = this.fileSystemHome.findByPrimaryKey(Long.valueOf(fsPk));
            this.checkConcurrentStudyStorage(study, fs);
            return this.toFileDTOs(study.getFiles(Long.valueOf(fsPk)));
        }
        catch (FinderException x) {
            throw new EJBException((Exception)((Object)x));
        }
    }

    public List<FileDTO> moveFiles(DeleteStudyOrder order, FileDTO[] dtos, Integer destFileStatus, boolean keepSrcFiles, boolean keepMovedFilesOnError) throws ConcurrentStudyStorageException {
        try {
            ArrayList<FileDTO> failed = null;
            long fsPk = order.getFsPk();
            StudyLocal study = this.studyHome.findByPrimaryKey(Long.valueOf(order.getStudyPk()));
            FileSystemLocal fs = this.fileSystemHome.findByPrimaryKey(Long.valueOf(fsPk));
            this.checkConcurrentStudyStorage(study, fs);
            FileSystemLocal fsDest = this.fileSystemHome.findByPrimaryKey(Long.valueOf(dtos[0].getFileSystemPk()));
            Collection c = study.getFiles(Long.valueOf(fsPk));
            FileLocal[] files = c.toArray(new FileLocal[c.size()]);
            for (int i = 0; i < dtos.length; ++i) {
                FileDTO dto = dtos[i];
                try {
                    FileLocal fSrc = this.getFile(dto.getPk(), files, i);
                    if (fSrc != null) {
                        if (keepSrcFiles) {
                            this.fileHome.create(dto.getFilePath(), fSrc.getFileTsuid(), fSrc.getFileSize(), fSrc.getFileMd5(), destFileStatus == null ? fSrc.getFileStatus() : destFileStatus.intValue(), fSrc.getInstance(), fsDest);
                            continue;
                        }
                        fSrc.setFilePath(dto.getFilePath());
                        fSrc.setFileSystem(fsDest);
                        if (destFileStatus == null) continue;
                        fSrc.setFileStatus(destFileStatus.intValue());
                        continue;
                    }
                    log.error((Object)("Missing source file for:" + dto));
                    continue;
                }
                catch (Exception e) {
                    if (!keepMovedFilesOnError) {
                        throw e instanceof RuntimeException ? (RuntimeException)e : new EJBException(e);
                    }
                    if (failed == null) {
                        failed = new ArrayList<FileDTO>();
                        order.setThrowable((Throwable)e);
                    }
                    failed.add(dto);
                }
            }
            int availabilityOfExtRetr = order.getExternalRetrieveAvailability();
            this.updateStudyAvailability(study, availabilityOfExtRetr);
            return failed;
        }
        catch (FinderException x) {
            throw new EJBException((Exception)((Object)x));
        }
    }

    private FileLocal getFile(long pk, FileLocal[] files, int i) {
        if (files[i].getPk() == pk) {
            return files[i];
        }
        for (int j = i + 1; j < files.length; ++j) {
            if (files[j].getPk() != pk) continue;
            FileLocal f = files[j];
            files[j] = files[i];
            files[i] = f;
            return f;
        }
        return null;
    }

    private void updateStudyAvailability(StudyLocal study, int availabilityOfExtRetr) {
        Collection seriess = study.getSeries();
        for (SeriesLocal series : seriess) {
            Collection insts = series.getInstances();
            for (InstanceLocal inst : insts) {
                inst.updateRetrieveAETs();
                inst.updateAvailability(availabilityOfExtRetr);
            }
            series.updateRetrieveAETs();
            series.updateAvailability();
        }
        study.updateRetrieveAETs();
        study.updateAvailability();
    }

    public Collection getSeriesPks(DeleteStudyOrder order) throws ConcurrentStudyStorageException {
        try {
            long fsPk = order.getFsPk();
            StudyLocal study = this.studyHome.findByPrimaryKey(Long.valueOf(order.getStudyPk()));
            Collection seriesPKs = study.getSeriesPks();
            FileSystemLocal fs = this.fileSystemHome.findByPrimaryKey(Long.valueOf(fsPk));
            this.checkConcurrentStudyStorage(study, fs);
            return seriesPKs;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public String[] deleteSeries(DeleteStudyOrder order, Long seriesPk, boolean delStudyFromDB, boolean delPatientWithoutObjects) throws ConcurrentStudyStorageException {
        try {
            long fsPk = order.getFsPk();
            SeriesLocal series = this.seriesHome.findByPrimaryKey(seriesPk);
            FileSystemLocal fs = this.fileSystemHome.findByPrimaryKey(Long.valueOf(fsPk));
            Collection files = series.getFiles(Long.valueOf(fsPk));
            String fsPath = fs.getDirectoryPath();
            String[] fpaths = new String[files.size()];
            int i = 0;
            for (FileLocal f : files) {
                fpaths[i] = fsPath + '/' + f.getFilePath();
                f.remove();
                ++i;
            }
            StudyLocal study = series.getStudy();
            if (delStudyFromDB && series.getAllFiles().isEmpty()) {
                series.remove();
                if (study.getSeries().isEmpty()) {
                    PatientLocal pat = study.getPatient();
                    study.remove();
                    if (delPatientWithoutObjects) {
                        this.deletePatientWithoutObjects(pat);
                    }
                }
            } else {
                int availabilityOfExtRetr = order.getExternalRetrieveAvailability();
                Collection insts = series.getInstances();
                for (InstanceLocal inst : insts) {
                    inst.updateRetrieveAETs();
                    inst.updateAvailability(availabilityOfExtRetr);
                }
                series.updateRetrieveAETs();
                series.updateAvailability();
                study.updateRetrieveAETs();
                study.updateAvailability();
            }
            return fpaths;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private void deletePatientWithoutObjects(PatientLocal patient) throws RemoveException {
        if (patient.getStudies().isEmpty() && patient.getMwlItems().isEmpty() && patient.getGsps().isEmpty() && patient.getMpps().isEmpty() && patient.getGppps().isEmpty() && patient.getUPS().isEmpty()) {
            patient.remove();
        }
    }

    public FileDTO[] findFilesToCompress(FileSystemDTO fsDTO, String cuid, Timestamp before, int limit) throws FinderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Querying for files to compress in " + fsDTO.getDirectoryPath()));
        }
        Collection c = this.fileHome.findFilesToCompress(fsDTO.getPk(), cuid, before, limit);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + c.size() + " files to compress in " + fsDTO.getDirectoryPath()));
        }
        return this.toFileDTOs(c);
    }

    public FileDTO[] findFilesForMD5Check(String dirPath, Timestamp before, int limit) throws FinderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Querying for files to check md5 in " + dirPath));
        }
        Collection c = this.fileHome.findToCheckMd5(dirPath, before, limit);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + c.size() + " files to check md5 in " + dirPath));
        }
        return this.toFileDTOs(c);
    }

    public FileDTO[] findFilesByStatusAndFileSystem(String dirPath, int status, Timestamp notBefore, Timestamp before, int limit) throws FinderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Querying for files with status " + status + " in " + dirPath));
        }
        Collection c = this.fileHome.findByStatusAndFileSystem(dirPath, status, notBefore, before, limit);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + c.size() + " files with status " + status + " in " + dirPath));
        }
        return this.toFileDTOs(c);
    }

    public void updateTimeOfLastMd5Check(long pk) throws FinderException {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)("update time of last md5 check to " + ts));
        }
        FileLocal fl = this.fileHome.findByPrimaryKey(new Long(pk));
        fl.setTimeOfLastMd5Check(ts);
    }

    public void replaceFile(long pk, String path, String tsuid, long size, byte[] md5, int status) throws FinderException {
        FileLocal oldFile = this.fileHome.findByPrimaryKey(Long.valueOf(pk));
        oldFile.setFilePath(path);
        oldFile.setFileTsuid(tsuid);
        oldFile.setFileSize(size);
        oldFile.setFileMd5(md5);
        oldFile.setFileStatus(status);
    }

    public void replaceFileAndCoerceAttributes(long fspk, long pk, String path, String tsuid, long size, byte[] md5, int status, Dataset ds) {
        try {
            FileLocal oldFile = this.fileHome.findByPrimaryKey(Long.valueOf(pk));
            oldFile.setFileSystem(this.fileSystemHome.findByPrimaryKey(Long.valueOf(fspk)));
            oldFile.setFilePath(path);
            oldFile.setFileTsuid(tsuid);
            oldFile.setFileSize(size);
            oldFile.setFileMd5(md5);
            oldFile.setFileStatus(status);
            oldFile.getInstance().coerceAttributes(ds, null);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void setFileStatus(long pk, int status) throws FinderException {
        FileLocal f = this.fileHome.findByPrimaryKey(Long.valueOf(pk));
        f.setFileStatus(status);
        if (status == 2) {
            InstanceLocal il = f.getInstance();
            if (il.getArchived()) {
                log.debug((Object)("Instance " + il.getSopIuid() + " is already marked as ARCHIVED!"));
            } else {
                il.setArchived(true);
                log.info((Object)("Instance " + il.getSopIuid() + " marked as ARCHIVED! File:" + f.asString()));
            }
        }
    }

    private FileDTO[] toFileDTOs(Collection c) {
        FileDTO[] dto = new FileDTO[c.size()];
        Iterator it = c.iterator();
        for (int i = 0; i < dto.length; ++i) {
            dto[i] = ((FileLocal)it.next()).getFileDTO();
        }
        return dto;
    }

    public FileDTO[] getOrphanedPrivateFilesOnFSGroup(String groupID, int limit) throws FinderException {
        return this.toFileDTOsPrivate(this.privFileHome.findOrphanedOnFSGroup(groupID, limit));
    }

    private FileDTO[] toFileDTOsPrivate(Collection c) {
        FileDTO[] dto = new FileDTO[c.size()];
        Iterator it = c.iterator();
        for (int i = 0; i < dto.length; ++i) {
            dto[i] = ((PrivateFileLocal)it.next()).getFileDTO();
        }
        return dto;
    }

    public void deletePrivateFile(long file_pk) throws RemoveException {
        this.privFileHome.remove((Object)file_pk);
    }

    public void touchStudyOnFileSystem(String siud, String dirPath) throws FinderException, CreateException {
        try {
            this.sofHome.findByStudyAndFileSystem(siud, dirPath).touch();
        }
        catch (ObjectNotFoundException e) {
            try {
                this.sofHome.create(this.studyHome.findByStudyIuid(siud), this.fileSystemHome.findByDirectoryPath(dirPath));
            }
            catch (Exception ignore) {
                log.info((Object)"Create StudyOnFS failed! Check if concurrent create.", (Throwable)ignore);
                this.sofHome.findByStudyAndFileSystem(siud, dirPath).touch();
            }
        }
    }

    public FileDTO[] deleteStoredSeries(SeriesStored seriesStored) {
        try {
            SeriesLocal series = this.seriesHome.findBySeriesIuid(seriesStored.getSeriesInstanceUID());
            StudyLocal study = series.getStudy();
            Collection instances = series.getInstances();
            ArrayList<FileDTO> fileDTOs = new ArrayList<FileDTO>(instances.size());
            DcmElement refSopSeq = seriesStored.getIAN().getItem(528661).get(528793);
            int numRefInst = refSopSeq.countItems();
            HashSet<String> iuids = new HashSet<String>(numRefInst * 4 / 3 + 1);
            for (int i = 0; i < numRefInst; ++i) {
                iuids.add(refSopSeq.getItem(i).getString(528725));
            }
            ArrayList<InstanceLocal> toRemove = new ArrayList<InstanceLocal>(numRefInst);
            for (InstanceLocal inst : instances) {
                if (!iuids.contains(inst.getSopIuid())) continue;
                Collection files = inst.getFiles();
                for (FileLocal file : files) {
                    fileDTOs.add(file.getFileDTO());
                }
                toRemove.add(inst);
            }
            if (toRemove.size() == instances.size()) {
                series.remove();
            } else {
                for (InstanceLocal inst : toRemove) {
                    inst.remove();
                }
                UpdateDerivedFieldsUtils.updateDerivedFieldsOf(series);
            }
            UpdateDerivedFieldsUtils.updateDerivedFieldsOf(study);
            return fileDTOs.toArray(new FileDTO[fileDTOs.size()]);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public FileDTO[] getFilesOfInstance(String iuid) throws FinderException {
        FileDTO[] dtos = this.toFileDTOs(this.instHome.findBySopIuid(iuid).getFiles());
        Arrays.sort(dtos, DESC_FILE_PK);
        return dtos;
    }

    public String getExternalRetrieveAET(String iuid) throws FinderException {
        return this.instHome.findBySopIuid(iuid).getExternalRetrieveAET();
    }

    public FileDTO[] findFilesToLossyCompress(String fsGroupID, String cuid, String bodyPart, String srcAET, Timestamp before, int limit) throws FinderException {
        return this.toFileDTOs(bodyPart == null ? this.fileHome.findFilesToLossyCompress(fsGroupID, cuid, srcAET, before, limit) : this.fileHome.findFilesToLossyCompress(fsGroupID, cuid, bodyPart, srcAET, before, limit));
    }

    public FileDTO[] findFilesToLossyCompressWithExternalRetrieveAET(String fsGroupID, String retrieveAET, String cuid, String bodyPart, String srcAET, Timestamp before, int limit) throws FinderException {
        return this.toFileDTOs(bodyPart == null ? this.fileHome.findFilesToLossyCompressWithExternalRetrieveAET(fsGroupID, retrieveAET, cuid, srcAET, before, limit) : this.fileHome.findFilesToLossyCompressWithExternalRetrieveAET(fsGroupID, retrieveAET, cuid, bodyPart, srcAET, before, limit));
    }

    public FileDTO[] findFilesToLossyCompressWithCopyOnOtherFileSystemGroup(String fsGroupID, String otherFSGroupID, String cuid, String bodyPart, String srcAET, Timestamp before, int limit) throws FinderException {
        return this.toFileDTOs(bodyPart == null ? this.fileHome.findFilesToLossyCompressWithCopyOnOtherFileSystemGroup(fsGroupID, otherFSGroupID, cuid, srcAET, before, limit) : this.fileHome.findFilesToLossyCompressWithCopyOnOtherFileSystemGroup(fsGroupID, otherFSGroupID, cuid, bodyPart, srcAET, before, limit));
    }

    public int syncArchivedFlag(String fsPath, int limit) throws FinderException {
        Collection c = this.fileHome.findToSyncArchived(fsPath, limit);
        log.info((Object)("Found files to sync archived flag on instance:" + c.size()));
        for (FileLocal f : c) {
            f.getInstance().setArchived(true);
        }
        return c.size();
    }

    public int deleteFilesOfInvalidTarFile(String fsId, String tarFilename) throws FinderException, RemoveException {
        if (fsId.startsWith("tar:") && tarFilename.length() > 10) {
            Collection c = this.fileHome.findFilesOfTarFile(fsId, tarFilename + "%");
            log.info((Object)("Found " + c.size() + " files of invalid tar file " + tarFilename));
            for (FileLocal f : c) {
                f.remove();
            }
            return c.size();
        }
        log.warn((Object)"Given arguments probably not a tar file! Delete request denied!");
        return -1;
    }

    public boolean deleteFileOnTarFs(String fsId, long filePk) {
        if (fsId.startsWith("tar:")) {
            try {
                this.fileHome.findByPrimaryKey(Long.valueOf(filePk)).remove();
                return true;
            }
            catch (Exception x) {
                log.error((Object)("Failed to remove file entity (pk=" + filePk + ")"), (Throwable)x);
            }
        } else {
            log.warn((Object)"Given Filesystem ID is not a tar file system! Delete request denied!");
        }
        return false;
    }

    private void logOrderInfoMsg(DeleteStudyOrder order, String msg) {
        log.info((Object)("Study " + order.getStudyIUID() + " [pk=" + order.getStudyPk() + "] on FileSystem[pk=" + order.getFsPk() + "] " + msg));
    }
}

