/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocalHome;

public abstract class ConsistencyCheckBean
implements SessionBean {
    private StudyLocalHome studyHome;
    private static final Logger log = Logger.getLogger(ConsistencyCheckBean.class);

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.studyHome = (StudyLocalHome)jndiCtx.lookup("java:comp/env/ejb/Study");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.studyHome = null;
    }

    public long[] findStudiesToCheck(Timestamp createdAfter, Timestamp createdBefore, Timestamp checkedBefore, int limit) throws FinderException {
        Collection c;
        if (log.isDebugEnabled()) {
            log.debug((Object)("findStudiesToCheck: created between " + createdAfter + " - " + createdBefore + " checkedBefore" + checkedBefore + " limit:" + limit));
        }
        if ((c = this.studyHome.findStudyToCheck(createdAfter, createdBefore, checkedBefore, limit)).size() < 1) {
            return new long[0];
        }
        Iterator iter = c.iterator();
        long[] ia = new long[c.size()];
        int i = 0;
        while (iter.hasNext()) {
            ia[i++] = ((StudyLocal)iter.next()).getPk();
        }
        return ia;
    }

    public boolean updateStudy(long study_pk, int availabilityOfExternalRetrieveable) {
        boolean updated = false;
        try {
            StudyLocal study = this.studyHome.findByPrimaryKey(new Long(study_pk));
            Collection col = study.getSeries();
            for (SeriesLocal series : col) {
                Collection instances = series.getInstances();
                for (InstanceLocal instance : instances) {
                    if (instance.updateRetrieveAETs()) {
                        log.info((Object)("Retrieve AETs in Instance " + instance.getSopIuid() + " updated!"));
                        updated = true;
                    }
                    if (!instance.updateAvailability(availabilityOfExternalRetrieveable)) continue;
                    log.info((Object)("Availability in Instance " + instance.getSopIuid() + " updated!"));
                    updated = true;
                }
                if (series.updateNumberOfSeriesRelatedInstances()) {
                    log.info((Object)("Number of Series Related Instances in Series " + series.getSeriesIuid() + " updated!"));
                    updated = true;
                }
                if (series.updateRetrieveAETs()) {
                    log.info((Object)("Retrieve AETs in Series " + series.getSeriesIuid() + " updated!"));
                    updated = true;
                }
                if (series.updateExternalRetrieveAET()) {
                    log.info((Object)("External Retrieve AET in Series " + series.getSeriesIuid() + " updated!"));
                    updated = true;
                }
                if (series.updateFilesetId()) {
                    log.info((Object)("Fileset ID in Series " + series.getSeriesIuid() + " updated!"));
                    updated = true;
                }
                if (!series.updateAvailability()) continue;
                log.info((Object)("Availability in Series " + series.getSeriesIuid() + " updated!"));
                updated = true;
            }
            if (study.updateNumberOfStudyRelatedSeries()) {
                log.info((Object)("Number of Study Related Series in Study " + study.getStudyIuid() + " updated!"));
                updated = true;
            }
            if (study.updateNumberOfStudyRelatedInstances()) {
                log.info((Object)("Number of Study Related Instances in Study " + study.getStudyIuid() + " updated!"));
                updated = true;
            }
            if (study.updateRetrieveAETs()) {
                log.info((Object)("Retrieve AETs in Study " + study.getStudyIuid() + " updated!"));
                updated = true;
            }
            if (study.updateExternalRetrieveAET()) {
                log.info((Object)("External Retrieve AET in Study " + study.getStudyIuid() + " updated!"));
                updated = true;
            }
            if (study.updateFilesetId()) {
                log.info((Object)("Fileset ID Study " + study.getStudyIuid() + " updated!"));
                updated = true;
            }
            if (study.updateAvailability()) {
                log.info((Object)("Availability in Study " + study.getStudyIuid() + " updated!"));
                updated = true;
            }
            if (study.updateModalitiesInStudy()) {
                log.info((Object)("Modalities In Study in Study " + study.getStudyIuid() + " updated!"));
                updated = true;
            }
            if (study.updateSOPClassesInStudy()) {
                log.info((Object)("SOP Classes in Study " + study.getStudyIuid() + " updated!"));
                updated = true;
            }
            study.setTimeOfLastConsistencyCheck(new Timestamp(System.currentTimeMillis()));
            return updated;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }
}

