/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocalHome;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;

public abstract class AvailabilityUpdateBean
implements SessionBean {
    private InstanceLocalHome instHome;

    public void setSessionContext(SessionContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.instHome = (InstanceLocalHome)jndiCtx.lookup("java:comp/env/ejb/Instance");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetSessionContext() {
        this.instHome = null;
    }

    public int updateAvailability(Dataset ian) {
        int count = 0;
        StudyLocal[] study = new StudyLocal[1];
        DcmElement refSeriesSq = ian.get(528661);
        int nS = refSeriesSq.countItems();
        for (int i = 0; i < nS; ++i) {
            count += this.updateAvailabilityOfSeries(refSeriesSq.getItem(i), study);
        }
        if (study[0] != null) {
            study[0].updateAvailability();
        }
        return count;
    }

    private int updateAvailabilityOfSeries(Dataset refSeries, StudyLocal[] study) {
        int count = 0;
        SeriesLocal[] series = new SeriesLocal[1];
        DcmElement refSOPSq = refSeries.get(528793);
        int nI = refSOPSq.countItems();
        for (int i = 0; i < nI; ++i) {
            count += this.updateAvailabilityOfInstance(refSOPSq.getItem(i), series);
        }
        if (series[0] != null && series[0].updateAvailability() && study[0] == null) {
            study[0] = series[0].getStudy();
        }
        return count;
    }

    private int updateAvailabilityOfInstance(Dataset refSop, SeriesLocal[] series) {
        InstanceLocal inst;
        try {
            inst = this.instHome.findBySopIuid(refSop.getString(528725));
        }
        catch (ObjectNotFoundException e) {
            return 0;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (!refSop.getString(524372).equals(inst.getExternalRetrieveAET())) {
            return 0;
        }
        if (!inst.updateAvailability(Availability.toInt((String)refSop.getString(524374)))) {
            return 0;
        }
        if (series[0] == null) {
            series[0] = inst.getSeries();
        }
        return 1;
    }
}

