/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.AELocal;
import org.dcm4chex.archive.ejb.interfaces.AELocalHome;
import org.dcm4chex.archive.exceptions.UnknownAETException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AEManagerBean
implements SessionBean {
    private AELocalHome aeHome;
    private SessionContext ctx;
    private static final int MAX_MAX_CACHE_SIZE = 1000;
    private static int maxCacheSize = 20;
    private static Map aeCache = Collections.synchronizedMap(new LinkedHashMap(32, 0.75f, true){
        private static final long serialVersionUID = -5477659896294241869L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > maxCacheSize;
        }
    });

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.aeHome = (AELocalHome)jndiCtx.lookup("java:comp/env/ejb/AE");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
        this.ctx = ctx;
    }

    public void unsetSessionContext() {
        this.aeHome = null;
        this.ctx = null;
    }

    public int getCacheSize() {
        return aeCache.size();
    }

    public int getMaxCacheSize() {
        return maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        if (maxCacheSize < 0 || maxCacheSize > 1000) {
            throw new IllegalArgumentException("maxCacheSize: " + maxCacheSize);
        }
        AEManagerBean.maxCacheSize = maxCacheSize;
    }

    public void clearCache() {
        aeCache.clear();
    }

    public AEDTO findByPrimaryKey(long aePk) throws FinderException {
        return this.aeHome.findByPrimaryKey(new Long(aePk)).toDTO();
    }

    public AEDTO findByAET(String aet) throws FinderException, UnknownAETException {
        AEDTO ae = (AEDTO)aeCache.get(aet = aet.trim());
        if (ae == null) {
            try {
                ae = this.aeHome.findByAET(aet).toDTO();
                aeCache.put(aet, ae);
            }
            catch (ObjectNotFoundException e) {
                throw new UnknownAETException(aet);
            }
        }
        return ae;
    }

    public Collection<AEDTO> findByHostName(String hostName) throws FinderException {
        return this.toDTOs(this.aeHome.findByHostName(hostName));
    }

    private Collection<AEDTO> toDTOs(Collection<AELocal> aes) {
        ArrayList<AEDTO> dtos = new ArrayList<AEDTO>(aes.size());
        for (AELocal ae : aes) {
            dtos.add(ae.toDTO());
        }
        return dtos;
    }

    public Collection<AEDTO> findAll() throws FinderException {
        return this.toDTOs(this.aeHome.findAll());
    }

    public void updateAE(AEDTO modAE) throws FinderException {
        try {
            AELocal ae = this.aeHome.findByPrimaryKey(new Long(modAE.getPk()));
            aeCache.remove(ae.getTitle());
            ae.update(modAE);
        }
        catch (FinderException e) {
            this.ctx.setRollbackOnly();
            throw e;
        }
    }

    public void newAE(AEDTO newAE) throws CreateException {
        this.aeHome.create(newAE);
    }

    public void removeAE(long aePk) throws Exception {
        try {
            this.aeHome.remove((Object)new Long(aePk));
            aeCache.clear();
        }
        catch (RemoveException e) {
            throw new Exception(e);
        }
    }
}

