/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.Priority;
import org.dcm4chex.archive.common.UPSState;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.UPSLocal;
import org.dcm4chex.archive.ejb.interfaces.UPSRelatedPSLocal;
import org.dcm4chex.archive.ejb.interfaces.UPSRelatedPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.UPSReplacedPSLocal;
import org.dcm4chex.archive.ejb.interfaces.UPSReplacedPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.UPSRequestLocal;
import org.dcm4chex.archive.ejb.interfaces.UPSRequestLocalHome;
import org.dcm4chex.archive.ejb.interfaces.UPSSubscriptionLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UPSBean
implements EntityBean {
    private static final Logger LOG = Logger.getLogger(UPSBean.class);
    private EntityContext ejbctx;
    private CodeLocalHome codeHome;
    private UPSRequestLocalHome rqHome;
    private UPSRelatedPSLocalHome relPSHome;
    private UPSReplacedPSLocalHome replPSHome;

    public void setEntityContext(EntityContext ctx) {
        this.ejbctx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
            this.rqHome = (UPSRequestLocalHome)jndiCtx.lookup("java:comp/env/ejb/UPSRequest");
            this.relPSHome = (UPSRelatedPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/UPSRelatedPS");
            this.replPSHome = (UPSReplacedPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/UPSReplacedPS");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.codeHome = null;
        this.rqHome = null;
        this.relPSHome = null;
        this.replPSHome = null;
        this.ejbctx = null;
    }

    public Long ejbCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setPatient(patient);
        try {
            this.setScheduledWorkItemCode(CodeBean.valueOf(this.codeHome, ds.getItem(4210712)));
            CodeBean.addCodesTo(this.codeHome, ds.get(0x404004), this.getScheduledProcessingApplicationsCodes());
            CodeBean.addCodesTo(this.codeHome, ds.get(4210725), this.getScheduledStationNameCodes());
            CodeBean.addCodesTo(this.codeHome, ds.get(4210726), this.getScheduledStationClassCodes());
            CodeBean.addCodesTo(this.codeHome, ds.get(4210727), this.getScheduledStationGeographicLocationCodes());
            this.updateScheduledHumanPerformers(null, ds.get(0x404034));
            this.updateRefRequests(null, ds.get(4236144));
            this.updateRelatedPS(null, ds.get(7606816));
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        LOG.info(this.prompt("Created UPS[pk="));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)ds);
        }
    }

    public void ejbRemove() throws RemoveException {
        LOG.info(this.prompt("Deleting UPS[pk="));
    }

    private Object prompt(String prefix) {
        return prefix + this.getPk() + ", uid=" + this.getSopInstanceUID() + "]";
    }

    private void updateScheduledHumanPerformers(DcmElement oldPerformers, DcmElement newPerformers) throws CreateException, FinderException {
        if (!UPSBean.equals(oldPerformers, newPerformers)) {
            Collection<CodeLocal> c = this.getScheduledHumanPerformerCodes();
            c.clear();
            if (newPerformers != null) {
                int n = newPerformers.countItems();
                for (int i = 0; i < n; ++i) {
                    Dataset code;
                    DcmElement codeSq = newPerformers.getItem(i).get(0x404009);
                    if (codeSq == null || (code = codeSq.getItem()) == null) continue;
                    c.add(CodeBean.valueOf(this.codeHome, code));
                }
            }
        }
    }

    private void updateRefRequests(DcmElement oldRequests, DcmElement newRequests) throws CreateException, RemoveException {
        if (!UPSBean.equals(oldRequests, newRequests)) {
            Collection<UPSRequestLocal> c = this.getRefRequests();
            for (UPSRequestLocal refRequest : c.toArray(new UPSRequestLocal[c.size()])) {
                refRequest.remove();
            }
            if (newRequests != null) {
                UPSLocal ups = (UPSLocal)this.ejbctx.getEJBLocalObject();
                int n = newRequests.countItems();
                for (int i = 0; i < n; ++i) {
                    c.add(this.rqHome.create(newRequests.getItem(i), ups));
                }
            }
        }
    }

    private void updateRelatedPS(DcmElement oldRelPS, DcmElement newRelPS) throws CreateException, RemoveException {
        if (!UPSBean.equals(oldRelPS, newRelPS)) {
            Collection<UPSRelatedPSLocal> c = this.getRelatedProcedureSteps();
            for (UPSRelatedPSLocal relatedPS : c.toArray(new UPSRelatedPSLocal[c.size()])) {
                relatedPS.remove();
            }
            if (newRelPS != null) {
                UPSLocal ups = (UPSLocal)this.ejbctx.getEJBLocalObject();
                int n = newRelPS.countItems();
                for (int i = 0; i < n; ++i) {
                    c.add(this.relPSHome.create(newRelPS.getItem(i), ups));
                }
            }
        }
    }

    private void updateReplacedPS(DcmElement oldReplPS, DcmElement newReplPS) throws CreateException, RemoveException {
        if (!UPSBean.equals(oldReplPS, newReplPS)) {
            Collection<UPSReplacedPSLocal> c = this.getReplacedProcedureSteps();
            for (UPSReplacedPSLocal replacedPS : c.toArray(new UPSReplacedPSLocal[c.size()])) {
                replacedPS.remove();
            }
            UPSLocal ups = (UPSLocal)this.ejbctx.getEJBLocalObject();
            int n = newReplPS.countItems();
            for (int i = 0; i < n; ++i) {
                c.add(this.replPSHome.create(newReplPS.getItem(i), ups));
            }
        }
    }

    public abstract Long getPk();

    public abstract void getPk(Long var1);

    public abstract String getSopInstanceUID();

    public abstract void setSopInstanceUID(String var1);

    public abstract String getTransactionUID();

    public abstract void setTransactionUID(String var1);

    public abstract String getAdmissionID();

    public abstract void setAdmissionID(String var1);

    public abstract String getIssuerOfAdmissionIDLocalNamespaceEntityID();

    public abstract void setIssuerOfAdmissionIDLocalNamespaceEntityID(String var1);

    public abstract String getIssuerOfAdmissionIDUniversialEntityID();

    public abstract void setIssuerOfAdmissionIDUniversialEntityID(String var1);

    public abstract String getProcedureStepLabel();

    public abstract void setProcedureStepLabel(String var1);

    public abstract String getWorklistLabel();

    public abstract void setWorklistLabel(String var1);

    public abstract Timestamp getScheduledStartDateTime();

    public abstract void setScheduledStartDateTime(Timestamp var1);

    public abstract Timestamp getExpectedCompletionDateTime();

    public abstract void setExpectedCompletionDateTime(Timestamp var1);

    public abstract int getStateAsInt();

    public abstract void setStateAsInt(int var1);

    public abstract int getPriorityAsInt();

    public abstract void setPriorityAsInt(int var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getUpdatedTime();

    public abstract void setUpdatedTime(Timestamp var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract void setPatient(PatientLocal var1);

    public abstract PatientLocal getPatient();

    public abstract CodeLocal getScheduledWorkItemCode();

    public abstract void setScheduledWorkItemCode(CodeLocal var1);

    public abstract Collection<CodeLocal> getScheduledProcessingApplicationsCodes();

    public abstract void setScheduledProcessingApplicationsCodes(Collection<CodeLocal> var1);

    public abstract Collection<CodeLocal> getScheduledStationNameCodes();

    public abstract void setScheduledStationNameCodes(Collection<CodeLocal> var1);

    public abstract Collection<CodeLocal> getScheduledStationClassCodes();

    public abstract void setScheduledStationClassCodes(Collection<CodeLocal> var1);

    public abstract Collection<CodeLocal> getScheduledStationGeographicLocationCodes();

    public abstract void setScheduledStationGeographicLocationCodes(Collection<CodeLocal> var1);

    public abstract Collection<CodeLocal> getScheduledHumanPerformerCodes();

    public abstract void setScheduledHumanPerformerCodes(Collection<CodeLocal> var1);

    public abstract Collection<UPSRequestLocal> getRefRequests();

    public abstract void setRefRequests(Collection<UPSRequestLocal> var1);

    public abstract Collection<UPSRelatedPSLocal> getRelatedProcedureSteps();

    public abstract void setRelatedProcedureSteps(Collection<UPSRelatedPSLocal> var1);

    public abstract Collection<UPSReplacedPSLocal> getReplacedProcedureSteps();

    public abstract void setReplacedProcedureSteps(Collection<UPSReplacedPSLocal> var1);

    public abstract Collection<UPSSubscriptionLocal> getSubscriptions();

    public abstract void setSubscriptions(Collection<UPSSubscriptionLocal> var1);

    public Dataset getAttributes() {
        return DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
    }

    private static Timestamp toTimestamp(Date date) {
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    public boolean updateState(int newState) {
        if (this.getStateAsInt() == newState) {
            return false;
        }
        this.setStateAsInt(newState);
        Dataset ds = this.getAttributes();
        ds.putCS(7606272, UPSState.toString((int)newState));
        this.setEncodedAttributes(DatasetUtils.toByteArray((Dataset)ds, (String)"1.2.840.10008.1.2.1.99"));
        return true;
    }

    public void setAttributes(Dataset ds) {
        this.setSopInstanceUID(ds.getString(524312));
        this.setAdmissionID(ds.getString(3670032));
        Dataset issuer = ds.getItem(3670036);
        if (issuer != null) {
            this.setIssuerOfAdmissionIDLocalNamespaceEntityID(issuer.getString(4194353));
            this.setIssuerOfAdmissionIDUniversialEntityID(issuer.getString(4194354));
        }
        this.setProcedureStepLabel(ds.getString(7606788));
        this.setWorklistLabel(ds.getString(7606786));
        this.setStateAsInt(UPSState.toInt((String)ds.getString(7606272)));
        this.setPriorityAsInt(Priority.toInt((String)ds.getString(7606784)));
        this.setScheduledStartDateTime(UPSBean.toTimestamp(ds.getDate(0x404005)));
        this.setExpectedCompletionDateTime(UPSBean.toTimestamp(ds.getDate(0x404011)));
        AttributeFilter filter = AttributeFilter.getExcludePatientAttributeFilter();
        this.setEncodedAttributes(DatasetUtils.toByteArray((Dataset)filter.filter(ds), (String)filter.getTransferSyntaxUID()));
    }

    public void updateAttributes(Dataset newAttrs) {
        Dataset ds = this.getAttributes();
        try {
            this.updateWorkitemCode(ds.getItem(4210712), newAttrs.getItem(4210712));
            this.updateScheduledProcessingApplicationsCodes(ds.get(0x404004), newAttrs.get(0x404004));
            this.updateScheduledStationNameCodes(ds.get(4210725), newAttrs.get(4210725));
            this.updateScheduledStationClassCodes(ds.get(4210726), newAttrs.get(4210726));
            this.updateScheduledStationGeographicLocationCodes(ds.get(4210727), newAttrs.get(4210727));
            this.updateScheduledHumanPerformers(ds.get(0x404034), newAttrs.get(0x404034));
            this.updateRefRequests(ds.get(4236144), newAttrs.get(4236144));
            this.updateRelatedPS(ds.get(7606816), newAttrs.get(7606816));
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        ds.putAll((DcmObject)newAttrs, 0);
        this.setAttributes(ds);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private void updateWorkitemCode(Dataset oldCode, Dataset newCode) throws CreateException, FinderException {
        if (!UPSBean.equals(oldCode, newCode)) {
            this.setScheduledWorkItemCode(CodeBean.valueOf(this.codeHome, newCode));
        }
    }

    private void updateScheduledProcessingApplicationsCodes(DcmElement oldCodes, DcmElement newCodes) throws CreateException, FinderException {
        if (!UPSBean.equals(newCodes, oldCodes)) {
            Collection<CodeLocal> codes = this.getScheduledProcessingApplicationsCodes();
            codes.clear();
            CodeBean.addCodesTo(this.codeHome, newCodes, codes);
        }
    }

    private void updateScheduledStationNameCodes(DcmElement oldCodes, DcmElement newCodes) throws CreateException, FinderException {
        if (!UPSBean.equals(oldCodes, newCodes)) {
            Collection<CodeLocal> codes = this.getScheduledStationNameCodes();
            codes.clear();
            CodeBean.addCodesTo(this.codeHome, newCodes, codes);
        }
    }

    private void updateScheduledStationClassCodes(DcmElement oldCodes, DcmElement newCodes) throws CreateException, FinderException {
        if (!UPSBean.equals(oldCodes, newCodes)) {
            Collection<CodeLocal> codes = this.getScheduledStationClassCodes();
            codes.clear();
            CodeBean.addCodesTo(this.codeHome, newCodes, codes);
        }
    }

    private void updateScheduledStationGeographicLocationCodes(DcmElement oldCodes, DcmElement newCodes) throws CreateException, FinderException {
        if (!UPSBean.equals(oldCodes, newCodes)) {
            Collection<CodeLocal> codes = this.getScheduledStationGeographicLocationCodes();
            codes.clear();
            CodeBean.addCodesTo(this.codeHome, newCodes, codes);
        }
    }

    public abstract Collection<String> ejbSelectNotSubscribed(String var1) throws FinderException;

    public Collection<String> ejbHomeGetNotSubscribed(String aet) throws FinderException {
        return this.ejbSelectNotSubscribed(aet);
    }
}

