/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.sql.Timestamp;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.ejb.interfaces.FileSystemLocal;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;

public abstract class StudyOnFileSystemBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(StudyOnFileSystemBean.class);

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getAccessTime();

    public abstract void setAccessTime(Timestamp var1);

    public abstract StudyLocal getStudy();

    public abstract void setStudy(StudyLocal var1);

    public abstract FileSystemLocal getFileSystem();

    public abstract void setFileSystem(FileSystemLocal var1);

    public abstract boolean getMarkedForDeletion();

    public abstract void setMarkedForDeletion(boolean var1);

    public Long ejbCreate(StudyLocal study, FileSystemLocal fs) throws CreateException {
        this.setAccessTime(new Timestamp(System.currentTimeMillis()));
        return null;
    }

    public void ejbPostCreate(StudyLocal study, FileSystemLocal fs) throws CreateException {
        this.setStudy(study);
        this.setFileSystem(fs);
        this.setMarkedForDeletion(false);
    }

    public void touch() {
        this.setAccessTime(new Timestamp(System.currentTimeMillis()));
        if (this.getMarkedForDeletion()) {
            this.setMarkedForDeletion(false);
            log.info((Object)("Study is marked for deletion on filesystem " + this.getFileSystem().getDirectoryPath() + " ! Deletion mark for study " + this.getStudy().getStudyIuid() + " removed because study is touched now!"));
        }
    }

    public String asString() {
        StudyLocal study = this.getStudy();
        FileSystemLocal fs = this.getFileSystem();
        return "StudyOnFileSystem[" + (study == null ? "null" : study.asString()) + "@" + (fs == null ? "null" : fs.asString()) + "]";
    }

    public boolean matchDeleteConstrains(boolean externalRetrieveable, boolean storageNotCommited, boolean copyOnMedia, String copyOnFSGroup, boolean copyArchived, boolean copyOnReadOnlyFS) throws FinderException {
        int count;
        StudyLocal study = this.getStudy();
        if (study.getNumberOfReceivingSeries() != 0 || externalRetrieveable && study.getExternalRetrieveAET() == null || storageNotCommited && study.getNumberOfCommitedInstances() != 0 || copyOnMedia && !study.isStudyAvailableOnMedia()) {
            return false;
        }
        if (copyOnFSGroup != null) {
            count = copyArchived ? (copyOnReadOnlyFS ? this.ejbSelectNumberOfStudyRelatedInstancesOnFSWithGroupIdAndStatusAndFileStatus(study, copyOnFSGroup, 2, 2) : this.ejbSelectNumberOfStudyRelatedInstancesOnFSWithGroupIdAndFileStatus(study, copyOnFSGroup, 2)) : (copyOnReadOnlyFS ? this.ejbSelectNumberOfStudyRelatedInstancesOnFSWithGroupIdAndStatus(study, copyOnFSGroup, 2) : this.ejbSelectNumberOfStudyRelatedInstancesOnFSWithGroupId(study, copyOnFSGroup));
        } else if (copyArchived) {
            count = copyOnReadOnlyFS ? this.ejbSelectNumberOfStudyRelatedInstancesOnFSWithDifferentGroupIdAndStatusAndFileStatus(study, this.getFileSystem().getGroupID(), 2, 2) : this.ejbSelectNumberOfStudyRelatedInstancesOnFSWithDifferentGroupIdAndFileStatus(study, this.getFileSystem().getGroupID(), 2);
        } else if (copyOnReadOnlyFS) {
            count = this.ejbSelectNumberOfStudyRelatedInstancesOnFSWithDifferentGroupIdAndStatus(study, this.getFileSystem().getGroupID(), 2);
        } else {
            return true;
        }
        return count == study.getNumberOfStudyRelatedInstances();
    }

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnFSWithGroupIdAndStatusAndFileStatus(StudyLocal var1, String var2, int var3, int var4) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnFSWithGroupIdAndFileStatus(StudyLocal var1, String var2, int var3) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnFSWithGroupIdAndStatus(StudyLocal var1, String var2, int var3) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnFSWithGroupId(StudyLocal var1, String var2) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnFSWithDifferentGroupIdAndStatusAndFileStatus(StudyLocal var1, String var2, int var3, int var4) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnFSWithDifferentGroupIdAndFileStatus(StudyLocal var1, String var2, int var3) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnFSWithDifferentGroupIdAndStatus(StudyLocal var1, String var2, int var3) throws FinderException;
}

