/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.PersonName;
import org.dcm4che.net.DcmServiceException;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.AttrUtils;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.entity.IssuerBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.IssuerLocal;
import org.dcm4chex.archive.ejb.interfaces.IssuerLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MediaLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.util.AETs;
import org.dcm4chex.archive.util.Convert;

public abstract class StudyBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(StudyBean.class);
    private static final Class[] STRING_PARAM = new Class[]{String.class};
    private CodeLocalHome codeHome;
    private IssuerLocalHome issuerHome;

    public void setEntityContext(EntityContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
            this.issuerHome = (IssuerLocalHome)jndiCtx.lookup("java:comp/env/ejb/Issuer");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.codeHome = null;
        this.issuerHome = null;
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getUpdatedTime();

    public abstract void setUpdatedTime(Timestamp var1);

    public abstract String getStudyIuid();

    public abstract void setStudyIuid(String var1);

    public abstract String getStudyId();

    public abstract void setStudyId(String var1);

    public abstract Timestamp getStudyDateTime();

    public abstract void setStudyDateTime(Timestamp var1);

    private void setStudyDateTime(Date date) {
        this.setStudyDateTime(date != null ? new Timestamp(date.getTime()) : null);
    }

    public abstract String getAccessionNumber();

    public abstract void setAccessionNumber(String var1);

    public abstract String getReferringPhysicianName();

    public abstract void setReferringPhysicianName(String var1);

    public abstract String getReferringPhysicianFamilyNameSoundex();

    public abstract void setReferringPhysicianFamilyNameSoundex(String var1);

    public abstract String getReferringPhysicianGivenNameSoundex();

    public abstract void setReferringPhysicianGivenNameSoundex(String var1);

    public abstract String getReferringPhysicianIdeographicName();

    public abstract void setReferringPhysicianIdeographicName(String var1);

    public abstract String getReferringPhysicianPhoneticName();

    public abstract void setReferringPhysicianPhoneticName(String var1);

    public abstract String getStudyDescription();

    public abstract void setStudyDescription(String var1);

    public abstract String getStudyCustomAttribute1();

    public abstract void setStudyCustomAttribute1(String var1);

    public abstract String getStudyCustomAttribute2();

    public abstract void setStudyCustomAttribute2(String var1);

    public abstract String getStudyCustomAttribute3();

    public abstract void setStudyCustomAttribute3(String var1);

    public abstract int getStudyStatus();

    public abstract void setStudyStatus(int var1);

    public abstract String getStudyStatusId();

    public abstract void setStudyStatusId(String var1);

    public abstract int getNumberOfStudyRelatedSeries();

    public abstract void setNumberOfStudyRelatedSeries(int var1);

    public abstract int getNumberOfStudyRelatedInstances();

    public abstract void setNumberOfStudyRelatedInstances(int var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract String getFilesetIuid();

    public abstract void setFilesetIuid(String var1);

    public abstract String getFilesetId();

    public abstract void setFilesetId(String var1);

    public abstract String getExternalRetrieveAET();

    public abstract void setExternalRetrieveAET(String var1);

    public abstract String getRetrieveAETs();

    public abstract void setRetrieveAETs(String var1);

    public abstract int getAvailability();

    public int getAvailabilitySafe() {
        try {
            return this.getAvailability();
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public abstract void setAvailability(int var1);

    public abstract String getModalitiesInStudy();

    public abstract void setModalitiesInStudy(String var1);

    public abstract String getSopClassesInStudy();

    public abstract void setSopClassesInStudy(String var1);

    public abstract Timestamp getTimeOfLastConsistencyCheck();

    public abstract void setTimeOfLastConsistencyCheck(Timestamp var1);

    public abstract void setPatient(PatientLocal var1);

    public abstract PatientLocal getPatient();

    public abstract void setSeries(Collection var1);

    public abstract Collection getSeries();

    public abstract Collection getProcedureCodes();

    public abstract void setProcedureCodes(Collection var1);

    public abstract IssuerLocal getIssuerOfAccessionNumber();

    public abstract void setIssuerOfAccessionNumber(IssuerLocal var1);

    public Long ejbCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds, PatientLocal patient) throws CreateException {
        try {
            this.setPatient(patient);
            DcmElement proceCodeSq = ds.get(528434);
            if (proceCodeSq != null && CodeBean.checkCodes("Procedure Code Sequence (0008,1032)", proceCodeSq)) {
                CodeBean.addCodesTo(this.codeHome, proceCodeSq, this.getProcedureCodes());
            }
            this.updateIssuerOfAccessionNumber(null, ds.getItem(524369));
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        log.info((Object)("Created " + this.prompt()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public abstract Set ejbSelectSeriesRetrieveAETs(Long var1) throws FinderException;

    public abstract Set ejbSelectExternalRetrieveAETs(Long var1) throws FinderException;

    public abstract Set ejbSelectMediaWithStatus(Long var1, int var2) throws FinderException;

    public abstract Set ejbSelectModalityInStudies(Long var1) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnMediaWithStatus(Long var1, int var2) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstances(Long var1) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedSeries(Long var1) throws FinderException;

    public abstract int ejbSelectNumberOfCommitedInstances(Long var1) throws FinderException;

    public abstract int ejbSelectNumberOfReceivingSeries(Long var1) throws FinderException;

    public int getNumberOfCommitedInstances() throws FinderException {
        return this.ejbSelectNumberOfCommitedInstances(this.getPk());
    }

    public int getNumberOfReceivingSeries() throws FinderException {
        return this.ejbSelectNumberOfReceivingSeries(this.getPk());
    }

    public abstract int ejbSelectAvailability(Long var1) throws FinderException;

    public abstract Long ejbSelectStudyFileSize(Long var1, Long var2) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesOnROFS(Long var1, int var2) throws FinderException;

    public abstract int ejbSelectNumberOfStudyRelatedInstancesForAvailability(Long var1, int var2) throws FinderException;

    public long ejbHomeSelectStudySize(Long studyPk, Long fsPk) throws FinderException {
        Long l = this.ejbSelectStudyFileSize(studyPk, fsPk);
        return l == null ? 0L : l;
    }

    public boolean updateRetrieveAETs() {
        String aets = null;
        if (this.getNumberOfStudyRelatedInstances() > 0) {
            Set seriesAets;
            try {
                seriesAets = this.ejbSelectSeriesRetrieveAETs(this.getPk());
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
            Iterator it = seriesAets.iterator();
            aets = (String)it.next();
            while (aets != null && it.hasNext()) {
                aets = AETs.common((String)aets, (String)((String)it.next()));
            }
        }
        if (aets == null ? this.getRetrieveAETs() == null : aets.equals(this.getRetrieveAETs())) {
            return false;
        }
        this.setRetrieveAETs(aets);
        return true;
    }

    public boolean updateExternalRetrieveAET() {
        String aet = null;
        if (this.getNumberOfStudyRelatedInstances() > 0) {
            Set eAetSet;
            try {
                eAetSet = this.ejbSelectExternalRetrieveAETs(this.getPk());
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
            if (eAetSet.size() == 1) {
                aet = (String)eAetSet.iterator().next();
            }
        }
        if (aet == null ? this.getExternalRetrieveAET() == null : aet.equals(this.getExternalRetrieveAET())) {
            return false;
        }
        this.setExternalRetrieveAET(aet);
        return true;
    }

    public boolean updateAvailability() {
        int availability;
        try {
            availability = this.getNumberOfStudyRelatedInstances() > 0 ? this.ejbSelectAvailability(this.getPk()) : 3;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        int prevAvailability = this.getAvailabilitySafe();
        if (availability == prevAvailability) {
            return false;
        }
        this.setAvailability(availability);
        if (log.isDebugEnabled()) {
            log.debug((Object)("update Availability of Study[pk=" + this.getPk() + ", uid=" + this.getStudyIuid() + "] from " + Availability.toString((int)prevAvailability) + " to " + Availability.toString((int)availability)));
        }
        return true;
    }

    public boolean updateNumberOfStudyRelatedSeries() {
        int numS;
        try {
            numS = this.ejbSelectNumberOfStudyRelatedSeries(this.getPk());
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (this.getNumberOfStudyRelatedSeries() == numS) {
            return false;
        }
        this.setNumberOfStudyRelatedSeries(numS);
        return true;
    }

    public boolean updateNumberOfStudyRelatedInstances() {
        int numI;
        try {
            numI = this.ejbSelectNumberOfStudyRelatedInstances(this.getPk());
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (this.getNumberOfStudyRelatedInstances() == numI) {
            return false;
        }
        this.setNumberOfStudyRelatedInstances(numI);
        return true;
    }

    public boolean updateFilesetId() {
        boolean updated = false;
        String fileSetId = null;
        String fileSetIuid = null;
        int numI = this.getNumberOfStudyRelatedInstances();
        if (numI > 0) {
            Long pk = this.getPk();
            try {
                Set c;
                if (this.ejbSelectNumberOfStudyRelatedInstancesOnMediaWithStatus(pk, 4) == numI && (c = this.ejbSelectMediaWithStatus(pk, 4)).size() == 1) {
                    MediaLocal media = (MediaLocal)c.iterator().next();
                    fileSetId = media.getFilesetId();
                    fileSetIuid = media.getFilesetIuid();
                }
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
        if (fileSetId == null ? this.getFilesetId() != null : !fileSetId.equals(this.getFilesetId())) {
            this.setFilesetId(fileSetId);
            updated = true;
        }
        if (fileSetIuid == null ? this.getFilesetIuid() != null : !fileSetIuid.equals(this.getFilesetIuid())) {
            this.setFilesetIuid(fileSetIuid);
            updated = true;
        }
        return updated;
    }

    public boolean updateModalitiesInStudy() {
        String mds = "";
        if (this.getNumberOfStudyRelatedInstances() > 0) {
            Set c;
            try {
                c = this.ejbSelectModalityInStudies(this.getPk());
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
            if (c.remove(null)) {
                log.warn((Object)("Study[iuid=" + this.getStudyIuid() + "] contains Series with unspecified Modality"));
            }
            if (!c.isEmpty()) {
                Iterator it = c.iterator();
                StringBuffer sb = new StringBuffer((String)it.next());
                while (it.hasNext()) {
                    sb.append('\\').append(it.next());
                }
                mds = sb.toString();
            }
        }
        if (mds.equals(this.getModalitiesInStudy())) {
            return false;
        }
        this.setModalitiesInStudy(mds);
        return true;
    }

    public boolean updateSOPClassesInStudy() {
        Set newSet;
        try {
            newSet = this.ejbSelectSOPClassesInStudies(this.getPk());
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        String oldStr = this.getSopClassesInStudy();
        if (oldStr == null) {
            if (newSet.isEmpty()) {
                return false;
            }
        } else {
            HashSet<String> oldSet = new HashSet<String>(Arrays.asList(StringUtils.split((String)oldStr, (char)'\\')));
            if (((Object)newSet).equals(oldSet)) {
                return false;
            }
            if (newSet.isEmpty()) {
                this.setSopClassesInStudy(null);
                return true;
            }
        }
        String[] newStrs = newSet.toArray(new String[newSet.size()]);
        this.setSopClassesInStudy(StringUtils.toString((String[])newStrs, (char)'\\'));
        return true;
    }

    public abstract Set ejbSelectSOPClassesInStudies(Long var1) throws FinderException;

    public void updateRetrieveAETs(String oldAET, String newAET) {
        Collection series = this.getSeries();
        Iterator it = series.iterator();
        while (it.hasNext()) {
            ((SeriesLocal)it.next()).updateRetrieveAETs(oldAET, newAET);
        }
        this.setRetrieveAETs(AETs.update((String)this.getRetrieveAETs(), (String)oldAET, (String)newAET));
    }

    public boolean isStudyAvailableOnMedia() throws FinderException {
        String fsuid = this.getFilesetIuid();
        return fsuid != null && fsuid.length() != 0 || this.ejbSelectNumberOfStudyRelatedInstancesOnMediaWithStatus(this.getPk(), 4) == this.getNumberOfStudyRelatedInstances();
    }

    public boolean isStudyAvailableOnROFs(int validFileStatus) throws FinderException {
        return this.ejbSelectNumberOfStudyRelatedInstancesOnROFS(this.getPk(), validFileStatus) == this.getNumberOfStudyRelatedInstances();
    }

    public boolean isStudyAvailable(int availability) throws FinderException {
        return this.ejbSelectNumberOfStudyRelatedInstancesForAvailability(this.getPk(), availability) == this.getNumberOfStudyRelatedInstances();
    }

    public Dataset getAttributes(boolean supplement) {
        Dataset ds = DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
        if (ds.isEmpty()) {
            log.warn((Object)("Empty Dataset in Study BLOB (pk:" + this.getPk() + ")! Use Dataset with DB values"));
            ds.putUI(0x20000D, this.getStudyIuid());
            ds.putSH(0x200010, this.getStudyId());
            ds.putCS(3276810, this.getStudyStatusId());
            ds.putDA(524320, (Date)this.getStudyDateTime());
            ds.putTM(524336, (Date)this.getStudyDateTime());
            ds.putSH(524368, this.getAccessionNumber());
            ds.putPN(524432, this.getReferringPhysicianName());
            ds.putLO(528432, this.getStudyDescription());
        }
        if (supplement) {
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putOB(4390929, Convert.toBytes((long)this.getPk()));
            ds.setPrivateCreatorID(null);
            ds.putCS(524385, StringUtils.split((String)this.getModalitiesInStudy(), (char)'\\'));
            ds.putIS(2101766, this.getNumberOfStudyRelatedSeries());
            ds.putIS(2101768, this.getNumberOfStudyRelatedInstances());
            ds.putSH(8913200, this.getFilesetId());
            ds.putUI(8913216, this.getFilesetIuid());
            DatasetUtils.putRetrieveAET((Dataset)ds, (String)this.getRetrieveAETs(), (String)this.getExternalRetrieveAET());
            ds.putCS(524374, Availability.toString((int)this.getAvailabilitySafe()));
            ds.putCS(3276810, this.getStudyStatusId());
        }
        return ds;
    }

    public void setAttributes(Dataset ds) {
        AttributeFilter filter = AttributeFilter.getStudyAttributeFilter();
        this.setStudyIuid(ds.getString(0x20000D));
        this.setStudyId(filter.getString(ds, 0x200010));
        this.setStudyStatusId(filter.getString(ds, 3276810));
        try {
            this.setStudyDateTime(ds.getDateTime(524320, 524336));
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Illegal Study Date/Time format: " + e.getMessage()));
        }
        this.setAccessionNumber(filter.getString(ds, 524368));
        PersonName pn = ds.getPersonName(524432);
        if (pn != null) {
            PersonName ppn;
            this.setReferringPhysicianName(filter.toUpperCase(pn.toComponentGroupString(false), 524432));
            PersonName ipn = pn.getIdeographic();
            if (ipn != null) {
                this.setReferringPhysicianIdeographicName(ipn.toComponentGroupString(false));
            }
            if ((ppn = pn.getPhonetic()) != null) {
                this.setReferringPhysicianPhoneticName(ppn.toComponentGroupString(false));
            }
        }
        if (AttributeFilter.isSoundexEnabled()) {
            this.setReferringPhysicianFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
            this.setReferringPhysicianGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
        }
        this.setStudyDescription(filter.getString(ds, 528432));
        byte[] b = DatasetUtils.toByteArray((Dataset)filter.filter(ds), (String)filter.getTransferSyntaxUID());
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "])"));
        }
        this.setEncodedAttributes(b);
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            this.setField(filter.getField(fieldTags[i]), filter.getString(ds, fieldTags[i]));
        }
    }

    private void setField(String field, String value) {
        try {
            Method m = StudyBean.class.getMethod("set" + Character.toUpperCase(field.charAt(0)) + field.substring(1), STRING_PARAM);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private boolean updateIssuerOfAccessionNumber(Dataset oldIssuer, Dataset newIssuer) {
        if (oldIssuer == null ? newIssuer == null : oldIssuer.equals(newIssuer)) {
            return false;
        }
        try {
            this.setIssuerOfAccessionNumber(IssuerBean.valueOf(this.issuerHome, newIssuer));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return true;
    }

    public boolean updateAttributes(Dataset newAttrs, Dataset modifiedAttrs) {
        Dataset oldAttrs = this.getAttributes(false);
        if (oldAttrs == null) {
            this.updateIssuerOfAccessionNumber(null, newAttrs.getItem(524369));
            this.setAttributes(newAttrs);
        } else {
            this.updateIssuerOfAccessionNumber(oldAttrs.getItem(524369), newAttrs.getItem(524369));
            AttributeFilter filter = AttributeFilter.getStudyAttributeFilter();
            if (!AttrUtils.updateAttributes(oldAttrs, filter.filter(newAttrs), modifiedAttrs, log)) {
                return false;
            }
            this.setAttributes(oldAttrs);
        }
        return true;
    }

    public void coerceAttributes(Dataset ds, Dataset coercedElements) throws DcmServiceException {
        AttributeFilter filter = AttributeFilter.getStudyAttributeFilter();
        if (filter.isOverwrite()) {
            Dataset attrs;
            if (filter.isMerge()) {
                attrs = this.getAttributes(false);
                AttrUtils.updateAttributes(attrs, filter.filter(ds), null, log);
            } else {
                attrs = ds;
            }
            this.setAttributes(attrs);
        } else {
            Dataset attrs = this.getAttributes(false);
            AttrUtils.coerceAttributes(attrs, ds, coercedElements, filter, log);
            if (filter.isMerge() && AttrUtils.mergeAttributes(attrs, filter.filter(ds), log)) {
                this.setAttributes(attrs);
            }
        }
    }

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        return "Study[pk=" + this.getPk() + ", uid=" + this.getStudyIuid() + ", patient->" + this.getPatient() + "]";
    }

    public abstract Collection ejbSelectFiles(Long var1, Long var2) throws FinderException;

    public Collection getFiles(Long fsPk) throws FinderException {
        return this.ejbSelectFiles(this.getPk(), fsPk);
    }

    public abstract Collection ejbSelectAllFiles(Long var1) throws FinderException;

    public Collection getAllFiles() throws FinderException {
        return this.ejbSelectAllFiles(this.getPk());
    }

    public abstract Collection ejbSelectSeriesPks(Long var1) throws FinderException;

    public Collection getSeriesPks() throws FinderException {
        return this.ejbSelectSeriesPks(this.getPk());
    }

    public abstract Collection ejbSelectInstancesNotOnMedia(Long var1) throws FinderException;

    public Collection getInstancesNotOnMedia() throws FinderException {
        return this.ejbSelectInstancesNotOnMedia(this.getPk());
    }

    public abstract Collection ejbSelectWithMissingPpsIuidFromSrcAETReceivedLastOfStudyBefore(String var1, Timestamp var2) throws FinderException;

    public Collection ejbHomeSelectWithMissingPpsIuidFromSrcAETReceivedLastOfStudyBefore(String srcAET, Timestamp receivedBefore) throws FinderException {
        return this.ejbSelectWithMissingPpsIuidFromSrcAETReceivedLastOfStudyBefore(srcAET, receivedBefore);
    }
}

