/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.PersonName;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.AttrUtils;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.InstanceLocal;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocal;
import org.dcm4chex.archive.ejb.interfaces.MPPSLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MediaLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesRequestLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesRequestLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.util.AETs;
import org.dcm4chex.archive.util.Convert;

public abstract class SeriesBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(SeriesBean.class);
    private static final Class[] STRING_PARAM = new Class[]{String.class};
    private EntityContext ejbctx;
    private MPPSLocalHome mppsHome;
    private SeriesRequestLocalHome reqHome;
    private CodeLocalHome codeHome;

    public void setEntityContext(EntityContext ctx) {
        this.ejbctx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.mppsHome = (MPPSLocalHome)jndiCtx.lookup("java:comp/env/ejb/MPPS");
            this.reqHome = (SeriesRequestLocalHome)jndiCtx.lookup("java:comp/env/ejb/Request");
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.mppsHome = null;
        this.reqHome = null;
        this.codeHome = null;
        this.ejbctx = null;
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getUpdatedTime();

    public abstract void setUpdatedTime(Timestamp var1);

    public abstract String getSeriesIuid();

    public abstract void setSeriesIuid(String var1);

    public abstract String getSeriesNumber();

    public abstract void setSeriesNumber(String var1);

    public abstract String getModality();

    public abstract void setModality(String var1);

    public abstract String getBodyPartExamined();

    public abstract void setBodyPartExamined(String var1);

    public abstract String getLaterality();

    public abstract void setLaterality(String var1);

    public abstract String getSeriesDescription();

    public abstract void setSeriesDescription(String var1);

    public abstract String getInstitutionalDepartmentName();

    public abstract void setInstitutionalDepartmentName(String var1);

    public abstract String getInstitutionName();

    public abstract void setInstitutionName(String var1);

    public abstract String getStationName();

    public abstract void setStationName(String var1);

    public abstract String getPerformingPhysicianName();

    public abstract void setPerformingPhysicianName(String var1);

    public abstract String getPerformingPhysicianFamilyNameSoundex();

    public abstract void setPerformingPhysicianFamilyNameSoundex(String var1);

    public abstract String getPerformingPhysicianGivenNameSoundex();

    public abstract void setPerformingPhysicianGivenNameSoundex(String var1);

    public abstract String getPerformingPhysicianIdeographicName();

    public abstract void setPerformingPhysicianIdeographicName(String var1);

    public abstract String getPerformingPhysicianPhoneticName();

    public abstract void setPerformingPhysicianPhoneticName(String var1);

    public abstract Timestamp getPpsStartDateTime();

    public abstract void setPpsStartDateTime(Timestamp var1);

    private void setPpsStartDateTime(Date date) {
        this.setPpsStartDateTime(date != null ? new Timestamp(date.getTime()) : null);
    }

    public abstract String getPpsIuid();

    public abstract void setPpsIuid(String var1);

    public abstract String getSeriesCustomAttribute1();

    public abstract void setSeriesCustomAttribute1(String var1);

    public abstract String getSeriesCustomAttribute2();

    public abstract void setSeriesCustomAttribute2(String var1);

    public abstract String getSeriesCustomAttribute3();

    public abstract void setSeriesCustomAttribute3(String var1);

    public abstract int getNumberOfSeriesRelatedInstances();

    public abstract void setNumberOfSeriesRelatedInstances(int var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract String getFilesetIuid();

    public abstract void setFilesetIuid(String var1);

    public abstract String getFilesetId();

    public abstract void setFilesetId(String var1);

    public abstract String getSourceAET();

    public abstract void setSourceAET(String var1);

    public abstract String getExternalRetrieveAET();

    public abstract void setExternalRetrieveAET(String var1);

    public abstract String getRetrieveAETs();

    public abstract void setRetrieveAETs(String var1);

    public abstract int getAvailability();

    public int getAvailabilitySafe() {
        try {
            return this.getAvailability();
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public abstract void setAvailability(int var1);

    public abstract int getSeriesStatus();

    public abstract void setSeriesStatus(int var1);

    public abstract CodeLocal getInstitutionCode();

    public abstract void setInstitutionCode(CodeLocal var1);

    public abstract StudyLocal getStudy();

    public abstract void setStudy(StudyLocal var1);

    public abstract MPPSLocal getMpps();

    public abstract void setMpps(MPPSLocal var1);

    public abstract Collection getRequestAttributes();

    public abstract void setRequestAttributes(Collection var1);

    public abstract Collection getInstances();

    public abstract void setInstances(Collection var1);

    public Long ejbCreate(Dataset ds, StudyLocal study) throws CreateException {
        ds.setPrivateCreatorID("dcm4che/archive");
        this.setSourceAET(ds.getString(4390932));
        ds.setPrivateCreatorID(null);
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds, StudyLocal study) throws CreateException {
        this.updateSeriesRequest(null, ds, false);
        this.updateInstitutionCode(null, ds.getItem(524418));
        this.setStudy(study);
        this.updateMpps();
        log.info((Object)("Created " + this.prompt()));
    }

    private boolean updateInstitutionCode(Dataset oldCode, Dataset newCode) {
        if (oldCode == null ? newCode == null : oldCode.equals(newCode)) {
            return false;
        }
        try {
            this.setInstitutionCode(newCode == null ? null : CodeBean.valueOf(this.codeHome, newCode));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return true;
    }

    public boolean updateAttributes(Dataset newAttrs, boolean overwriteReqAttrSQ, Dataset modifiedAttrs) {
        Dataset oldAttrs = this.getAttributes(false);
        this.updateSeriesRequest(oldAttrs, newAttrs, overwriteReqAttrSQ);
        if (oldAttrs == null) {
            this.updateInstitutionCode(null, newAttrs.getItem(524418));
            this.setAttributes(newAttrs);
        } else {
            this.updateInstitutionCode(oldAttrs.getItem(524418), newAttrs.getItem(524418));
            AttributeFilter filter = AttributeFilter.getSeriesAttributeFilter();
            if (!AttrUtils.updateAttributes(oldAttrs, filter.filter(newAttrs), modifiedAttrs, log)) {
                return false;
            }
            this.setAttributes(oldAttrs);
        }
        return true;
    }

    private boolean updateSeriesRequest(Dataset oldAttrs, Dataset newAttrs, boolean overwriteReqAttrSQ) {
        int i;
        DcmElement newReqAttrSQ = newAttrs.get(4194933);
        if (newReqAttrSQ == null) {
            return false;
        }
        if (oldAttrs != null && newReqAttrSQ.equals(oldAttrs.get(4194933))) {
            return false;
        }
        Collection c = this.getRequestAttributes();
        if (overwriteReqAttrSQ && !c.isEmpty()) {
            oldAttrs.remove(4194933);
            SeriesRequestLocal[] srls = new SeriesRequestLocal[c.size()];
            srls = c.toArray(srls);
            for (i = 0; i < srls.length; ++i) {
                try {
                    srls[i].remove();
                    continue;
                }
                catch (Exception ignore) {
                    log.warn((Object)("Cant delete SeriesRequest! Ignore deletion of " + srls[i]), (Throwable)ignore);
                }
            }
            c.clear();
        }
        SeriesLocal series = (SeriesLocal)this.ejbctx.getEJBLocalObject();
        int len = newReqAttrSQ.countItems();
        for (i = 0; i < len; ++i) {
            try {
                c.add(this.reqHome.create(newReqAttrSQ.getItem(i), series));
                continue;
            }
            catch (CreateException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
        return true;
    }

    public Collection ejbHomeGetSeriesPksWithStatusAndUpdatedBefore(int status, Timestamp updatedBefore) throws FinderException {
        return this.ejbSelectSeriesPksByStatusAndUpdatedBefore(status, updatedBefore);
    }

    public abstract Collection ejbSelectSeriesPksByStatusAndUpdatedBefore(int var1, Timestamp var2) throws FinderException;

    public abstract Set ejbSelectInternalRetrieveAETs(Long var1) throws FinderException;

    public abstract Set ejbSelectExternalRetrieveAETs(Long var1) throws FinderException;

    public abstract Set ejbSelectMediaWithStatus(Long var1, int var2) throws FinderException;

    public abstract int ejbSelectNumberOfSeriesRelatedInstancesOnMediaWithStatus(Long var1, int var2) throws FinderException;

    public abstract int ejbSelectNumberOfSeriesRelatedInstances(Long var1) throws FinderException;

    public abstract Timestamp ejbSelectMaxUpdatedTimeOfSeriesRelatedInstances(Long var1) throws FinderException;

    public abstract int ejbSelectAvailability(Long var1) throws FinderException;

    public abstract Collection ejbSelectSeriesIuidsByModalityAndSrcAETAndUpdatedTime(int var1, String var2, String var3, Timestamp var4, Timestamp var5, int var6, int var7) throws FinderException;

    public abstract Collection ejbSelectSeriesIuidsByModalityAndUpdatedTime(int var1, String var2, Timestamp var3, Timestamp var4, int var5, int var6) throws FinderException;

    public abstract Collection ejbSelectSeriesIuidsBySrcAETAndUpdatedTime(int var1, String var2, Timestamp var3, Timestamp var4, int var5, int var6) throws FinderException;

    public abstract Collection ejbSelectSeriesIuidsByUpdatedTime(int var1, Timestamp var2, Timestamp var3, int var4, int var5) throws FinderException;

    public abstract int ejbSelectCountSeriesByModalityAndSrcAETAndUpdatedTime(int var1, String var2, String var3, Timestamp var4, Timestamp var5) throws FinderException;

    public abstract int ejbSelectCountSeriesByModalityAndUpdatedTime(int var1, String var2, Timestamp var3, Timestamp var4) throws FinderException;

    public abstract int ejbSelectCountSeriesBySrcAETAndUpdatedTime(int var1, String var2, Timestamp var3, Timestamp var4) throws FinderException;

    public abstract int ejbSelectCountSeriesByUpdatedTime(int var1, Timestamp var2, Timestamp var3) throws FinderException;

    public Collection ejbHomeSeriesIuidsForAttributesUpdate(int availability, String modality, String srcAET, Timestamp updatedAfter, Timestamp updatedBefore, int offset, int limit) throws FinderException {
        return modality == null || modality.length() == 0 ? (srcAET == null || srcAET.length() == 0 ? this.ejbSelectSeriesIuidsByUpdatedTime(availability, updatedAfter, updatedBefore, offset, limit) : this.ejbSelectSeriesIuidsBySrcAETAndUpdatedTime(availability, srcAET, updatedAfter, updatedBefore, offset, limit)) : (srcAET == null || srcAET.length() == 0 ? this.ejbSelectSeriesIuidsByModalityAndUpdatedTime(availability, modality, updatedAfter, updatedBefore, offset, limit) : this.ejbSelectSeriesIuidsByModalityAndSrcAETAndUpdatedTime(availability, modality, srcAET, updatedAfter, updatedBefore, offset, limit));
    }

    public int ejbHomeCountSeriesForAttributesUpdate(int availability, String modality, String srcAET, Timestamp updatedAfter, Timestamp updatedBefore) throws FinderException {
        return modality == null || modality.length() == 0 ? (srcAET == null || srcAET.length() == 0 ? this.ejbSelectCountSeriesByUpdatedTime(availability, updatedAfter, updatedBefore) : this.ejbSelectCountSeriesBySrcAETAndUpdatedTime(availability, srcAET, updatedAfter, updatedBefore)) : (srcAET == null || srcAET.length() == 0 ? this.ejbSelectCountSeriesByModalityAndUpdatedTime(availability, modality, updatedAfter, updatedBefore) : this.ejbSelectCountSeriesByModalityAndSrcAETAndUpdatedTime(availability, modality, srcAET, updatedAfter, updatedBefore));
    }

    public abstract Collection ejbSelectGeneric(String var1, Object[] var2) throws FinderException;

    public Collection ejbHomeListPriorOfPatient(PatientLocal pat, String ignoreStudyIUID, Timestamp createdAfter, int minAvail, String[] modalities) throws FinderException {
        StringBuffer jbossQl = new StringBuffer("SELECT OBJECT(s) FROM Series s");
        jbossQl.append(" WHERE s.study.patient = ?1");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(pat);
        int idx = 2;
        if (ignoreStudyIUID != null) {
            jbossQl.append(" AND s.study.studyIuid <> ?").append(idx++);
            params.add(ignoreStudyIUID);
        }
        if (createdAfter != null) {
            jbossQl.append(" AND s.study.createdTime > ?").append(idx++);
            params.add(createdAfter);
        }
        if (minAvail < 3) {
            jbossQl.append(" AND s.availability <= ?").append(idx++);
            params.add(minAvail);
        }
        if (modalities != null && modalities.length > 0) {
            jbossQl.append(" AND s.modality");
            idx = this.addIN(jbossQl, params, idx, modalities);
        }
        log.debug((Object)("Execute JBossQL: " + jbossQl));
        return this.ejbSelectGeneric(jbossQl.toString(), params.toArray());
    }

    public Collection ejbHomeListBySeriesIUIDsWithoutPPS(String[] seriesIUIDs) throws FinderException {
        if (seriesIUIDs == null || seriesIUIDs.length < 1) {
            return new ArrayList();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT OBJECT(s) FROM Series s WHERE s.ppsIuid IS NULL AND s.seriesIuid");
        ArrayList params = new ArrayList();
        this.addIN(sb, params, 1, seriesIUIDs);
        log.debug((Object)("Execute JBossQL: " + sb));
        return this.ejbSelectGeneric(sb.toString(), params.toArray());
    }

    private int addIN(StringBuffer jbossQl, List params, int idx, String[] values) {
        params.add(values[0]);
        if (values.length > 1) {
            jbossQl.append(" IN ( ");
            for (int i = 1; i < values.length; ++i) {
                jbossQl.append("?").append(idx++).append(", ");
                params.add(values[i]);
            }
            jbossQl.append("?").append(idx++).append(")");
        } else {
            jbossQl.append(" = ?").append(idx++);
        }
        return idx;
    }

    public boolean updateRetrieveAETs() {
        String aets = null;
        int numI = this.getNumberOfSeriesRelatedInstances();
        if (numI > 0) {
            Set iAetSet;
            StringBuffer sb = new StringBuffer();
            Long pk = this.getPk();
            try {
                iAetSet = this.ejbSelectInternalRetrieveAETs(pk);
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
            Iterator it = iAetSet.iterator();
            aets = (String)it.next();
            while (aets != null && it.hasNext()) {
                aets = AETs.common((String)aets, (String)((String)it.next()));
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
                aets = sb.toString();
            }
        }
        if (aets == null ? this.getRetrieveAETs() == null : aets.equals(this.getRetrieveAETs())) {
            return false;
        }
        this.setRetrieveAETs(aets);
        return true;
    }

    public boolean updateExternalRetrieveAET() {
        String aet = null;
        if (this.getNumberOfSeriesRelatedInstances() > 0) {
            Set eAetSet;
            try {
                eAetSet = this.ejbSelectExternalRetrieveAETs(this.getPk());
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
            if (eAetSet.size() == 1) {
                aet = (String)eAetSet.iterator().next();
            }
        }
        if (aet == null ? this.getExternalRetrieveAET() == null : aet.equals(this.getExternalRetrieveAET())) {
            return false;
        }
        this.setExternalRetrieveAET(aet);
        return true;
    }

    public boolean updateAvailability() {
        int availability;
        try {
            availability = this.getNumberOfSeriesRelatedInstances() > 0 ? this.ejbSelectAvailability(this.getPk()) : 3;
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        int prevAvailability = this.getAvailabilitySafe();
        if (availability == prevAvailability) {
            return false;
        }
        this.setAvailability(availability);
        if (log.isDebugEnabled()) {
            log.debug((Object)("update Availability of Series[pk=" + this.getPk() + ", uid=" + this.getSeriesIuid() + "] from " + Availability.toString((int)prevAvailability) + " to " + Availability.toString((int)availability)));
        }
        return true;
    }

    public boolean updateNumberOfSeriesRelatedInstances() {
        int numI;
        try {
            numI = this.ejbSelectNumberOfSeriesRelatedInstances(this.getPk());
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (this.getNumberOfSeriesRelatedInstances() == numI) {
            return false;
        }
        this.setNumberOfSeriesRelatedInstances(numI);
        return true;
    }

    public Timestamp getMaxUpdatedTimeOfSeriesRelatedInstances() {
        try {
            return this.ejbSelectMaxUpdatedTimeOfSeriesRelatedInstances(this.getPk());
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean updateFilesetId() {
        boolean updated = false;
        String fileSetId = null;
        String fileSetIuid = null;
        int numI = this.getNumberOfSeriesRelatedInstances();
        if (numI > 0) {
            Long pk = this.getPk();
            try {
                Set c;
                if (this.ejbSelectNumberOfSeriesRelatedInstancesOnMediaWithStatus(pk, 4) == numI && (c = this.ejbSelectMediaWithStatus(pk, 4)).size() == 1) {
                    MediaLocal media = (MediaLocal)c.iterator().next();
                    fileSetId = media.getFilesetId();
                    fileSetIuid = media.getFilesetIuid();
                }
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
        if (fileSetId == null ? this.getFilesetId() != null : !fileSetId.equals(this.getFilesetId())) {
            this.setFilesetId(fileSetId);
            updated = true;
        }
        if (fileSetIuid == null ? this.getFilesetIuid() != null : !fileSetIuid.equals(this.getFilesetIuid())) {
            this.setFilesetIuid(fileSetIuid);
            updated = true;
        }
        return updated;
    }

    public void updateRetrieveAETs(String oldAET, String newAET) {
        Collection insts = this.getInstances();
        Iterator it = insts.iterator();
        while (it.hasNext()) {
            ((InstanceLocal)it.next()).updateRetrieveAETs(oldAET, newAET);
        }
        this.setRetrieveAETs(AETs.update((String)this.getRetrieveAETs(), (String)oldAET, (String)newAET));
    }

    public void removeMPPS() {
        this.setMpps(null);
    }

    private void updateMpps() {
        String ppsiuid = this.getPpsIuid();
        MPPSLocal mpps = null;
        if (ppsiuid != null) {
            try {
                mpps = this.mppsHome.findBySopIuid(ppsiuid);
                PatientLocal pat = this.getStudy().getPatient();
                if (pat.getPk() != mpps.getPatient().getPk()) {
                    mpps.setPatient(pat);
                }
            }
            catch (ObjectNotFoundException ignore) {
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
        this.setMpps(mpps);
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public void setAttributes(Dataset ds) {
        AttributeFilter filter = AttributeFilter.getSeriesAttributeFilter();
        this.setSeriesIuid(ds.getString(0x20000E));
        this.setSeriesNumber(filter.getString(ds, 0x200011));
        this.setModality(filter.getString(ds, 524384));
        this.setBodyPartExamined(filter.getString(ds, 1572885));
        this.setLaterality(filter.getString(ds, 0x200060));
        this.setSeriesDescription(filter.getString(ds, 528446));
        this.setInstitutionName(filter.getString(ds, 524416));
        this.setInstitutionalDepartmentName(filter.getString(ds, 528448));
        this.setStationName(filter.getString(ds, 528400));
        PersonName pn = ds.getPersonName(528464);
        if (pn != null) {
            PersonName ppn;
            this.setPerformingPhysicianName(filter.toUpperCase(pn.toComponentGroupString(false), 528464));
            PersonName ipn = pn.getIdeographic();
            if (ipn != null) {
                this.setPerformingPhysicianIdeographicName(ipn.toComponentGroupString(false));
            }
            if ((ppn = pn.getPhonetic()) != null) {
                this.setPerformingPhysicianPhoneticName(ppn.toComponentGroupString(false));
            }
        }
        if (AttributeFilter.isSoundexEnabled()) {
            this.setPerformingPhysicianFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
            this.setPerformingPhysicianGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
        }
        try {
            this.setPpsStartDateTime(ds.getDateTime(0x400244, 4194885));
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Illegal PPS Date/Time format: " + e.getMessage()));
        }
        Dataset refPPS = ds.getItem(528657);
        this.setPpsIuid(refPPS == null ? null : refPPS.getString(528725));
        byte[] b = DatasetUtils.toByteArray((Dataset)filter.filter(ds), (String)filter.getTransferSyntaxUID());
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "])"));
        }
        this.setEncodedAttributes(b);
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            this.setField(filter.getField(fieldTags[i]), filter.getString(ds, fieldTags[i]));
        }
        if (this.getSourceAET() == null) {
            ds.setPrivateCreatorID("dcm4che/archive");
            this.setSourceAET(ds.getString(4390932));
            ds.setPrivateCreatorID(null);
        }
    }

    private void setField(String field, String value) {
        try {
            Method m = SeriesBean.class.getMethod("set" + Character.toUpperCase(field.charAt(0)) + field.substring(1), STRING_PARAM);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public void coerceAttributes(Dataset ds, Dataset coercedElements) throws DcmServiceException {
        AttributeFilter filter = AttributeFilter.getSeriesAttributeFilter();
        Dataset attrs = this.getAttributes(false);
        Dataset oldInstCode = attrs.getItem(524418);
        if (filter.isOverwrite()) {
            if (filter.isMerge()) {
                AttrUtils.updateAttributes(attrs, filter.filter(ds), null, log);
            } else {
                attrs = ds;
            }
            this.setAttributes(attrs);
        } else {
            AttrUtils.coerceAttributes(attrs, ds, coercedElements, filter, log);
            if (filter.isMerge() && AttrUtils.mergeAttributes(attrs, filter.filter(ds), log)) {
                this.setAttributes(attrs);
            }
        }
        this.updateInstitutionCode(oldInstCode, attrs.getItem(524418));
    }

    public Dataset getAttributes(boolean supplement) {
        Dataset ds = DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
        if (ds.isEmpty()) {
            log.warn((Object)("Empty Dataset in Series BLOB (pk:" + this.getPk() + ")! Use Dataset with DB values"));
            ds.putUI(0x20000E, this.getSeriesIuid());
            ds.putIS(0x200011, this.getSeriesNumber());
            ds.putCS(524384, this.getModality());
            ds.putCS(1572885, this.getBodyPartExamined());
            ds.putCS(0x200060, this.getLaterality());
            ds.putLO(528446, this.getSeriesDescription());
            ds.putLO(524416, this.getInstitutionName());
            ds.putLO(528448, this.getInstitutionalDepartmentName());
            ds.putSH(528400, this.getStationName());
            ds.putPN(528464, this.getPerformingPhysicianName());
            ds.putDA(0x400244, (Date)this.getPpsStartDateTime());
            ds.putTM(4194885, (Date)this.getPpsStartDateTime());
        }
        if (supplement) {
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putOB(4390930, Convert.toBytes((long)this.getPk()));
            ds.putAE(4390932, this.getSourceAET());
            ds.setPrivateCreatorID(null);
            ds.putIS(2101769, this.getNumberOfSeriesRelatedInstances());
            ds.putSH(8913200, this.getFilesetId());
            ds.putUI(8913216, this.getFilesetIuid());
            DatasetUtils.putRetrieveAET((Dataset)ds, (String)this.getRetrieveAETs(), (String)this.getExternalRetrieveAET());
            ds.putCS(524374, Availability.toString((int)this.getAvailabilitySafe()));
        }
        return ds;
    }

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        return "Series[pk=" + this.getPk() + ", uid=" + this.getSeriesIuid() + ", study->" + this.getStudy() + "]";
    }

    public abstract Collection ejbSelectFiles(Long var1, Long var2) throws FinderException;

    public Collection getFiles(Long fsPk) throws FinderException {
        return this.ejbSelectFiles(this.getPk(), fsPk);
    }

    public abstract Collection ejbSelectAllFiles(Long var1) throws FinderException;

    public Collection getAllFiles() throws FinderException {
        return this.ejbSelectAllFiles(this.getPk());
    }
}

