/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.PersonName;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.PatientMatching;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.AttrUtils;
import org.dcm4chex.archive.ejb.interfaces.OtherPatientIDLocal;
import org.dcm4chex.archive.ejb.interfaces.OtherPatientIDLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocalHome;
import org.dcm4chex.archive.ejb.interfaces.StudyLocal;
import org.dcm4chex.archive.exceptions.CircularMergedException;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.exceptions.NonUniquePatientException;
import org.dcm4chex.archive.exceptions.NonUniquePatientIDException;
import org.dcm4chex.archive.exceptions.PatientMergedException;
import org.dcm4chex.archive.util.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PatientBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(PatientBean.class);
    private static final int[] OTHER_PID_SQ = new int[]{0x101002};
    private static final Class[] STRING_PARAM = new Class[]{String.class};
    private OtherPatientIDLocalHome opidHome;
    private EntityContext ctx;

    public void setEntityContext(EntityContext ctx) {
        InitialContext jndiCtx = null;
        try {
            this.ctx = ctx;
            jndiCtx = new InitialContext();
            this.opidHome = (OtherPatientIDLocalHome)jndiCtx.lookup("java:comp/env/ejb/OtherPatientID");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.ctx = null;
        this.opidHome = null;
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getUpdatedTime();

    public abstract void setUpdatedTime(Timestamp var1);

    public abstract String getPatientId();

    public abstract void setPatientId(String var1);

    public abstract String getIssuerOfPatientId();

    public abstract void setIssuerOfPatientId(String var1);

    public abstract String getPatientName();

    public abstract void setPatientName(String var1);

    public abstract String getPatientFamilyNameSoundex();

    public abstract void setPatientFamilyNameSoundex(String var1);

    public abstract String getPatientGivenNameSoundex();

    public abstract void setPatientGivenNameSoundex(String var1);

    public abstract String getPatientIdeographicName();

    public abstract void setPatientIdeographicName(String var1);

    public abstract String getPatientPhoneticName();

    public abstract void setPatientPhoneticName(String var1);

    public abstract String getPatientBirthDate();

    public abstract void setPatientBirthDate(String var1);

    public abstract String getPatientSex();

    public abstract void setPatientSex(String var1);

    public abstract String getPatientCustomAttribute1();

    public abstract void setPatientCustomAttribute1(String var1);

    public abstract String getPatientCustomAttribute2();

    public abstract void setPatientCustomAttribute2(String var1);

    public abstract String getPatientCustomAttribute3();

    public abstract void setPatientCustomAttribute3(String var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract Collection getOtherPatientIds();

    public abstract void setOtherPatientIds(Collection var1);

    public abstract PatientLocal getMergedWith();

    public abstract void setMergedWith(PatientLocal var1);

    public abstract Collection getMerged();

    public abstract void setMerged(Collection var1);

    public abstract void setStudies(Collection var1);

    public abstract Collection getStudies();

    public abstract void setMwlItems(Collection var1);

    public abstract Collection getMwlItems();

    public abstract void setMpps(Collection var1);

    public abstract Collection getMpps();

    public abstract void setGppps(Collection var1);

    public abstract Collection getGppps();

    public abstract Collection getGsps();

    public abstract void setGsps(Collection var1);

    public abstract Collection getUPS();

    public abstract void setUPS(Collection var1);

    public Long ejbCreate(Dataset ds) throws CreateException {
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds) throws CreateException {
        try {
            this.createOtherPatientIds(ds.get(0x101002));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        log.info((Object)("Created " + this.prompt()));
    }

    private void createOtherPatientIds(DcmElement opidsq) throws CreateException, FinderException {
        if (opidsq == null || opidsq.isEmpty() || opidsq.getItem().isEmpty()) {
            return;
        }
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        Collection opids = this.getOtherPatientIds();
        int n = opidsq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset opid = opidsq.getItem(i);
            opids.add(this.opidHome.valueOf(filter.getString(opid, 0x100020), filter.getString(opid, 0x100021)));
        }
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
        Iterator iter = this.getOtherPatientIds().iterator();
        while (iter.hasNext()) {
            OtherPatientIDLocal opid = (OtherPatientIDLocal)iter.next();
            if (opid.getPatients().size() != 1) continue;
            iter.remove();
            opid.remove();
        }
        iter = this.getStudies().iterator();
        while (iter.hasNext()) {
            StudyLocal study = (StudyLocal)iter.next();
            iter.remove();
            study.remove();
        }
    }

    public PatientLocal ejbHomeSelectPatient(String pid, String issuer) throws FinderException {
        Iterator patIter;
        if (pid == null) {
            throw new ObjectNotFoundException();
        }
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        pid = filter.toUpperCase(pid, 0x100020);
        issuer = filter.toUpperCase(issuer, 0x100021);
        PatientLocalHome patHome = (PatientLocalHome)this.ctx.getEJBLocalHome();
        Collection c = patHome.findByPatientId(pid);
        if (issuer != null) {
            this.matchIssuer(true, issuer, c);
        }
        if (!(patIter = c.iterator()).hasNext()) {
            throw new ObjectNotFoundException();
        }
        PatientLocal pat = (PatientLocal)patIter.next();
        if (patIter.hasNext()) {
            throw new NonUniquePatientException("Patient[id=" + pid + ", issuer=" + issuer + "] ambiguous");
        }
        return pat;
    }

    public PatientLocal ejbHomeSelectPatient(Dataset ds, PatientMatching matching, boolean followMerged) throws FinderException {
        String pid = ds.getString(0x100020);
        String issuer = ds.getString(0x100021);
        PersonName pn = ds.getPersonName(0x100010);
        String familyName = pn != null ? pn.get(0) : null;
        String givenName = pn != null ? pn.get(1) : null;
        String middleName = pn != null ? pn.get(2) : null;
        String namePrefix = pn != null ? pn.get(3) : null;
        String nameSuffix = pn != null ? pn.get(4) : null;
        String birthdate = PatientBean.normalizeDA(ds.getString(0x100030));
        String sex = ds.getString(0x100040);
        return this.selectPatient(pid, issuer, familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex, matching, followMerged);
    }

    private PatientLocal selectPatient(String pid, String issuer, String familyName, String givenName, String middleName, String namePrefix, String nameSuffix, String birthdate, String sex, PatientMatching matching, boolean followMerged) throws ObjectNotFoundException, FinderException, NonUniquePatientException, NonUniquePatientIDException, CircularMergedException, PatientMergedException {
        Collection c;
        if (matching.noMatchesFor(pid, issuer, familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex)) {
            throw new ObjectNotFoundException();
        }
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        pid = filter.toUpperCase(pid, 0x100020);
        issuer = filter.toUpperCase(issuer, 0x100021);
        if (filter.isICase(0x100010)) {
            familyName = AttributeFilter.toUpperCase((String)familyName);
            givenName = AttributeFilter.toUpperCase((String)givenName);
            middleName = AttributeFilter.toUpperCase((String)middleName);
            namePrefix = AttributeFilter.toUpperCase((String)namePrefix);
            nameSuffix = AttributeFilter.toUpperCase((String)nameSuffix);
        }
        PatientLocalHome patHome = (PatientLocalHome)this.ctx.getEJBLocalHome();
        if (pid != null) {
            c = patHome.findByPatientId(pid);
            if (c.isEmpty()) {
                throw new ObjectNotFoundException();
            }
            if (issuer != null) {
                int countWithIssuer = this.matchIssuer(matching.isUnknownIssuerAlwaysMatch(), issuer, c);
                if (!matching.isTrustPatientIDWithIssuer() || countWithIssuer == 0) {
                    PatientLocal matchWithIssuer = countWithIssuer > 0 ? (PatientLocal)c.iterator().next() : null;
                    this.matchDemographics(matching, familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex, c);
                    if (matchWithIssuer != null && c.isEmpty()) {
                        throw new NonUniquePatientIDException("Existing " + matchWithIssuer.asString() + " with equal Patient ID but different demographis than Patient[id=" + pid + ", issuer=" + issuer + ", name=" + familyName + '^' + givenName + '^' + namePrefix + '^' + nameSuffix + "]");
                    }
                }
            } else {
                this.matchDemographics(matching, familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex, c);
            }
        } else {
            c = patHome.findByPatientName(familyName.toUpperCase() + "^%");
            if (c.isEmpty()) {
                throw new ObjectNotFoundException();
            }
            this.matchDemographics(matching, familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex, c);
        }
        Iterator patIter = c.iterator();
        if (!patIter.hasNext()) {
            throw new ObjectNotFoundException();
        }
        PatientLocal pat = (PatientLocal)patIter.next();
        if (patIter.hasNext()) {
            throw new NonUniquePatientException("Patient[id=" + pid + ", issuer=" + issuer + ", name=" + familyName + '^' + givenName + '^' + namePrefix + '^' + nameSuffix + "] ambiguous");
        }
        PatientLocal merged = pat.getMergedWith();
        if (merged != null) {
            if (followMerged) {
                PatientLocal pat1 = pat;
                while (merged != null) {
                    if (merged.isIdentical((EJBLocalObject)pat1)) {
                        String prompt = "Detect circular merged Patient " + pat1.asString();
                        log.warn((Object)prompt);
                        throw new CircularMergedException(prompt);
                    }
                    pat = merged;
                    merged = pat.getMergedWith();
                }
            } else {
                if (pat.getIssuerOfPatientId() == null && issuer != null) {
                    throw new ObjectNotFoundException("Select patient with issuer but found only merged patient without issuer!");
                }
                String prompt = "Patient ID[id=" + pat.getPatientId() + ",issuer=" + pat.getIssuerOfPatientId() + "] merged with Patient ID[id=" + merged.getPatientId() + ",issuer=" + merged.getIssuerOfPatientId() + "]";
                log.warn((Object)prompt);
                throw new PatientMergedException(prompt);
            }
        }
        return pat;
    }

    private int matchIssuer(boolean unknownIssuerAlwaysMatch, String issuer, Collection<PatientLocal> c) {
        String issuer2;
        PatientLocal pat;
        int countWithIssuer = 0;
        Iterator<PatientLocal> iter = c.iterator();
        while (iter.hasNext()) {
            pat = iter.next();
            issuer2 = pat.getIssuerOfPatientId();
            if (issuer2 == null) continue;
            if (issuer2.equals(issuer)) {
                ++countWithIssuer;
                continue;
            }
            iter.remove();
        }
        if (countWithIssuer > 0 || !unknownIssuerAlwaysMatch) {
            iter = c.iterator();
            while (iter.hasNext()) {
                pat = iter.next();
                issuer2 = pat.getIssuerOfPatientId();
                if (issuer2 != null) continue;
                iter.remove();
            }
        }
        return countWithIssuer;
    }

    private void matchDemographics(PatientMatching matching, String familyName, String givenName, String middleName, String namePrefix, String nameSuffix, String birthdate, String sex, Collection<PatientLocal> c) throws ObjectNotFoundException {
        if (matching.allMatchesFor(familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex)) {
            return;
        }
        if (matching.noMatchesFor(familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex)) {
            throw new ObjectNotFoundException();
        }
        List pnPatterns = matching.compilePNPatterns(familyName, givenName, middleName, namePrefix, nameSuffix);
        Iterator<PatientLocal> iter = c.iterator();
        while (iter.hasNext()) {
            PatientLocal pat = iter.next();
            if (matching.matches(pat.getPatientName(), pat.getPatientBirthDate(), pat.getPatientSex(), pnPatterns.iterator(), birthdate, sex)) continue;
            iter.remove();
        }
    }

    public Dataset getAttributes(boolean supplement) {
        Dataset ds = DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
        if (ds.isEmpty()) {
            log.warn((Object)("Empty Dataset in Patient BLOB (pk:" + this.getPk() + ")! Use Dataset with DB values"));
            ds.putLO(0x100020, this.getPatientId());
            ds.putLO(0x100021, this.getIssuerOfPatientId());
            ds.putPN(0x100010, this.getPatientName());
            ds.putDA(0x100030, this.getPatientBirthDate());
            ds.putCS(0x100040, this.getPatientSex());
        }
        if (supplement) {
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putOB(4390928, Convert.toBytes((long)this.getPk()));
            ds.setPrivateCreatorID(null);
        }
        return ds;
    }

    public void setAttributes(Dataset ds) {
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        this.setPatientId(filter.getString(ds, 0x100020));
        this.setIssuerOfPatientId(filter.getString(ds, 0x100021));
        PersonName pn = ds.getPersonName(0x100010);
        if (pn != null) {
            PersonName ppn;
            this.setPatientName(filter.toUpperCase(pn.toComponentGroupString(false), 0x100010));
            PersonName ipn = pn.getIdeographic();
            if (ipn != null) {
                this.setPatientIdeographicName(ipn.toComponentGroupString(false));
            }
            if ((ppn = pn.getPhonetic()) != null) {
                this.setPatientPhoneticName(ppn.toComponentGroupString(false));
            }
        }
        if (AttributeFilter.isSoundexEnabled()) {
            this.setPatientFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
            this.setPatientGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
        }
        this.setPatientBirthDate(PatientBean.normalizeDA(ds.getString(0x100030)));
        this.setPatientSex(filter.getString(ds, 0x100040));
        byte[] b = DatasetUtils.toByteArray((Dataset)filter.filter(ds), (String)filter.getTransferSyntaxUID());
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "])"));
        }
        this.setEncodedAttributes(b);
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            this.setField(filter.getField(fieldTags[i]), filter.getString(ds, fieldTags[i]));
        }
    }

    private void setField(String field, String value) {
        try {
            Method m = PatientBean.class.getMethod("set" + Character.toUpperCase(field.charAt(0)) + field.substring(1), STRING_PARAM);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public void coerceAttributes(Dataset ds, Dataset coercedElements) throws DcmServiceException {
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        if (filter.isOverwrite()) {
            Dataset attrs;
            if (filter.isMerge()) {
                attrs = this.getAttributes(false);
                this.appendOtherPatientIds(attrs, ds, null, filter);
                AttrUtils.updateAttributes(attrs, filter.filter(ds).exclude(OTHER_PID_SQ), null, log);
            } else {
                log.debug((Object)"-merge update-strategy not specified.  Not synchronizing other patient ids!");
                attrs = ds;
            }
            this.setAttributes(attrs);
        } else {
            Dataset attrs = this.getAttributes(false);
            boolean b = false;
            if (filter.isMerge()) {
                b = this.appendOtherPatientIds(attrs, ds, null, filter);
            } else {
                log.debug((Object)"-merge update-strategy not specified.  Not synchronizing other patient ids!");
            }
            AttrUtils.coerceAttributes(attrs, ds, coercedElements, filter, log);
            if (filter.isMerge() && (AttrUtils.mergeAttributes(attrs, filter.filter(ds), log) || b)) {
                this.setAttributes(attrs);
            }
        }
    }

    public boolean updateAttributes(Dataset ds) {
        return this.updateAttributes(ds, null);
    }

    public boolean updateAttributes(Dataset attrs, Dataset modifiedAttrs) {
        Dataset oldAttrs = this.getAttributes(false);
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        Dataset newAttrs = filter.filter(attrs);
        boolean b = this.appendOtherPatientIds(oldAttrs, newAttrs, modifiedAttrs, filter);
        if (oldAttrs == null) {
            this.setAttributes(newAttrs);
        } else {
            if (!AttrUtils.updateAttributes(oldAttrs, newAttrs.exclude(OTHER_PID_SQ), modifiedAttrs, log) && !b) {
                return false;
            }
            this.setAttributes(oldAttrs);
        }
        return true;
    }

    private boolean appendOtherPatientIds(Dataset oldAttrs, Dataset newAttrs, Dataset modifiedAttrs, AttributeFilter filter) {
        int i;
        int n;
        DcmElement nopidsq = newAttrs.get(0x101002);
        if (nopidsq == null || nopidsq.isEmpty() || nopidsq.getItem().isEmpty()) {
            return false;
        }
        DcmElement oopidsq = oldAttrs.get(0x101002);
        if (oopidsq != null && nopidsq.equals(oopidsq)) {
            return false;
        }
        if (oopidsq == null) {
            oopidsq = oldAttrs.putSQ(0x101002);
        }
        if (modifiedAttrs != null) {
            DcmElement sq = modifiedAttrs.putSQ(0x101002);
            n = oopidsq.countItems();
            for (i = 0; i < n; ++i) {
                sq.addItem(oopidsq.getItem(i));
            }
        }
        boolean updated = false;
        n = nopidsq.countItems();
        for (i = 0; i < n; ++i) {
            Dataset nItem = nopidsq.getItem(i);
            String nopid = filter.getString(nItem, 0x100020);
            String issuer = filter.getString(nItem, 0x100021);
            Dataset oItem = this.findOtherPIDByIssuer(issuer, oopidsq);
            if (oItem == null) {
                oopidsq.addItem(nItem);
                this.getOtherPatientIds().add(this.opidHome.valueOf(nopid, issuer));
                log.info((Object)("Add additional Other Patient ID: " + nopid + "^^^" + issuer + " to " + this.prompt()));
                updated = true;
                continue;
            }
            try {
                String oopid = filter.getString(oItem, 0x100020);
                if (oopid.equals(nopid)) continue;
                oItem.putLO(0x100020, nItem.getString(0x100020));
                OtherPatientIDLocal oopidBean = this.opidHome.findByPatientIdAndIssuer(oopid, issuer);
                this.getOtherPatientIds().remove(oopidBean);
                if (oopidBean.getPatients().isEmpty()) {
                    oopidBean.remove();
                }
                this.getOtherPatientIds().add(this.opidHome.valueOf(nopid, issuer));
                log.info((Object)("Other Patient ID of " + oopid + "^^^" + issuer + " is replaced by" + nopid + "^^^" + issuer + " to " + this.prompt()));
                updated = true;
                continue;
            }
            catch (Exception onfe) {
                // empty catch block
            }
        }
        return updated;
    }

    public boolean updateOtherPatientIDs(Dataset ds) {
        String issuer;
        String pid;
        int i;
        int n;
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        Dataset attrs = this.getAttributes(false);
        DcmElement opidsq = attrs.remove(0x101002);
        DcmElement nopidsq = ds.get(0x101002);
        boolean update = false;
        if (opidsq != null) {
            n = opidsq.countItems();
            for (i = 0; i < n; ++i) {
                Dataset opid = opidsq.getItem(i);
                pid = filter.getString(opid, 0x100020);
                issuer = filter.getString(opid, 0x100021);
                if (nopidsq != null && this.containsPID(pid, issuer, nopidsq, filter)) continue;
                try {
                    OtherPatientIDLocal otherPatientId = this.opidHome.findByPatientIdAndIssuer(pid, issuer);
                    this.getOtherPatientIds().remove(otherPatientId);
                    if (otherPatientId.getPatients().isEmpty()) {
                        otherPatientId.remove();
                    }
                }
                catch (FinderException e) {
                    throw new EJBException((Exception)((Object)e));
                }
                catch (RemoveException e) {
                    throw new EJBException((Exception)((Object)e));
                }
                update = true;
                log.info((Object)("Remove Other Patient ID: " + pid + "^^^" + issuer + " from " + this.prompt()));
            }
        }
        if (nopidsq != null) {
            n = nopidsq.countItems();
            for (i = 0; i < n; ++i) {
                Dataset nopid = nopidsq.getItem(i);
                pid = filter.getString(nopid, 0x100020);
                issuer = filter.getString(nopid, 0x100021);
                if (opidsq != null && this.containsPID(pid, issuer, opidsq, filter)) continue;
                this.getOtherPatientIds().add(this.opidHome.valueOf(pid, issuer));
                update = true;
                log.info((Object)("Add additional Other Patient ID: " + pid + "^^^" + issuer + " to " + this.prompt()));
            }
            if (update) {
                opidsq = attrs.putSQ(0x101002);
                n = nopidsq.countItems();
                for (i = 0; i < n; ++i) {
                    opidsq.addItem(nopidsq.getItem(i));
                }
            }
        }
        if (update) {
            this.setAttributes(attrs);
        }
        return update;
    }

    private boolean containsPID(String pid, String issuer, DcmElement opidsq, AttributeFilter filter) {
        int n = opidsq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset opid = opidsq.getItem(i);
            if (!filter.getString(opid, 0x100020).equals(pid) || !filter.getString(opid, 0x100021).equals(issuer)) continue;
            return true;
        }
        return false;
    }

    private Dataset findOtherPIDByIssuer(String issuer, DcmElement opidsq) {
        int n = opidsq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset opid = opidsq.getItem(i);
            if (!opid.getString(0x100021).equals(issuer)) continue;
            return opid;
        }
        return null;
    }

    private static String normalizeDA(String s) {
        if (s == null) {
            return null;
        }
        String trim = s.trim();
        int l = trim.length();
        if (l == 0) {
            return null;
        }
        if (l == 10 && trim.charAt(4) == '-' && trim.charAt(7) == '-') {
            StringBuilder sb = new StringBuilder(8);
            sb.append(trim.substring(0, 4));
            sb.append(trim.substring(5, 7));
            sb.append(trim.substring(8));
            return sb.toString();
        }
        return trim;
    }

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        return "Patient[pk=" + this.getPk() + ", pid=" + this.getPatientId() + ", issuer=" + this.getIssuerOfPatientId() + ", name=" + this.getPatientName() + "]";
    }
}

