/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.PPSStatus;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocalHome;

public abstract class MPPSBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(MPPSBean.class);
    private SeriesLocalHome seriesHome;
    private CodeLocalHome codeHome;

    public void setEntityContext(EntityContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.seriesHome = (SeriesLocalHome)jndiCtx.lookup("java:comp/env/ejb/Series");
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.seriesHome = null;
        this.codeHome = null;
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getUpdatedTime();

    public abstract void setUpdatedTime(Timestamp var1);

    public abstract String getSopIuid();

    public abstract void setSopIuid(String var1);

    public abstract Timestamp getPpsStartDateTime();

    public abstract void setPpsStartDateTime(Timestamp var1);

    public void setPpsStartDateTime(Date date) {
        this.setPpsStartDateTime(date != null ? new Timestamp(date.getTime()) : null);
    }

    public abstract String getPerformedStationAET();

    public abstract void setPerformedStationAET(String var1);

    public abstract String getModality();

    public abstract void setModality(String var1);

    public abstract String getAccessionNumber();

    public abstract void setAccessionNumber(String var1);

    public abstract int getPpsStatusAsInt();

    public abstract void setPpsStatusAsInt(int var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract void setPatient(PatientLocal var1);

    public abstract PatientLocal getPatient();

    public abstract void setSeries(Collection var1);

    public abstract Collection getSeries();

    public abstract void setDrCode(CodeLocal var1);

    public abstract CodeLocal getDrCode();

    public Long ejbCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setSopIuid(ds.getString(524312));
        return null;
    }

    public void ejbPostCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setPatient(patient);
        this.setAttributes(ds);
        try {
            this.setSeries(this.seriesHome.findByPpsIuid(this.getSopIuid()));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        log.info((Object)("Created " + this.asString()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.asString()));
    }

    public boolean isInProgress() {
        return this.getPpsStatusAsInt() == 0;
    }

    public boolean isCompleted() {
        return this.getPpsStatusAsInt() == 1;
    }

    public boolean isDiscontinued() {
        return this.getPpsStatusAsInt() == 2;
    }

    public String getPpsStatus() {
        return PPSStatus.toString((int)this.getPpsStatusAsInt());
    }

    public void setPpsStatus(String status) {
        this.setPpsStatusAsInt(PPSStatus.toInt((String)status));
    }

    public String asString() {
        return "MPPS[pk=" + this.getPk() + ", iuid=" + this.getSopIuid() + ", status=" + this.getPpsStatus() + ", patient->" + this.getPatient() + "]";
    }

    public Dataset getAttributes() {
        return DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
    }

    public void setAttributes(Dataset ds) {
        this.setPpsStartDateTime(ds.getDateTime(0x400244, 4194885));
        this.setPerformedStationAET(ds.getString(4194881));
        this.setModality(ds.getString(524384));
        this.setPpsStatus(ds.getString(4194898));
        Dataset ssa = ds.getItem(4194928);
        this.setAccessionNumber(ssa.getString(524368));
        try {
            this.setDrCode(CodeBean.valueOf(this.codeHome, ds.getItem(4194945)));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        AttributeFilter filter = AttributeFilter.getExcludePatientAttributeFilter();
        byte[] b = DatasetUtils.toByteArray((Dataset)filter.filter(ds), (String)filter.getTransferSyntaxUID());
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "])"));
        }
        this.setEncodedAttributes(b);
    }

    public boolean isIncorrectWorklistEntrySelected() {
        CodeLocal drcode = this.getDrCode();
        return drcode != null && "110514".equals(drcode.getCodeValue()) && "DCM".equals(drcode.getCodingSchemeDesignator());
    }

    public abstract Collection ejbSelectMppsIuidsByStudyIuid(String var1) throws FinderException;

    public Collection ejbHomeMppsIuidsByStudyIuid(String suid) throws FinderException {
        return this.ejbSelectMppsIuidsByStudyIuid(suid);
    }

    public abstract Collection ejbSelectMppsByStudyIuid(String var1) throws FinderException;

    public Collection ejbHomeMppsByStudyIuid(String suid) throws FinderException {
        return this.ejbSelectMppsByStudyIuid(suid);
    }
}

