/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.ejb.interfaces.IssuerLocal;
import org.dcm4chex.archive.ejb.interfaces.IssuerLocalHome;

public abstract class IssuerBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(IssuerBean.class);

    public static IssuerLocal valueOf(IssuerLocalHome issuerHome, Dataset item) throws CreateException, FinderException {
        IssuerLocal issuer;
        if (item == null) {
            return null;
        }
        String id = item.getString(4194353);
        String uid = item.getString(4194354);
        String type = item.getString(0x400033);
        if (uid == null) {
            if (id == null) {
                throw new IllegalArgumentException("Missing Local Name Space and Universal Entity ID");
            }
        } else if (type == null) {
            throw new IllegalArgumentException("Missing Universal Entity ID Type");
        }
        if (uid != null) {
            try {
                issuer = issuerHome.findByUniversalEntityID(uid, type);
                if (id != null) {
                    String eid = issuer.getLocalNamespaceEntityID();
                    if (eid == null) {
                        issuer.setLocalNamespaceEntityID(id);
                        log.info((Object)("Update " + issuer.asString()));
                    } else if (!id.equals(eid)) {
                        throw new CreateException("Existing " + issuer.asString() + " Issuer with given Universal Entity ID" + " but different Local Namespace Entity ID");
                    }
                }
            }
            catch (ObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        if (id != null) {
            try {
                issuer = issuerHome.findByLocalNamespaceEntityID(id);
                if (uid != null && type != null) {
                    String euid = issuer.getUniversalEntityID();
                    String etype = issuer.getUniversalEntityIDType();
                    if (euid == null) {
                        issuer.setUniversalEntityID(uid);
                        issuer.setUniversalEntityIDType(type);
                        log.info((Object)("Update " + issuer.asString()));
                    } else if (!uid.equals(euid) || !type.equals(etype)) {
                        throw new CreateException("Existing " + issuer.asString() + " with given Local Namespace Entity ID" + " but different Universal Entity ID");
                    }
                }
                return issuer;
            }
            catch (ObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        return issuerHome.create(id, uid, type);
    }

    public Long ejbCreate(String id, String uid, String type) throws CreateException {
        this.setLocalNamespaceEntityID(id);
        this.setUniversalEntityID(uid);
        this.setUniversalEntityIDType(type);
        return null;
    }

    public void ejbPostCreate(String value, String designator, String version, String meaning) throws CreateException {
        log.info((Object)("Created " + this.prompt()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public abstract Long getPk();

    public abstract String getLocalNamespaceEntityID();

    public abstract void setLocalNamespaceEntityID(String var1);

    public abstract String getUniversalEntityID();

    public abstract void setUniversalEntityID(String var1);

    public abstract String getUniversalEntityIDType();

    public abstract void setUniversalEntityIDType(String var1);

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        return "Issuer[pk=" + this.getPk() + ", id=" + this.getLocalNamespaceEntityID() + ", uid=" + this.getUniversalEntityID() + ", type=" + this.getUniversalEntityIDType() + "]";
    }
}

