/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.AttrUtils;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.ContentItemLocal;
import org.dcm4chex.archive.ejb.interfaces.ContentItemLocalHome;
import org.dcm4chex.archive.ejb.interfaces.MediaLocal;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;
import org.dcm4chex.archive.ejb.interfaces.SeriesLocal;
import org.dcm4chex.archive.ejb.interfaces.VerifyingObserverLocal;
import org.dcm4chex.archive.ejb.interfaces.VerifyingObserverLocalHome;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.util.AETs;
import org.dcm4chex.archive.util.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstanceBean
implements EntityBean {
    private static final int DEFAULT_IN_LIST_SIZE = 200;
    private static final Logger log = Logger.getLogger(InstanceBean.class);
    private static final Class[] STRING_PARAM = new Class[]{String.class};
    private CodeLocalHome codeHome;
    private VerifyingObserverLocalHome observerHome;
    private ContentItemLocalHome contentItemHome;

    public void setEntityContext(EntityContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
            this.observerHome = (VerifyingObserverLocalHome)jndiCtx.lookup("java:comp/env/ejb/VerifyingObserver");
            this.contentItemHome = (ContentItemLocalHome)jndiCtx.lookup("java:comp/env/ejb/ContentItem");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.codeHome = null;
        this.observerHome = null;
        this.contentItemHome = null;
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract Timestamp getCreatedTime();

    public abstract void setCreatedTime(Timestamp var1);

    public abstract Timestamp getUpdatedTime();

    public abstract void setUpdatedTime(Timestamp var1);

    public abstract String getSopIuid();

    public abstract void setSopIuid(String var1);

    public abstract String getSopCuid();

    public abstract void setSopCuid(String var1);

    public abstract String getInstanceNumber();

    public abstract void setInstanceNumber(String var1);

    public abstract Timestamp getContentDateTime();

    public abstract void setContentDateTime(Timestamp var1);

    private void setContentDateTime(Date date) {
        this.setContentDateTime(date != null ? new Timestamp(date.getTime()) : null);
    }

    public abstract String getSrCompletionFlag();

    public abstract void setSrCompletionFlag(String var1);

    public abstract String getSrVerificationFlag();

    public abstract void setSrVerificationFlag(String var1);

    public abstract String getInstanceCustomAttribute1();

    public abstract void setInstanceCustomAttribute1(String var1);

    public abstract String getInstanceCustomAttribute2();

    public abstract void setInstanceCustomAttribute2(String var1);

    public abstract String getInstanceCustomAttribute3();

    public abstract void setInstanceCustomAttribute3(String var1);

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract String getExternalRetrieveAET();

    public abstract void setExternalRetrieveAET(String var1);

    public abstract String getRetrieveAETs();

    public abstract void setRetrieveAETs(String var1);

    public abstract int getAvailability();

    public int getAvailabilitySafe() {
        try {
            return this.getAvailability();
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public abstract void setAvailability(int var1);

    public abstract int getInstanceStatus();

    public abstract void setInstanceStatus(int var1);

    public abstract boolean getArchived();

    public abstract void setArchived(boolean var1);

    public abstract boolean getAllAttributes();

    public abstract void setAllAttributes(boolean var1);

    public abstract boolean getCommitment();

    public boolean getCommitmentSafe() {
        try {
            return this.getCommitment();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public abstract void setCommitment(boolean var1);

    public abstract void setSeries(SeriesLocal var1);

    public abstract SeriesLocal getSeries();

    public abstract Collection getFiles();

    public abstract void setFiles(Collection var1);

    public abstract MediaLocal getMedia();

    public abstract void setMedia(MediaLocal var1);

    public abstract void setSrCode(CodeLocal var1);

    public abstract CodeLocal getSrCode();

    public abstract Collection<VerifyingObserverLocal> getVerifyingObservers();

    public abstract void setVerifyingObservers(Collection<VerifyingObserverLocal> var1);

    public abstract Collection<ContentItemLocal> getContentItems();

    public abstract void setContentItems(Collection<ContentItemLocal> var1);

    public Long ejbCreate(Dataset ds, SeriesLocal series) throws CreateException {
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds, SeriesLocal series) throws CreateException {
        this.updateSrCode(null, ds.getItem(4235331));
        this.updateVerifyingObservers(null, ds.get(4235379));
        this.updateContentItems(ds.get(4237104));
        this.setSeries(series);
        this.setArchived(false);
        log.info((Object)("Created " + this.prompt()));
    }

    private boolean updateSrCode(Dataset oldSrCode, Dataset newSrCode) {
        if (oldSrCode == null ? newSrCode == null : oldSrCode.equals(newSrCode)) {
            return false;
        }
        try {
            this.setSrCode(newSrCode == null ? null : CodeBean.valueOf(this.codeHome, newSrCode));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return true;
    }

    private boolean updateVerifyingObservers(DcmElement oldObservers, DcmElement newObservers) {
        if (oldObservers == null || oldObservers.isEmpty() ? newObservers == null || newObservers.isEmpty() : oldObservers.equals(newObservers)) {
            return false;
        }
        try {
            Iterator<VerifyingObserverLocal> iter = new ArrayList<VerifyingObserverLocal>(this.getVerifyingObservers()).iterator();
            while (iter.hasNext()) {
                iter.next().remove();
            }
            Collection<VerifyingObserverLocal> c = this.getVerifyingObservers();
            if (newObservers != null) {
                int n = newObservers.countItems();
                for (int i = 0; i < n; ++i) {
                    c.add(this.observerHome.create(newObservers.getItem(i)));
                }
            }
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return true;
    }

    private void updateContentItems(DcmElement items) {
        Collection<ContentItemLocal> c = this.getContentItems();
        if (!c.isEmpty()) {
            for (ContentItemLocal item : new ArrayList<ContentItemLocal>(c)) {
                try {
                    item.remove();
                }
                catch (RemoveException e) {
                    throw new EJBException((Exception)((Object)e));
                }
            }
            c = this.getContentItems();
        }
        if (items == null) {
            return;
        }
        int n = items.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = items.getItem(i);
            String valueType = item.getString(0x40A040);
            if (!"CODE".equals(valueType) && !"TEXT".equals(valueType)) continue;
            try {
                c.add(this.contentItemHome.create(item));
                continue;
            }
            catch (CreateException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public abstract Set ejbSelectRetrieveAETs(Long var1) throws FinderException;

    public void addRetrieveAET(String aet) {
        String s = this.getRetrieveAETs();
        if (s == null) {
            this.setRetrieveAETs(aet);
        } else {
            HashSet<String> aetSet = new HashSet<String>(Arrays.asList(StringUtils.split((String)s, (char)'\\')));
            if (aetSet.add(aet)) {
                this.setRetrieveAETs(InstanceBean.toString(aetSet));
            }
        }
    }

    public boolean updateRetrieveAETs() {
        String aets;
        Set aetSet;
        try {
            aetSet = this.ejbSelectRetrieveAETs(this.getPk());
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        if (aetSet.remove(null)) {
            log.warn((Object)("Instance[iuid=" + this.getSopIuid() + "] reference File(s) with unspecified Retrieve AET"));
        }
        if ((aets = InstanceBean.toString(aetSet)) == null ? this.getRetrieveAETs() == null : aets.equals(this.getRetrieveAETs())) {
            return false;
        }
        this.setRetrieveAETs(aets);
        return true;
    }

    public abstract int ejbSelectLocalAvailability(Long var1) throws FinderException;

    public boolean updateAvailability(int availabilityOfExternalRetrieveable) {
        int prevAvailability;
        MediaLocal media;
        int availability = 3;
        if (this.getRetrieveAETs() != null) {
            try {
                availability = this.ejbSelectLocalAvailability(this.getPk());
            }
            catch (FinderException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
        if (this.getExternalRetrieveAET() != null) {
            availability = Math.min(availability, availabilityOfExternalRetrieveable);
        }
        if (availability == 3 && (media = this.getMedia()) != null && media.getMediaStatus() == 4) {
            availability = 2;
        }
        if (availability == (prevAvailability = this.getAvailabilitySafe())) {
            return false;
        }
        this.setAvailability(availability);
        if (log.isDebugEnabled()) {
            log.debug((Object)("update Availability of Instance[pk=" + this.getPk() + ", uid=" + this.getSopIuid() + "] from " + Availability.toString((int)prevAvailability) + " to " + Availability.toString((int)availability)));
        }
        return true;
    }

    public void updateRetrieveAETs(String oldAET, String newAET) {
        this.setRetrieveAETs(AETs.update((String)this.getRetrieveAETs(), (String)oldAET, (String)newAET));
    }

    public boolean updateAttributes(Dataset newAttrs, Dataset modifiedAttrs) {
        Dataset oldAttrs = this.getAttributes(false);
        Dataset newCode = newAttrs.getItem(4235331);
        if (newCode != null) {
            this.updateSrCode(oldAttrs.getItem(4235331), newCode);
        }
        this.updateVerifyingObservers(oldAttrs.get(4235379), newAttrs.get(4235379));
        AttributeFilter filter = AttributeFilter.getInstanceAttributeFilter((String)newAttrs.getString(524310, oldAttrs.getString(524310)));
        this.updateContentItems(newAttrs.get(4237104));
        if (!AttrUtils.updateAttributes(oldAttrs, filter.filter(newAttrs), modifiedAttrs, log)) {
            return false;
        }
        this.setAttributes(oldAttrs);
        return true;
    }

    private static String toString(Set s) {
        if (s.isEmpty()) {
            return null;
        }
        String[] a = s.toArray(new String[s.size()]);
        return StringUtils.toString((String[])a, (char)'\\');
    }

    public Dataset getAttributes(boolean supplement) {
        Dataset ds = DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
        if (ds.isEmpty()) {
            log.warn((Object)("Empty Dataset in Instance BLOB (pk:" + this.getPk() + ")! Use Dataset with DB values"));
            ds = DcmObjectFactory.getInstance().newDataset();
            ds.putUI(524312, this.getSopIuid());
            ds.putUI(524310, this.getSopCuid());
            ds.putIS(2097171, this.getInstanceNumber());
            ds.putDA(524323, (Date)this.getContentDateTime());
            ds.putTM(524339, (Date)this.getContentDateTime());
            ds.putCS(4236433, this.getSrCompletionFlag());
            ds.putCS(4236435, this.getSrVerificationFlag());
        }
        if (supplement) {
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putOB(4390931, Convert.toBytes((long)this.getPk()));
            ds.setPrivateCreatorID(null);
            MediaLocal media = this.getMedia();
            if (media != null && media.getMediaStatus() == 4) {
                ds.putSH(8913200, media.getFilesetId());
                ds.putUI(8913216, media.getFilesetIuid());
            }
            DatasetUtils.putRetrieveAET((Dataset)ds, (String)this.getRetrieveAETs(), (String)this.getExternalRetrieveAET());
            ds.putCS(524374, Availability.toString((int)this.getAvailabilitySafe()));
        }
        return ds;
    }

    public void setAttributes(Dataset ds) {
        String cuid = ds.getString(524310);
        AttributeFilter filter = AttributeFilter.getInstanceAttributeFilter((String)cuid);
        this.setAllAttributes(filter.isNoFilter());
        this.setSopIuid(ds.getString(524312));
        this.setSopCuid(ds.getString(524310));
        this.setInstanceNumber(filter.getString(ds, 2097171));
        try {
            this.setContentDateTime(ds.getDateTime(524323, 524339));
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Illegal Content Date/Time format: " + e.getMessage()));
        }
        this.setSrCompletionFlag(filter.getString(ds, 4236433));
        this.setSrVerificationFlag(filter.getString(ds, 4236435));
        byte[] b = DatasetUtils.toByteArray((Dataset)filter.filter(ds), (String)filter.getTransferSyntaxUID());
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEncodedAttributes(byte[" + b.length + "])"));
        }
        this.setEncodedAttributes(b);
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            this.setField(filter.getField(fieldTags[i]), filter.getString(ds, fieldTags[i]));
        }
    }

    private void setField(String field, String value) {
        try {
            Method m = InstanceBean.class.getMethod("set" + Character.toUpperCase(field.charAt(0)) + field.substring(1), STRING_PARAM);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public void coerceAttributes(Dataset ds, Dataset coercedElements) throws DcmServiceException {
        String cuid = ds.getString(524310);
        AttributeFilter filter = AttributeFilter.getInstanceAttributeFilter((String)cuid);
        Dataset attrs = this.getAttributes(false);
        Dataset oldSrCode = attrs.getItem(4235331);
        DcmElement oldObservers = attrs.get(4235379);
        if (filter.isOverwrite()) {
            if (filter.isMerge()) {
                AttrUtils.updateAttributes(attrs, filter.filter(ds), null, log);
            } else {
                attrs = ds;
            }
        } else {
            AttrUtils.coerceAttributes(attrs, ds, coercedElements, filter, log);
            if (!filter.isMerge() || !AttrUtils.mergeAttributes(attrs, filter.filter(ds), log)) {
                return;
            }
        }
        this.setAttributes(attrs);
        this.updateSrCode(oldSrCode, attrs.getItem(4235331));
        this.updateVerifyingObservers(oldObservers, attrs.get(4235379));
        this.updateContentItems(attrs.get(4237104));
    }

    public abstract Collection ejbSelectGeneric(String var1, Object[] var2) throws FinderException;

    public Collection ejbHomeListByIUIDs(String[] iuids) throws FinderException {
        Collection c;
        if (iuids == null || iuids.length < 1) {
            return new ArrayList();
        }
        log.debug((Object)("List by IUIDs:" + iuids.length));
        long t0 = System.currentTimeMillis();
        if (iuids.length > 200) {
            int idx;
            String jbossQl = this.getByIUIDsQueryString(200);
            Object[] uids = new String[200];
            System.arraycopy(iuids, 0, uids, 0, 200);
            int maxIdx = iuids.length - 200;
            c = this.ejbSelectGeneric(jbossQl, uids);
            log.debug((Object)("First chunked query:" + c.size()));
            for (idx = 200; idx < maxIdx; idx += 200) {
                System.arraycopy(iuids, idx, uids, 0, 200);
                c.addAll(this.ejbSelectGeneric(jbossQl, uids));
                log.debug((Object)("chunked query (idx:" + idx + "):" + c.size()));
            }
            if (idx < iuids.length) {
                int remain = iuids.length - idx;
                jbossQl = this.getByIUIDsQueryString(remain);
                uids = new String[remain];
                System.arraycopy(iuids, idx, uids, 0, remain);
                c.addAll(this.ejbSelectGeneric(jbossQl, uids));
                log.debug((Object)("Remain chunked query(remain:" + remain + "):" + c.size()));
            }
        } else {
            String jbossQl = this.getByIUIDsQueryString(iuids.length);
            c = this.ejbSelectGeneric(jbossQl, iuids);
        }
        log.debug((Object)("Total time:" + (System.currentTimeMillis() - t0)));
        return c;
    }

    private String getByIUIDsQueryString(int size) {
        StringBuffer sb = new StringBuffer("SELECT OBJECT(i) FROM Instance i");
        sb.append(" WHERE i.sopIuid");
        this.addIN(sb, 1, size);
        log.debug((Object)("Execute JBossQL: " + sb));
        return sb.toString();
    }

    public Collection ejbHomeListByPatientAndSRCode(PatientLocal pat, Collection srCodes, Collection cuids) throws FinderException {
        StringBuffer jbossQl = new StringBuffer("SELECT OBJECT(i) FROM Instance i");
        jbossQl.append(" WHERE i.series.study.patient = ?1");
        ArrayList<PatientLocal> params = new ArrayList<PatientLocal>();
        params.add(pat);
        int idx = 2;
        if (srCodes != null && srCodes.size() > 0) {
            jbossQl.append(" AND i.srCode.pk");
            idx = this.addIN(jbossQl, idx, srCodes.size());
            params.addAll(srCodes);
        }
        if (cuids != null && cuids.size() > 0) {
            jbossQl.append(" AND i.sopCuid");
            idx = this.addIN(jbossQl, idx, cuids.size());
            params.addAll(cuids);
        }
        log.debug((Object)("Execute JBossQL: " + jbossQl));
        return this.ejbSelectGeneric(jbossQl.toString(), params.toArray());
    }

    private int addIN(StringBuffer jbossQl, int idx, int len) {
        if (len > 1) {
            jbossQl.append(" IN ( ");
            for (int i = 1; i < len; ++i) {
                jbossQl.append("?").append(idx++).append(", ");
            }
            jbossQl.append("?").append(idx++).append(")");
        } else {
            jbossQl.append(" = ?").append(idx++);
        }
        return idx;
    }

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        return "Instance[pk=" + this.getPk() + ", iuid=" + this.getSopIuid() + ", cuid=" + this.getSopCuid() + ", series->" + this.getSeries() + "]";
    }
}

