/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.PersonName;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.GPSPSLocal;

public abstract class GPSPSPerformerBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(GPSPSPerformerBean.class);
    private CodeLocalHome codeHome;

    public void setEntityContext(EntityContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.codeHome = null;
    }

    public Long ejbCreate(Dataset ds, GPSPSLocal gpsps) throws CreateException {
        PersonName pn = ds.getPersonName(4210743);
        if (pn != null) {
            PersonName ppn;
            this.setHumanPerformerName(GPSPSPerformerBean.toUpperCase(pn.toComponentGroupString(false)));
            PersonName ipn = pn.getIdeographic();
            if (ipn != null) {
                this.setHumanPerformerIdeographicName(ipn.toComponentGroupString(false));
            }
            if ((ppn = pn.getPhonetic()) != null) {
                this.setHumanPerformerPhoneticName(ppn.toComponentGroupString(false));
            }
        }
        if (AttributeFilter.isSoundexEnabled()) {
            this.setHumanPerformerFamilyNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)0, (String)"*"));
            this.setHumanPerformerGivenNameSoundex(AttributeFilter.toSoundex((PersonName)pn, (int)1, (String)"*"));
        }
        return null;
    }

    private static String toUpperCase(String s) {
        return s != null ? s.toUpperCase() : null;
    }

    public void ejbPostCreate(Dataset ds, GPSPSLocal gpsps) throws CreateException {
        try {
            this.setHumanPerformerCode(CodeBean.valueOf(this.codeHome, ds.getItem(0x404009)));
        }
        catch (CreateException e) {
            throw new CreateException(e.getMessage());
        }
        catch (FinderException e) {
            throw new CreateException(e.getMessage());
        }
        this.setGpsps(gpsps);
        log.info((Object)("Created " + this.prompt()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract String getHumanPerformerName();

    public abstract void setHumanPerformerName(String var1);

    public abstract String getHumanPerformerFamilyNameSoundex();

    public abstract void setHumanPerformerFamilyNameSoundex(String var1);

    public abstract String getHumanPerformerGivenNameSoundex();

    public abstract void setHumanPerformerGivenNameSoundex(String var1);

    public abstract String getHumanPerformerIdeographicName();

    public abstract void setHumanPerformerIdeographicName(String var1);

    public abstract String getHumanPerformerPhoneticName();

    public abstract void setHumanPerformerPhoneticName(String var1);

    public abstract CodeLocal getHumanPerformerCode();

    public abstract void setHumanPerformerCode(CodeLocal var1);

    public abstract GPSPSLocal getGpsps();

    public abstract void setGpsps(GPSPSLocal var1);

    private String prompt() {
        return "GPSPSHumanPerformer[pk=" + this.getPk() + ", name=" + this.getHumanPerformerName() + ", code->" + this.getHumanPerformerCode() + ", gpsps->" + this.getGpsps() + "]";
    }
}

