/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.GPSPSStatus;
import org.dcm4chex.archive.common.InputAvailabilityFlag;
import org.dcm4chex.archive.common.Priority;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;
import org.dcm4chex.archive.ejb.interfaces.GPSPSLocal;
import org.dcm4chex.archive.ejb.interfaces.GPSPSPerformerLocalHome;
import org.dcm4chex.archive.ejb.interfaces.GPSPSRequestLocalHome;
import org.dcm4chex.archive.ejb.interfaces.PatientLocal;

public abstract class GPSPSBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(GPSPSBean.class);
    private String spsIdPrefix;
    private EntityContext ejbctx;
    private CodeLocalHome codeHome;
    private GPSPSRequestLocalHome rqHome;
    private GPSPSPerformerLocalHome performerHome;

    private static Timestamp toTimestamp(Date date) {
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    public void setEntityContext(EntityContext ctx) {
        this.ejbctx = ctx;
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.spsIdPrefix = (String)jndiCtx.lookup("java:comp/env/SpsIdPrefix");
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
            this.rqHome = (GPSPSRequestLocalHome)jndiCtx.lookup("java:comp/env/ejb/Request");
            this.performerHome = (GPSPSPerformerLocalHome)jndiCtx.lookup("java:comp/env/ejb/Performer");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.codeHome = null;
        this.rqHome = null;
        this.performerHome = null;
        this.ejbctx = null;
    }

    public Long ejbCreate(Dataset ds, PatientLocal patient) throws CreateException {
        this.setAttributes(ds);
        return null;
    }

    public void ejbPostCreate(Dataset ds, PatientLocal patient) throws CreateException {
        if (ds.getString(0x400009) == null) {
            String id = this.spsIdPrefix + this.getPk();
            ds.putSH(0x400009, id);
            this.setEncodedAttributes(DatasetUtils.toByteArray((Dataset)ds, (String)"1.2.840.10008.1.2.1.99"));
        }
        this.setPatient(patient);
        try {
            this.setScheduledWorkItemCode(CodeBean.valueOf(this.codeHome, ds.getItem(4210712)));
            CodeBean.addCodesTo(this.codeHome, ds.get(0x404004), this.getScheduledProcessingApplicationsCodes());
            CodeBean.addCodesTo(this.codeHome, ds.get(4210725), this.getScheduledStationNameCodes());
            CodeBean.addCodesTo(this.codeHome, ds.get(4210726), this.getScheduledStationClassCodes());
            CodeBean.addCodesTo(this.codeHome, ds.get(4210727), this.getScheduledStationGeographicLocationCodes());
            this.createScheduledHumanPerformers(ds.get(0x404034));
            this.createRefRequests(ds.get(4236144));
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        log.info((Object)("Created " + this.prompt()));
        if (log.isDebugEnabled()) {
            log.debug((Object)ds);
        }
    }

    private void createScheduledHumanPerformers(DcmElement sq) throws CreateException {
        if (sq == null) {
            return;
        }
        Collection c = this.getScheduledHumanPerformers();
        GPSPSLocal gpsps = (GPSPSLocal)this.ejbctx.getEJBLocalObject();
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            c.add(this.performerHome.create(sq.getItem(i), gpsps));
        }
    }

    private void createRefRequests(DcmElement sq) throws CreateException {
        if (sq == null) {
            return;
        }
        Collection c = this.getRefRequests();
        GPSPSLocal gpsps = (GPSPSLocal)this.ejbctx.getEJBLocalObject();
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            c.add(this.rqHome.create(sq.getItem(i), gpsps));
        }
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract String getSopIuid();

    public abstract void setSopIuid(String var1);

    public abstract String getTransactionUid();

    public abstract void setTransactionUid(String var1);

    public abstract Timestamp getSpsStartDateTime();

    public abstract void setSpsStartDateTime(Timestamp var1);

    public abstract Timestamp getExpectedCompletionDateTime();

    public abstract void setExpectedCompletionDateTime(Timestamp var1);

    public abstract int getGpspsStatusAsInt();

    public abstract void setGpspsStatusAsInt(int var1);

    public String getGpspsStatus() {
        return GPSPSStatus.toString((int)this.getGpspsStatusAsInt());
    }

    public void setGpspsStatus(String status) {
        this.setGpspsStatusAsInt(GPSPSStatus.toInt((String)status));
    }

    public boolean isScheduled() {
        return this.getGpspsStatusAsInt() == 0;
    }

    public boolean isInProgress() {
        return this.getGpspsStatusAsInt() == 1;
    }

    public boolean isSuspended() {
        return this.getGpspsStatusAsInt() == 2;
    }

    public boolean isCompleted() {
        return this.getGpspsStatusAsInt() == 3;
    }

    public boolean isDiscontinued() {
        return this.getGpspsStatusAsInt() == 4;
    }

    public abstract int getGpspsPriorityAsInt();

    public abstract void setGpspsPriorityAsInt(int var1);

    public String getGpspsPriority() {
        return Priority.toString((int)this.getGpspsPriorityAsInt());
    }

    public void setGpspsPriority(String prior) {
        this.setGpspsPriorityAsInt(Priority.toInt((String)prior));
    }

    public abstract int getInputAvailabilityFlagAsInt();

    public abstract void setInputAvailabilityFlagAsInt(int var1);

    public String getInputAvailabilityFlag() {
        return InputAvailabilityFlag.toString((int)this.getInputAvailabilityFlagAsInt());
    }

    public void setInputAvailabilityFlag(String availability) {
        this.setInputAvailabilityFlagAsInt(InputAvailabilityFlag.toInt((String)availability));
    }

    public abstract byte[] getEncodedAttributes();

    public abstract void setEncodedAttributes(byte[] var1);

    public abstract void setPatient(PatientLocal var1);

    public abstract PatientLocal getPatient();

    public abstract void setGppps(Collection var1);

    public abstract Collection getGppps();

    public abstract CodeLocal getScheduledWorkItemCode();

    public abstract void setScheduledWorkItemCode(CodeLocal var1);

    public abstract Collection getScheduledProcessingApplicationsCodes();

    public abstract void setScheduledProcessingApplicationsCodes(Collection var1);

    public abstract Collection getScheduledStationNameCodes();

    public abstract void setScheduledStationNameCodes(Collection var1);

    public abstract Collection getScheduledStationClassCodes();

    public abstract void setScheduledStationClassCodes(Collection var1);

    public abstract Collection getScheduledStationGeographicLocationCodes();

    public abstract void setScheduledStationGeographicLocationCodes(Collection var1);

    public abstract Collection getScheduledHumanPerformers();

    public abstract void setScheduledHumanPerformers(Collection var1);

    public abstract Collection getRefRequests();

    public abstract void setRefRequests(Collection var1);

    public Dataset getAttributes() {
        return DatasetUtils.fromByteArray((byte[])this.getEncodedAttributes());
    }

    public void setAttributes(Dataset ds) {
        this.setSopIuid(ds.getString(524312));
        this.setGpspsStatus(ds.getString(0x404001));
        this.setGpspsPriority(ds.getString(0x404003));
        this.setInputAvailabilityFlag(ds.getString(0x404020));
        this.setSpsStartDateTime(GPSPSBean.toTimestamp(ds.getDate(0x404005)));
        this.setExpectedCompletionDateTime(GPSPSBean.toTimestamp(ds.getDate(0x404011)));
        AttributeFilter filter = AttributeFilter.getExcludePatientAttributeFilter();
        this.setEncodedAttributes(DatasetUtils.toByteArray((Dataset)filter.filter(ds), (String)filter.getTransferSyntaxUID()));
    }

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        return "GPSPS[pk=" + this.getPk() + ", iuid=" + this.getSopIuid() + ", pat->" + this.getPatient() + "]";
    }
}

