/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.FileSystemStatus;
import org.dcm4chex.archive.ejb.interfaces.FileSystemDTO;
import org.dcm4chex.archive.ejb.interfaces.FileSystemLocal;

public abstract class FileSystemBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(FileSystemBean.class);
    private EntityContext ctx;

    public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
        this.ctx = ctx;
    }

    public void unsetEntityContext() throws EJBException, RemoteException {
        this.ctx = null;
    }

    public Long ejbCreate(FileSystemDTO dto) throws CreateException {
        this.fromDTO(dto);
        return null;
    }

    public void ejbPostCreate(FileSystemDTO dto) throws CreateException {
        log.info((Object)("Created " + this.asString()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.asString()));
    }

    public abstract int ejbSelectNumberOfFiles(Long var1) throws FinderException;

    public int countFiles() throws FinderException {
        return this.ejbSelectNumberOfFiles(this.getPk());
    }

    public abstract int ejbSelectNumberOfPrivateFiles(Long var1) throws FinderException;

    public abstract Long ejbSelectSizeOfFilesCreatedAfter(Long var1, Timestamp var2) throws FinderException;

    public long ejbHomeSizeOfFilesCreatedAfter(Long pk, Timestamp createdAfter) throws FinderException {
        try {
            Long sum = this.ejbSelectSizeOfFilesCreatedAfter(pk, createdAfter);
            return sum != null ? sum : 0L;
        }
        catch (Exception e) {
            log.info((Object)"Failed - assume no matching file records");
            return 0L;
        }
    }

    public abstract Collection ejbSelectAllRetrieveAETs() throws FinderException;

    public Collection ejbHomeAllRetrieveAETs() throws FinderException {
        return this.ejbSelectAllRetrieveAETs();
    }

    public int countPrivateFiles() throws FinderException {
        return this.ejbSelectNumberOfPrivateFiles(this.getPk());
    }

    public abstract Timestamp ejbSelectMinCreatedTimeOnFsWithFileStatus(String var1, int var2) throws FinderException;

    public Timestamp ejbHomeMinCreatedTimeOnFsWithFileStatus(String dirPath, int status) throws FinderException {
        try {
            return this.ejbSelectMinCreatedTimeOnFsWithFileStatus(dirPath, status);
        }
        catch (Exception e) {
            log.info((Object)"Failed - assume no matching file records");
            return null;
        }
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileSystem[pk=").append(this.getPk());
        sb.append(", ").append(this.getDirectoryPath());
        sb.append(", groupID=").append(this.getGroupID());
        sb.append(", aet=").append(this.getRetrieveAET());
        sb.append(", ").append(Availability.toString((int)this.getAvailability()));
        sb.append(", ").append(FileSystemStatus.toString((int)this.getStatus()));
        sb.append(", userinfo=").append(this.getUserInfo());
        FileSystemLocal next = this.getNextFileSystem();
        if (next != null) {
            sb.append(", next=").append(next.getDirectoryPath());
        }
        sb.append("]");
        return sb.toString();
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract String getDirectoryPath();

    public abstract void setDirectoryPath(String var1);

    public abstract String getGroupID();

    public abstract void setGroupID(String var1);

    public abstract String getRetrieveAET();

    public abstract void setRetrieveAET(String var1);

    public abstract int getAvailability();

    public abstract void setAvailability(int var1);

    public int getAvailabilitySafe() {
        try {
            return this.getAvailability();
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public abstract int getStatus();

    public abstract void setStatus(int var1);

    public abstract String getUserInfo();

    public abstract void setUserInfo(String var1);

    public abstract FileSystemLocal getNextFileSystem();

    public abstract void setNextFileSystem(FileSystemLocal var1);

    public abstract Collection getPreviousFileSystems();

    public abstract void setPreviousFileSystems(Collection var1);

    public void fromDTO(FileSystemDTO dto) {
        this.setDirectoryPath(dto.getDirectoryPath());
        this.setGroupID(dto.getGroupID());
        this.setRetrieveAET(dto.getRetrieveAET());
        this.setAvailability(dto.getAvailability());
        this.setStatus(dto.getStatus());
        this.setUserInfo(dto.getUserInfo());
    }

    public FileSystemDTO toDTO() {
        FileSystemDTO dto = new FileSystemDTO();
        dto.setPk(this.getPk().longValue());
        dto.setDirectoryPath(this.getDirectoryPath());
        dto.setGroupID(this.getGroupID());
        dto.setRetrieveAET(this.getRetrieveAET());
        dto.setAvailability(this.getAvailability());
        dto.setStatus(this.getStatus());
        dto.setUserInfo(this.getUserInfo());
        FileSystemLocal next = this.getNextFileSystem();
        if (next != null) {
            String nextPath = next.isIdentical(this.ctx.getEJBLocalObject()) ? this.getDirectoryPath() : next.getDirectoryPath();
            dto.setNext(nextPath);
        }
        return dto;
    }
}

