/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.dcm4che.data.Dataset;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.entity.CodeBean;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;

public abstract class ContentItemBean
implements EntityBean {
    private CodeLocalHome codeHome;

    public void setEntityContext(EntityContext ctx) {
        InitialContext jndiCtx = null;
        try {
            jndiCtx = new InitialContext();
            this.codeHome = (CodeLocalHome)jndiCtx.lookup("java:comp/env/ejb/Code");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            if (jndiCtx != null) {
                try {
                    jndiCtx.close();
                }
                catch (NamingException ignore) {}
            }
        }
    }

    public void unsetEntityContext() {
        this.codeHome = null;
    }

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract String getRelationshipType();

    public abstract void setRelationshipType(String var1);

    public abstract String getTextValue();

    public abstract void setTextValue(String var1);

    public abstract CodeLocal getConceptName();

    public abstract void setConceptName(CodeLocal var1);

    public abstract CodeLocal getConceptCode();

    public abstract void setConceptCode(CodeLocal var1);

    public Long ejbCreate(Dataset item) throws CreateException {
        this.setRelationshipType(item.getString(4235280));
        String s = item.getString(4235616);
        if (s != null) {
            AttributeFilter filter = AttributeFilter.getInstanceAttributeFilter(null);
            int maxLength = filter.getContentItemTextValueMaxLength();
            if (s.length() > maxLength) {
                s = s.substring(0, maxLength);
            }
            if (filter.isICase(4235616)) {
                s = s.toUpperCase();
            }
        }
        this.setTextValue(s);
        return null;
    }

    public void ejbPostCreate(Dataset item) throws CreateException {
        try {
            this.setConceptName(CodeBean.valueOf(this.codeHome, item.getItem(4235331)));
            this.setConceptCode(CodeBean.valueOf(this.codeHome, item.getItem(4235624)));
        }
        catch (FinderException e) {
            throw new CreateException(e.getMessage());
        }
    }
}

