/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.ejb.interfaces.CodeLocal;
import org.dcm4chex.archive.ejb.interfaces.CodeLocalHome;

public abstract class CodeBean
implements EntityBean {
    private static final Logger log = Logger.getLogger(CodeBean.class);

    public abstract Long getPk();

    public abstract void setPk(Long var1);

    public abstract String getCodeValue();

    public abstract void setCodeValue(String var1);

    public abstract String getCodingSchemeDesignator();

    public abstract void setCodingSchemeDesignator(String var1);

    public abstract String getCodingSchemeVersion();

    public abstract void setCodingSchemeVersion(String var1);

    public abstract String getCodeMeaning();

    public abstract void setCodeMeaning(String var1);

    public String asString() {
        return this.prompt();
    }

    private String prompt() {
        return "Code[pk=" + this.getPk() + ", value=" + this.getCodeValue() + ", designator=" + this.getCodingSchemeDesignator() + ", version=" + this.getCodingSchemeVersion() + ", meaning=" + this.getCodeMeaning() + "]";
    }

    public Long ejbCreate(String value, String designator, String version, String meaning) throws CreateException {
        this.setCodeValue(value);
        this.setCodingSchemeDesignator(designator);
        this.setCodingSchemeVersion(version);
        this.setCodeMeaning(meaning);
        return null;
    }

    public void ejbPostCreate(String value, String designator, String version, String meaning) throws CreateException {
        log.info((Object)("Created " + this.prompt()));
    }

    public void ejbRemove() throws RemoveException {
        log.info((Object)("Deleting " + this.prompt()));
    }

    public static CodeLocal valueOf(CodeLocalHome codeHome, Dataset item) throws CreateException, FinderException {
        if (item == null) {
            return null;
        }
        String value = item.getString(524544);
        String designator = item.getString(524546);
        String version = item.getString(524547);
        String meaning = item.getString(524548);
        Collection c = codeHome.findByValueAndDesignator(value, designator);
        for (CodeLocal code : c) {
            if (version == null) {
                return code;
            }
            String version2 = code.getCodingSchemeVersion();
            if (version2 != null && !version2.equals(version)) continue;
            return code;
        }
        return codeHome.create(value, designator, version, meaning);
    }

    public static void addCodesTo(CodeLocalHome codeHome, DcmElement sq, Collection c) throws CreateException, FinderException {
        if (sq == null || sq.isEmpty()) {
            return;
        }
        Dataset item = sq.getItem(0);
        if (item.isEmpty()) {
            return;
        }
        c.add(CodeBean.valueOf(codeHome, item));
        int n = sq.countItems();
        for (int i = 1; i < n; ++i) {
            c.add(CodeBean.valueOf(codeHome, sq.getItem(i)));
        }
    }

    public static boolean checkCodes(String prompt, DcmElement sq) {
        if (sq == null || sq.isEmpty()) {
            return true;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = sq.getItem(i);
            if (!item.containsValue(524544)) {
                log.warn((Object)("Missing Code Value (0008,0100) in " + prompt + " - ignore all items"));
                return false;
            }
            if (!item.containsValue(524546)) {
                log.warn((Object)("Missing Coding Scheme Designator (0008,0102) in " + prompt + " - ignore all items"));
                return false;
            }
            if (item.containsValue(524548)) continue;
            log.warn((Object)("Missing Code Meaning (0008,0104) in " + prompt + " - ignore all items"));
            return false;
        }
        return true;
    }
}

