/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.entity;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;

public class AttrUtils {
    private static final int FORBIDDEN_ATTRIBUTE_COERCION = 51968;

    public static boolean coerceAttributes(Dataset oldAttrs, Dataset newAttrs, Dataset coercedElements, AttributeFilter filter, Logger log) throws DcmServiceException {
        boolean coercedIdentity = false;
        for (DcmElement refEl : oldAttrs) {
            int tag;
            DcmElement el;
            if (refEl.isEmpty() || AttrUtils.equals(el = newAttrs.get(tag = refEl.tag()), newAttrs.getSpecificCharacterSet(), refEl, oldAttrs.getSpecificCharacterSet(), coercedElements, log)) continue;
            if (filter != null && filter.isCoercionForbidden(tag)) {
                throw new DcmServiceException(51968, "Storage would require forbidden Coercion of " + el + " to " + refEl);
            }
            log.warn((Object)("Coerce " + el + " to " + refEl));
            if (coercedElements != null) {
                if (VRs.isLengthField16Bit((int)refEl.vr())) {
                    coercedElements.putXX(tag, refEl.getByteBuffer());
                } else {
                    coercedElements.putXX(tag);
                }
            }
            coercedIdentity = true;
        }
        return coercedIdentity;
    }

    private static boolean equals(DcmElement el, SpecificCharacterSet cs, DcmElement refEl, SpecificCharacterSet refCS, Dataset coercedElements, Logger log) throws DcmServiceException {
        int vr = refEl.vr();
        if (el == null || el.vr() != vr) {
            return false;
        }
        if (vr == 20311 || vr == 20290 || vr == 21838) {
            return true;
        }
        if (vr == 21329) {
            int n = refEl.countItems();
            if (el.countItems() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (!AttrUtils.coerceAttributes(refEl.getItem(i), el.getItem(i), null, null, log) || coercedElements == null) continue;
                coercedElements.putSQ(el.tag());
            }
        } else {
            try {
                if (vr == 20558 ? !Arrays.equals(refEl.getPersonNames(refCS), el.getPersonNames(cs)) : !Arrays.equals(refEl.getStrings(refCS), el.getStrings(cs))) {
                    return false;
                }
            }
            catch (DcmValueException e) {
                log.warn((Object)("Failure during coercion of " + el), (Throwable)e);
            }
        }
        return true;
    }

    public static boolean mergeAttributes(Dataset oldAttrs, Dataset newAttrs, Logger log) {
        boolean updateEntity = false;
        for (DcmElement dsEl : newAttrs) {
            int i;
            int tag = dsEl.tag();
            int vr = dsEl.vr();
            int numItems = dsEl.countItems();
            if (Tags.isPrivate((int)tag) || dsEl.isEmpty()) continue;
            DcmElement refEl = oldAttrs.get(tag);
            if (dsEl.hasItems()) {
                if (refEl == null || refEl.isEmpty()) {
                    log.info((Object)("Update stored objects with additional element/value from new received object- " + dsEl));
                    refEl = oldAttrs.putSQ(tag);
                    for (i = 0; i < numItems; ++i) {
                        refEl.addItem(dsEl.getItem());
                    }
                    updateEntity = true;
                    continue;
                }
                if (refEl.countItems() != numItems) continue;
                for (i = 0; i < numItems; ++i) {
                    if (!AttrUtils.mergeAttributes(refEl.getItem(), dsEl.getItem(), log)) continue;
                    updateEntity = true;
                }
                continue;
            }
            if (refEl != null && !refEl.isEmpty()) continue;
            log.info((Object)("Update stored objects with additional element/value from new received object - " + dsEl));
            if (dsEl.hasDataFragments()) {
                refEl = oldAttrs.putXXsq(tag, vr);
                for (i = 0; i < numItems; ++i) {
                    refEl.addDataFragment(dsEl.getDataFragment(i));
                }
            } else {
                oldAttrs.putXX(tag, vr, dsEl.getByteBuffer());
            }
            updateEntity = true;
        }
        return updateEntity;
    }

    public static boolean updateAttributes(Dataset oldAttrs, Dataset newAttrs, Dataset modifiedAttrs, Logger log) {
        boolean updateEntity = false;
        for (DcmElement dsEl : newAttrs) {
            int i;
            int tag;
            DcmElement refEl;
            if (dsEl.equals(refEl = oldAttrs.get(tag = dsEl.tag()))) continue;
            int vr = dsEl.vr();
            if (refEl == null || refEl.isEmpty()) {
                log.info((Object)("Add " + dsEl));
                if (modifiedAttrs != null) {
                    modifiedAttrs.putXX(tag, vr);
                }
            } else {
                log.info((Object)("Change " + refEl + " to " + dsEl));
                if (modifiedAttrs != null) {
                    if (refEl.hasItems()) {
                        DcmElement modEl = modifiedAttrs.putSQ(tag);
                        int oldNumItems = refEl.countItems();
                        for (int i2 = 0; i2 < oldNumItems; ++i2) {
                            modEl.addItem(refEl.getItem(i2));
                        }
                    } else {
                        modifiedAttrs.putXX(tag, vr, refEl.getByteBuffer());
                    }
                }
            }
            int numItems = dsEl.countItems();
            if (dsEl.isEmpty()) {
                oldAttrs.putXX(tag, vr);
            } else if (dsEl.hasItems()) {
                refEl = oldAttrs.putSQ(tag);
                for (i = 0; i < numItems; ++i) {
                    refEl.addItem(dsEl.getItem(i));
                }
            } else if (dsEl.hasDataFragments()) {
                refEl = oldAttrs.putXXsq(tag, vr);
                for (i = 0; i < numItems; ++i) {
                    refEl.addDataFragment(dsEl.getDataFragment(i));
                }
            } else {
                oldAttrs.putXX(tag, vr, dsEl.getByteBuffer());
            }
            updateEntity = true;
        }
        return updateEntity;
    }

    public static void fetchModifiedAttributes(Dataset newAttrs, Dataset modifiedOrigAttrs, Dataset modifiedAttrs, AttributeFilter filter) {
        AttrUtils.fetchModifiedAttributes(filter != null && newAttrs != null ? filter.filter(newAttrs) : newAttrs, modifiedOrigAttrs, modifiedAttrs);
    }

    public static void fetchModifiedAttributes(Dataset newAttrs, Dataset modifiedOrigAttrs, Dataset modifiedAttrs) {
        if (newAttrs == null || modifiedOrigAttrs == null || modifiedAttrs == null) {
            return;
        }
        if (modifiedOrigAttrs.isEmpty()) {
            modifiedAttrs.putAll((DcmObject)newAttrs);
        } else {
            for (DcmElement modEl : modifiedOrigAttrs) {
                int tag = modEl.tag();
                DcmElement newEl = newAttrs.get(tag);
                if (newEl == null || newEl.isEmpty()) continue;
                if (newEl.hasItems()) {
                    DcmElement sq = null;
                    int n = newEl.countItems();
                    block1: for (int i = 0; i < n; ++i) {
                        Dataset childDs = newEl.getItem(i);
                        int m = modEl.countItems();
                        for (int j = 0; j < m; ++j) {
                            if (childDs.equals(modEl.getItem(j))) continue block1;
                        }
                        if (sq == null) {
                            sq = modifiedAttrs.putSQ(tag);
                        }
                        sq.addItem(childDs);
                    }
                    continue;
                }
                modifiedAttrs.putXX(tag, newEl.vr(), newEl.getByteBuffer());
            }
        }
    }
}

