/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.vendor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
import org.jboss.util.NestedRuntimeException;

public class OracleValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 5379340663276548636L;
    private static final Logger log = Logger.getLogger(OracleValidConnectionChecker.class);
    private static Object[] params = new Object[]{new Integer(5000)};

    public OracleValidConnectionChecker() {
        try {
            Class<?> oracleConnection = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.driver.OracleConnection");
            Method method = oracleConnection.getMethod("pingDatabase", Integer.TYPE);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Unable to resolve pingDatabase method:", (Throwable)e);
        }
    }

    public SQLException isValidConnection(Connection c) {
        try {
            Class<?> oracleConnection = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.driver.OracleConnection");
            Method ping = oracleConnection.getMethod("pingDatabase", Integer.TYPE);
            Integer status = (Integer)ping.invoke((Object)c, params);
            if (status < 0) {
                return new SQLException("pingDatabase failed status=" + status);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected error in pingDatabase", (Throwable)e);
        }
        return null;
    }
}

