/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCJBossQLQueryMetaData
implements JDBCQueryMetaData {
    private final Method method;
    private final String jbossQL;
    private final boolean resultTypeMappingLocal;
    private final JDBCReadAheadMetaData readAhead;
    private final Class compiler;
    private final boolean lazyResultSetLoading;

    public JDBCJBossQLQueryMetaData(JDBCJBossQLQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class qlCompiler, boolean lazyResultSetLoading) throws DeploymentException {
        this.method = defaults.getMethod();
        this.readAhead = readAhead;
        this.jbossQL = defaults.getJBossQL();
        this.resultTypeMappingLocal = defaults.isResultTypeMappingLocal();
        this.compiler = qlCompiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
    }

    public JDBCJBossQLQueryMetaData(boolean resultTypeMappingLocal, Element element, Method method, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading) throws DeploymentException {
        this.method = method;
        this.readAhead = readAhead;
        this.jbossQL = MetaData.getElementContent(element);
        if (this.jbossQL == null || this.jbossQL.trim().length() == 0) {
            throw new DeploymentException("jboss-ql element is empty");
        }
        this.resultTypeMappingLocal = resultTypeMappingLocal;
        this.compiler = compiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getQLCompilerClass() {
        return this.compiler;
    }

    public String getJBossQL() {
        return this.jbossQL;
    }

    public boolean isResultTypeMappingLocal() {
        return this.resultTypeMappingLocal;
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public boolean isLazyResultSetLoading() {
        return this.lazyResultSetLoading;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCJBossQLQueryMetaData) {
            return ((JDBCJBossQLQueryMetaData)o).method.equals(this.method);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return "[JDBCJBossQLQueryMetaData : method=" + this.method + "]";
    }
}

