/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.apache.fop.svg.PDFBridgeContext;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class PDFImageElementBridge
extends SVGImageElementBridge {
    private final ImageFlavor[] supportedFlavors = new ImageFlavor[]{ImageFlavor.RAW_JPEG, ImageFlavor.RAW_CCITTFAX, ImageFlavor.GRAPHICS2D, ImageFlavor.XML_DOM};

    protected GraphicsNode createImageGraphicsNode(BridgeContext ctx, Element imageElement, ParsedURL purl) {
        PDFBridgeContext pdfCtx = (PDFBridgeContext)ctx;
        ImageManager manager = pdfCtx.getImageManager();
        ImageSessionContext sessionContext = pdfCtx.getImageSessionContext();
        try {
            ImageInfo info = manager.getImageInfo(purl.toString(), sessionContext);
            Image image = manager.getImage(info, this.supportedFlavors, sessionContext);
            AbstractGraphicsNode specializedNode = null;
            if (image instanceof ImageXMLDOM) {
                ImageXMLDOM xmlImage = (ImageXMLDOM)image;
                if (xmlImage.getDocument() instanceof SVGDocument) {
                    return this.createSVGImageNode(ctx, imageElement, (SVGDocument)xmlImage.getDocument());
                }
                image = manager.convertImage((Image)xmlImage, new ImageFlavor[]{ImageFlavor.GRAPHICS2D});
            }
            if (image instanceof ImageRawJPEG) {
                specializedNode = new LoaderImageNode(image, ctx, imageElement, purl);
            } else if (image instanceof ImageRawCCITTFax) {
                specializedNode = new LoaderImageNode(image, ctx, imageElement, purl);
            } else if (image instanceof ImageGraphics2D) {
                ImageGraphics2D g2dImage = (ImageGraphics2D)image;
                specializedNode = new Graphics2DNode(g2dImage);
            } else {
                ctx.getUserAgent().displayError((Exception)((Object)new ImageException("Cannot convert an image to a usable format: " + purl)));
            }
            Rectangle2D imgBounds = PDFImageElementBridge.getImageBounds(ctx, imageElement);
            Rectangle2D bounds = specializedNode.getPrimitiveBounds();
            float[] vb = new float[]{0.0f, 0.0f, (float)bounds.getWidth(), (float)bounds.getHeight()};
            PDFImageElementBridge.initializeViewport(ctx, imageElement, specializedNode, vb, imgBounds);
            return specializedNode;
        }
        catch (Exception e) {
            ctx.getUserAgent().displayError(e);
            return this.superCreateGraphicsNode(ctx, imageElement, purl);
        }
    }

    protected GraphicsNode superCreateGraphicsNode(BridgeContext ctx, Element imageElement, ParsedURL purl) {
        return super.createImageGraphicsNode(ctx, imageElement, purl);
    }

    public class Graphics2DNode
    extends AbstractGraphicsNode {
        private ImageGraphics2D image;

        public Graphics2DNode(ImageGraphics2D g2d) {
            this.image = g2d;
        }

        public Shape getOutline() {
            return this.getPrimitiveBounds();
        }

        public void primitivePaint(Graphics2D g2d) {
            int width = this.image.getSize().getWidthPx();
            int height = this.image.getSize().getHeightPx();
            Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, width, height);
            this.image.getGraphics2DImagePainter().paint(g2d, (Rectangle2D)area);
        }

        public Rectangle2D getGeometryBounds() {
            return this.getPrimitiveBounds();
        }

        public Rectangle2D getPrimitiveBounds() {
            return new Rectangle2D.Double(0.0, 0.0, this.image.getSize().getWidthPx(), this.image.getSize().getHeightPx());
        }

        public Rectangle2D getSensitiveBounds() {
            return this.getPrimitiveBounds();
        }
    }

    public class LoaderImageNode
    extends AbstractGraphicsNode {
        private Image image;
        private BridgeContext ctx;
        private Element imageElement;
        private ParsedURL purl;
        private GraphicsNode origGraphicsNode = null;

        public LoaderImageNode(Image image, BridgeContext ctx, Element imageElement, ParsedURL purl) {
            this.image = image;
            this.ctx = ctx;
            this.imageElement = imageElement;
            this.purl = purl;
        }

        public Shape getOutline() {
            return this.getPrimitiveBounds();
        }

        public void primitivePaint(Graphics2D g2d) {
            if (g2d instanceof PDFGraphics2D) {
                PDFGraphics2D pdfg = (PDFGraphics2D)((Object)g2d);
                float x = 0.0f;
                float y = 0.0f;
                try {
                    float width = this.image.getSize().getWidthPx();
                    float height = this.image.getSize().getHeightPx();
                    pdfg.addNativeImage(this.image, x, y, width, height);
                }
                catch (Exception e) {
                    this.ctx.getUserAgent().displayError(e);
                }
            } else {
                if (this.origGraphicsNode == null) {
                    this.origGraphicsNode = PDFImageElementBridge.this.superCreateGraphicsNode(this.ctx, this.imageElement, this.purl);
                }
                this.origGraphicsNode.primitivePaint(g2d);
            }
        }

        public Rectangle2D getGeometryBounds() {
            return this.getPrimitiveBounds();
        }

        public Rectangle2D getPrimitiveBounds() {
            return new Rectangle2D.Double(0.0, 0.0, this.image.getSize().getWidthPx(), this.image.getSize().getHeightPx());
        }

        public Rectangle2D getSensitiveBounds() {
            return this.getPrimitiveBounds();
        }
    }
}

