/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.CachedFontInfo;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.util.LogUtil;

public final class FontCache
implements Serializable {
    private static final long serialVersionUID = 605232520271754718L;
    private static Log log = LogFactory.getLog((Class)FontCache.class);
    private static final String FOP_USER_DIR = ".fop";
    private static final String DEFAULT_CACHE_FILENAME = "fop-fonts.cache";
    private transient boolean changed = false;
    private transient Object changeLock = new Object();
    private Map fontMap = new HashMap();
    private Map failedFontMap = new HashMap();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.changeLock = new Object();
    }

    private static File getUserHome() {
        File userDir;
        String s = System.getProperty("user.home");
        if (s != null && (userDir = new File(s)).exists()) {
            return userDir;
        }
        return null;
    }

    public static File getDefaultCacheFile(boolean forWriting) {
        File userHome = FontCache.getUserHome();
        if (userHome != null) {
            File fopUserDir = new File(userHome, FOP_USER_DIR);
            if (forWriting) {
                fopUserDir.mkdir();
            }
            return new File(fopUserDir, DEFAULT_CACHE_FILENAME);
        }
        return new File(FOP_USER_DIR);
    }

    public static FontCache load() {
        return FontCache.loadFrom(FontCache.getDefaultCacheFile(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontCache loadFrom(File cacheFile) {
        block8: {
            if (cacheFile.exists()) {
                FontCache fontCache;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading font cache from " + cacheFile.getCanonicalPath()));
                }
                InputStream in = new FileInputStream(cacheFile);
                in = new BufferedInputStream(in);
                ObjectInputStream oin = new ObjectInputStream(in);
                try {
                    fontCache = (FontCache)oin.readObject();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly((InputStream)oin);
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        log.warn((Object)("Could not read font cache. Discarding font cache file. Reason: " + e.getMessage()));
                        break block8;
                    }
                    catch (IOException ioe) {
                        log.warn((Object)("I/O exception while reading font cache (" + ioe.getMessage() + "). Discarding font cache file."));
                    }
                }
                IOUtils.closeQuietly((InputStream)oin);
                return fontCache;
            }
        }
        return null;
    }

    public void save() throws FOPException {
        this.saveTo(FontCache.getDefaultCacheFile(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File cacheFile) throws FOPException {
        Object object = this.changeLock;
        synchronized (object) {
            if (this.changed) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Writing font cache to " + cacheFile.getCanonicalPath()));
                    }
                    OutputStream out = new FileOutputStream(cacheFile);
                    out = new BufferedOutputStream(out);
                    ObjectOutputStream oout = new ObjectOutputStream(out);
                    try {
                        oout.writeObject(this);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)oout);
                    }
                }
                catch (IOException ioe) {
                    LogUtil.handleException(log, ioe, true);
                }
                this.changed = false;
                log.trace((Object)"Cache file written.");
            }
        }
    }

    protected static String getCacheKey(EmbedFontInfo fontInfo) {
        if (fontInfo != null) {
            String embedFile = fontInfo.getEmbedFile();
            String metricsFile = fontInfo.getMetricsFile();
            return embedFile != null ? embedFile : metricsFile;
        }
        return null;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean containsFont(String embedUrl) {
        if (embedUrl != null) {
            return this.fontMap.containsKey(embedUrl);
        }
        return false;
    }

    public boolean containsFont(EmbedFontInfo fontInfo) {
        if (fontInfo != null) {
            return this.fontMap.containsKey(FontCache.getCacheKey(fontInfo));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFont(EmbedFontInfo fontInfo) {
        String cacheKey = FontCache.getCacheKey(fontInfo);
        Object object = this.changeLock;
        synchronized (object) {
            if (!this.containsFont(cacheKey)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Font added to cache: " + cacheKey));
                }
                if (fontInfo instanceof CachedFontInfo) {
                    this.fontMap.put(cacheKey, fontInfo);
                } else {
                    this.fontMap.put(cacheKey, new CachedFontInfo(fontInfo));
                }
                this.changed = true;
            }
        }
    }

    public CachedFontInfo getFont(String embedUrl) {
        if (this.containsFont(embedUrl)) {
            return (CachedFontInfo)this.fontMap.get(embedUrl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFont(String embedUrl) {
        Object object = this.changeLock;
        synchronized (object) {
            if (this.containsFont(embedUrl)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Font removed from cache: " + embedUrl));
                }
                this.fontMap.remove(embedUrl);
                this.changed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailedFont(String embedUrl, long lastModified) {
        if (this.failedFontMap.containsKey(embedUrl)) {
            Object object = this.changeLock;
            synchronized (object) {
                long failedLastModified = (Long)this.failedFontMap.get(embedUrl);
                if (lastModified != failedLastModified) {
                    this.failedFontMap.remove(embedUrl);
                    this.changed = true;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailedFont(String embedUrl, long lastModified) {
        Object object = this.changeLock;
        synchronized (object) {
            if (!this.failedFontMap.containsKey(embedUrl)) {
                this.failedFontMap.put(embedUrl, new Long(lastModified));
                this.changed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.changeLock;
        synchronized (object) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Font cache cleared.");
            }
            this.fontMap.clear();
            this.failedFontMap.clear();
            this.changed = true;
        }
    }
}

