/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

public class StringUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String join(String[] ss, char delim) {
        if (ss == null) {
            return null;
        }
        if (ss.length == 0) {
            return "";
        }
        if (ss.length == 1) {
            return ss[0];
        }
        int sumlen = 0;
        int i = 0;
        while (i < ss.length) {
            if (ss[i] != null) {
                sumlen += ss[i].length();
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer(sumlen + ss.length);
        int i2 = 0;
        while (i2 < ss.length) {
            if (ss[i2] != null) {
                sb.append(ss[i2]);
            }
            sb.append(delim);
            ++i2;
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String[] split(String s, char delim) {
        int l;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        int r0 = s.indexOf(delim);
        if (r0 == -1) {
            return new String[]{s};
        }
        int i = 2;
        int r = r0;
        while ((r = s.indexOf(delim, l = r + 1)) != -1) {
            ++i;
        }
        String[] ss = new String[i];
        l = 0;
        i = 0;
        r = r0;
        do {
            ss[i++] = s.substring(l, r);
        } while ((r = s.indexOf(delim, l = r + 1)) != -1);
        ss[i] = s.substring(l);
        return ss;
    }

    public static int count(String s, char ch) {
        int next;
        if (s == null || s.length() == 0) {
            return 0;
        }
        int count = 0;
        int off = 0;
        while ((next = s.indexOf(ch, off)) != -1) {
            off = next + 1;
            ++count;
        }
        return count;
    }

    public static String first(String s, char delim) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int r0 = s.indexOf(delim);
        return r0 == -1 ? s : s.substring(0, r0);
    }

    private static String trim(String s, char lead, char tail1, char tail2) {
        char c;
        if (s == null) {
            return null;
        }
        int len = s.length();
        int st = 0;
        while (st < len && s.charAt(st) == lead) {
            ++st;
        }
        while (st < len && ((c = s.charAt(len - 1)) == tail1 || c == tail2)) {
            --len;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    private static String[] trim(String[] ss, char lead, char tail1, char tail2) {
        if (ss == null) {
            return null;
        }
        int i = 0;
        while (i < ss.length) {
            ss[i] = StringUtils.trim(ss[i], lead, tail1, tail2);
            ++i;
        }
        return ss;
    }

    public static String trim(String s) {
        return StringUtils.trim(s, ' ', '\u0000', ' ');
    }

    public static String[] trim(String[] ss) {
        return StringUtils.trim(ss, ' ', '\u0000', ' ');
    }

    public static String trimPN(String s) {
        return StringUtils.trim(s, ' ', '^', ' ');
    }

    public static String[] trimPN(String[] ss) {
        return StringUtils.trim(ss, ' ', '^', ' ');
    }

    public static String trimEnd(String s) {
        return StringUtils.trim(s, '\u0000', '\u0000', ' ');
    }

    public static String[] trimEnd(String[] ss) {
        return StringUtils.trim(ss, '\u0000', '\u0000', ' ');
    }

    public static String[] ints2strs(int[] val) {
        if (val == null || val.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] ss = new String[val.length];
        int i = 0;
        while (i < ss.length) {
            ss[i] = Integer.toString(val[i]);
            ++i;
        }
        return ss;
    }

    public static String[] uints2strs(int[] val) {
        if (val == null || val.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] ss = new String[val.length];
        int i = 0;
        while (i < ss.length) {
            ss[i] = Long.toString((long)val[i] & 0xFFFFFFFFL);
            ++i;
        }
        return ss;
    }

    public static String[] floats2strs(float[] fs) {
        if (fs == null || fs.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] ss = new String[fs.length];
        int i = 0;
        while (i < ss.length) {
            ss[i] = Float.toString(fs[i]);
            ++i;
        }
        return ss;
    }

    public static String[] doubles2strs(double[] ds) {
        if (ds == null || ds.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] ss = new String[ds.length];
        int i = 0;
        while (i < ss.length) {
            ss[i] = Double.toString(ds[i]);
            ++i;
        }
        return ss;
    }

    public static StringBuffer intToHex(int val, StringBuffer sb) {
        sb.append(HEX_DIGITS[val >> 28 & 0xF]);
        sb.append(HEX_DIGITS[val >> 24 & 0xF]);
        sb.append(HEX_DIGITS[val >> 20 & 0xF]);
        sb.append(HEX_DIGITS[val >> 16 & 0xF]);
        sb.append(HEX_DIGITS[val >> 12 & 0xF]);
        sb.append(HEX_DIGITS[val >> 8 & 0xF]);
        sb.append(HEX_DIGITS[val >> 4 & 0xF]);
        sb.append(HEX_DIGITS[val & 0xF]);
        return sb;
    }

    public static StringBuffer shortToHex(int val, StringBuffer sb) {
        sb.append(HEX_DIGITS[val >> 12 & 0xF]);
        sb.append(HEX_DIGITS[val >> 8 & 0xF]);
        sb.append(HEX_DIGITS[val >> 4 & 0xF]);
        sb.append(HEX_DIGITS[val & 0xF]);
        return sb;
    }

    public static StringBuffer byteToHex(int val, StringBuffer sb) {
        sb.append(HEX_DIGITS[val >> 4 & 0xF]);
        sb.append(HEX_DIGITS[val & 0xF]);
        return sb;
    }

    public static void intToHex(int val, char[] ch, int off) {
        ch[off] = HEX_DIGITS[val >> 28 & 0xF];
        ch[off + 1] = HEX_DIGITS[val >> 24 & 0xF];
        ch[off + 2] = HEX_DIGITS[val >> 20 & 0xF];
        ch[off + 3] = HEX_DIGITS[val >> 16 & 0xF];
        ch[off + 4] = HEX_DIGITS[val >> 12 & 0xF];
        ch[off + 5] = HEX_DIGITS[val >> 8 & 0xF];
        ch[off + 6] = HEX_DIGITS[val >> 4 & 0xF];
        ch[off + 7] = HEX_DIGITS[val & 0xF];
    }

    public static void shortToHex(int val, char[] ch, int off) {
        ch[off] = HEX_DIGITS[val >> 12 & 0xF];
        ch[off + 1] = HEX_DIGITS[val >> 8 & 0xF];
        ch[off + 2] = HEX_DIGITS[val >> 4 & 0xF];
        ch[off + 3] = HEX_DIGITS[val & 0xF];
    }

    public static void byteToHex(int val, char[] ch, int off) {
        ch[off] = HEX_DIGITS[val >> 4 & 0xF];
        ch[off + 1] = HEX_DIGITS[val & 0xF];
    }

    public static String intToHex(int val) {
        char[] ch = new char[8];
        StringUtils.intToHex(val, ch, 0);
        return new String(ch);
    }

    public static String[] intsToHex(int[] val) {
        if (val == null || val.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] ss = new String[val.length];
        int i = 0;
        while (i < ss.length) {
            ss[i] = StringUtils.intToHex(val[i]);
            ++i;
        }
        return ss;
    }

    public static String shortToHex(int val) {
        char[] ch = new char[4];
        StringUtils.shortToHex(val, ch, 0);
        return new String(ch);
    }
}

