/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

public class ByteUtils {
    public static byte[] int2bytesLE(int val, byte[] b, int off) {
        b[off] = (byte)val;
        b[off + 1] = (byte)(val >>> 8);
        b[off + 2] = (byte)(val >>> 16);
        b[off + 3] = (byte)(val >>> 24);
        return b;
    }

    public static byte[] ints2bytesLE(int[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 2];
        int i = 0;
        while (i < val.length) {
            ByteUtils.int2bytesLE(val[i], b, i << 2);
            ++i;
        }
        return b;
    }

    public static byte[] int2bytesBE(int val, byte[] b, int off) {
        b[off] = (byte)(val >>> 24);
        b[off + 1] = (byte)(val >>> 16);
        b[off + 2] = (byte)(val >>> 8);
        b[off + 3] = (byte)val;
        return b;
    }

    public static byte[] ints2bytesBE(int[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 2];
        int i = 0;
        while (i < val.length) {
            ByteUtils.int2bytesBE(val[i], b, i << 2);
            ++i;
        }
        return b;
    }

    public static int bytesLE2int(byte[] b, int off) {
        return (b[off + 3] & 0xFF) << 24 | (b[off + 2] & 0xFF) << 16 | (b[off + 1] & 0xFF) << 8 | b[off] & 0xFF;
    }

    public static int[] bytesLE2ints(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 3) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        int[] val = new int[b.length >> 2];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesLE2int(b, i << 2);
            ++i;
        }
        return val;
    }

    public static int bytesBE2int(byte[] b, int off) {
        return (b[off] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    public static int[] bytesBE2ints(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 3) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        int[] val = new int[b.length >> 2];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesBE2int(b, i << 2);
            ++i;
        }
        return val;
    }

    public static byte[] tag2bytesLE(int tag, byte[] b, int off) {
        b[off] = (byte)(tag >>> 16 & 0xFF);
        b[off + 1] = (byte)(tag >>> 24 & 0xFF);
        b[off + 2] = (byte)(tag & 0xFF);
        b[off + 3] = (byte)(tag >>> 8 & 0xFF);
        return b;
    }

    public static byte[] tags2bytesLE(int[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 2];
        int i = 0;
        while (i < val.length) {
            ByteUtils.tag2bytesLE(val[i], b, i << 2);
            ++i;
        }
        return b;
    }

    public static byte[] tag2bytesBE(int tag, byte[] b, int off) {
        return ByteUtils.int2bytesBE(tag, b, off);
    }

    public static byte[] tags2bytesBE(int[] val) {
        return ByteUtils.ints2bytesBE(val);
    }

    public static int bytesLE2tag(byte[] b, int off) {
        return (b[off + 1] & 0xFF) << 24 | (b[off] & 0xFF) << 16 | (b[off + 3] & 0xFF) << 8 | b[off + 2] & 0xFF;
    }

    public static int[] bytesLE2tags(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 3) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        int[] val = new int[b.length >> 2];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesLE2tag(b, i << 2);
            ++i;
        }
        return val;
    }

    public static int bytesBE2tag(byte[] b, int off) {
        return ByteUtils.bytesBE2int(b, off);
    }

    public static int[] bytesBE2tags(byte[] b) {
        return ByteUtils.bytesBE2ints(b);
    }

    public static byte[] ushort2bytesLE(int val, byte[] b, int off) {
        b[off] = (byte)val;
        b[off + 1] = (byte)(val >>> 8);
        return b;
    }

    public static byte[] ushorts2bytesLE(int[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 1];
        int i = 0;
        while (i < val.length) {
            ByteUtils.ushort2bytesLE(val[i], b, i << 1);
            ++i;
        }
        return b;
    }

    public static byte[] ushort2bytesBE(int val, byte[] b, int off) {
        b[off] = (byte)(val >>> 8);
        b[off + 1] = (byte)val;
        return b;
    }

    public static byte[] ushorts2bytesBE(int[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 1];
        int i = 0;
        while (i < val.length) {
            ByteUtils.ushort2bytesBE(val[i], b, i << 1);
            ++i;
        }
        return b;
    }

    public static byte[] shorts2bytesLE(short[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 1];
        int i = 0;
        while (i < val.length) {
            ByteUtils.ushort2bytesLE(val[i], b, i << 1);
            ++i;
        }
        return b;
    }

    public static byte[] shorts2bytesBE(short[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 1];
        int i = 0;
        while (i < val.length) {
            ByteUtils.ushort2bytesBE(val[i], b, i << 1);
            ++i;
        }
        return b;
    }

    public static int bytesLE2ushort(byte[] b, int off) {
        return ByteUtils.bytesLE2sshort(b, off) & 0xFFFF;
    }

    public static int[] bytesLE2ushorts(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 1) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        int[] val = new int[b.length >> 1];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesLE2ushort(b, i << 1);
            ++i;
        }
        return val;
    }

    public static int bytesBE2ushort(byte[] b, int off) {
        return ByteUtils.bytesBE2sshort(b, off) & 0xFFFF;
    }

    public static int[] bytesBE2ushorts(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 1) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        int[] val = new int[b.length >> 1];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesBE2ushort(b, i << 1);
            ++i;
        }
        return val;
    }

    public static int bytesLE2sshort(byte[] b, int off) {
        return b[off + 1] << 8 | b[off] & 0xFF;
    }

    public static int[] bytesLE2sshorts(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 1) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        int[] val = new int[b.length >> 1];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesLE2sshort(b, i << 1);
            ++i;
        }
        return val;
    }

    public static int bytesBE2sshort(byte[] b, int off) {
        return b[off] << 8 | b[off + 1] & 0xFF;
    }

    public static int[] bytesBE2sshorts(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 1) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        int[] val = new int[b.length >> 1];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesBE2sshort(b, i << 1);
            ++i;
        }
        return val;
    }

    public static short[] bytesLE2shorts(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 1) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        short[] val = new short[b.length >> 1];
        int i = 0;
        while (i < val.length) {
            val[i] = (short)ByteUtils.bytesLE2sshort(b, i << 1);
            ++i;
        }
        return val;
    }

    public static short[] bytesBE2shorts(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 1) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        short[] val = new short[b.length >> 1];
        int i = 0;
        while (i < val.length) {
            val[i] = (short)ByteUtils.bytesBE2sshort(b, i << 1);
            ++i;
        }
        return val;
    }

    public static byte[] float2bytesLE(float val, byte[] b, int off) {
        return ByteUtils.int2bytesLE(Float.floatToIntBits(val), b, off);
    }

    public static byte[] floats2bytesLE(float[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 2];
        int i = 0;
        while (i < val.length) {
            ByteUtils.float2bytesLE(val[i], b, i << 2);
            ++i;
        }
        return b;
    }

    public static byte[] float2bytesBE(float val, byte[] b, int off) {
        return ByteUtils.int2bytesBE(Float.floatToIntBits(val), b, off);
    }

    public static byte[] floats2bytesBE(float[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 2];
        int i = 0;
        while (i < val.length) {
            ByteUtils.float2bytesBE(val[i], b, i << 2);
            ++i;
        }
        return b;
    }

    public static float bytesLE2float(byte[] b, int off) {
        return Float.intBitsToFloat(ByteUtils.bytesLE2int(b, off));
    }

    public static float[] bytesLE2floats(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 3) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        float[] val = new float[b.length >> 2];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesLE2float(b, i << 2);
            ++i;
        }
        return val;
    }

    public static double[] bytesLE2floats2doubles(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 3) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        double[] val = new double[b.length >> 2];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesLE2float(b, i << 2);
            ++i;
        }
        return val;
    }

    public static float bytesBE2float(byte[] b, int off) {
        return Float.intBitsToFloat(ByteUtils.bytesBE2int(b, off));
    }

    public static float[] bytesBE2floats(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 3) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        float[] val = new float[b.length >> 2];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesBE2float(b, i << 2);
            ++i;
        }
        return val;
    }

    public static double[] bytesBE2floats2doubles(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 3) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        double[] val = new double[b.length >> 2];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesBE2float(b, i << 2);
            ++i;
        }
        return val;
    }

    public static byte[] long2bytesLE(long val, byte[] b, int off) {
        b[off] = (byte)val;
        b[off + 1] = (byte)(val >>> 8);
        b[off + 2] = (byte)(val >>> 16);
        b[off + 3] = (byte)(val >>> 24);
        b[off + 4] = (byte)(val >>> 32);
        b[off + 5] = (byte)(val >>> 40);
        b[off + 6] = (byte)(val >>> 48);
        b[off + 7] = (byte)(val >>> 56);
        return b;
    }

    public static byte[] longs2bytesLE(long[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 2];
        int i = 0;
        while (i < val.length) {
            ByteUtils.long2bytesLE(val[i], b, i << 2);
            ++i;
        }
        return b;
    }

    public static byte[] long2bytesBE(long val, byte[] b, int off) {
        b[off] = (byte)(val >>> 56);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 7] = (byte)val;
        return b;
    }

    public static byte[] longs2bytesBE(long[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 3];
        int i = 0;
        while (i < val.length) {
            ByteUtils.long2bytesBE(val[i], b, i << 3);
            ++i;
        }
        return b;
    }

    public static long bytesLE2long(byte[] b, int off) {
        return ((long)b[off + 7] & 0xFFL) << 56 | ((long)b[off + 6] & 0xFFL) << 48 | ((long)b[off + 5] & 0xFFL) << 40 | ((long)b[off + 4] & 0xFFL) << 32 | ((long)b[off + 3] & 0xFFL) << 24 | ((long)b[off + 2] & 0xFFL) << 16 | ((long)b[off + 1] & 0xFFL) << 8 | (long)b[off] & 0xFFL;
    }

    public static long[] bytesLE2longs(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 7) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        long[] val = new long[b.length >> 3];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesLE2long(b, i << 3);
            ++i;
        }
        return val;
    }

    public static long bytesBE2long(byte[] b, int off) {
        return ((long)b[off] & 0xFFL) << 56 | ((long)b[off + 1] & 0xFFL) << 48 | ((long)b[off + 2] & 0xFFL) << 40 | ((long)b[off + 3] & 0xFFL) << 32 | ((long)b[off + 4] & 0xFFL) << 24 | ((long)b[off + 5] & 0xFFL) << 16 | ((long)b[off + 6] & 0xFFL) << 8 | (long)b[off + 7] & 0xFFL;
    }

    public static long[] bytesBE2longs(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 7) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        long[] val = new long[b.length >> 3];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesBE2long(b, i << 3);
            ++i;
        }
        return val;
    }

    public static byte[] double2bytesLE(double val, byte[] b, int off) {
        return ByteUtils.long2bytesLE(Double.doubleToLongBits(val), b, off);
    }

    public static byte[] doubles2bytesLE(double[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 3];
        int i = 0;
        while (i < val.length) {
            ByteUtils.double2bytesLE(val[i], b, i << 3);
            ++i;
        }
        return b;
    }

    public static byte[] double2bytesBE(double val, byte[] b, int off) {
        return ByteUtils.long2bytesBE(Double.doubleToLongBits(val), b, off);
    }

    public static byte[] doubles2bytesBE(double[] val) {
        if (val == null) {
            return null;
        }
        byte[] b = new byte[val.length << 3];
        int i = 0;
        while (i < val.length) {
            ByteUtils.double2bytesBE(val[i], b, i << 3);
            ++i;
        }
        return b;
    }

    public static double bytesLE2double(byte[] b, int off) {
        return Double.longBitsToDouble(ByteUtils.bytesLE2long(b, off));
    }

    public static double[] bytesLE2doubles(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 7) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        double[] val = new double[b.length >> 3];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesLE2double(b, i << 3);
            ++i;
        }
        return val;
    }

    public static double bytesBE2double(byte[] b, int off) {
        return Double.longBitsToDouble(ByteUtils.bytesBE2long(b, off));
    }

    public static double[] bytesBE2doubles(byte[] b) {
        if (b == null) {
            return null;
        }
        if ((b.length & 7) != 0) {
            throw new IllegalArgumentException("byte[" + b.length + "]");
        }
        double[] val = new double[b.length >> 3];
        int i = 0;
        while (i < val.length) {
            val[i] = ByteUtils.bytesBE2double(b, i << 3);
            ++i;
        }
        return val;
    }

    public static void toggleShortEndian(byte[] b) {
        if (b != null) {
            ByteUtils.toggleShortEndian(b, 0, b.length);
        }
    }

    public static void toggleShortEndian(byte[] b, int off, int len) {
        if (b == null || len == 0) {
            return;
        }
        int end = off + len;
        if (off < 0 || len < 0 || end > b.length) {
            throw new IndexOutOfBoundsException("b.length = " + b.length + ", off = " + off + ", len = " + len);
        }
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("len = " + len);
        }
        int i = off;
        while (i < end) {
            byte tmp = b[i];
            b[i] = b[i + 1];
            b[i + 1] = tmp;
            ++i;
            ++i;
        }
    }

    public static void toggleIntEndian(byte[] b) {
        if (b != null) {
            ByteUtils.toggleIntEndian(b, 0, b.length);
        }
    }

    public static void toggleIntEndian(byte[] b, int off, int len) {
        if (b == null || len == 0) {
            return;
        }
        int end = off + len;
        if (off < 0 || len < 0 || end > b.length) {
            throw new IndexOutOfBoundsException("b.length = " + b.length + ", off = " + off + ", len = " + len);
        }
        if ((len & 3) != 0) {
            throw new IllegalArgumentException("len = " + len);
        }
        int i = off;
        while (i < end) {
            byte tmp = b[i];
            b[i] = b[i + 3];
            b[i + 3] = tmp;
            tmp = b[i + 1];
            b[i + 1] = b[i + 2];
            b[i + 2] = tmp;
            ++i;
            ++i;
            ++i;
            ++i;
        }
    }

    public static void toggleLongEndian(byte[] b) {
        if (b != null) {
            ByteUtils.toggleLongEndian(b, 0, b.length);
        }
    }

    public static void toggleLongEndian(byte[] b, int off, int len) {
        if (b == null || len == 0) {
            return;
        }
        int end = off + len;
        if (off < 0 || len < 0 || end > b.length) {
            throw new IndexOutOfBoundsException("b.length = " + b.length + ", off = " + off + ", len = " + len);
        }
        if ((len & 7) != 0) {
            throw new IllegalArgumentException("len = " + len);
        }
        int i = off;
        while (i < end) {
            byte tmp = b[i];
            b[i] = b[i + 7];
            b[i + 7] = tmp;
            tmp = b[i + 1];
            b[i + 1] = b[i + 6];
            b[i + 6] = tmp;
            tmp = b[i + 2];
            b[i + 2] = b[i + 5];
            b[i + 5] = tmp;
            tmp = b[i + 3];
            b[i + 3] = b[i + 4];
            b[i + 4] = tmp;
            i += 8;
        }
    }
}

