/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.worklist.modality;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.AETGroup;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.dao.util.QueryUtil;

public class ModalityWorklistFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String patientName;
    private String patientID;
    private String issuerOfPatientID;
    private Date birthDateMin;
    private Date birthDateMax;
    private String accessionNumber;
    private boolean extendedQuery;
    private String studyInstanceUID;
    private String modality;
    private String scheduledStationAET;
    private String scheduledStationName;
    private boolean latestItemsFirst;
    private String spsStatus;
    private Date startDateMin;
    private Date startDateMax;
    private boolean fuzzyPN;
    private int autoWildcard = 0;
    private boolean isStudyIuidQuery;

    public ModalityWorklistFilter(String forUsername) {
        this.clear();
    }

    public void clear() {
        this.spsStatus = null;
        this.scheduledStationName = null;
        this.scheduledStationAET = null;
        this.modality = null;
        this.studyInstanceUID = null;
        this.accessionNumber = null;
        this.issuerOfPatientID = null;
        this.patientID = null;
        this.patientName = null;
        this.birthDateMax = null;
        this.birthDateMin = null;
        this.startDateMax = null;
        this.startDateMin = null;
        this.latestItemsFirst = false;
        this.isStudyIuidQuery = false;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public void setPatientName(String patientName) {
        this.patientName = patientName;
    }

    public boolean isFuzzyPNEnabled() {
        return AttributeFilter.isSoundexEnabled();
    }

    public boolean isFuzzyPN() {
        return this.fuzzyPN;
    }

    public void setFuzzyPN(boolean fuzzyPN) {
        this.fuzzyPN = fuzzyPN;
    }

    public String getPatientID() {
        return this.patientID;
    }

    public void setPatientID(String patientID) {
        this.patientID = patientID;
    }

    public void setIssuerOfPatientID(String issuerOfPatientID) {
        this.issuerOfPatientID = issuerOfPatientID;
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public Date getBirthDateMin() {
        return this.birthDateMin;
    }

    public void setBirthDateMin(Date birthdateMin) {
        this.birthDateMin = birthdateMin;
    }

    public Date getBirthDateMax() {
        return this.birthDateMax;
    }

    public void setBirthDateMax(Date birthdateMax) {
        this.birthDateMax = birthdateMax;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public void setExtendedQuery(boolean extendedQuery) {
        this.extendedQuery = extendedQuery;
    }

    public boolean isExtendedQuery() {
        return this.extendedQuery;
    }

    public void setStudyInstanceUID(String studyInstanceUID) {
        this.studyInstanceUID = studyInstanceUID;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getModality() {
        return this.modality;
    }

    public void setModality(String modality) {
        this.modality = modality;
    }

    public boolean isLatestItemsFirst() {
        return this.latestItemsFirst;
    }

    public void setLatestItemsFirst(boolean latestItemsFirst) {
        this.latestItemsFirst = latestItemsFirst;
    }

    public String getScheduledStationAET() {
        return this.scheduledStationAET;
    }

    public void setScheduledStationAET(String scheduledStationAET) {
        this.scheduledStationAET = scheduledStationAET;
    }

    public String[] getScheduledStationAETs() {
        HashSet aetStringSet = new HashSet();
        if (this.scheduledStationAET != null) {
            if (this.scheduledStationAET.startsWith("(") && this.scheduledStationAET.endsWith(")")) {
                String groupName = this.scheduledStationAET.substring(1, this.scheduledStationAET.length() - 1);
                for (AETGroup aetGroup : ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).getAllAETGroups()) {
                    if (!aetGroup.getGroupname().equals(groupName)) continue;
                    aetStringSet.addAll(aetGroup.getAets());
                }
            } else {
                return new String[]{this.scheduledStationAET};
            }
        }
        return aetStringSet.toArray(new String[aetStringSet.size()]);
    }

    public String getScheduledStationName() {
        return this.scheduledStationName;
    }

    public void setScheduledStationName(String scheduledStationName) {
        this.scheduledStationName = scheduledStationName;
    }

    public String getSPSStatus() {
        return this.spsStatus;
    }

    public void setSPSStatus(String SPSStatus2) {
        this.spsStatus = SPSStatus2;
    }

    public Date getStartDateMin() {
        return this.startDateMin;
    }

    public void setStartDateMin(Date startDateMin) {
        this.startDateMin = startDateMin;
    }

    public Date getStartDateMax() {
        return this.startDateMax;
    }

    public void setStartDateMax(Date startDateMax) {
        this.startDateMax = startDateMax;
    }

    public boolean isAutoWildcard() {
        return this.autoWildcard > 1;
    }

    public boolean isPNAutoWildcard() {
        return this.autoWildcard > 0;
    }

    public void setAutoWildcard(int autoWildcard) {
        this.autoWildcard = autoWildcard;
    }

    public boolean isStudyIuidQuery() {
        return this.isStudyIuidQuery;
    }

    public void setStudyIuidQuery(boolean b) {
        this.isStudyIuidQuery = b;
    }

    public DicomObject getQueryDicomObject() {
        BasicDicomObject obj = new BasicDicomObject();
        obj.putString(524370, VR.CS, "STUDY");
        if (this.extendedQuery && this.isStudyIuidQuery) {
            obj.putString(0x20000D, VR.UI, this.studyInstanceUID);
        } else {
            obj.putString(0x100010, VR.PN, QueryUtil.checkAutoWildcard(this.patientName, this.isPNAutoWildcard()));
            obj.putString(0x100020, VR.LO, QueryUtil.checkAutoWildcard(this.patientID, this.isAutoWildcard()));
            obj.putString(0x100021, VR.LO, QueryUtil.checkAutoWildcard(this.issuerOfPatientID, this.isAutoWildcard()));
            if (this.extendedQuery) {
                obj.putDateRange(0x100030, VR.DA, new DateRange(this.birthDateMin, this.birthDateMax));
            }
            DicomObject item = obj.putSequence(0x400100).addDicomObject((DicomObject)new BasicDicomObject());
            item.putString(524368, VR.SH, QueryUtil.checkAutoWildcard(this.accessionNumber, this.isAutoWildcard()));
            item.putString(524384, VR.CS, this.modality);
            item.putString(0x400001, VR.AE, this.scheduledStationAET);
            item.putString(0x400010, VR.SH, this.scheduledStationName);
            item.putString(0x400020, VR.CS, this.spsStatus);
            item.putDateRange(0x404005, VR.DT, new DateRange(this.startDateMin, this.startDateMax));
        }
        return obj;
    }
}

