/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.worklist.modality;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.common.SPSStatus;
import org.dcm4chee.archive.entity.MWLItem;
import org.dcm4chee.archive.entity.Study;
import org.dcm4chee.web.dao.util.QueryUtil;
import org.dcm4chee.web.dao.worklist.modality.ModalityWorklistFilter;
import org.dcm4chee.web.dao.worklist.modality.ModalityWorklistLocal;
import org.jboss.annotation.ejb.LocalBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@LocalBinding(jndiBinding="dcm4chee-web-ear/ModalityWorklistBean/local")
public class ModalityWorklistBean
implements ModalityWorklistLocal {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    @Override
    public List<MWLItem> findAll() {
        List l = this.em.createQuery("FROM MWLItem mwlItem ORDER BY mwlItem.studyInstanceUID").getResultList();
        this.em.clear();
        return l;
    }

    @Override
    public int countMWLItems(ModalityWorklistFilter filter) {
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT COUNT(*)");
        ModalityWorklistBean.appendFromClause(ql, filter);
        ModalityWorklistBean.appendWhereClause(ql, filter);
        Query query = this.em.createQuery(ql.toString());
        ModalityWorklistBean.setQueryParameters(query, filter);
        return ((Number)query.getSingleResult()).intValue();
    }

    @Override
    public List<MWLItem> findMWLItems(ModalityWorklistFilter filter, int max, int index) {
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT m");
        ModalityWorklistBean.appendFromClause(ql, filter);
        ModalityWorklistBean.appendWhereClause(ql, filter);
        ql.append(" ORDER BY p.patientName, m.startDateTime");
        if (filter.isLatestItemsFirst()) {
            ql.append(" DESC");
        }
        Query query = this.em.createQuery(ql.toString());
        ModalityWorklistBean.setQueryParameters(query, filter);
        return query.setMaxResults(max).setFirstResult(index).getResultList();
    }

    private static void appendFromClause(StringBuilder ql, ModalityWorklistFilter filter) {
        ql.append(ql.toString().startsWith("SELECT COUNT(*)") ? " FROM MWLItem m LEFT JOIN m.patient p " : " FROM MWLItem m LEFT JOIN FETCH m.patient p ");
    }

    private static void appendWhereClause(StringBuilder ql, ModalityWorklistFilter filter) {
        ql.append(" WHERE p.mergedWith IS NULL");
        if (filter.isExtendedQuery() && !QueryUtil.isUniversalMatch(filter.getStudyInstanceUID())) {
            ql.append(" AND m.studyInstanceUID = :studyInstanceUID");
        } else {
            if (filter.isFuzzyPN()) {
                QueryUtil.appendPatientNameFuzzyFilter(ql, filter.getPatientName());
            } else {
                QueryUtil.appendPatientNameFilter(ql, QueryUtil.checkAutoWildcard(filter.getPatientName(), filter.isPNAutoWildcard()));
            }
            ModalityWorklistBean.appendPatientIDFilter(ql, QueryUtil.checkAutoWildcard(filter.getPatientID(), filter.isAutoWildcard()));
            ModalityWorklistBean.appendIssuerOfPatientIDFilter(ql, QueryUtil.checkAutoWildcard(filter.getIssuerOfPatientID(), filter.isAutoWildcard()));
            if (filter.isExtendedQuery()) {
                ModalityWorklistBean.appendPatientBirthDateFilter(ql, filter.getBirthDateMin(), filter.getBirthDateMax());
            }
            ModalityWorklistBean.appendAccessionNumberFilter(ql, QueryUtil.checkAutoWildcard(filter.getAccessionNumber(), filter.isAutoWildcard()));
            ModalityWorklistBean.appendStartDateMinFilter(ql, filter.getStartDateMin());
            ModalityWorklistBean.appendStartDateMaxFilter(ql, filter.getStartDateMax());
            ModalityWorklistBean.appendModalityFilter(ql, filter.getModality());
            ModalityWorklistBean.appendScheduledStationAETFilter(ql, filter.getScheduledStationAETs());
            ModalityWorklistBean.appendScheduledStationNameFilter(ql, filter.getScheduledStationName());
            ModalityWorklistBean.appendScheduledProcedureStepStatus(ql, filter.getSPSStatus());
        }
    }

    private static void setQueryParameters(Query query, ModalityWorklistFilter filter) {
        if (filter.isExtendedQuery() && !QueryUtil.isUniversalMatch(filter.getStudyInstanceUID())) {
            ModalityWorklistBean.setStudyInstanceUIDQueryParameter(query, filter.getStudyInstanceUID());
        } else {
            if (filter.isFuzzyPN()) {
                QueryUtil.setPatientNameFuzzyQueryParameter(query, filter.getPatientName());
            } else {
                QueryUtil.setPatientNameQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getPatientName(), filter.isPNAutoWildcard()));
            }
            ModalityWorklistBean.setPatientIDQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getPatientID(), filter.isAutoWildcard()));
            ModalityWorklistBean.setIssuerOfPatientIDQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getIssuerOfPatientID(), filter.isAutoWildcard()));
            if (filter.isExtendedQuery()) {
                ModalityWorklistBean.setPatientBirthDateQueryParameter(query, filter.getBirthDateMin(), filter.getBirthDateMax());
            }
            ModalityWorklistBean.setAccessionNumberQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getAccessionNumber(), filter.isAutoWildcard()));
            ModalityWorklistBean.setStartDateMinQueryParameter(query, filter.getStartDateMin());
            ModalityWorklistBean.setStartDateMaxQueryParameter(query, filter.getStartDateMax());
            ModalityWorklistBean.setModalityQueryParameter(query, filter.getModality());
            ModalityWorklistBean.setScheduledStationAETQueryParameter(query, filter.getScheduledStationAETs());
            ModalityWorklistBean.setScheduledStationNameQueryParameter(query, filter.getScheduledStationName());
            ModalityWorklistBean.setScheduledProcedureStepStatusQueryParameter(query, filter.getSPSStatus());
        }
    }

    private static void appendPatientIDFilter(StringBuilder ql, String patientID) {
        QueryUtil.appendANDwithTextValue(ql, "p.patientID", "patientID", patientID);
    }

    private static void setPatientIDQueryParameter(Query query, String patientID) {
        QueryUtil.setTextQueryParameter(query, "patientID", patientID);
    }

    private static void appendIssuerOfPatientIDFilter(StringBuilder ql, String issuerOfPatientID) {
        QueryUtil.appendANDwithTextValue(ql, "p.issuerOfPatientID", "issuerOfPatientID", issuerOfPatientID);
    }

    private static void setIssuerOfPatientIDQueryParameter(Query query, String issuerOfPatientID) {
        QueryUtil.setTextQueryParameter(query, "issuerOfPatientID", issuerOfPatientID);
    }

    private static void appendPatientBirthDateFilter(StringBuilder ql, Date minDate, Date maxDate) {
        if (minDate != null) {
            if (maxDate == null) {
                ql.append(" AND p.patientBirthDate >= :birthdateMin");
            } else {
                ql.append(" AND p.patientBirthDate BETWEEN :birthdateMin AND :birthdateMax");
            }
        } else if (maxDate != null) {
            ql.append(" AND p.patientBirthDate <= :birthdateMax");
        }
    }

    private static void setPatientBirthDateQueryParameter(Query query, Date minDate, Date maxDate) {
        if (minDate != null) {
            query.setParameter("birthdateMin", (Object)sdf.format(minDate));
        }
        if (maxDate != null) {
            query.setParameter("birthdateMax", (Object)sdf.format(maxDate));
        }
    }

    private static void appendStartDateMinFilter(StringBuilder ql, Date date) {
        if (date != null) {
            ql.append(" AND m.startDateTime >= :startDateTimeMin");
        }
    }

    private static void appendStartDateMaxFilter(StringBuilder ql, Date date) {
        if (date != null) {
            ql.append(" AND m.startDateTime <= :startDateTimeMax");
        }
    }

    private static void setStartDateMinQueryParameter(Query query, Date date) {
        ModalityWorklistBean.setStartDateQueryParameter(query, date, "startDateTimeMin");
    }

    private static void setStartDateMaxQueryParameter(Query query, Date date) {
        ModalityWorklistBean.setStartDateQueryParameter(query, date, "startDateTimeMax");
    }

    private static void setStartDateQueryParameter(Query query, Date startDate, String param) {
        if (startDate != null) {
            query.setParameter(param, startDate, TemporalType.TIMESTAMP);
        }
    }

    private static void appendAccessionNumberFilter(StringBuilder ql, String accessionNumber) {
        QueryUtil.appendANDwithTextValue(ql, "m.accessionNumber", "accessionNumber", accessionNumber);
    }

    private static void setAccessionNumberQueryParameter(Query query, String accessionNumber) {
        QueryUtil.setTextQueryParameter(query, "accessionNumber", accessionNumber);
    }

    private static void setStudyInstanceUIDQueryParameter(Query query, String studyInstanceUID) {
        if (!QueryUtil.isUniversalMatch(studyInstanceUID)) {
            query.setParameter("studyInstanceUID", (Object)studyInstanceUID);
        }
    }

    private static void appendModalityFilter(StringBuilder ql, String modality) {
        if (!QueryUtil.isUniversalMatch(modality)) {
            ql.append(" AND m.modality = :modality");
        }
    }

    private static void setModalityQueryParameter(Query query, String modality) {
        if (!QueryUtil.isUniversalMatch(modality)) {
            query.setParameter("modality", (Object)modality);
        }
    }

    private static void appendScheduledStationAETFilter(StringBuilder ql, String[] scheduledStationAETs) {
        if (!QueryUtil.isUniversalMatch(scheduledStationAETs)) {
            if (scheduledStationAETs.length == 1) {
                ql.append(" AND m.scheduledStationAET = :scheduledStationAET");
            } else {
                ql.append(" AND m.scheduledStationAET");
                QueryUtil.appendIN(ql, scheduledStationAETs.length);
            }
        }
    }

    private static void setScheduledStationAETQueryParameter(Query query, String[] scheduledStationAETs) {
        if (!QueryUtil.isUniversalMatch(scheduledStationAETs)) {
            if (scheduledStationAETs.length == 1) {
                query.setParameter("scheduledStationAET", (Object)scheduledStationAETs[0]);
            } else {
                QueryUtil.setParametersForIN(query, scheduledStationAETs);
            }
        }
    }

    private static void appendScheduledStationNameFilter(StringBuilder ql, String scheduledStationName) {
        if (!QueryUtil.isUniversalMatch(scheduledStationName)) {
            ql.append(" AND m.scheduledStationName = :scheduledStationName");
        }
    }

    private static void setScheduledStationNameQueryParameter(Query query, String scheduledStationName) {
        if (!QueryUtil.isUniversalMatch(scheduledStationName)) {
            query.setParameter("scheduledStationName", (Object)scheduledStationName);
        }
    }

    private static void appendScheduledProcedureStepStatus(StringBuilder ql, String scheduledProcedureStepStatus) {
        if (!QueryUtil.isUniversalMatch(scheduledProcedureStepStatus)) {
            ql.append(" AND m.status = :scheduledProcedureStepStatus");
        }
    }

    private static void setScheduledProcedureStepStatusQueryParameter(Query query, String scheduledProcedureStepStatus) {
        if (!QueryUtil.isUniversalMatch(scheduledProcedureStepStatus)) {
            query.setParameter("scheduledProcedureStepStatus", (Object)SPSStatus.valueOf((String)scheduledProcedureStepStatus));
        }
    }

    public List<Study> findMWLItemsOfPatient(long pk, boolean latestStudyFirst) {
        return this.em.createQuery(latestStudyFirst ? "FROM Study s WHERE s.patient.pk=?1 ORDER BY s.studyDateTime DESC" : "FROM Study s WHERE s.patient.pk=?1 ORDER BY s.studyDateTime").setParameter(1, (Object)pk).getResultList();
    }

    @Override
    public List<String> selectDistinctModalities() {
        return this.em.createQuery("SELECT DISTINCT m.modality FROM MWLItem m WHERE m.modality IS NOT NULL ORDER BY m.modality").getResultList();
    }

    @Override
    public List<String> selectDistinctStationAETs() {
        return this.em.createQuery("SELECT DISTINCT m.scheduledStationAET FROM MWLItem m WHERE m.scheduledStationAET IS NOT NULL ORDER BY m.scheduledStationAET").getResultList();
    }

    @Override
    public List<String> selectDistinctStationNames() {
        return this.em.createQuery("SELECT DISTINCT m.scheduledStationName FROM MWLItem m WHERE m.scheduledStationName IS NOT NULL ORDER BY m.scheduledStationName").getResultList();
    }

    public List<String> selectDistinctStatus() {
        return this.em.createQuery("SELECT DISTINCT m.status FROM MWLItem m WHERE m.status IS NOT NULL ORDER BY m.status").getResultList();
    }

    @Override
    public MWLItem getMWLItem(long pk) {
        return (MWLItem)this.em.find(MWLItem.class, (Object)pk);
    }

    @Override
    public MWLItem updateMWLItem(long pk, DicomObject attrs) {
        MWLItem mwlItem = (MWLItem)this.em.find(MWLItem.class, (Object)pk);
        mwlItem.setAttributes(attrs);
        return mwlItem;
    }

    @Override
    public boolean hasMPPS(String accessionNumber) {
        return ((Number)this.em.createQuery("SELECT COUNT(*) FROM MPPS mpps WHERE mpps.accessionNumber IS NOT NULL AND mpps.accessionNumber = :accessionNumber").setParameter("accessionNumber", (Object)accessionNumber).getSingleResult()).intValue() > 0;
    }

    @Override
    public void removeMWLItem(long pk) {
        MWLItem mwlItem = (MWLItem)this.em.find(MWLItem.class, (Object)pk);
        this.em.remove((Object)mwlItem);
    }
}

