/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcm4chee.archive.entity.MPPS;
import org.dcm4chee.archive.entity.MWLItem;
import org.dcm4chee.archive.entity.Study;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MppsToMwlLinkResult
implements Serializable {
    private static final long serialVersionUID = 3468299157101603139L;
    private MWLItem mwl;
    private List<MPPS> mppss = new ArrayList<MPPS>();
    private Set<Study> studiesToMove = new HashSet<Study>();

    public void setMwl(MWLItem mwl) {
        this.mwl = mwl;
    }

    public void addMppsAttributes(MPPS mpps) {
        this.mppss.add(mpps);
    }

    public void addStudyToMove(Study study) {
        this.studiesToMove.add(study);
    }

    public MWLItem getMwl() {
        return this.mwl;
    }

    public List<MPPS> getMppss() {
        return this.mppss;
    }

    public Set<Study> getStudiesToMove() {
        return this.studiesToMove;
    }

    public boolean isUnlinkResult() {
        return this.mwl == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MppsToMwlLinkResult:");
        if (this.mwl == null) {
            sb.append("UNLINK\nMPPS Attrs(previous):").append(this.mppss.get(0).getAttributes());
        } else {
            sb.append("LINK\nMWL Attrs:\n").append(this.mwl.getAttributes());
            sb.append("\n\nlinked MPPS: ").append(this.mppss.size());
            for (MPPS mpps : this.mppss) {
                sb.append("\nMPPS Attributes:").append(mpps).append("\n");
            }
            if (this.studiesToMove.size() > 0) {
                sb.append("\n Patient(s) of MPPSs was different to MWL patient! need move of studies:");
                for (Study s : this.studiesToMove) {
                    sb.append("\nStudyIuid:").append(s.getStudyInstanceUID());
                }
            }
        }
        return sb.toString();
    }
}

