/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.vo;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcm4chee.archive.entity.Instance;
import org.dcm4chee.archive.entity.MPPS;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.entity.Series;
import org.dcm4chee.archive.entity.Study;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTree
implements Serializable {
    private static final long serialVersionUID = 3468299157101603139L;
    private Collection<Instance> allInstances;
    private Map<Patient, Map<Study, Map<Series, Set<Instance>>>> entityTreeMap = new HashMap<Patient, Map<Study, Map<Series, Set<Instance>>>>();
    private static Logger log = LoggerFactory.getLogger(EntityTree.class);

    public EntityTree() {
        this.allInstances = new HashSet<Instance>();
    }

    public EntityTree(int size) {
        this.allInstances = new HashSet<Instance>(size);
    }

    public EntityTree(Collection<Instance> instances) {
        this(instances.size());
        this.addInstances(instances);
    }

    public EntityTree addInstances(Collection<Instance> instances) {
        for (Instance i : instances) {
            this.addInstance(i);
        }
        return this;
    }

    public void addInstance(Instance instance) {
        Set<Instance> instances;
        Map<Series, Set<Instance>> mapSeries;
        Study study;
        Patient pat;
        Map<Study, Map<Series, Set<Instance>>> mapStudies;
        if (!this.allInstances.add(instance)) {
            log.warn("Instance already in this EntityTree! :" + instance.getSOPInstanceUID());
            return;
        }
        Series series = instance.getSeries();
        MPPS mpps = series.getModalityPerformedProcedureStep();
        if (mpps != null) {
            mpps.getPatient();
        }
        if ((mapStudies = this.entityTreeMap.get(pat = (study = series.getStudy()).getPatient())) == null) {
            mapStudies = new HashMap<Study, Map<Series, Set<Instance>>>();
            this.entityTreeMap.put(pat, mapStudies);
        }
        if ((mapSeries = mapStudies.get(study)) == null) {
            mapSeries = new HashMap<Series, Set<Instance>>();
            instances = new HashSet<Instance>();
            mapSeries.put(series, instances);
            mapStudies.put(study, mapSeries);
        } else {
            instances = mapSeries.get(series);
            if (instances == null) {
                instances = new HashSet<Instance>();
                mapSeries.put(series, instances);
            }
        }
        instances.add(instance);
    }

    public void addSeries(Series series) {
        Map<Series, Set<Instance>> mapSeries;
        Study study = series.getStudy();
        Patient pat = study.getPatient();
        Map<Study, Map<Series, Set<Instance>>> mapStudies = this.entityTreeMap.get(pat);
        if (mapStudies == null) {
            mapStudies = new HashMap<Study, Map<Series, Set<Instance>>>();
            this.entityTreeMap.put(pat, mapStudies);
            mapSeries = new HashMap<Series, Set<Instance>>();
            mapStudies.put(study, mapSeries);
        } else {
            mapSeries = mapStudies.get(study);
        }
        Set instances = series.getInstances();
        mapSeries.put(series, instances);
        if (instances != null) {
            this.allInstances.addAll(instances);
        }
    }

    public void addStudy(Study study) {
        Patient pat = study.getPatient();
        HashMap<Series, Set> mapSeries = new HashMap<Series, Set>();
        Map<Study, Map<Series, Set<Instance>>> mapStudies = this.entityTreeMap.get(pat);
        if (mapStudies == null) {
            mapStudies = new HashMap<Study, Map<Series, Set<Instance>>>();
            this.entityTreeMap.put(pat, mapStudies);
        }
        mapStudies.put(study, mapSeries);
        for (Series series : study.getSeries()) {
            Set instances = series.getInstances();
            mapSeries.put(series, instances);
            this.allInstances.addAll(series.getInstances());
            if (instances == null) continue;
            this.allInstances.addAll(instances);
        }
    }

    public void addPatient(Patient pat) {
        if (this.entityTreeMap.get(pat) == null) {
            this.entityTreeMap.put(pat, new HashMap());
        }
    }

    public boolean isEmpty() {
        return this.allInstances.isEmpty();
    }

    public Collection<Instance> getAllInstances() {
        return this.allInstances;
    }

    public Map<Patient, Map<Study, Map<Series, Set<Instance>>>> getEntityTreeMap() {
        return this.entityTreeMap;
    }
}

