/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.util;

import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.dcm4chee.archive.common.Availability;
import org.dcm4chee.archive.entity.Series;
import org.dcm4chee.archive.entity.Study;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDerivedFieldsUtil {
    private static Logger log = LoggerFactory.getLogger(UpdateDerivedFieldsUtil.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    public UpdateDerivedFieldsUtil(EntityManager em) {
        this.em = em;
    }

    public void updateDerivedFieldsOfSeries(Series series) {
        this.updateNumberOfSeriesRelatedInstances(series);
        this.updateAvailability(series);
        this.em.merge((Object)series);
    }

    public void updateDerivedFieldsOfStudy(Study study) {
        for (Series s : study.getSeries()) {
            this.updateDerivedFieldsOfSeries(s);
        }
        this.updateNumberOfStudyRelatedSeriesAndInstances(study);
        this.updateModalitiesInStudy(study);
        this.updateAvailability(study);
        this.em.merge((Object)study);
    }

    private void updateNumberOfStudyRelatedSeriesAndInstances(Study study) {
        Query qS = this.em.createQuery("SELECT count(s) FROM Study st INNER JOIN st.series s WHERE st.pk = :pk");
        qS.setParameter("pk", (Object)study.getPk());
        Long nos = (Long)qS.getSingleResult();
        Query qI = this.em.createQuery("SELECT count(i) FROM Study st INNER JOIN st.series s INNER JOIN s.instances i WHERE st.pk = :pk");
        qI.setParameter("pk", (Object)study.getPk());
        Long noi = (Long)qI.getSingleResult();
        study.setNumberOfStudyRelatedSeries(nos.intValue());
        study.setNumberOfStudyRelatedInstances(noi.intValue());
    }

    private void updateNumberOfSeriesRelatedInstances(Series series) {
        Query qI = this.em.createQuery("SELECT count(i) FROM Series s INNER JOIN s.instances i WHERE s.pk = :pk");
        qI.setParameter("pk", (Object)series.getPk());
        Long noi = (Long)qI.getSingleResult();
        series.setNumberOfSeriesRelatedInstances(noi.intValue());
    }

    public boolean updateModalitiesInStudy(Study study) {
        String mds = "";
        if (study.getNumberOfStudyRelatedInstances() > 0) {
            Query qM = this.em.createQuery("SELECT DISTINCT s.modality FROM Study st, IN(st.series) s WHERE st.pk = :pk");
            qM.setParameter("pk", (Object)study.getPk());
            List modalities = qM.getResultList();
            if (modalities.remove(null)) {
                log.warn("Study[iuid=" + study.getStudyInstanceUID() + "] contains Series with unspecified Modality");
            }
            if (!modalities.isEmpty()) {
                Iterator it = modalities.iterator();
                StringBuffer sb = new StringBuffer((String)it.next());
                while (it.hasNext()) {
                    sb.append('\\').append(it.next());
                }
                mds = sb.toString();
            }
        }
        if (mds.equals(study.getModalitiesInStudy())) {
            return false;
        }
        study.setModalitiesInStudy(mds);
        return true;
    }

    private boolean updateAvailability(Study study) {
        Availability prevAvailability;
        Availability availability = null;
        if (study.getNumberOfStudyRelatedInstances() > 0) {
            Query qA = this.em.createQuery("SELECT MAX(s.availability) FROM Series s WHERE s.study.pk = :pk");
            qA.setParameter("pk", (Object)study.getPk());
            availability = (Availability)qA.getSingleResult();
        }
        if (availability == null) {
            availability = Availability.ONLINE;
        }
        if (availability.equals((Object)(prevAvailability = study.getAvailability()))) {
            return false;
        }
        study.setAvailability(availability);
        if (log.isDebugEnabled()) {
            log.debug("update Availability of Study[pk=" + study.getPk() + ", uid=" + study.getStudyInstanceUID() + "] from " + prevAvailability.name() + " to " + availability.name());
        }
        return true;
    }

    private boolean updateAvailability(Series series) {
        log.info("Update availability of series pk:" + series.getPk());
        Availability availability = null;
        if (series.getNumberOfSeriesRelatedInstances() > 0) {
            Query qA = this.em.createQuery("SELECT MAX(i.availability) FROM Instance i WHERE i.series.pk = :pk");
            qA.setParameter("pk", (Object)series.getPk());
            availability = (Availability)qA.getSingleResult();
            log.info("found availabilty for series from instances" + availability);
        }
        if (availability == null) {
            availability = Availability.ONLINE;
        }
        Availability prevAvailability = series.getAvailability();
        log.info("availabilty:" + availability.name() + " prevAvailability:" + prevAvailability.name() + " prevAvailability:" + prevAvailability);
        if (availability.equals((Object)prevAvailability)) {
            return false;
        }
        series.setAvailability(availability);
        if (log.isDebugEnabled()) {
            log.debug("update Availability of Study[pk=" + series.getPk() + ", uid=" + series.getSeriesInstanceUID() + "] from " + prevAvailability.name() + " to " + availability.name());
        }
        return true;
    }
}

