/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.dcm4che2.data.PersonName;
import org.dcm4chee.archive.conf.AttributeFilter;

public class QueryUtil {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private static final String ESCAPE_CHAR = "|";

    public static Query getQueryForPks(EntityManager em, String base, long[] pks) {
        Query q;
        int len = pks.length;
        if (len == 1) {
            q = em.createQuery(base + "= :pk").setParameter("pk", (Object)pks[0]);
        } else {
            StringBuilder sb = new StringBuilder(base);
            QueryUtil.appendIN(sb, len);
            q = em.createQuery(sb.toString());
            QueryUtil.setParametersForIN(q, pks);
        }
        return q;
    }

    public static void appendIN(StringBuilder sb, int len) {
        sb.append(" IN ( ?");
        for (int i = 1; i < len; ++i) {
            sb.append(i).append(", ?");
        }
        sb.append(len).append(" )");
    }

    public static void setParametersForIN(Query q, long[] pks) {
        int i = 1;
        for (long pk : pks) {
            q.setParameter(i++, (Object)pk);
        }
    }

    public static void setParametersForIN(Query q, Object[] values) {
        int i = 1;
        for (Object v : values) {
            q.setParameter(i++, v);
        }
    }

    public static Query getPatientQuery(EntityManager em, String patId, String issuer) {
        StringBuilder sb = new StringBuilder();
        boolean useIssuer = issuer != null && issuer.trim().length() > 0;
        sb.append("SELECT OBJECT(p) FROM Patient p WHERE patientID = :patId");
        if (useIssuer) {
            sb.append(" AND issuerOfPatientID = :issuer");
        }
        Query qP = em.createQuery(sb.toString()).setParameter("patId", (Object)patId);
        if (useIssuer) {
            qP.setParameter("issuer", (Object)issuer);
        }
        return qP;
    }

    public static String checkAutoWildcard(String s, boolean allowWildcard) {
        if (QueryUtil.isUniversalMatch(s)) {
            return null;
        }
        if (!allowWildcard || s.indexOf(42) != -1 || s.indexOf(63) != -1 || s.indexOf(94) != -1) {
            return s;
        }
        return s + '*';
    }

    public static boolean isUniversalMatch(String s) {
        return s == null || s.length() == 0 || s.equals("*");
    }

    public static boolean isUniversalMatch(String[] sa) {
        if (sa == null || sa.length == 0) {
            return true;
        }
        for (int i = 0; i < sa.length; ++i) {
            if (sa[i] != null && !sa[i].equals("*")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWildcard(String s) {
        return s.indexOf(42) != -1 || s.indexOf(63) != -1;
    }

    public static boolean needEscape(String s) {
        return s.indexOf(37) != -1 || s.indexOf(95) != -1;
    }

    public static boolean isMustNotNull(String s) {
        return "?*".equals(s) || "*?".equals(s);
    }

    public static String toLike(String s) {
        StringBuilder param = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(s, "*?_%", true);
        block6: while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            switch (token.charAt(0)) {
                case '%': {
                    param.append("|%");
                    continue block6;
                }
                case '*': {
                    param.append('%');
                    continue block6;
                }
                case '?': {
                    param.append('_');
                    continue block6;
                }
                case '_': {
                    param.append("|_");
                    continue block6;
                }
            }
            param.append(token);
        }
        return param.toString();
    }

    public static void appendANDwithTextValue(StringBuilder ql, String fieldName, String varName, String value) {
        if (value != null) {
            ql.append(" AND ").append(fieldName);
            if ("-".equals(value)) {
                ql.append(" IS NULL");
            } else if (QueryUtil.isMustNotNull(value)) {
                ql.append(" IS NOT NULL");
            } else if (QueryUtil.containsWildcard(value)) {
                ql.append(" LIKE ");
                if (QueryUtil.needEscape(value)) {
                    ql.append("'").append(QueryUtil.toLike(value)).append("' ESCAPE '|' ");
                } else {
                    ql.append(QueryUtil.toVarName(fieldName, varName));
                }
            } else {
                ql.append(" = ").append(QueryUtil.toVarName(fieldName, varName));
            }
        }
    }

    public static void setTextQueryParameter(Query query, String varName, String value) {
        if (!(value == null || "-".equals(value) || QueryUtil.isMustNotNull(value) || QueryUtil.containsWildcard(value) && QueryUtil.needEscape(value))) {
            query.setParameter(varName, (Object)(QueryUtil.containsWildcard(value) ? QueryUtil.toLike(value) : value));
        }
    }

    public static void appendPatientNameFilter(StringBuilder ql, String patientName) {
        QueryUtil.appendPatientName(ql, "p.patientName", ":patientName", patientName);
    }

    public static void appendPatientName(StringBuilder ql, String fieldName, String varName, String patientName) {
        if (patientName != null) {
            ql.append(" AND ").append(fieldName).append(" LIKE ");
            if (QueryUtil.needEscape(patientName)) {
                ql.append("'").append(QueryUtil.toPatientNameQueryString(patientName)).append("' ESCAPE '|' ");
            } else {
                ql.append(QueryUtil.toVarName(fieldName, varName));
            }
        }
    }

    public static void appendPatientNameFuzzyFilter(StringBuilder ql, String patientName) {
        QueryUtil.appendPersonNameFuzzyFilter(ql, "p.patientFamilyNameSoundex", "p.patientGivenNameSoundex", patientName);
    }

    public static void appendPersonNameFuzzyFilter(StringBuilder ql, String fnField, String gnField, String name) {
        PersonName pn = new PersonName(name);
        String fnSoundex = AttributeFilter.toSoundexWithLike((PersonName)pn, (int)0);
        String gnSoundex = AttributeFilter.toSoundexWithLike((PersonName)pn, (int)1);
        if (fnSoundex != null && gnSoundex != null) {
            ql.append(" AND ((").append(fnField).append(QueryUtil.like(fnSoundex)).append(" :fnsx OR ").append(fnField).append(" ='*')").append(" AND (").append(gnField).append(QueryUtil.like(gnSoundex)).append(" :gnsx OR ").append(gnField).append(" ='*')").append(" OR (").append(gnField).append(QueryUtil.like(fnSoundex)).append(" :fnsx OR ").append(gnField).append(" ='*')").append(" AND (").append(fnField).append(QueryUtil.like(gnSoundex)).append(" :gnsx OR ").append(fnField).append(" ='*'))");
        } else if (fnSoundex != null || gnSoundex != null) {
            String varName = fnSoundex != null ? " :fnsx" : " :gnsx";
            ql.append(" AND (").append(fnField).append(QueryUtil.like(fnSoundex)).append(varName).append(" OR ").append(gnField).append(QueryUtil.like(fnSoundex)).append(varName).append(" OR (").append(fnField).append(" ='*' AND ").append(gnField).append(" ='*'))");
        }
    }

    private static String like(String soundex) {
        return soundex != null && soundex.endsWith("%") ? " LIKE " : " = ";
    }

    public static void setPatientNameQueryParameter(Query query, String patientName) {
        QueryUtil.setPatientNameQueryParameter(query, "patientName", patientName);
    }

    public static void setPatientNameFuzzyQueryParameter(Query query, String patientName) {
        PersonName pn = new PersonName(patientName);
        String fnSoundex = AttributeFilter.toSoundexWithLike((PersonName)pn, (int)0);
        String gnSoundex = AttributeFilter.toSoundexWithLike((PersonName)pn, (int)1);
        if (fnSoundex != null) {
            query.setParameter("fnsx", (Object)fnSoundex);
        }
        if (gnSoundex != null) {
            query.setParameter("gnsx", (Object)gnSoundex);
        }
    }

    public static void setPatientNameQueryParameter(Query query, String varName, String patientName) {
        if (patientName != null && !QueryUtil.needEscape(patientName)) {
            query.setParameter(varName, (Object)QueryUtil.toPatientNameQueryString(patientName));
        }
    }

    public static void appendPatientIDFilter(StringBuilder ql, String patientID) {
        QueryUtil.appendANDwithTextValue(ql, "p.patientID", "patientID", patientID);
    }

    public static void setPatientIDQueryParameter(Query query, String patientID) {
        QueryUtil.setTextQueryParameter(query, "patientID", patientID);
    }

    public static void appendIssuerOfPatientIDFilter(StringBuilder ql, String issuerOfPatientID) {
        QueryUtil.appendANDwithTextValue(ql, "p.issuerOfPatientID", "issuerOfPatientID", issuerOfPatientID);
    }

    public static void setIssuerOfPatientIDQueryParameter(Query query, String issuerOfPatientID) {
        QueryUtil.setTextQueryParameter(query, "issuerOfPatientID", issuerOfPatientID);
    }

    public static void appendPatientBirthDateFilter(StringBuilder ql, Date minDate, Date maxDate) {
        if (minDate != null) {
            if (maxDate == null) {
                ql.append(" AND p.patientBirthDate >= :birthdateMin");
            } else {
                ql.append(" AND p.patientBirthDate BETWEEN :birthdateMin AND :birthdateMax");
            }
        } else if (maxDate != null) {
            ql.append(" AND p.patientBirthDate <= :birthdateMax");
        }
    }

    public static void setPatientBirthDateQueryParameter(Query query, Date minDate, Date maxDate) {
        if (minDate != null) {
            query.setParameter("birthdateMin", (Object)sdf.format(minDate));
        }
        if (maxDate != null) {
            query.setParameter("birthdateMax", (Object)sdf.format(maxDate));
        }
    }

    public static void appendStudyDateMinFilter(StringBuilder ql, Date date) {
        if (date != null) {
            ql.append(" AND s.studyDateTime >= :studyDateTimeMin");
        }
    }

    public static void appendStudyDateMaxFilter(StringBuilder ql, Date date) {
        if (date != null) {
            ql.append(" AND s.studyDateTime <= :studyDateTimeMax");
        }
    }

    public static void setStudyDateMinQueryParameter(Query query, Date date) {
        QueryUtil.setStudyDateQueryParameter(query, date, "studyDateTimeMin");
    }

    public static void setStudyDateMaxQueryParameter(Query query, Date date) {
        QueryUtil.setStudyDateQueryParameter(query, date, "studyDateTimeMax");
    }

    public static void setStudyDateQueryParameter(Query query, Date studyDate, String param) {
        if (studyDate != null) {
            query.setParameter(param, studyDate, TemporalType.TIMESTAMP);
        }
    }

    public static void appendAccessionNumberFilter(StringBuilder ql, String accessionNumber) {
        QueryUtil.appendANDwithTextValue(ql, "s.accessionNumber", "accessionNumber", accessionNumber);
    }

    public static void setAccessionNumberQueryParameter(Query query, String accessionNumber) {
        QueryUtil.setTextQueryParameter(query, "accessionNumber", accessionNumber);
    }

    public static void appendPpsWithoutMwlFilter(StringBuilder ql, boolean withoutPps, boolean ppsWithoutMwl) {
        if (withoutPps || ppsWithoutMwl) {
            ql.append(" AND (");
            if (withoutPps) {
                ql.append("EXISTS (SELECT ser FROM s.series ser WHERE ser.modalityPerformedProcedureStep IS NULL)").append(ppsWithoutMwl ? " OR " : ")");
            }
            if (ppsWithoutMwl) {
                ql.append("EXISTS (SELECT ser FROM s.series ser WHERE ser.modalityPerformedProcedureStep").append(" IS NOT NULL AND ser.modalityPerformedProcedureStep.accessionNumber IS NULL))");
            }
        }
    }

    public static void setStudyInstanceUIDQueryParameter(Query query, String studyInstanceUID) {
        if (!QueryUtil.isUniversalMatch(studyInstanceUID)) {
            query.setParameter("studyInstanceUID", (Object)studyInstanceUID);
        }
    }

    public static void appendDicomSecurityFilter(StringBuilder ql) {
        ql.append(" AND (s.studyInstanceUID IN (SELECT sp.studyInstanceUID FROM StudyPermission sp WHERE sp.action = 'Q' AND sp.role IN (:roles)))");
    }

    public static void appendModalityFilter(StringBuilder ql, String modality) {
        if (!QueryUtil.isUniversalMatch(modality)) {
            ql.append(" AND EXISTS (SELECT ser FROM s.series ser WHERE ser.modality = :modality)");
        }
    }

    public static void appendModalitiesInStudyExactFilter(StringBuilder ql, String modality) {
        if (!QueryUtil.isUniversalMatch(modality)) {
            ql.append(" AND s.modalitiesInStudy = :modality");
        }
    }

    public static void setModalityQueryParameter(Query query, String modality) {
        if (!QueryUtil.isUniversalMatch(modality)) {
            query.setParameter("modality", (Object)modality);
        }
    }

    public static void appendSourceAETFilter(StringBuilder ql, String[] sourceAETs) {
        if (!QueryUtil.isUniversalMatch(sourceAETs)) {
            if (sourceAETs.length == 1) {
                ql.append(" AND EXISTS (SELECT ser FROM s.series ser WHERE ser.sourceAET = :sourceAET)");
            } else {
                ql.append(" AND EXISTS (SELECT ser FROM s.series ser WHERE ser.sourceAET");
                QueryUtil.appendIN(ql, sourceAETs.length);
                ql.append(")");
            }
        }
    }

    public static void setSourceAETQueryParameter(Query query, String[] sourceAETs) {
        if (!QueryUtil.isUniversalMatch(sourceAETs)) {
            if (sourceAETs.length == 1) {
                query.setParameter("sourceAET", (Object)sourceAETs[0]);
            } else {
                QueryUtil.setParametersForIN(query, sourceAETs);
            }
        }
    }

    public static void appendSeriesInstanceUIDFilter(StringBuilder ql, String seriesInstanceUID) {
        if (!QueryUtil.isUniversalMatch(seriesInstanceUID)) {
            ql.append(" AND EXISTS (SELECT ser FROM s.series ser WHERE ser.seriesInstanceUID = :seriesInstanceUID)");
        }
    }

    public static void setSeriesInstanceUIDQueryParameter(Query query, String seriesInstanceUID) {
        if (!QueryUtil.isUniversalMatch(seriesInstanceUID)) {
            query.setParameter("seriesInstanceUID", (Object)seriesInstanceUID);
        }
    }

    public static void appendOrderBy(StringBuilder ql, String[] order) {
        if (order != null && order.length > 0) {
            ql.append(" ORDER BY ").append(order[0]);
            for (int i = 1; i < order.length; ++i) {
                if (order[i] == null) continue;
                ql.append(", ").append(order[i]);
            }
        }
    }

    private static String toPatientNameQueryString(String patientName) {
        int padcarets = 4;
        StringBuilder param = new StringBuilder();
        if (AttributeFilter.getPatientAttributeFilter().isICase(0x100010)) {
            patientName = patientName.toUpperCase();
        }
        StringTokenizer tokens = new StringTokenizer(patientName, "^*?_%", true);
        block7: while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            switch (token.charAt(0)) {
                case '%': {
                    param.append("|%");
                    continue block7;
                }
                case '*': {
                    param.append('%');
                    continue block7;
                }
                case '?': {
                    param.append('_');
                    continue block7;
                }
                case '^': {
                    --padcarets;
                    param.append('^');
                    continue block7;
                }
                case '_': {
                    param.append("|_");
                    continue block7;
                }
            }
            param.append(token);
        }
        while (padcarets-- > 0) {
            param.append("^%");
        }
        return param.toString();
    }

    private static Object toVarName(String fieldName, String varName) {
        if (varName == null) {
            if (fieldName == null) {
                throw new IllegalArgumentException("toVarName: filedName must not be null if varName is null");
            }
            int pos = fieldName.lastIndexOf(46);
            varName = ":" + fieldName.substring(++pos);
        } else if (varName.charAt(0) != ':') {
            varName = ":" + varName;
        }
        return varName;
    }

    public static int compareIntegerStringAndPk(long pk1, long pk2, String is1, String is2) {
        block11: {
            if (is1 != null) {
                if (is2 != null) {
                    try {
                        Integer i1 = new Integer(is1);
                        try {
                            int i = i1.compareTo(new Integer(is2));
                            if (i != 0) {
                                return i;
                            }
                            break block11;
                        }
                        catch (NumberFormatException x) {
                            return -1;
                        }
                    }
                    catch (NumberFormatException x) {
                        try {
                            Integer.parseInt(is2);
                            return 1;
                        }
                        catch (NumberFormatException x1) {
                            int i = is1.compareTo(is2);
                            if (i != 0) {
                                return i;
                            }
                            break block11;
                        }
                    }
                }
                return -1;
            }
            if (is2 != null) {
                return 1;
            }
        }
        return new Long(pk1).compareTo(new Long(pk2));
    }
}

