/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.util;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoercionUtil {
    private static Logger log = LoggerFactory.getLogger(CoercionUtil.class);

    public static void coerceAttributes(DicomObject attrs, DicomObject coerce) {
        CoercionUtil.coerceAttributes(attrs, coerce, null);
    }

    public static void coerceAttributes(DicomObject attrs, DicomObject coerce, DicomElement parent) {
        boolean coerced = false;
        for (DicomElement el : coerce) {
            DicomElement oldEl = attrs.get(el.tag());
            if (el.isEmpty()) {
                boolean bl = coerced = oldEl != null && !oldEl.isEmpty();
                if (oldEl == null || coerced) {
                    if (el.vr() == VR.SQ) {
                        attrs.putSequence(el.tag());
                    } else {
                        attrs.putBytes(el.tag(), el.vr(), el.getBytes());
                    }
                }
            } else {
                DicomElement sq = oldEl;
                if (el.vr() == VR.SQ) {
                    boolean bl = coerced = oldEl != null && sq.vr() != VR.SQ;
                    if (oldEl == null || coerced) {
                        sq = attrs.putSequence(el.tag());
                    }
                    int n = el.countItems();
                    int sqLen = sq.countItems();
                    for (int i = 0; i < n; ++i) {
                        DicomObject item;
                        if (i < sqLen) {
                            item = sq.getDicomObject(i);
                        } else {
                            item = new BasicDicomObject();
                            sq.addDicomObject(item);
                        }
                        DicomObject coerceItem = el.getDicomObject(i);
                        CoercionUtil.coerceAttributes(item, coerceItem, el);
                        if (coerceItem.isEmpty()) continue;
                        coerced = true;
                    }
                } else {
                    boolean bl = coerced = oldEl != null && !oldEl.equals(el);
                    if (oldEl == null || coerced) {
                        attrs.putBytes(el.tag(), el.vr(), el.getBytes());
                    }
                }
            }
            if (coerced) {
                log.info(parent == null ? "Coerce " + oldEl + " to " + el : "Coerce " + oldEl + " to " + el + " in item of " + parent);
                continue;
            }
            if (oldEl != null || !log.isDebugEnabled()) continue;
            log.debug(parent == null ? "Add " + el : "Add " + el + " in item of " + parent);
        }
    }
}

