/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.trash;

import java.io.Serializable;
import java.util.HashSet;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.AETGroup;
import org.dcm4chee.usr.util.JNDIUtils;

public class TrashListFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String patientName;
    private String patientID;
    private String issuerOfPatientID;
    private String accessionNumber;
    private String studyInstanceUID;
    private String sourceAET;
    private boolean patientQuery;
    private int autoWildcard = 0;

    public TrashListFilter(String forUsername) {
        this.clear();
    }

    public void clear() {
        this.sourceAET = null;
        this.studyInstanceUID = null;
        this.accessionNumber = null;
        this.issuerOfPatientID = null;
        this.patientID = null;
        this.patientName = null;
        this.patientQuery = false;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public void setPatientName(String patientName) {
        this.patientName = patientName;
    }

    public String getPatientID() {
        return this.patientID;
    }

    public void setPatientID(String patientID) {
        this.patientID = patientID;
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public void setIssuerOfPatientID(String issuerOfPatientID) {
        this.issuerOfPatientID = issuerOfPatientID;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String studyInstanceUID) {
        this.studyInstanceUID = studyInstanceUID;
    }

    public String getSourceAET() {
        return this.sourceAET;
    }

    public void setSourceAET(String sourceAET) {
        this.sourceAET = sourceAET;
    }

    public String[] getSourceAETs() {
        HashSet aetStringSet = new HashSet();
        if (this.sourceAET != null) {
            if (this.sourceAET.startsWith("(") && this.sourceAET.endsWith(")")) {
                String groupName = this.sourceAET.substring(1, this.sourceAET.length() - 1);
                for (AETGroup aetGroup : ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).getAllAETGroups()) {
                    if (!aetGroup.getGroupname().equals(groupName)) continue;
                    aetStringSet.addAll(aetGroup.getAets());
                }
            } else {
                return new String[]{this.sourceAET};
            }
        }
        return aetStringSet.toArray(new String[aetStringSet.size()]);
    }

    public boolean isPatientQuery() {
        return this.patientQuery;
    }

    public void setPatientQuery(boolean patQuery) {
        this.patientQuery = patQuery;
    }

    public boolean isAutoWildcard() {
        return this.autoWildcard > 1;
    }

    public boolean isPNAutoWildcard() {
        return this.autoWildcard > 0;
    }

    public void setAutoWildcard(int autoWildcard) {
        this.autoWildcard = autoWildcard;
    }
}

