/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.trash;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.PrivateFile;
import org.dcm4chee.archive.entity.PrivateInstance;
import org.dcm4chee.archive.entity.PrivatePatient;
import org.dcm4chee.archive.entity.PrivateSeries;
import org.dcm4chee.archive.entity.PrivateStudy;
import org.dcm4chee.archive.entity.Study;
import org.dcm4chee.web.dao.trash.TrashListFilter;
import org.dcm4chee.web.dao.trash.TrashListLocal;
import org.dcm4chee.web.dao.util.QueryUtil;
import org.jboss.annotation.ejb.LocalBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@LocalBinding(jndiBinding="dcm4chee-web-ear/TrashListBean/local")
public class TrashListBean
implements TrashListLocal {
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    private static Comparator<PrivateInstance> instanceComparator = new Comparator<PrivateInstance>(){

        @Override
        public int compare(PrivateInstance o1, PrivateInstance o2) {
            String in1 = o1.getAttributes().getString(2097171);
            String in2 = o2.getAttributes().getString(2097171);
            return QueryUtil.compareIntegerStringAndPk(o1.getPk(), o2.getPk(), in1, in2);
        }
    };
    private static Comparator<PrivateSeries> seriesComparator = new Comparator<PrivateSeries>(){

        @Override
        public int compare(PrivateSeries o1, PrivateSeries o2) {
            String in1 = o1.getAttributes().getString(0x200011);
            String in2 = o2.getAttributes().getString(0x200011);
            return QueryUtil.compareIntegerStringAndPk(o1.getPk(), o2.getPk(), in1, in2);
        }
    };

    @Override
    public int count(TrashListFilter filter, List<String> roles) {
        if (roles != null && roles.size() == 0) {
            return 0;
        }
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT COUNT(*)");
        TrashListBean.appendFromClause(ql, filter);
        TrashListBean.appendWhereClause(ql, filter, roles);
        Query query = this.em.createQuery(ql.toString());
        TrashListBean.setQueryParameters(query, filter, roles);
        return ((Number)query.getSingleResult()).intValue();
    }

    @Override
    public List<PrivatePatient> findPatients(TrashListFilter filter, int pagesize, int offset, List<String> roles) {
        if (roles != null && roles.size() == 0) {
            return new ArrayList<PrivatePatient>();
        }
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT p");
        if (!filter.isPatientQuery()) {
            ql.append(", s");
        }
        TrashListBean.appendFromClause(ql, filter);
        TrashListBean.appendWhereClause(ql, filter, roles);
        QueryUtil.appendOrderBy(ql, new String[]{"p.patientName"});
        Query query = this.em.createQuery(ql.toString());
        TrashListBean.setQueryParameters(query, filter, roles);
        if (filter.isPatientQuery()) {
            return query.setMaxResults(pagesize).setFirstResult(offset).getResultList();
        }
        List result = query.setMaxResults(pagesize).setFirstResult(offset).getResultList();
        ArrayList<PrivatePatient> patientList = new ArrayList<PrivatePatient>();
        PrivatePatient patient = null;
        for (Object[] element : result) {
            if (!patientList.contains((PrivatePatient)element[0])) {
                patient = (PrivatePatient)element[0];
                patient.setStudies(new HashSet());
                patientList.add(patient);
            }
            patient.getStudies().add((PrivateStudy)element[1]);
        }
        return patientList;
    }

    private static void appendFromClause(StringBuilder ql, TrashListFilter filter) {
        ql.append(" FROM PrivatePatient p");
        if (!filter.isPatientQuery()) {
            ql.append(" INNER JOIN p.studies s");
        }
    }

    private static void appendWhereClause(StringBuilder ql, TrashListFilter filter, List<String> roles) {
        ql.append(" WHERE p.privateType = 1");
        if (filter.isPatientQuery()) {
            TrashListBean.appendPatFilter(ql, filter);
        } else {
            if (QueryUtil.isUniversalMatch(filter.getStudyInstanceUID())) {
                TrashListBean.appendPatFilter(ql, filter);
                QueryUtil.appendAccessionNumberFilter(ql, QueryUtil.checkAutoWildcard(filter.getAccessionNumber(), filter.isAutoWildcard()));
            } else {
                ql.append(" AND s.studyInstanceUID = :studyInstanceUID");
            }
            QueryUtil.appendSourceAETFilter(ql, new String[]{filter.getSourceAET()});
            if (roles != null && !filter.isPatientQuery()) {
                QueryUtil.appendDicomSecurityFilter(ql);
            }
        }
    }

    private static void appendPatFilter(StringBuilder ql, TrashListFilter filter) {
        QueryUtil.appendPatientNameFilter(ql, QueryUtil.checkAutoWildcard(filter.getPatientName(), filter.isPNAutoWildcard()));
        QueryUtil.appendPatientIDFilter(ql, QueryUtil.checkAutoWildcard(filter.getPatientID(), filter.isAutoWildcard()));
        QueryUtil.appendIssuerOfPatientIDFilter(ql, QueryUtil.checkAutoWildcard(filter.getIssuerOfPatientID(), filter.isAutoWildcard()));
    }

    private static void setQueryParameters(Query query, TrashListFilter filter, List<String> roles) {
        if (filter.isPatientQuery()) {
            TrashListBean.setPatQueryParameters(query, filter);
        } else {
            if (QueryUtil.isUniversalMatch(filter.getStudyInstanceUID())) {
                TrashListBean.setPatQueryParameters(query, filter);
                QueryUtil.setAccessionNumberQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getAccessionNumber(), filter.isAutoWildcard()));
            } else {
                QueryUtil.setStudyInstanceUIDQueryParameter(query, filter.getStudyInstanceUID());
            }
            QueryUtil.setSourceAETQueryParameter(query, new String[]{filter.getSourceAET()});
            if (roles != null && !filter.isPatientQuery()) {
                query.setParameter("roles", roles);
            }
        }
    }

    private static void setPatQueryParameters(Query query, TrashListFilter filter) {
        QueryUtil.setPatientNameQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getPatientName(), filter.isPNAutoWildcard()));
        QueryUtil.setPatientIDQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getPatientID(), filter.isAutoWildcard()));
        QueryUtil.setIssuerOfPatientIDQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getIssuerOfPatientID(), filter.isAutoWildcard()));
    }

    @Override
    public int countStudiesOfPatient(long pk, List<String> roles) {
        if (roles != null && roles.size() == 0) {
            return 0;
        }
        return ((Number)this.getStudiesOfPatientQuery(true, pk, roles).getSingleResult()).intValue();
    }

    @Override
    public List<PrivateStudy> findStudiesOfPatient(long pk, List<String> roles) {
        if (roles != null && roles.size() == 0) {
            return new ArrayList<PrivateStudy>();
        }
        return this.getStudiesOfPatientQuery(false, pk, roles).getResultList();
    }

    private Query getStudiesOfPatientQuery(boolean isCount, long pk, List<String> roles) {
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT " + (isCount ? "COUNT(s)" : "s") + " FROM PrivateStudy s WHERE s.patient.pk=?1");
        if (roles != null) {
            QueryUtil.appendDicomSecurityFilter(ql);
        }
        Query query = this.em.createQuery(ql.toString());
        query.setParameter(1, (Object)pk);
        if (roles != null) {
            query.setParameter("roles", roles);
        }
        return query;
    }

    @Override
    public List<PrivateSeries> findSeriesOfStudy(long pk) {
        List l = this.em.createQuery("FROM PrivateSeries s WHERE s.study.pk=?1 ORDER BY s.pk").setParameter(1, (Object)pk).getResultList();
        Collections.sort(l, seriesComparator);
        return l;
    }

    @Override
    public List<PrivateInstance> findInstancesOfSeries(long pk) {
        List l = this.em.createQuery("FROM PrivateInstance i WHERE i.series.pk=?1 ORDER BY i.pk").setParameter(1, (Object)pk).getResultList();
        Collections.sort(l, instanceComparator);
        return l;
    }

    public List<String> selectDistinctSourceAETs() {
        return this.em.createQuery("SELECT DISTINCT s.sourceAET FROM Series s WHERE s.sourceAET IS NOT NULL ORDER BY s.sourceAET").getResultList();
    }

    @Override
    public PrivatePatient getPatient(long pk) {
        return (PrivatePatient)this.em.find(PrivatePatient.class, (Object)pk);
    }

    @Override
    public PrivateStudy getStudy(long pk) {
        return (PrivateStudy)this.em.find(PrivateStudy.class, (Object)pk);
    }

    @Override
    public PrivateSeries getSeries(long pk) {
        return (PrivateSeries)this.em.find(PrivateSeries.class, (Object)pk);
    }

    @Override
    public PrivateInstance getInstance(long pk) {
        return (PrivateInstance)this.em.find(PrivateInstance.class, (Object)pk);
    }

    @Override
    public void removeTrashEntities(List<Long> pks, Class<? extends BaseEntity> clazz, boolean removeFile) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!clazz.equals(PrivatePatient.class)) break block4;
                        for (Long pk : pks) {
                            this.removeTrashEntity((BaseEntity)this.getPatient(pk), removeFile);
                        }
                        break block5;
                    }
                    if (!clazz.equals(PrivateStudy.class)) break block6;
                    for (Long pk : pks) {
                        this.removeTrashEntity((BaseEntity)this.getStudy(pk), removeFile);
                    }
                    break block5;
                }
                if (!clazz.equals(PrivateSeries.class)) break block7;
                for (Long pk : pks) {
                    this.removeTrashEntity((BaseEntity)this.getSeries(pk), removeFile);
                }
                break block5;
            }
            if (!clazz.equals(PrivateInstance.class)) break block5;
            for (Long pk : pks) {
                this.removeTrashEntity((BaseEntity)this.getInstance(pk), removeFile);
            }
        }
    }

    private void removeTrashEntity(BaseEntity entity, boolean removeFile) {
        if (entity == null) {
            return;
        }
        if (entity instanceof PrivatePatient) {
            PrivatePatient pp = (PrivatePatient)entity;
            for (PrivateStudy pst : pp.getStudies()) {
                this.removeTrashEntity((BaseEntity)pst, removeFile);
            }
            this.em.remove((Object)pp);
        } else if (entity instanceof PrivateStudy) {
            PrivateStudy pst = (PrivateStudy)entity;
            for (PrivateSeries pse : pst.getSeries()) {
                this.removeTrashEntity((BaseEntity)pse, removeFile);
            }
            PrivatePatient p = pst.getPatient();
            this.em.remove((Object)pst);
            if (p.getStudies().size() <= 1) {
                this.em.remove((Object)p);
            }
        } else if (entity instanceof PrivateSeries) {
            PrivateSeries pse = (PrivateSeries)entity;
            for (PrivateInstance pi : pse.getInstances()) {
                this.removeTrashEntity((BaseEntity)pi, removeFile);
            }
            PrivateStudy pst = pse.getStudy();
            this.em.remove((Object)pse);
            if (pst.getSeries().size() <= 1) {
                this.em.remove((Object)pst);
            }
        } else if (entity instanceof PrivateInstance) {
            PrivateInstance pi = (PrivateInstance)entity;
            for (PrivateFile pf : pi.getFiles()) {
                if (removeFile) {
                    this.em.remove((Object)pf);
                    continue;
                }
                pf.setInstance(null);
                this.em.merge((Object)pf);
            }
            PrivateSeries pse = pi.getSeries();
            this.em.remove((Object)pi);
            if (pse.getInstances().size() <= 1) {
                this.em.remove((Object)pse);
            }
        } else {
            return;
        }
    }

    @Override
    public void removeTrashAll() {
        this.em.createQuery("UPDATE PrivateFile p SET p.instance = Null").executeUpdate();
        this.em.createQuery("DELETE FROM PrivateInstance pi").executeUpdate();
        this.em.createQuery("DELETE FROM PrivateSeries pse").executeUpdate();
        this.em.createQuery("DELETE FROM PrivateStudy pst").executeUpdate();
        this.em.createQuery("DELETE FROM PrivatePatient pp").executeUpdate();
    }

    @Override
    public List<PrivateFile> getFilesForEntity(long pk, Class<? extends BaseEntity> clazz) {
        String query = "SELECT DISTINCT f FROM PrivateFile f LEFT JOIN FETCH f.fileSystem fs ";
        if (clazz.equals(PrivateInstance.class)) {
            query = query + "WHERE f.instance.pk = :pk";
        } else {
            query = query + "LEFT JOIN f.instance.series se ";
            if (clazz.equals(PrivateSeries.class)) {
                query = query + "WHERE se.pk = :pk";
            } else {
                query = query + "LEFT JOIN se.study st ";
                if (clazz.equals(PrivateStudy.class)) {
                    query = query + "WHERE st.pk = :pk";
                } else if (clazz.equals(PrivatePatient.class)) {
                    query = query + "LEFT JOIN st.patient p WHERE p.pk = :pk";
                } else {
                    return null;
                }
            }
        }
        return this.em.createQuery(query).setParameter("pk", (Object)pk).getResultList();
    }

    @Override
    public List<Study> getStudiesInFolder(String[] suids) {
        StringBuilder sb = new StringBuilder("SELECT st from Study st WHERE st.studyInstanceUID");
        QueryUtil.appendIN(sb, suids.length);
        Query q = this.em.createQuery(sb.toString());
        QueryUtil.setParametersForIN(q, suids);
        return q.getResultList();
    }

    @Override
    public DicomObject getDicomAttributes(long filePk) {
        PrivateFile pf = (PrivateFile)this.em.find(PrivateFile.class, (Object)filePk);
        DicomObject dio = pf.getInstance().getAttributes();
        pf.getInstance().getSeries().getAttributes().copyTo(dio);
        pf.getInstance().getSeries().getStudy().getAttributes().copyTo(dio);
        pf.getInstance().getSeries().getStudy().getPatient().getAttributes().copyTo(dio);
        dio.putString(dio.resolveTag(4390932, "dcm4che/archive"), VR.AE, pf.getInstance().getSeries().getSourceAET());
        return dio;
    }

    @Override
    public Long getNumberOfSeriesOfStudy(long studyPk) {
        return (Long)this.em.createQuery("SELECT COUNT(s) from PrivateSeries s WHERE s.study.pk = :studyPk").setParameter("studyPk", (Object)studyPk).getSingleResult();
    }

    @Override
    public Long getNumberOfInstancesOfStudy(long studyPk) {
        return (Long)this.em.createQuery("SELECT DISTINCT COUNT(i) FROM PrivateInstance i, PrivateSeries se , PrivateStudy st WHERE i.series.pk = se.pk AND se.study.pk = st.pk AND st.pk = :studyPk").setParameter("studyPk", (Object)studyPk).getSingleResult();
    }

    @Override
    public Long getNumberOfInstancesOfSeries(long seriesPk) {
        return (Long)this.em.createQuery("SELECT COUNT(i) from PrivateInstance i WHERE i.series.pk = :seriesPk").setParameter("seriesPk", (Object)seriesPk).getSingleResult();
    }
}

