/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.tc;

import java.io.Serializable;
import java.util.Random;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.web.dao.tc.TCQueryFilterKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCQueryFilterValue<T>
implements Serializable {
    private T value;

    public TCQueryFilterValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }

    public abstract QueryParam[] appendSQLWhereConstraint(TCQueryFilterKey var1, StringBuilder var2);

    public static TCQueryFilterValue<String> create(String value) {
        return new TCQueryFilterValue<String>(value){

            @Override
            public QueryParam[] appendSQLWhereConstraint(TCQueryFilterKey key, StringBuilder sb) {
                QueryParam searchStringParam = new QueryParam("searchString", "%" + ((String)this.getValue()).replaceAll("\\*", "%").toUpperCase() + "%");
                QueryParam conceptNameValueParam = new QueryParam("conceptNameValue", key.getCode().getCodeValue());
                QueryParam conceptNameDesignatorParam = new QueryParam("conceptNameDesignator", key.getCode().getCodingSchemeDesignator());
                sb.append("EXISTS (");
                sb.append("FROM ContentItem content_item");
                sb.append(" INNER JOIN content_item.conceptName concept_name");
                sb.append(" WHERE (instance.sopInstanceUID = content_item.instance.sopInstanceUID)");
                sb.append(" AND (content_item.relationshipType = 'CONTAINS')");
                sb.append(" AND (upper(content_item.textValue) LIKE :" + searchStringParam.getKey() + ")");
                sb.append(" AND (concept_name.codeValue = :" + conceptNameValueParam.getKey() + ")");
                sb.append(" AND (concept_name.codingSchemeDesignator = :" + conceptNameDesignatorParam.getKey() + ")");
                sb.append(")");
                if (key.supportsCodeValue()) {
                    QueryParam conceptCodeMeaningParam = new QueryParam("conceptCodeMeaning", "%" + ((String)this.getValue()).replaceAll("\\*", "%").toUpperCase() + "%");
                    sb.append(" OR ");
                    sb.append("EXISTS (");
                    sb.append("FROM ContentItem content_item");
                    sb.append(" INNER JOIN content_item.conceptName concept_name");
                    sb.append(" INNER JOIN content_item.conceptCode concept_code");
                    sb.append(" WHERE (instance.sopInstanceUID = content_item.instance.sopInstanceUID)");
                    sb.append(" AND (content_item.relationshipType = 'CONTAINS')");
                    sb.append(" AND (concept_name.codeValue = :" + conceptNameValueParam.getKey() + ")");
                    sb.append(" AND (concept_name.codingSchemeDesignator = :" + conceptNameDesignatorParam.getKey() + ")");
                    sb.append(" AND (upper(concept_code.codeMeaning) LIKE :" + conceptCodeMeaningParam.getKey() + ")");
                    sb.append(")");
                    return new QueryParam[]{searchStringParam, conceptNameValueParam, conceptNameDesignatorParam, conceptCodeMeaningParam};
                }
                return new QueryParam[]{searchStringParam, conceptNameValueParam, conceptNameDesignatorParam};
            }
        };
    }

    public static TCQueryFilterValue<Code> create(Code code) {
        return new TCQueryFilterValue<Code>(code){

            @Override
            public QueryParam[] appendSQLWhereConstraint(TCQueryFilterKey key, StringBuilder sb) {
                QueryParam conceptNameValueParam = new QueryParam("conceptNameValue", key.getCode().getCodeValue());
                QueryParam conceptNameDesignatorParam = new QueryParam("conceptNameDesignator", key.getCode().getCodingSchemeDesignator());
                QueryParam conceptCodeValueParam = new QueryParam("conceptCodeValue", ((Code)this.getValue()).getCodeValue());
                QueryParam conceptCodeDesignatorParam = new QueryParam("conceptCodeDesignator", ((Code)this.getValue()).getCodingSchemeDesignator());
                QueryParam searchStringParam = new QueryParam("searchString", "%" + ((Code)this.getValue()).getCodeValue().toUpperCase() + "%");
                sb.append("EXISTS (");
                sb.append("FROM ContentItem content_item");
                sb.append(" INNER JOIN content_item.conceptName concept_name");
                sb.append(" INNER JOIN content_item.conceptCode concept_code");
                sb.append(" WHERE (instance.sopInstanceUID = content_item.instance.sopInstanceUID)");
                sb.append(" AND (content_item.relationshipType = 'CONTAINS')");
                sb.append(" AND (concept_name.codeValue = :" + conceptNameValueParam.getKey() + ")");
                sb.append(" AND (concept_name.codingSchemeDesignator = :" + conceptNameDesignatorParam.getKey() + ")");
                sb.append(" AND (concept_code.codeValue = :" + conceptCodeValueParam.getKey() + ")");
                sb.append(" AND (concept_code.codingSchemeDesignator = :" + conceptCodeDesignatorParam.getKey() + ")");
                sb.append(")");
                sb.append(" OR ");
                sb.append("EXISTS (");
                sb.append("FROM ContentItem content_item");
                sb.append(" INNER JOIN content_item.conceptName concept_name");
                sb.append(" WHERE (instance.sopInstanceUID = content_item.instance.sopInstanceUID)");
                sb.append(" AND (content_item.relationshipType = 'CONTAINS')");
                sb.append(" AND (upper(content_item.textValue) LIKE :" + searchStringParam.getKey() + ")");
                sb.append(" AND (concept_name.codeValue = :" + conceptNameValueParam.getKey() + ")");
                sb.append(" AND (concept_name.codingSchemeDesignator = :" + conceptNameDesignatorParam.getKey() + ")");
                sb.append(")");
                return new QueryParam[]{conceptNameValueParam, conceptNameDesignatorParam, conceptCodeValueParam, conceptCodeDesignatorParam, searchStringParam};
            }
        };
    }

    public static TCQueryFilterValue<Code> create(String designator, String value) {
        return TCQueryFilterValue.create(TCQueryFilterValue.createCode(designator, value, null));
    }

    public static TCQueryFilterValue<DicomCodeEnum> create(DicomCodeEnum value) {
        return new TCQueryFilterValue<DicomCodeEnum>(value){

            @Override
            public QueryParam[] appendSQLWhereConstraint(TCQueryFilterKey key, StringBuilder sb) {
                QueryParam conceptNameValueParam = new QueryParam("conceptNameValue", key.getCode().getCodeValue());
                QueryParam conceptNameDesignatorParam = new QueryParam("conceptNameDesignator", key.getCode().getCodingSchemeDesignator());
                QueryParam conceptCodeValueParam = new QueryParam("conceptCodeValue", ((DicomCodeEnum)this.getValue()).getCode().getCodeValue());
                QueryParam conceptCodeDesignatorParam = new QueryParam("conceptCodeDesignator", ((DicomCodeEnum)this.getValue()).getCode().getCodingSchemeDesignator());
                sb.append("EXISTS (");
                sb.append("FROM ContentItem content_item");
                sb.append(" INNER JOIN content_item.conceptName concept_name");
                sb.append(" INNER JOIN content_item.conceptCode concept_code");
                sb.append(" WHERE (instance.sopInstanceUID = content_item.instance.sopInstanceUID)");
                sb.append(" AND (content_item.relationshipType = 'CONTAINS')");
                sb.append(" AND (concept_name.codeValue = :" + conceptNameValueParam.getKey() + ")");
                sb.append(" AND (concept_name.codingSchemeDesignator = :" + conceptNameDesignatorParam.getKey() + ")");
                sb.append(" AND (concept_code.codeValue = :" + conceptCodeValueParam.getKey() + ")");
                sb.append(" AND (concept_code.codingSchemeDesignator = :" + conceptCodeDesignatorParam.getKey() + ")");
                sb.append(")");
                return new QueryParam[]{conceptNameValueParam, conceptNameDesignatorParam, conceptCodeValueParam, conceptCodeDesignatorParam};
            }
        };
    }

    public static TCQueryFilterValue<DicomStringEnum> create(DicomStringEnum value) {
        return new TCQueryFilterValue<DicomStringEnum>(value){

            @Override
            public QueryParam[] appendSQLWhereConstraint(TCQueryFilterKey key, StringBuilder sb) {
                QueryParam searchStringParam = new QueryParam("searchString", ((DicomStringEnum)this.getValue()).getString().toUpperCase());
                QueryParam conceptNameValueParam = new QueryParam("conceptNameValue", key.getCode().getCodeValue());
                QueryParam conceptNameDesignatorParam = new QueryParam("conceptNameDesignator", key.getCode().getCodingSchemeDesignator());
                sb.append("EXISTS (");
                sb.append("FROM ContentItem content_item");
                sb.append(" INNER JOIN content_item.conceptName concept_name");
                sb.append(" WHERE (instance.sopInstanceUID = content_item.instance.sopInstanceUID)");
                sb.append(" AND (content_item.relationshipType = 'CONTAINS')");
                sb.append(" AND (upper(content_item.textValue) = :" + searchStringParam.getKey() + ")");
                sb.append(" AND (concept_name.codeValue = :" + conceptNameValueParam.getKey() + ")");
                sb.append(" AND (concept_name.codingSchemeDesignator = :" + conceptNameDesignatorParam.getKey() + ")");
                sb.append(")");
                return new QueryParam[]{searchStringParam, conceptNameValueParam, conceptNameDesignatorParam};
            }
        };
    }

    private static Code createCode(String designator, String value, String meaning) {
        BasicDicomObject dataset = new BasicDicomObject();
        dataset.putString(524546, VR.SH, designator);
        dataset.putString(524544, VR.SH, value);
        dataset.putString(524548, VR.LO, meaning == null ? "" : meaning);
        return new Code((DicomObject)dataset);
    }

    private static boolean equals(Code code1, Code code2) {
        return code1.getCodingSchemeDesignator().equals(code2.getCodingSchemeDesignator()) && code1.getCodeValue().equals(code2.getCodeValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category implements DicomCodeEnum
    {
        Musculoskeletal("TCE301", "IHERADTF"),
        Pulmonary("TCE302", "IHERADTF"),
        Cardiovascular("TCE303", "IHERADTF"),
        Gastrointestinal("TCE304", "IHERADTF"),
        Genitourinary("TCE305", "IHERADTF"),
        Neuro("TCE306", "IHERADTF"),
        Nuclear("TCE308", "IHERADTF"),
        Ultrasound("TCE309", "IHERADTF"),
        VascularAndInterventional("TCE307", "IHERADTF"),
        Pediatric("TCE310", "IHERADTF"),
        Breast("TCE311", "IHERADTF");

        private Code code;

        private Category(String v, String d) {
            this.code = TCQueryFilterValue.createCode(d, v, null);
        }

        @Override
        public Code getCode() {
            return this.code;
        }

        public static Category get(Code code) {
            if (code != null) {
                for (Category category : Category.values()) {
                    if (!TCQueryFilterValue.equals(code, category.getCode())) continue;
                    return category;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Purpose implements DicomCodeEnum
    {
        ForTeaching("TCE001", "IHERADTF"),
        ForClinicalTrial("TCE002", "IHERADTF"),
        ForResearch("TCE007", "IHERADTF"),
        ForPublication("TCE008", "IHERADTF");

        private Code code;

        private Purpose(String v, String d) {
            this.code = TCQueryFilterValue.createCode(d, v, null);
        }

        @Override
        public Code getCode() {
            return this.code;
        }

        public static Purpose get(Code code) {
            if (code != null) {
                for (Purpose purpose : Purpose.values()) {
                    if (!TCQueryFilterValue.equals(code, purpose.getCode())) continue;
                    return purpose;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AcquisitionModality implements DicomCodeEnum
    {
        CR("DCM", "CR"),
        CT("DCM", "CT"),
        DG("DCM", "DG"),
        DX("DCM", "DX"),
        ECG("DCM", "ECG"),
        ES("DCM", "ES"),
        GM("DCM", "GM"),
        IVUS("DCM", "IVUS"),
        MG("DCM", "MG"),
        MR("DCM", "MR"),
        NM("DCM", "NM"),
        PT("DCM", "PT"),
        RF("DCM", "RF"),
        RG("DCM", "RG"),
        SM("DCM", "SM"),
        US("DCM", "US"),
        XA("DCM", "XA"),
        XC("DCM", "XC");

        private Code code;

        private AcquisitionModality(String d, String v) {
            this.code = TCQueryFilterValue.createCode(d, v, null);
        }

        @Override
        public Code getCode() {
            return this.code;
        }

        public static AcquisitionModality get(Code code) {
            if (code != null) {
                for (AcquisitionModality mod : AcquisitionModality.values()) {
                    if (!TCQueryFilterValue.equals(code, mod.getCode())) continue;
                    return mod;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PatientSex implements DicomStringEnum
    {
        Male("M"),
        Female("F"),
        Other("O"),
        Unknown("U");

        private String value;

        private PatientSex(String v) {
            this.value = v;
        }

        @Override
        public String getString() {
            return this.value;
        }

        public static PatientSex get(String value) {
            if (value != null) {
                for (PatientSex sex : PatientSex.values()) {
                    if (!value.equals(sex.getString())) continue;
                    return sex;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum YesNo implements DicomCodeEnum
    {
        Yes("R-0038D", "SRT"),
        No("R-00339D", "SRT");

        private Code code;

        private YesNo(String v, String d) {
            this.code = TCQueryFilterValue.createCode(d, v, null);
        }

        @Override
        public Code getCode() {
            return this.code;
        }

        public static YesNo get(Code code) {
            if (code != null) {
                for (YesNo yesNo : YesNo.values()) {
                    if (!TCQueryFilterValue.equals(code, yesNo.getCode())) continue;
                    return yesNo;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level implements DicomCodeEnum
    {
        Primary("TCE201", "IHERADTF"),
        Intermediate("TCE202", "IHERADTF"),
        Advanced("TCE203", "IHERADTF");

        private Code code;

        private Level(String v, String d) {
            this.code = TCQueryFilterValue.createCode(d, v, null);
        }

        @Override
        public Code getCode() {
            return this.code;
        }

        public static Level get(Code code) {
            if (code != null) {
                for (Level level : Level.values()) {
                    if (!TCQueryFilterValue.equals(code, level.getCode())) continue;
                    return level;
                }
            }
            return null;
        }
    }

    private static interface DicomStringEnum {
        public String getString();
    }

    private static interface DicomCodeEnum {
        public Code getCode();
    }

    public static class QueryParam {
        private static final Random random = new Random();
        private String key;
        private Object value;

        public QueryParam(String key_prefix, Object value) {
            this.key = key_prefix + "_" + random.nextInt(Integer.MAX_VALUE);
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

